<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkappli.class.php";

/**
 * @package Alkanet_Module_Crbn_cat 
 *          Une description longue du package et de ses classes
 * 
 * @class AlkAppliCrbn_cat
 * @brief Description de la classe
 *
 * Description longue de la classe
 */
class AlkAppliCrbn_cat extends AlkAppli implements AlkIntAppli, AlkIntRights 
{

  /**
   * Constructeur par défaut
   *
   * @param oSpace Référence vers l'objet de l'espace en cours
   */
  public function __construct($appli_id)
  {
    parent::__construct(ALK_ATYPE_ID_CRBN_CAT, $appli_id);
    
                                       
    $dsBdCRBN = $this->oQuery->getDsByTableName("etude_config");
    // initialisation des param
    if($drBdCRBN = $dsBdCRBN->getRowIter()){
            
            if(!defined("config_wms")) define("config_wms",$drBdCRBN->getValueName("config_wms"));
            if(!defined("config_layer_wms")) define("config_layer_wms",$drBdCRBN->getValueName("config_layer_wms")); 
            if(!defined("config_id_com")) define("config_id_com",$drBdCRBN->getValueName("config_id_com"));  
            if(!defined("config_nom_coml")) define("config_nom_coml",$drBdCRBN->getValueName("config_nom_coml")); 
            if(!defined("config_id_epci")) define("config_id_epci",$drBdCRBN->getValueName("config_id_epci" )); 
            if(!defined("config_nom_epci")) define("config_nom_epci",$drBdCRBN->getValueName("config_nom_epci")); 
            if(!defined("config_id_pays")) define("config_id_pays",$drBdCRBN->getValueName("config_id_pays")); 
            if(!defined("config_nom_pays")) define("config_nom_pays",$drBdCRBN->getValueName("config_nom_pays")); 
            if(!defined("config_id_pnr")) define("config_id_pnr",$drBdCRBN->getValueName("config_id_pnr" )); 
            if(!defined("config_nom_pnr")) define("config_nom_pnr",$drBdCRBN->getValueName("config_nom_pnr" )); 
            if(!defined("config_id_dep")) define("config_id_dep",$drBdCRBN->getValueName("config_id_dep")); 
            if(!defined("config_nom_dep")) define("config_nom_dep",$drBdCRBN->getValueName("config_nom_dep")); 
            if(!defined("config_id_reg")) define("config_id_reg",$drBdCRBN->getValueName("config_id_reg")); 
            if(!defined("config_nom_reg")) define("config_nom_reg",$drBdCRBN->getValueName("config_nom_reg"));     
            if(!defined("config_table_com")) define("config_table_com",$drBdCRBN->getValueName("config_table_com")); 
    } 
  }

  /**
   * Destructeur par défaut
   */
  public function __destruct() { }
  
  // --------- interface AlkIntAppli ----------
  
  /**
   * Méthode appelée après création puis ajout de l'application à un espace.
   * Implémenter les actions à effectuer pour initialiser l'application
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   * @return int
   */
  public function addAppli($tabFields) { /** rien à faire */ }

  /**
   * Méthode appelée après modification des propriétés d'une application à un espace.
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   */
  public function updateAppli($tabFields) { /** rien à faire */ }

  /**
   * Méthode appelée avant suppression définitive d'une application d'un espace
   * Implémenter les actions effectuant le ménage interne à l'application
   */
  public function delAppli() { /** rien à faire */ }

  /**
   *  Déplacement d'une application d'un espace vers un autre
   *        Cette méthode se charge d'appelé la recopie des droits
   * @param appli_id  identifiant de l'appli
   * @param idContTo  identifiant de l'espace recevant l'appli
   */
  public function moveAppli($idContTo) { /** rien à faire */  }

  /**
   * Duplication de la structure et du paramètrage de l'application src à la courante
   * @param appli_id_src  identifiant de l'application source
   * @param iTypeDup      type de duplication : 0 = application vierge (ne fait rien) 
   *                                            1 = structure et paramétrage
   *                                            2 = structure, paramétrage et données  
   */
  public function dupAppli($appli_id_src, $iTypeDup) { /** rien à faire */ }
  
  // --------- interface AlkIntRights ----------
  
  /**
   *  Transfère de propriété d'un utilisateur à un autre
   *        Méthode à appeler avant suppression définitive d'un utilisateur
   * @param idUserFrom  identifiant de l'utilisateur perdant la propriété des ses données
   * @param idUserTo    identifiant de l'utilisateur récupérant la propriété des données
   */
  public function replaceUser($idUserFrom, $idUserTo) { /** rien à faire */ }

  /**
   *  Invitation d'un utilisateur à un espace (tous si cont_id=-1, tous les espaces publics si cont_id=-2)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces. -2 tous les espaces publics
   * @param priv_id  identifiant du privilège
   */
  public function addUserToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   *  Modification du privilège espace pour l'utilisateur à un espace (tous si cont_id=-1)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   * @param priv_id  identifiant du privilège
   */
  public function updateUserPrivToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   *  Suppression de l'accès à un espace (ou tous si cont_id=-1) pour un utilisateur
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   */
  public function removeUserFromSpace($user_id, $cont_id) { /** rien à faire */ }

  /**
   *  Personnalisation des droits d'un utilisateur
   * @note Appelé en admin. annuaire avec gestion des droits sur un profil sur l'espace courant
   * @param cont_id       identifiant de l'espace
   * @param user_id       identifiant de l'utilisateur sélectionné
   * @param iRight        non utilisé
   * @param iDefaultRight non utilisé
   */
  public function setUserRightsOnSpace($cont_id, $user_id, $iRight=-1, $iDefaultRight=-1) { /** rien à faire */ }

  /**
   *  Enregistre les droits des profils sur les applications d'un espace
   * @param cont_id       identifiant d'utilisateur
   * @param tabRight      non utilisé dans le cas espace, 
   *                      sinon tableau de type "_".idProfil => droid_id pour les autres applis
   */
  public function setProfilRightsOnSpace($cont_id, $tabRight=array()) { /** rien à faire */ }

  /**
   *  Application de droits sur les profils pour l'application
   * @note Appelé en config. espace avec gestion des droits sur les profils pour l'appli
   * @param atype_id  type d'application
   * @param appli_id  identifiant de l'application
   */
  public function setRightsOnAppli($atype_id, $appli_id) { /** rien à faire */ }
  
  /**
   * Applique les droits d'un utilisateur par rapport à ses profils
   * @param user_id  identifiant de l'utilisateur 
   */
  public function setProfilRightToUser($user_id) {}
  
  
  /** 
   *  Ajout d'un profil sur l'extranet.
   *        Si l'application gère des droits, il faut y associer le droit NONE
   * @param profil_id  identifiant du profil à supprimer
   * @param cont_id    identifiant de l'espace associé, =0 pour tous les espaces (par défaut)
   */
  public function addProfil($profil_id, $cont_id=0) { /** rien à faire */ }
  
  /** 
   *  Suppression d'un profil sur l'extranet.
   *        Si l'application gère des droits, il faut supprimer les droits associés
   * @param profil_id  identifiant du profil à supprimer
   */
  public function delProfil($profil_id) { /** rien à faire */ }
  
  
  /**
   * Envoi un mail à un agent
   *
   * @param tabAssoc    tableau associatif contenant les données relatives à l'agent
   * @param tabInfoMail mode d'envoi de mail
   * @param strType     cle servant à identifier le type de mail à expédier
   * @param $stName nom du nouv serv
   */
  public function SendMailToAgent($tabAssoc, $strType, $stName)
  {
    // initialisation de l'objet mail
    setMailAlkLocale(ALK_MAIL_ADMIN_LG);
    $oAlkMail = AlkFactory::getMail();
    $strNomFrom = ALK_APP_TITLE;
    $strMailFrom = "";
    //$strMailFrom = (AlkFactory::getSProperty("user_mail", ALK_MAIL_ADMIN_MAIL) == "" ? ALK_MAIL_ADMIN_MAIL: AlkFactory::getSProperty("user_mail", ALK_MAIL_ADMIN_MAIL));
    //$strNomFrom  = (AlkFactory::getSProperty("user_name", ALK_MAIL_ADMIN_NAME) == "Utilisateur anonyme" ? ALK_MAIL_ADMIN_MAIL: AlkFactory::getSProperty("user_mail", ALK_MAIL_ADMIN_NAME));
  
    if ($strMailFrom==""){
      $strMailFrom = ALK_MAIL_NOREPLY_MAIL;
    }
    $oAlkMail->SetFrom($strNomFrom, $strMailFrom);
  
    // strMsgto les admin
    
    $dsListAdmin = $this->oQuery->getDsListAdmin(ALK_PRIV_ANNU_ALL+ALK_PRIV_SPACE_ADMIN);
    
    
    while ($drListAdmin = $dsListAdmin->getRowIter()){
    
      $strMailTo = $tabAssoc["agent_mail"]  = $drListAdmin->getValueName("agent_mail");
      $tabAssoc["agent_prenom"] = $drListAdmin->getValueName("agent_prenom");
      $tabAssoc["agent_nom"] = $drListAdmin->getValueName("agent_nom");
      $strNomTo  = trim($tabAssoc["agent_prenom"]." ".$tabAssoc["agent_nom"]);
      $oAlkMail->AddTo($strNomTo, $strMailTo);

  
      $tabAssoc["msg"] =
      "Une demande de création de service intitulé '".$stName."', vient d'être effectuée pour la liste des ".$tabAssoc["type_service"]." de l'étude :'".$tabAssoc["etude_intitule"]."'". 
        "<br/>".
        "Le service a été créé en statut en attente d'activation.".
        "<br/> Ce mail est généré automatiquement.";
    }
    AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);
    setCurrentAlkLocale();
  
  }
  
  
  
  
  /** heritage AlkAppli */
  
  /**
   * Retourne l'objet Panel correspondant au iSheet et iSSheet sélectionné
   * 
   * @param oAppliFrom    AlkAppli   Application appelant cette fonction (principe call services par dérivation)
   * 
   * @return AlkHtmlPanel
   */
  public function getPanel(AlkAppli $oAppliFrom=null)
  {  
    $oPanel = null;
    switch( $this->iTypeSheet ) {
      case ALK_TYPESHEET_CONSULT: // partie consultation
        switch ( $this->iSheet ){
        case ALK_SHEET_RECHERCHE : 
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmlformconsultcrbn_catlist.class.php");
          $oPanel = new AlkHtmlFormConsultCrbn_catList($this);
          break; 
        
        case ALK_SHEET_FICHE :
            require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmlformconsultcrbn_catform.class.php");
            $oPanel = new AlkHtmlFormConsultCrbn_catForm($this);
            break;        
        
        }
        break;
  
      case ALK_TYPESHEET_ADMIN: // partie admin
        switch ( $this->iSheet ){
        case ALK_SHEET_ADMINISTRATION : //
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmlformadmincrbn_catform.class.php");
          $oPanel = new AlkHtmlFormAdminCrbn_catForm($this);
          break; 
        
        case ALK_SHEET_DICTIONNAIRE :
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmldicocrbn_cat.class.php");
          $oPanel = new AlkHtmlDicoCrbn_Cat($this);
          break; 
              
        case ALK_SHEET_VALIDATION :
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmlformadmincrbn_catlist.class.php");
          $oPanel = new AlkHtmlFormAdminCrbn_catList($this);
          break;           

        case ALK_SHEET_FICHE :
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmlformadmincrbn_chpsup_catform.class.php");
          $oPanel = new AlkHtmlFormAdminCrbn_chpsup_catForm($this);
          break;       
          
      }
     
      case ALK_TYPESHEET_POPUP:
      	switch ( $this->iSheet ){
        case ALK_SHEET_IMPORTEXPORT : // import de fiches etudes
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmlforpopupcrbn_import.class.php");
          $oPanel = new AlkHtmlFormPopupCrbn_import($this);
          break; 
        }
      	break;
     
      case ALK_TYPESHEET_PROPRIETE: // partie parametres
        switch ( $this->iSheet ){
        case ALK_SHEET_PROPRIETE : //
          //require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/classes/alkhtmlformparamcrbn_catform.class.php");
          //$oPanel = new AlkHtmlFormParamCrbn_catForm($this);
          $oPanel = AlkHtmlFactory::getHtmlPanel("default", "(Panel par défaut)");
          break; 
        }
        break;
    }
    
    return $oPanel;
  }
  
  /**
   *  Fonction virtuelle appelée par le constructeur permettant d'initialiser le tableau this->tabSheets
   */
  public function setTabSheets() 
  { 
    
    
    $iTypeSheet = AlkRequest::getToken("iTypeSheet",  ALK_TYPESHEET_CONSULT);
    $iSheet = AlkRequest::getToken("iSheet",  ALK_TYPESHEET_CONSULT);
    if( $iTypeSheet==ALK_TYPESHEET_POPUP ) 
      return;
    
    $strUrl = ALK_ALKANET;
    
    // onglets de consultation
    //$this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_CONSULTATION, ALK_SHEET_LIST, 
    //               "Consultation Crbn_cat", $strUrl, "", "",
    //               ALK_APPLI_RIGHT_READ, ALK_PRIV_SPACE_USER, true);
    
    // onglets d'administration
    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, 
                    "Paramétrage de l'application", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);
 
    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_DICTIONNAIRE, ALK_SHEET_LIST, 
                    "Gestion des listes", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);

    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_VALIDATION, ALK_SHEET_NONE, 
                    "Activation des champs", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);         
        
    if( $iSheet==ALK_SHEET_FICHE ){                     
    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_FICHE, ALK_SHEET_NONE, 
                    "Gestion des champs supplémentaires", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);                      
    }
                    
                               
    // onglets des propriétés
    //$this->addSheet(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_PROPRIETE, ALK_SHEET_NONE, 
    //                "Propriétés Crbn_cat", $strUrl, "", "",
    //                ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);
  }
/**
   *
   * @param $etude_id identificant d'étude
   * @param mode 1 sauvegarde fichier, 0 retourne xml
   * @param $strFileExport fichier à sauvegarder
   * @return unknown_type
   */
  public function ExportXml($etude_id, $mode="1", $strFileExport=""){
    //défini dans app_conf_crbn_cat.php
    if($strFileExport==""){
	  	$strExtension = "xml";
	    $strFileExport = $this->getProperty("strPathUpload")."fiche_".$etude_id.$strExtension;
    }
       
    $dsEtude = $this->oQuery->getDataEtudeById($etude_id);
    if ($drEtude = $dsEtude->getRowIter()){
      //création d'un nouveau fichier xml
      
      //création de la structure de base
      $dom = new DOMDocument('1.0', 'utf-8');
      $dom->formatOutput = true;
      $simpledc = $dom->createElement('simpledc');
      $root = $dom->appendChild($simpledc);

      //création des champs
      $etude_intitule = $drEtude->getValueName("etude_intitule");
      $element = $dom->createElement('dc:title', htmlspecialchars($etude_intitule));
      $root->appendChild($element);
        
      $etude_auteurs = $drEtude->getValueName("etude_auteurs");
      $element = $dom->createElement('dc:publisher', htmlspecialchars($etude_auteurs));
      $root->appendChild($element);

      $etude_redacteurs = $drEtude->getValueName("etude_redacteurs");
      $element = $dom->createElement('dc:creator', htmlspecialchars($etude_redacteurs));
      $root->appendChild($element);

      $etude_mots_cles = $drEtude->getValueName("etude_mots_cles");
      $tab_mots_cles = explode(",", $etude_mots_cles);
      foreach($tab_mots_cles as $key => $value){
        $element = $dom->createElement('dc:subject', htmlspecialchars($value));
        $root->appendChild($element); 
      }
      $etude_resume = $drEtude->getValueName("etude_resume");
      $element = $dom->createElement('dc:description', htmlspecialchars($etude_resume));
      $root->appendChild($element);

      $etude_annee_achevement = $drEtude->getValueName("etude_annee_achevement");
      $element = $dom->createElement('dct:created', htmlspecialchars($etude_annee_achevement));
      $root->appendChild($element);

      $etude_annee_maj = $drEtude->getValueName("etude_annee_maj");
      $element = $dom->createElement('dct:modified', htmlspecialchars($etude_annee_maj));
      $root->appendChild($element);

      $etude_date_publication = $drEtude->getValueName("etude_date_publication");
      $element = $dom->createElement('dct:dateSubmitted', htmlspecialchars($etude_date_publication));
      $root->appendChild($element);

      $element = $dom->createElement('dc:format', "application/pdf");
      $root->appendChild($element);

      $etude_isrn = $drEtude->getValueName("etude_isrn");
      $element = $dom->createElement('dc:identifier', htmlspecialchars($etude_isrn));
      $root->appendChild($element);

      $element = $dom->createElement('dc:language', "fre");
      $root->appendChild($element);

      //TODO inscrire les liens vers les documents
      //dc:relation
      //dc:cc_relation
      //dc:thumbnail
    
      $etude_droit = $drEtude->getValueName("etude_droit");
      $element = $dom->createElement('dc:rights', $GLOBALS["tabDroits"][$etude_droit]);
      $root->appendChild($element);

      // themes
      $oDsDataTheme = $this->oQuery->getDsByTableName(" etude_thematique eth".
                                                            " left join thematique t on eth.thematique_id =  t.thematique_id ".
                                                            " left join sous_thematiques st on eth.sous_thematique_id =  st.sous_thematique_id ".
                                                            " where etude_id =".$etude_id );

      while ($oDrDataTheme = $oDsDataTheme->getRowIter()){
        if($oDrDataTheme->getValueName("etude_thematique_type")==1){  // theme princip
          $pk = $dom->createElement('dc:principal_keywords');
        }else{
          $pk = $dom->createElement('dc:secondary_keywords');
        }
        $thematique_intitule = $oDrDataTheme->getValueName("thematique_intitule");
        $sous_thematique_intitule = $oDrDataTheme->getValueName("sous_thematique_intitule");

        $keyword = $dom->createElement('dc:keyword');
        $keyword->setAttribute("theme", htmlspecialchars($thematique_intitule));
        $keyword->setAttribute("subtheme", htmlspecialchars($sous_thematique_intitule));
        $pk->appendChild($keyword);
        $root->appendChild($pk);
      }
     

      $etude_desc_nb_fascicules = $drEtude->getValueName("etude_desc_nb_fascicules");
      $element = $dom->createElement('dc:booklet', htmlspecialchars($etude_desc_nb_fascicules));
      $root->appendChild($element);

      $etude_desc_nb_pages = $drEtude->getValueName("etude_desc_nb_pages");
      $element = $dom->createElement('dc:page', htmlspecialchars($etude_desc_nb_pages));
      $root->appendChild($element);

      //ne pas mettre le cout en consultation, donc pas d'export

      $etude_perimetre_principal_intitule = $drEtude->getValueName("etude_perimetre_principal_intitule");
      $element = $dom->createElement('dc:primary_area', htmlspecialchars($etude_perimetre_principal_intitule));
      $root->appendChild($element);

      $etude_perimetre_secondaire_intitule = $drEtude->getValueName("etude_perimetre_secondaire_intitule");
      $element = $dom->createElement('dc:secondary_area', htmlspecialchars($etude_perimetre_secondaire_intitule));
      $root->appendChild($element);


      //doc type
      $oDsDataDocType = $this->oQuery->getDsByTableName(" etude_document_type edt".
          " left join document_type dt on edt.document_type_id =  dt.document_type_id ".
          " where etude_id=".$etude_id );
      While($oDrDataDocType = $oDsDataDocType->getRowIter()){
        $etude_type =  $oDrDataDocType->getValueName("document_type_intitule");
        $element = $dom->createElement('dc:type', htmlspecialchars($etude_type));
        $root->appendChild($element);
      }

      //methodologie
      $oDsDatamethodoType = $this->oQuery->getDsByTableName(" etude_methodologie em".
          " left join methodologie methodo on em.methodologie_id =  methodo.methodologie_id ".
          " where etude_id=".$etude_id );
      While ($oDrDatamethodoType = $oDsDatamethodoType->getRowIter()){
        $etude_methodology =  $oDrDatamethodoType->getValueName("methodologie_intitule");
        $element = $dom->createElement('dc:methodology', htmlspecialchars($etude_methodology));
        $root->appendChild($element);
      }

      //typologie
      $tab_typologie_intitule = array();
      $oDsDataTypoType = $this->oQuery->getDsByTableName(" etude_typologie et".
          " left join typologie typo on et.typologie_id =  typo.typologie_id ".
          " where etude_id=".$etude_id );
      While ($oDrDataTypoType = $oDsDataTypoType->getRowIter()){
        $etude_typologie =  $oDrDataTypoType->getValueName("typologie_intitule");
        $element = $dom->createElement('dc:typology', htmlspecialchars($etude_typologie));
        $root->appendChild($element);
      }

      //iconographie
      $oDsDataIcono = $this->oQuery->getDsByTableName("etude_iconographie ei".
          " left join iconographie i on ei.iconographie_id =  i.iconographie_id ".
          " where etude_id=".$etude_id );
      While ($oDrDataIcono = $oDsDataIcono->getRowIter()){
        $iconographie_intitule =  $oDrDataIcono->getValueName("iconographie_intitule");
        $element = $dom->createElement('dc:iconography', htmlspecialchars($iconographie_intitule));
        $root->appendChild($element);
      }

      //partenaires
      $partenaires = "";
      $oDsDataPartenaires = $this->oQuery->getDsByTableName("etude_partenaire ep".
          " left join sit_service ss on ep.service_id = ss.service_id ".
          " where etude_id in (".$etude_id.")" );
      While ($oDrDataPartenaires = $oDsDataPartenaires->getRowIter()){
        $partenaires =  $oDrDataPartenaires->getValueName("service_intitule");
        $element = $dom->createElement('dc:partner', htmlspecialchars($partenaires));
        $root->appendChild($element);
      }

      //commanditaires
      $tabcommanditaires = array();
      $oDsDataCommanditaires = $this->oQuery->getDsByTableName("etude_commanditaires ec".
        " left join sit_service ss on ec.service_id = ss.service_id ".
        " where etude_id in (".$etude_id.")" );
      While ($oDrDataCommanditaires = $oDsDataCommanditaires->getRowIter()){
        $commanditaires =  $oDrDataCommanditaires->getValueName("service_intitule");
        $element = $dom->createElement('dc:owner', htmlspecialchars($commanditaires));
        $root->appendChild($element);
      }


      $etude_cote = $drEtude->getValueName("etude_cote");
      $element = $dom->createElement('dc:cote', htmlspecialchars($etude_cote));
      $root->appendChild($element);

      $etude_prod_periode = $drEtude->getValueName("etude_prod_periode");
      $element = $dom->createElement('dc:period', htmlspecialchars($etude_prod_periode));
      $root->appendChild($element);
      // contact

      $oDsContact = $this->oQuery->getDsByTableName("etude e ".
          " left join sit_service ss on e.etude_contact_service_id = ss.service_id ".
          " where etude_id in (".$etude_id.")" );
      if($oDrContact = $oDsContact->getRowIter()){
        $contactNom       =  $oDrContact->getValueName("service_intitule");
        $contactNomCourt  =  $oDrContact->getValueName("service_intitule_court");
        $contactAdresse   =  $oDrContact->getValueName("service_adresse");
        $contacttel       =  $oDrContact->getValueName("service_tel");
        $contactemail       =  $oDrContact->getValueName("service_email");
        $contactWeb       =  $oDrContact->getValueName("service_web");

        $contact = $dom->createElement('dc:contact');

        $contact->setAttribute("organization_name", htmlspecialchars($contactNom));
        $contact->setAttribute("telephone", htmlspecialchars($contacttel));
        $contact->setAttribute("email", htmlspecialchars($contactemail));
        
        $contact->setAttribute("web", htmlspecialchars($contactWeb));
        
        $root->appendChild($contact);
      } 
      
      $oDsAuthor = $this->oQuery->getDsByTableName("etude e ".
          " left join sit_agent on e.etude_agent_id = sit_agent.agent_id ".
          " where etude_id in (".$etude_id.")" );
      if($oDrAuthor = $oDsAuthor->getRowIter()){
        $contactNom       =  $oDrAuthor->getValueName("agent_nom");
        $contactPrenom       =  $oDrAuthor->getValueName("agent_prenom");
        $contact = $dom->createElement('dc:author', htmlspecialchars($contactNom). ' '. htmlspecialchars($contactPrenom));
        $root->appendChild($contact);
      }
      
      //TODO dc:contact_desc à automatiser
      if($mode==1){
       $dom->save($strFileExport);
       return $strFileExport;
      }else{
        return $dom->saveXML();
      }
    }
    return false;
  }
}
?>