<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Jmaplink
Module d'administration de bordereaux tourinfrance.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once ALK_ALKANET_ROOT_PATH."classes/form/alkhtmlform.class.php";
require_once ALK_ALKANET_ROOT_PATH."scripts/crbn_cat/classes/alkdicocrbn_cat.class.php";

/**
 * @package Alkanet_Module_Jmaplink
 * 
 * @class AlkHtmlDicoJmaplink
 */
class AlkHtmlDicoCrbn_Cat extends AlkHtmlForm 
{
  /** référence sur la déclaration du dictionnaire */
  protected $oDicoCrbn;

  /** url pour afficher la liste des éléments d'un dictionnaire */
  protected $strUrlList;
  
  /** url pour afficher le formulaire du dictionnaire */
  protected $strUrlForm;
  
  /** url pour valider le dictionnaire */
  protected $strUrlSql;
  
  /** dictionnaire sélectionné par défaut */
  protected $iDefaultDico;

  /**
   * Constructeur
   */
  public function __construct(AlkAppli &$oAppli) 
  {
    parent::__construct($oAppli, "formDico");

    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");

    $this->strUrlList = ALK_ALKANET."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_LIST);
    $this->strUrlForm = ALK_ALKANET."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_FORM);
    $this->strUrlSql = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_NONE);
    $this->oDico = new AlkDicoCrbn_Cat($oAppli);
    $this->iDefaultDico = $this->oDico->getFirstDico();   
  }

  /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $oAppliDico = $this->oDico->getAppliDico();
    $oHtmlDico = $oAppliDico->getPanel(); 
    $oHtmlDico->setDataInfoDico($this, $this->strUrlList, $this->strUrlForm, $this->strUrlSql, $this->iDefaultDico, $this->iSSheet);
    return $oHtmlDico->doSql();
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $oAppliDico = $this->oDico->getAppliDico();
    $oHtmlDico = $oAppliDico->getPanel(); 
    $oHtmlDico->setDataInfoDico($this, $this->strUrlList, $this->strUrlForm, $this->strUrlSql, $this->iDefaultDico, $this->iSSheet);
    $oBlockDico = $oHtmlDico->getPanelContents();
    if( !is_null($oBlockDico) ) {
      if( method_exists($oBlockDico, "enableblock") ) $oBlockDico->enableBlock("", $oBlockDico->getLabelDesc(), 5, 790);
      $this->addPanel($oBlockDico);
    }    
  }

  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH."scripts/jmaplink/help/index_admin.htm"); 
  }

}

?>