<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/lib/app_conf_crbn_cat.php");

/**
 * @class AlkHtmlFormConsultCrbn_catForm
 * @brief Description de la classe
 */
class AlkHtmlFormConsultCrbn_catForm extends AlkHtmlForm 
{
  
  protected $strParam;
  protected $etude_id;               
  protected $etude_intitule;
  protected $etude_statut;
  protected $etude_auteurs;
  protected $etude_redacteurs;
  protected $etude_resume;
  protected $etude_mots_cles;
  protected $etude_desc_nb_fascicules;
  protected $etude_desc_nb_pages;
  protected $etude_cout;
  protected $etude_prod_periode;
  protected $etude_annee_achevement;
  protected $etude_annee_maj;
  protected $etude_date_publication;
  protected $etude_cote;
  protected $etude_isrn;
  protected $etude_redacteur;
  protected $etude_droit;
  protected $etude_perimetre_principal_intitule;
  protected $etude_perimetre_principal_geom;
  protected $perimetre_secondaire_intitule;
  protected $thematique_id;
  protected $sous_thematique_id;
  protected $thematique_id2;
  protected $sous_thematique_id2;
  protected $document_type_intitule;
  protected $methodologie_intitule;
  protected $typologie_intitule;
  protected $iconographie_intitule;
  protected $selectTypeTerritoire;
  protected $selectTerritoire;
  protected $partenaire;
  protected $etude_contact_service_id;
  protected $data_pj_pdf;
  protected $data_pj_cc;
  protected $listcommanditaire;
  protected $com_id;   
  protected $data_pj_vignette;  
  protected $etude_url;
  
  /**
   * Constructeur
   * @param oAppli    Application appelante
   */
  public function __construct(AlkAppli &$oAppli) 
  {
    parent::__construct($oAppli, "formCrbnconsult_catForm");
    $this->iMode = AlkRequest::getToken("iMode", AlkRequest::_REQUESTint("iMode", ALK_FORM_MODE_READ));

    $this->cssForm = ""; // pour annuler le css
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".$this->iMode);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;
    $this->setProperties($this->iMode, ALK_FORM_METHOD_POST, $strAction);  

    $this->user_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET);

  }

  /**
   *  Abstract : Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { 
    $etude_id  = AlkRequest::getToken("id", AlkRequest::_REQUESTint("id", -1));
    // tableau de correspondance 
    
        
    // correspondance aec les champs de etude_config
    $tabCorresp[0]["Name"]="config_nom_reg";
    $tabCorresp[0]["ID"]="config_id_reg";
    $tabCorresp[1]["Name"]="config_nom_dep";
    $tabCorresp[1]["ID"]="config_id_dep";
    $tabCorresp[2]["Name"]="config_nom_pnr";
    $tabCorresp[2]["ID"]="config_id_pnr";
    $tabCorresp[3]["Name"]="config_nom_epci";
    $tabCorresp[3]["ID"]="config_id_epci";
    $tabCorresp[4]["Name"]="config_nom_coml";
    $tabCorresp[4]["ID"]="config_id_com";
    $tabCorresp[5]["Name"]="config_nom_pays";
    $tabCorresp[5]["ID"]="config_id_pays";
    $tabCorresp[6]["Name"]="config_nom_au";
    $tabCorresp[6]["ID"]="config_id_au";
    $tabCorresp[7]["Name"]="config_nom_bv";
    $tabCorresp[7]["ID"]="config_id_bv";
    $tabCorresp[8]["Name"]="config_nom_ze";
    $tabCorresp[8]["ID"]="config_id_ze";
    $tabCorresp[9]["Name"]="config_nom_litt";
    $tabCorresp[9]["ID"]="config_id_litt";
    
    $tabValTxt = array(0    => "Région",
        1 => "Départements",
        2 => "Parcs Naturels Régionaux",
        3 => "EPCI", 
        4 => "Communes",
        5 => "Pays",
        6 => "Aires urbaines",
        7 => "Bassins versants",
        8 => "Zones d'emploi",
        9 => "Littoral");

    $this->tabTypeTerritoire = $tabValTxt;
    $this->tabCorresp = $tabCorresp;
    
    $this->etude_id                  = new AlkFormData($this, "etude_id", $etude_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC); // destiné à recup le nom de la table prodige
    $this->etude_intitule            = new AlkFormData($this, "etude_intitule", "", ALK_SQL_TEXT);
    $this->etude_statut              = new AlkFormData($this, "etude_statut", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->etude_auteurs             = new AlkFormData($this, "etude_auteurs", "", ALK_SQL_TEXT);
    $this->etude_redacteurs          = new AlkFormData($this, "etude_redacteurs", "", ALK_SQL_TEXT);
    $this->etude_resume              = new AlkFormData($this, "etude_resume", "", ALK_SQL_TEXT);
    $this->etude_mots_cles           = new AlkFormData($this, "etude_mots_cles", "", ALK_SQL_TEXT);
    $this->etude_desc_nb_fascicules  = new AlkFormData($this, "etude_desc_nb_fascicules", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->etude_desc_nb_pages       = new AlkFormData($this, "etude_desc_nb_pages", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->etude_cout                = new AlkFormData($this, "etude_cout", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->etude_prod_periode        = new AlkFormData($this, "etude_prod_periode", "", ALK_SQL_TEXT);
    $this->etude_annee_achevement    = new AlkFormData($this, "etude_annee_achevement", "", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->etude_annee_maj           = new AlkFormData($this, "etude_annee_maj", "", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->etude_date_publication    = new AlkFormData($this, "etude_date_publication", "", ALK_SQL_DATE);
    $this->etude_cote                = new AlkFormData($this, "etude_cote", "", ALK_SQL_TEXT);
    $this->etude_isrn                = new AlkFormData($this, "etude_isrn", "", ALK_SQL_TEXT);
    $this->etude_redacteur           = new AlkFormData($this, "etude_redacteur", "", ALK_SQL_TEXT);   
    $this->etude_droit               = new AlkFormData($this, "etude_droit", -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);    
    //$this->etude_agent_id           = new AlkFormData($this, "etude_agent_id", -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    //$this->etude_contact_service_id = new AlkFormData($this, "etude_contact_service_id", -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);    
    $this->etude_perimetre_principal_intitule = new AlkFormData($this, "etude_perimetre_principal_intitule", "", ALK_SQL_TEXT);
    $this->etude_perimetre_principal_geom     = new AlkFormData($this, "etude_perimetre_principal_geom", null, ALK_SQL_TEXT);
    $this->etude_perimetre_secondaire_intitule= new AlkFormData($this, "etude_perimetre_secondaire_intitule", "", ALK_SQL_TEXT);    
    $this->thematique_id             = new AlkFormData($this, "thematique_id[]", array(), ALK_SQL_TEXT);    
    $this->sous_thematique_id        = new AlkFormData($this, "sous_thematique_id[]", array(), ALK_SQL_TEXT);  
    $this->theme_type1               = new AlkFormData($this, "theme_type1[]", array(), ALK_SQL_TEXT);  
    
    $this->thematique_id2            = new AlkFormData($this, "thematique_id2[]", array(), ALK_SQL_TEXT);
    $this->sous_thematique_id2       = new AlkFormData($this, "sous_thematique_id2[]",array(), ALK_SQL_TEXT);
    $this->theme_type2               = new AlkFormData($this, "theme_type2[]", array(), ALK_SQL_TEXT);
    
    $this->document_type_intitule    = new AlkFormData($this, "document_type_intitule[]", array(), ALK_SQL_TEXT);
    $this->methodologie_intitule     = new AlkFormData($this, "methodologie_intitule[]", array(), ALK_SQL_TEXT);    
    $this->typologie_intitule        = new AlkFormData($this, "typologie_intitule[]", array(), ALK_SQL_TEXT);  
    $this->iconographie_intitule     = new AlkFormData($this, "iconographie_intitule[]", array(), ALK_SQL_TEXT);  
    $this->selectTypeTerritoire      = new AlkFormData($this, "selectTypeTerritoire", -1, ALK_SQL_TEXT);  
    $this->selectTerritoire          = new AlkFormData($this, "selectTerritoire", -1, ALK_SQL_TEXT);    
    $this->partenaire                = new AlkFormData($this, "partenaire[]", array(), ALK_SQL_TEXT);  
    $this->etude_contact_service_id  = new AlkFormData($this, "etude_contact_service_id", -1, ALK_SQL_NUMBER);  
    $this->listcommanditaire         = new AlkFormData($this, "listcommanditaire[]", array(), ALK_SQL_TEXT);
    $this->com_id                    = new AlkFormData($this, "com_id[]", array(), ALK_SQL_TEXT);
    // telechargment pdf
    $this->data_pj_pdf               = new AlkFormData($this, "data_pj_pdf", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);    
    // telechargment cc
    $this->data_pj_cc                = new AlkFormData($this, "data_pj_cc", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);    
    $this->data_pj_vignette          = new AlkFormData($this, "data_pj_vignette", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT); 
    $this->etude_url                 = new AlkFormData($this, "etude_url", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
        
    $this->etude_geom_astext         =  new AlkFormData($this, "geom_astext", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    
    // initialisation des propriétés par REQUEST ou DATAROW
    $tabData = array(null);
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->getDataEtudeById($etude_id);
      $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
    
  }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql() { 
  	
    
    
    
    $this->setData(ALK_INIT_MODE_REQUEST + ALK_INIT_MODE_DATAROW);
    switch( $this->iMode ) {        

      case ALK_FORM_MODE_ADD:
        //$this->oAppli->oQueryAction->addWithTabQuery($this, $tabReturn, $strTable);

        $this->bclose       = AlkRequest::getToken("bclose", AlkRequest::_REQUESTint("bclose", 0));
        $this->publi        = AlkRequest::getToken("publi", AlkRequest::_REQUESTint("publi", -2));

        
        $tabIgnore = array();
        $tabFields = $this->getTabQuery(array("etude_id"), $tabIgnore);
        $tabFields = $tabFields["field"];


        $serv_id_new_contact = -1;
               
        // cas de la demande 'un nouveau etude_contact_service_id (presence du champ "service_intitule");
        if(array_key_exists("service_intitule", $_REQUEST) && $_REQUEST["etude_contact_service_id"] == -2){
          $serv_id_new_contact = $this->addServ($_REQUEST["service_intitule"], $tabFields["ETUDE_INTITULE"][1], "contacts");
        
          //echo "new contact".$serv_id_new_contact;
          //$this->oAppli->oQueryAction->updateEtudeContact($etude_id, $serv_id_new_contact);
        }

        // creation de la nelle etude_id;
        $etude_id = $this->oAppli->oQueryAction->addEtude($_REQUEST, $this->user_id, $serv_id_new_contact);

        // calcul de la geomtry
        
        if(array_key_exists("COM_ID[]", $tabFields)){ // si un territoire est sélectionné
          
          $field_geomtry_name = "the_geom"; // à fixer??
          $the_geom_union = "";
          $dsthe_geom_union = $this->oAppli->oQuery->GetUnionTheGeomByListComId($tabFields["COM_ID[]"][1], config_id_com, config_table_com, $field_geomtry_name);
        
          if($drthe_geom_union = $dsthe_geom_union->getRowIter()){
            $the_geom_union = $drthe_geom_union->getValueName("the_geom");
          }
          if($the_geom_union != ""){
            
          	$this->oAppli->oQueryAction->updateTheGeomByEtudeId($the_geom_union, $etude_id);
            // verifi du caract region si le perim de l'etude contient le perim de la region  
            $dsthe_geom_union_region = $this->oAppli->oQuery->getDsGeomRegion(config_id_reg, config_table_com, VAL_ID_REGION, $field_geomtry_name, $the_geom_union);
            if($drthe_geom_union_region = $dsthe_geom_union_region->getRowIter()){
              $b_is_regional = $drthe_geom_union_region->getValueName("b_is_regional");
            }

            if($b_is_regional=="t"){
              $this->oAppli->oQueryAction->updateCaractereRegion($etude_id, 1);
            }else{
              $this->oAppli->oQueryAction->updateCaractereRegion($etude_id, 0);
            } 
          }    
        }
        
        // maj du statut

        switch( $this->publi ) {
        
          case  -1: // vers etat archive  >etude_statut =2
            $this->oAppli->oQueryAction->updateStatut($etude_id, 2);
        
            break;
        
          case  0:// de publi vers depubli > etude_statut = 0
            $this->oAppli->oQueryAction->updateStatut($etude_id, 0);
        
            break;
        
          case  1: // vers etat publi  >etude_statut =1
            $this->oAppli->oQueryAction->updateStatut($etude_id, 1);
        
            break;
        
          case  2: //de archive vers en cours ->etude_statut =0
            $this->oAppli->oQueryAction->updateStatut($etude_id, 0);
        
            break;
        
          case  -2 : // par defaut on laisse le statut
            $this->oAppli->oQueryAction->updateStatut($etude_id, $this->etude_statut->value);
            break;
        }

        // creation de service
        // cas de la demande 'un nouveau etude_contact_service_id (presence du champ "service_intitule");
/*        if(array_key_exists("service_intitule", $_REQUEST) && $_REQUEST["etude_contact_service_id"] == -2){
          $serv_id_new_contact = $this->addServ($_REQUEST["service_intitule"], $tabFields["ETUDE_INTITULE"][1], "contacts");
          //$this->oAppli->oQueryAction->updateEtudeContact($etude_id, $serv_id_new_contact);
        }
  */      
        
        $serv_id_new_Commanditaire = -1;
        if(array_key_exists("LISTCOMMANDITAIRE[]", $tabFields)){

          $this->oAppli->oQueryAction->addEtudeCommanditaire($tabFields["LISTCOMMANDITAIRE[]"][1], $etude_id, -2);
          if(array_key_exists("commanditaire_autre", $_REQUEST) && in_array(-2, $tabFields["LISTCOMMANDITAIRE[]"][1])){// cas d'une demande nouv commandiataire
            $serv_id_new_Commanditaire = $this->addServ($_REQUEST["commanditaire_autre"], $tabFields["ETUDE_INTITULE"][1], "commanditaires");
            //echo "new command".$serv_id_new_Commanditaire;
            $this->oAppli->oQueryAction->addCommanditaireId($etude_id, $serv_id_new_Commanditaire);
          }
        }
        
        if(array_key_exists("PARTENAIRE[]", $tabFields)){
          $this->oAppli->oQueryAction->addEtudePartenaires($tabFields["PARTENAIRE[]"][1], $etude_id, array(-3, -2));
          if(array_key_exists("partenaire_autre", $_REQUEST) && in_array(-3, $tabFields["PARTENAIRE[]"][1])){// cas d'une demande nouv PARTENaire
            $serv_id_new_Partenaire = $this->addServ($_REQUEST["partenaire_autre"], $tabFields["ETUDE_INTITULE"][1], "partenaires");
            //echo "new part".$serv_id_new_Partenaire;
            $this->oAppli->oQueryAction->addPartenaireId($etude_id, $serv_id_new_Partenaire);
        
          }
        }

        if(array_key_exists("THEME_TYPE1[]", $tabFields)){
          $this->oAppli->oQueryAction->addEtudeThematiqueConcat($tabFields["THEME_TYPE1[]"][1], $etude_id, 1);
        }
        
        if(array_key_exists("THEME_TYPE2[]", $tabFields)){
          $this->oAppli->oQueryAction->addEtudeThematiqueConcat($tabFields["THEME_TYPE2[]"][1], $etude_id, 2);
        }
        
        if(array_key_exists("DOCUMENT_TYPE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->addDocumentType($tabFields["DOCUMENT_TYPE_INTITULE[]"][1], $etude_id);
        }
        
        if(array_key_exists("TYPOLOGIE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->addTypologie($tabFields["TYPOLOGIE_INTITULE[]"][1], $etude_id);
        }
        if(array_key_exists("METHODOLOGIE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->addMethodologie($tabFields["METHODOLOGIE_INTITULE[]"][1], $etude_id);
        }
        
        if(array_key_exists("ICONOGRAPHIE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->addIconographie($tabFields["ICONOGRAPHIE_INTITULE[]"][1], $etude_id);
        }
        
        // chp sup
        $oDsDataListChampSup = $this->oAppli->oQuery->getDsListChampSupplementaire();
        While($oDrDataListChampSup = $oDsDataListChampSup->getRowIter()){ // pour tous les champs supplémentaire
          $nomChp = $oDrDataListChampSup->getValueName("etude_champ_nom");
        
          if(isset($_REQUEST[$nomChp]) && $_REQUEST[$nomChp]!=""){
            //$this->oAppli->oQueryAction->delEtudeChpSupplementaire($this->etude_id->value);
            $this->oAppli->oQueryAction->insertEtudeChpSupplementaire($etude_id, $_REQUEST[$nomChp], $nomChp);
          }
        }
        
        // enregsitrement des pj data_pj_pdf
        
/*
        if(array_key_exists("data_pj_pdf", $_FILES) && $_FILES["data_pj_pdf"]["name"] != ""){      

          echo "ici0"; die(); 
          $pj_id_doc = $this->oAppli->oQuery->AddPj("etude_pj", $etude_id, "data_pj_pdf", $this->user_id,
            ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, $_FILES["data_pj_pdf"]["name"], false);
        }
        echo "ici1"; die();
        
        if(array_key_exists("data_pj_cc", $_FILES) && $_FILES["data_pj_cc"]["name"] != ""){
          $pj_id_doc = $this->oAppli->oQuery->AddPj("etude_pj", $etude_id, "data_pj_cc", $this->user_id,
              ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, $_FILES["data_pj_cc"]["name"], false);
        }
        if(array_key_exists("data_pj_vignette", $_FILES) && $_FILES["data_pj_vignette"]["name"] != ""){
          $pj_id_doc = $this->oAppli->oQuery->AddPj("etude_pj", $etude_id, "data_pj_vignette", $this->user_id,
              ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, $_FILES["data_pj_vignette"]["name"], false);
        }
  */      
        
        //sauvegarde XML en base pour requetage mnogoseatch 
        $strXmlEtude = $this->oAppli->ExportXml($etude_id, 1, AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT)."indexFiles/fiche_".$etude_id."xml");
        //$this->oAppli->oQueryAction->updateEtudeXml($etude_id, $strXmlEtude);
        
        // retour sur l'onglet Modifier avec la fiche créée
        $strUrl = ALK_ROOT_URL_FRONTOFFICE."/accueil?id=".$etude_id."&iMode=".ALK_FORM_MODE_UPDATE;
        
        if($this->bclose == 1){ // retour vers la liste
          $strUrl = ALK_ROOT_URL_FRONTOFFICE."/accueil?&iMode=".ALK_FORM_MODE_UPDATE;
        }elseif($this->bclose == 0){// retour vers fiche en mode update après enregistrement
           
        }
         
        return $strUrl;
        exit;
        break;
     
      case ALK_FORM_MODE_UPDATE:
 
        // demande de creation de service
        
        $bError = false;
        $this->bclose       = AlkRequest::getToken("bclose", AlkRequest::_REQUESTint("bclose", 0));
        $this->publi        = AlkRequest::getToken("publi", AlkRequest::_REQUESTint("publi", -2));
        
        
        switch( $this->publi ) {
          
          case  -1: // vers etat archive  >etude_statut =2         
            $this->oAppli->oQueryAction->updateStatut($this->etude_id->value, 2);

          break;
                    
          case  0:// de publi vers depubli > etude_statut = 0 
            $this->oAppli->oQueryAction->updateStatut( $this->etude_id->value, 0);
            
          break;
            
          case  1: // vers etat publi  >etude_statut =1 
            $this->oAppli->oQueryAction->updateStatut( $this->etude_id->value, 1);
            //force le retour à la liste
            $this->bclose = 1;
          break;
          
          case  2: //de archive vers en cours ->etude_statut =0 
            $this->oAppli->oQueryAction->updateStatut($this->etude_id->value, 0);
            
          break; 

          case  -2 : // par defaut on laisse le statut 
            $this->oAppli->oQueryAction->updateStatut($this->etude_id->value, $this->etude_statut->value);
          break;
        }

        $tabIgnore = array();
        $tabFields = $this->getTabQuery(array("etude_id"), $tabIgnore);
        $tabFields = $tabFields["field"];       
        if(array_key_exists("COM_ID[]", $tabFields)){ // si un territoire est sélectionné
          $field_geomtry_name = "the_geom"; // à fixer??
          $the_geom_union = "";
          $dsthe_geom_union = $this->oAppli->oQuery->GetUnionTheGeomByListComId($tabFields["COM_ID[]"][1], config_id_com, config_table_com, $field_geomtry_name);
          if($drthe_geom_union = $dsthe_geom_union->getRowIter()){           
            $the_geom_union = $drthe_geom_union->getValueName("the_geom");
          }
        }
        $bAddGeom = in_array(-1, $tabFields["COM_ID[]"][1]);
        $the_geom_union = $this->oAppli->oQueryAction->updateTheGeomByEtudeId($the_geom_union, $this->etude_id->value, $bAddGeom);
        // verifi du caract region si le perim de l'etude contient le perim de la region
        if($the_geom_union!=""){
	        $dsthe_geom_union_region = $this->oAppli->oQuery->getDsGeomRegion(config_id_reg, config_table_com, VAL_ID_REGION, $field_geomtry_name, $the_geom_union);
	        if($drthe_geom_union_region = $dsthe_geom_union_region->getRowIter()){
	          $b_is_regional = $drthe_geom_union_region->getValueName("b_is_regional");            
	        }
	        if($b_is_regional=="t"){
	          $this->oAppli->oQueryAction->updateCaractereRegion($this->etude_id->value, 1);
	        }else{
	          $this->oAppli->oQueryAction->updateCaractereRegion($this->etude_id->value, 0);
	        }
        }

        // creation de service
        $serv_id_new_contact = -1;
        $serv_id_new_Commanditaire = -1;
        $serv_id_new_Partenaire = -1;
        
        $this->oAppli->oQueryAction->updateEtude($tabFields, $this->user_id, $this->etude_id->value);
        
        // cas de la demande 'un nouveau etude_contact_service_id (presence du champ "service_intitule");
        if(array_key_exists("service_intitule", $_REQUEST) && $_REQUEST["etude_contact_service_id"] == -2){
          $serv_id_new_contact = $this->addServ($_REQUEST["service_intitule"], $this->etude_intitule->value, "contacts");       
          
          //echo "new contact".$serv_id_new_contact;
          $this->oAppli->oQueryAction->updateEtudeContact($this->etude_id->value, $serv_id_new_contact);
        }        
        
        if(array_key_exists("LISTCOMMANDITAIRE[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudeCommanditaire($this->etude_id->value);        
          $this->oAppli->oQueryAction->addEtudeCommanditaire($tabFields["LISTCOMMANDITAIRE[]"][1], $this->etude_id->value, -2);
          if(array_key_exists("commanditaire_autre", $_REQUEST) && in_array(-2, $tabFields["LISTCOMMANDITAIRE[]"][1])){// cas d'une demande nouv commandiataire
            $serv_id_new_Commanditaire = $this->addServ($_REQUEST["commanditaire_autre"], $this->etude_intitule->value, "commanditaires");
            //echo "new command".$serv_id_new_Commanditaire;
            $this->oAppli->oQueryAction->addCommanditaireId($this->etude_id->value, $serv_id_new_Commanditaire);
          }
        }

        if(array_key_exists("PARTENAIRE[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudePartenaire($this->etude_id->value);
          $this->oAppli->oQueryAction->addEtudePartenaires($tabFields["PARTENAIRE[]"][1], $this->etude_id->value, array(-3, -2));
          if(array_key_exists("partenaire_autre", $_REQUEST) && in_array(-3, $tabFields["PARTENAIRE[]"][1])){// cas d'une demande nouv PARTENaire
            $serv_id_new_Partenaire = $this->addServ($_REQUEST["partenaire_autre"], $this->etude_intitule->value, "partenaires");
            //echo "new part".$serv_id_new_Partenaire;
            $this->oAppli->oQueryAction->addPartenaireId($this->etude_id->value, $serv_id_new_Partenaire);
            
          }  
        }

        if(array_key_exists("THEME_TYPE1[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudeThematique($this->etude_id->value, 1);
          $this->oAppli->oQueryAction->addEtudeThematiqueConcat($tabFields["THEME_TYPE1[]"][1], $this->etude_id->value, 1);
        }

        if(array_key_exists("THEME_TYPE2[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudeThematique($this->etude_id->value, 2);
          $this->oAppli->oQueryAction->addEtudeThematiqueConcat($tabFields["THEME_TYPE2[]"][1], $this->etude_id->value, 2);
        }

        if(array_key_exists("DOCUMENT_TYPE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudeDocumentType($this->etude_id->value);
          $this->oAppli->oQueryAction->addDocumentType($tabFields["DOCUMENT_TYPE_INTITULE[]"][1], $this->etude_id->value);
        }

        if(array_key_exists("TYPOLOGIE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudeTypologie($this->etude_id->value);
          $this->oAppli->oQueryAction->addTypologie($tabFields["TYPOLOGIE_INTITULE[]"][1], $this->etude_id->value);
        }
        if(array_key_exists("METHODOLOGIE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudeMethodologie($this->etude_id->value);
          $this->oAppli->oQueryAction->addMethodologie($tabFields["METHODOLOGIE_INTITULE[]"][1], $this->etude_id->value);
        }

        if(array_key_exists("ICONOGRAPHIE_INTITULE[]", $tabFields)){
          $this->oAppli->oQueryAction->delEtudeIconographie($this->etude_id->value);
          $this->oAppli->oQueryAction->addIconographie($tabFields["ICONOGRAPHIE_INTITULE[]"][1], $this->etude_id->value);
        }
        
        // chp sup
        $this->oAppli->oQueryAction->delEtudeChpSupplementaire($this->etude_id->value);
        $oDsDataListChampSup = $this->oAppli->oQuery->getDsListChampSupplementaire();
        While($oDrDataListChampSup = $oDsDataListChampSup->getRowIter()){ // pour tous les champs supplémentaire
          $nomChp = $oDrDataListChampSup->getValueName("etude_champ_nom");
        
          if(isset($_REQUEST[$nomChp]) && $_REQUEST[$nomChp]!=""){
            
            $this->oAppli->oQueryAction->insertEtudeChpSupplementaire($this->etude_id->value, $_REQUEST[$nomChp], $nomChp);
          }
        }
        
        //génération automatique de l'imagette
        $document_generate =  AlkRequest::_REQUEST("document_generate", "-1");
        if($document_generate!=-1){
          $dsData = $this->oAppli->oQuery->getDsDataByPjId($document_generate);
          if($drData = $dsData->getRowIter()){
            $file = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$this->oAppli->cont_id. "/".$drData->getValueName("pj_file");
            if(file_exists($file)){
            	//$fileImage = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$drData->getValueName("pj_agentcrea")."/vignette.jpeg";
            	$fileImage = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$this->oAppli->cont_id."/vignette.jpeg";
            	exec("convert ".$file."[0] ".$fileImage, $tabError);             
              if(empty($tabError) && file_exists($fileImage)){
                $this->oAppli->oQuery->DelPjByDataId("etude_pj", $this->etude_id->value, ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", "data_pj_vignette");
              	$pj_id = $this->oAppli->oQuery->AddPj("etude_pj", $this->etude_id->value, "data_pj_vignette", $this->user_id,
                                        ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, "vignette.jpeg", false);
              }else{
              	$bError= true;
              }
            }
          }
        }
        //sauvegarde XML en base pour requetage 
        //$strXmlEtude = $this->oAppli->ExportXml($this->etude_id->value, 0);
        $strXmlEtude = $this->oAppli->ExportXml($this->etude_id->value, 1, AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT)."indexFiles/fiche_".$this->etude_id->value."xml");
        
        //$this->oAppli->oQueryAction->updateEtudeXml($this->etude_id->value,$strXmlEtude);
        
        // retour sur l'onglet Modifier avec la fiche créée
        $strUrl = ALK_ROOT_URL_FRONTOFFICE."/accueil?id=".$this->etude_id->value."&iMode=".ALK_FORM_MODE_UPDATE. ($bError ? "&bError=1" : "");
        
        if($this->bclose == 1 && !$bError){// retour vers la liste
          $strUrl = ALK_ROOT_URL_FRONTOFFICE."/accueil?&iMode=".ALK_FORM_MODE_UPDATE;
        }
       
        return $strUrl;
        exit;
      break;    
        
      exit;
      break;
      
      case ALK_FORM_MODE_DEL : 
        // supp des pj dans etude pj
        $strCheminImage = ALK_ROOT_UPLOAD.AlkFactory::getModuleName($this->oAppli->atype_id)."/".$this->oAppli->cont_id."/";

        $this->oAppli->oQueryAction->del_pj_by_etudeId($this->etude_id->value, $strCheminImage);    

      	//TODO vérification des droits de l'agent pour supprimer l'étude       
        $this->oAppli->oQueryAction->delEtude($this->etude_id->value);
        
        //suppression fichier etude
        $strFileExport = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT)."indexFiles/fiche_".$this->etude_id->value."xml";
        delFile($strFileExport);
        
      	$strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet);
        return ALK_ALKANET_ROOT_URL."accueil";
        
      	//TODO suppression des documents attachés
      	
      	
      break;	
      
      case 4:      // req ajax pour maj liste en fonction du choix d'un type de territoire.
      
      // id du type de territoire select
      $id_type_territoire       = AlkRequest::getToken("id_type_territoire", AlkRequest::_REQUEST("id_type_territoire", ""));      
      
      $tabFields = array();
      $tabFields[] = array(-1, "Sélectionnez des territoires");
      
      //$oDsSsCategorie = $this->oAppli->oQuery->getDsDomForComboDomaine("sdom.ssdom_nom", "sdom.pk_sous_domaine", ALK_BDCOM_RESP_FILTR_DOM, ( $dom_id != -1 ? "AND sdom.pk_domaine =".$dom_id : "" ));
      // liste des champs de la table sélectionnée :
      
      $taballFields = array();
      // champ insee de la couche ou lot si mode tabulaire
      if($id_type_territoire!=-1){
        $dsEtudeconfig = $this->oAppli->oQuery->getEtudeConfig();
        
        
        if($drEtudeconfig = $dsEtudeconfig->getRowIter()){          
        	$dsListTerritoire = $this->oAppli->oQuery->getDsListTerritoireByType($drEtudeconfig->getValueName("config_table_com"), $drEtudeconfig->getValueName($this->tabCorresp[$id_type_territoire]["ID"]), $drEtudeconfig->getValueName($this->tabCorresp[$id_type_territoire]["Name"]));
        }
        while ( $drListTerritoire = $dsListTerritoire->getRowIter() ) {
          $tabFields[] = array($drListTerritoire->getValueName("DATATYPE_ID"), trim($drListTerritoire->getValueName("DATATYPE_INTITULE"))." (".$drListTerritoire->getValueName("DATATYPE_ID").")");
        }
      }

      $array["data_res"] = $tabFields;
      
      echo json_encode( $array);
      exit;
      break;

      case 5:      // req ajax pour maj liste en fonction du choix d'un type de territoire.
      
        // id du type de territoire select
        $id_type_territoire            = AlkRequest::getToken("id_type_territoire", AlkRequest::_REQUEST("id_type_territoire", ""));
        //liste des id des territoire selected
        $strTerritoireIdSelected       = AlkRequest::getToken("strTerritoireIdSelected", AlkRequest::_REQUEST("strTerritoireIdSelected", "")); 
        $tabTerritoireIdSelected = explode("|", $strTerritoireIdSelected);
  
        
        // nouvelle selection
        $strIdTerri="";
        if(count($tabTerritoireIdSelected)>0){
          foreach($tabTerritoireIdSelected as $j => $IdTerri){
              $strIdTerri.= "'".$IdTerri."',";
          }
          $strIdTerri = substr($strIdTerri, 0, -4);
        }

        // req sql pour sélectionner les nelles communes à selectionne
        $tabFields = array();
        if($id_type_territoire!=-1){
          $dsEtudeconfig = $this->oAppli->oQuery->getEtudeConfig();
          if($drEtudeconfig = $dsEtudeconfig->getRowIter()){
            $dsListCommune = $this->oAppli->oQuery->getDsListCommuneByTypeAndListId($drEtudeconfig->getValueName("config_table_com"), $drEtudeconfig->getValueName($this->tabCorresp[$id_type_territoire]["ID"]), $drEtudeconfig->getValueName($this->tabCorresp[4]["Name"]), $drEtudeconfig->getValueName($this->tabCorresp[4]["ID"]), $strIdTerri);
          }
          while ( $drListCommune = $dsListCommune->getRowIter() ) {
            $tabFields[] = array($drListCommune->getValueName("DATATYPE_ID"), $drListCommune->getValueName("DATATYPE_INTITULE"));
            $tabGeom[] = array($drListCommune->getValueName("DATATYPE_ID"), $drListCommune->getValueName("GEOM"));
          }
        }
        // on ajoute à celle déjà sélectionnee
        $array["data_com"] = $tabFields;
        $array["data_geom"] = $tabGeom;
        echo json_encode($array);
        exit;
        break;  

      case 6 :  // changement de theme
      
        $strThemeSelected  = AlkRequest::getToken("strThemeSelected", AlkRequest::_REQUEST("strThemeSelected", ""));
        $tabThemeSelected = explode("|", $strThemeSelected);
        
        // nouvelle selection
        $strIdTheme="";
        if(count($tabThemeSelected)>0){
          foreach($tabThemeSelected as $j => $IdTheme){
            $strIdTheme.= "'".$IdTheme."',";
          }
          $strIdTheme = substr($strIdTheme, 0, -4);
        }
        $tabSSth = array();
        $tabSSth = array(array("-1", "Aucun sous-thème"));
        $oDsSSTheme = $this->oAppli->oQuery->getDsByTableName("sous_thematiques ".($strThemeSelected != "" ?  "WHERE thematique_id IN (".$strIdTheme.")" : "")." ORDER BY sous_thematique_intitule ASC" , false);
        while ( $oDrSSTheme = $oDsSSTheme->getRowIter() ) {
          $tabSSth[] = array($oDrSSTheme->getValueName("sous_thematique_id"), $oDrSSTheme->getValueName("sous_thematique_intitule"));
        }
        $array["data_com"] = $tabSSth;
        echo json_encode($array);
        exit;
        break;

      case 7 :  // changement de theme secondaire
      
        $strThemeSelected  = AlkRequest::getToken("strThemeSelected2", AlkRequest::_REQUEST("strThemeSelected2", ""));
        $tabThemeSelected = explode("|", $strThemeSelected);
        
        // nouvelle selection
        $strIdTheme="";
        if(count($tabThemeSelected)>0){
          foreach($tabThemeSelected as $j => $IdTheme){
            $strIdTheme.= "'".$IdTheme."',";
          }
          $strIdTheme = substr($strIdTheme, 0, -4);
        }

        $tabSSth = array();
        $tabSSth = array(array("-1", "Aucun sous-thème"));
        $oDsSSTheme = $this->oAppli->oQuery->getDsByTableName("sous_thematiques ".($strThemeSelected != "" ?  "WHERE thematique_id IN (".$strIdTheme.")" : "")." ORDER BY sous_thematique_intitule ASC" , false);
        while ( $oDrSSTheme = $oDsSSTheme->getRowIter() ) {
          $tabSSth[] = array($oDrSSTheme->getValueName("sous_thematique_id"), $oDrSSTheme->getValueName("sous_thematique_intitule"));
        }
        $array["data_com"] = $tabSSth;
        echo json_encode($array);
        exit;
        break;
        
      case 8 :  // changement de contact
        
        $id_contact  = AlkRequest::getToken("id_contact", AlkRequest::_REQUESTint("id_contact", -1));

        $oDsPartenaires = $this->oAppli->oQuery->getDsByTableName("sit_service " , false, " WHERE service_id =".$id_contact);

        $array["contactNom"]       =  "";
        $array["contactNomcourt"]  =  "";
        $array["contactAdresse"]   =  "";
        $array["contactTel"]       =  "";
        $array["contactWeb"]       =  "";
        
        while ( $oDrPartenaires = $oDsPartenaires->getRowIter() ) {
         $array["contactNom"]       =  ($oDrPartenaires->getValueName("service_intitule") != null ? $oDrPartenaires->getValueName("service_intitule") :"");
         $array["contactNomcourt"]  =  ($oDrPartenaires->getValueName("service_intitule_court") !=null ? $oDrPartenaires->getValueName("service_intitule_court") :"");
         $array["contactAdresse"]   =  ($oDrPartenaires->getValueName("service_adresse") != null ? $oDrPartenaires->getValueName("service_adresse") :"");
         $array["contactEmail"]   =  ($oDrPartenaires->getValueName("service_email") != null ? $oDrPartenaires->getValueName("service_email") :"");
         
         if($oDrPartenaires->getValueName("service_tel") != null){
           $TabnumTel = str_split($oDrPartenaires->getValueName("service_tel"), 2);

           if((is_array($TabnumTel)) && (count($TabnumTel)>0)){
             $contacttel = "";
             foreach($TabnumTel as $k => $val){
               $contacttel.= $val.".";
             }
             $contacttel = substr($contacttel,0,-1);
             $array["contactTel"]     = $contacttel;
           }else{
             $array["contactTel"]     = "";
           }
         }else{
           $array["contactTel"]     = "";           
         }
         //$array["contactTel"]       =  ($oDrPartenaires->getValueName("service_tel") != null ? $oDrPartenaires->getValueName("service_tel") :"");
         $array["contactWeb"]       =  ($oDrPartenaires->getValueName("service_web") != null ? $oDrPartenaires->getValueName("service_web") :"");           
        }

        echo json_encode($array);
        exit;
        break;
    }
  } 
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);   
    $this->tabActivationChamps = array(); 
    $dsActivationChamps = $this->oAppli->oQuery->getDsActivationChamp(); 
    while ($drActivationChamps = $dsActivationChamps->getRowIter()){
    	$this->tabActivationChamps[$drActivationChamps->getValueName("etude_activation_champ_champ")] = $drActivationChamps->getValueName("etude_activation_champ_statut");
    }
    
    $this->CompteurConsult($this->etude_id->value, "etude_nb_consult");    
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
   
    if($this->iMode == ALK_FORM_MODE_READ || $this->iMode==-1){
      $this->addSheetFicheConsult(); // en mode consult
    }elseif ($this->iMode==ALK_FORM_MODE_UPDATE && $user_right >= ALK_APPLI_RIGHT_ADMIN && $this->etude_id->value!=-1) {     
      //TODO vérification droits sur l'étude
      $this->addSheetFicheModif(); // en mode modif   
    }elseif($this->iMode==ALK_FORM_MODE_UPDATE && $user_right >= ALK_APPLI_RIGHT_ADMIN && $this->etude_id->value==-1){
      $this->iMode = ALK_FORM_MODE_ADD;
      $this->addSheetFicheModif(); // en mode modif   
    }else{

      //redirection vers accueil
    	header("location:/accueil");
    }
  }
  
  private function addSheetFicheConsult() {
    
    
    $oSheetFiche = $this;
    $iSelectWidth = 280;
    $iTxtWidth    = 38;
    $iWidthLabel = 150;
    $iWidthCtrl  = $iSelectWidth+10;

    $this->addScriptJs(ALK_ALKANET_ROOT_URL."scripts/crbn_cat/lib/alkhtmlformconsultcrbn_catform.js");
    $oSheetFiche->setTemplate("crbn_cat", "alkhtmlformficheform.tpl");
    $oSheetFiche->assign("b_mode_update", 0);
    
    $oSheetFiche->assign("tabActivationChamps", $this->tabActivationChamps);
    $oSheetFiche->assign("etude_intitule", $this->etude_intitule->value); 
    $oSheetFiche->assign("etude_auteurs", $this->etude_auteurs->value);
    $oSheetFiche->assign("etude_redacteurs", $this->etude_redacteurs->value);
    $oSheetFiche->assign("etude_resume", str_replace("\r\n", "<br>", $this->etude_resume->value));
    $oSheetFiche->assign("etude_mots_cles", $this->etude_mots_cles->value);
    $oSheetFiche->assign("etude_desc_nb_fascicules", $this->etude_desc_nb_fascicules->value);    
    $oSheetFiche->assign("etude_desc_nb_pages", $this->etude_desc_nb_pages->value);
    $oSheetFiche->assign("etude_cout", $this->etude_cout->value);
    $oSheetFiche->assign("etude_prod_periode", $this->etude_prod_periode->value);
    $oSheetFiche->assign("etude_annee_achevement", $this->etude_annee_achevement->value);
    $oSheetFiche->assign("etude_annee_maj", $this->etude_annee_maj->value);
    $oSheetFiche->assign("etude_date_publication", $this->etude_date_publication->value);
    $oSheetFiche->assign("etude_cote", $this->etude_cote->value);
    $oSheetFiche->assign("etude_isrn", $this->etude_isrn->value);
    $oSheetFiche->assign("etude_redacteur", $this->etude_redacteur->value);    
    $oSheetFiche->assign("etude_perimetre_principal_intitule", $this->etude_perimetre_principal_intitule->value);
    $oSheetFiche->assign("etude_perimetre_secondaire_intitule", $this->etude_perimetre_secondaire_intitule->value);
    

    // image vignette
    $oDsDataVignette = $this->oAppli->oQuery->getDsByTableName(" etude_pj".
        " where data_id = ".$this->etude_id->value." and pj_champ = 'data_pj_vignette'");
    $strCheminVignette = "";
    if($oDrDataVignette = $oDsDataVignette->getRowIter()){
      $strCheminVignette = $oDrDataVignette->getValueName("pj_file");
    }
    $strCheminImage = ALK_ALKANET_ROOT_URL."upload/".AlkFactory::getModuleName($this->oAppli->atype_id)."/".$this->oAppli->cont_id."/".$strCheminVignette;
    $oSheetFiche->assign("chemin_image", $strCheminImage);
    //pour recup la small
    $tabChemin = explode(".", $strCheminVignette);
    $strCheminVignette = ALK_ALKANET_ROOT_URL."upload/".AlkFactory::getModuleName($this->oAppli->atype_id)."/".$this->oAppli->cont_id."/".$tabChemin[0]."_small.".$tabChemin[1];
    $oSheetFiche->assign("chemin_vignette", $strCheminVignette);    
    
    
    // themes
    $oDsDataTheme = $this->oAppli->oQuery->getDsByTableName(" etude_thematique eth". 
                                                            " left join thematique t on eth.thematique_id =  t.thematique_id ".
                                                            " where etude_id in (".$this->etude_id->value.")" );
    $strTheme = "";
    $strTheme2 = "";
    While ($oDrDataTheme = $oDsDataTheme->getRowIter()){
      if($oDrDataTheme->getValueName("etude_thematique_type")==1){  // theme princip
        $strTheme.= $oDrDataTheme->getValueName("thematique_intitule").", ";
      }elseif($oDrDataTheme->getValueName("etude_thematique_type")==2){ // theme 2d
        $strTheme2.= $oDrDataTheme->getValueName("thematique_intitule").", ";
      }
    }

    // ss theme
    $strssTheme = "";
    $strssTheme2 = "";
    $oDsDataSSTheme = $this->oAppli->oQuery->getDsByTableName(" etude_thematique eth".
        " left join sous_thematiques st on eth.sous_thematique_id =  st.sous_thematique_id ".
        " where etude_id in(".$this->etude_id->value.")" );    
    While ($oDrDataSSTheme = $oDsDataSSTheme->getRowIter()){
      if($oDrDataSSTheme->getValueName("etude_thematique_type")==1){  // theme princip      
        $strssTheme.= $oDrDataSSTheme->getValueName("sous_thematique_intitule").", ";
      }elseif($oDrDataSSTheme->getValueName("etude_thematique_type")==2){
        $strssTheme2.=  $oDrDataSSTheme->getValueName("sous_thematique_intitule").", ";
      }  
    }    
    //doc type
    $str_document_type_intitule = "";
    $oDsDataDocType = $this->oAppli->oQuery->getDsByTableName(" etude_document_type edt".
        " left join document_type dt on edt.document_type_id =  dt.document_type_id ".
        " where etude_id = ".$this->etude_id->value );
    While ($oDrDataDocType = $oDsDataDocType->getRowIter()){
      $str_document_type_intitule.=  $oDrDataDocType->getValueName("document_type_intitule").", ";
    }   
    
    //methodologie
    $str_methodologie_intitule ="";
    $oDsDatamethodoType = $this->oAppli->oQuery->getDsByTableName(" etude_methodologie em".
        " left join methodologie methodo on em.methodologie_id =  methodo.methodologie_id ".
        " where etude_id=".$this->etude_id->value );
    While ($oDrDatamethodoType = $oDsDatamethodoType->getRowIter()){
      $str_methodologie_intitule.=  $oDrDatamethodoType->getValueName("methodologie_intitule").", ";
    }

    //typologie
    $tab_typologie_intitule = array();
    $oDsDataTypoType = $this->oAppli->oQuery->getDsByTableName(" etude_typologie et".
        " left join typologie typo on et.typologie_id =  typo.typologie_id ".
        " where etude_id=".$this->etude_id->value );
    While ($oDrDataTypoType = $oDsDataTypoType->getRowIter()){
      $tab_typologie_intitule[] =  $oDrDataTypoType->getValueName("typologie_intitule");
    }
    
    //iconographie
    $str_iconographie_intitule ="";
    $oDsDataIcono = $this->oAppli->oQuery->getDsByTableName("etude_iconographie ei".
        " left join iconographie i on ei.iconographie_id =  i.iconographie_id ".
        " where etude_id=".$this->etude_id->value );
    While ($oDrDataIcono = $oDsDataIcono->getRowIter()){
      $str_iconographie_intitule.=  $oDrDataIcono->getValueName("iconographie_intitule").", ";
    }    

    //partenaires
    $partenaires = "";
    $oDsDataPartenaires = $this->oAppli->oQuery->getDsByTableName("etude_partenaire ep".
        " left join sit_service ss on ep.service_id = ss.service_id ".
        " where etude_id in (".$this->etude_id->value.")" );
    While ($oDrDataPartenaires = $oDsDataPartenaires->getRowIter()){
      $partenaires.=  $oDrDataPartenaires->getValueName("service_intitule").", ";
    }
    if($partenaires == ""){
      $partenaires = "Pas de partenaires  ";
    }
    

    //commanditaires
    $tabcommanditaires = array();
    $oDsDataCommanditaires = $this->oAppli->oQuery->getDsByTableName("etude_commanditaires ec".
        " left join sit_service ss on ec.service_id = ss.service_id ".
        " where etude_id in (".$this->etude_id->value.")" );
    While ($oDrDataCommanditaires = $oDsDataCommanditaires->getRowIter()){
      $tabcommanditaires[] =  $oDrDataCommanditaires->getValueName("service_intitule").", ";
    }

    $oSheetFiche->assign("thematique_intitule", substr($strTheme, 0, -2));
    $oSheetFiche->assign("sous_thematique_intitule", substr($strssTheme, 0, -2));
    $oSheetFiche->assign("thematique_intitule2", substr($strTheme2, 0, -2));
    $oSheetFiche->assign("sous_thematique_intitule2", substr($strssTheme2, 0, -2));
    $oSheetFiche->assign("document_type_intitule", substr($str_document_type_intitule, 0,-2));
    $oSheetFiche->assign("methodologie_intitule", substr($str_methodologie_intitule,0,-2));
    $oSheetFiche->assign("tabtypologie_intitule", $tab_typologie_intitule);
    $oSheetFiche->assign("iconographie_intitule", substr($str_iconographie_intitule, 0,-2));
    $oSheetFiche->assign("partenaires", substr($partenaires, 0, -2));
    $oSheetFiche->assign("tabcommanditaires", $tabcommanditaires);    

    // contact
    $contactNom = "";
    $contactNomCourt ="";
    $contactAdresse = "";
    $contacttel = "";
    $contactWeb = "";
    $oDsDataPartenaires = $this->oAppli->oQuery->getDsByTableName("etude e ".
        " left join sit_service ss on e.etude_contact_service_id = ss.service_id ".
        " where etude_id in (".$this->etude_id->value.")" );
    if($oDrDataPartenaires = $oDsDataPartenaires->getRowIter()){
      $contactNom       =  $oDrDataPartenaires->getValueName("service_intitule");
      $contactNomCourt  =  $oDrDataPartenaires->getValueName("service_intitule_court");
      $contactAdresse   =  $oDrDataPartenaires->getValueName("service_adresse");
      $contacttel       =  $oDrDataPartenaires->getValueName("service_tel");
      $contactWeb       =  $oDrDataPartenaires->getValueName("service_web");
      $contactEmail     =  $oDrDataPartenaires->getValueName("service_email");
      
      $oSheetFiche->assign("contactNom", $contactNom);
      $oSheetFiche->assign("contactNomCourt", $contactNomCourt);
      $oSheetFiche->assign("contactAdresse", $contactAdresse);
      $oSheetFiche->assign("contactEmail", $contactEmail);

      if($contacttel!=""){
        $TabnumTel = str_split($contacttel, 2);
      }
      if((is_array($TabnumTel)) && (count($TabnumTel)>0)){
        $contacttel = "";
        foreach($TabnumTel as $k => $val){
          $contacttel.= $val.".";
        }
        $contacttel = substr($contacttel,0,-1);
      }

      $oSheetFiche->assign("contacttel", $contacttel);
      $oSheetFiche->assign("contactWeb", $contactWeb);
    } 
    
    //Actions
    $strTokenXmlExport = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE, "&iMode=8&id=".$this->etude_id->value);
    $oSheetFiche->assign("oActionXmlExport", "javascript:Export('".$strTokenXmlExport."')");

    
    $dsData = $this->oAppli->oQuery->getDsDataById($this->etude_id->value);
    $tabData = array();
    while($drData = $dsData->getRowIter()){
      if($drData->getvalueName("pj_champ") == "data_pj_pdf"){
        $tabData[] = AlkFactory::getUploadUrl(ALK_ATYPE_ID_CRBN_CAT).$this->oAppli->cont_id. "/".$drData->getValueName("pj_file");
      }      
    }
    $strTokenEtudeExport = ALK_ALKANET_SQL."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE, "&iMode=9&id=".$this->etude_id->value);
    if (empty($tabData)){
      $oSheetFiche->assign("oActionExportEtude", "javascript:Export('Aucun document n'est attaché à l\'étude')");
    }else{
      $oSheetFiche->assign("oActionExportEtude", "javascript:Export('".$strTokenEtudeExport."')");
    }
       
    /*if(count($tabData)>=1){// priorité donnée à la fiche en pj
      $oSheetFiche->assign("oActionConsultEtude", "javascript:void window.open('".$tabData[0]."')");
    }else{// sinon verifier si une url etude est donnée
      //url etude
      if($this->etude_url->value!=""){
        $strUrlEutde = $this->etude_url->value;
        $oSheetFiche->assign("oActionConsultEtude", "javascript:void window.open('".$strUrlEutde."')");
      } 
    }*/
    $tabUrl = array();
    if($this->etude_url->value!="")
      $tabUrl = explode("#", $this->etude_url->value);
    $tabLinks = array_merge($tabData, $tabUrl);
    foreach($tabLinks as $key => $value){
    	$tab = explode("/",$value);
    	$tabInfoLink[substr($tab[count($tab)-1], -38)]= $value;
    }
   
    $oSheetFiche->assign("tabLinks", $tabInfoLink);
      
    
  }

  private function addSheetFicheModif() { // formulaire en mode modif(imode=2) ou add (imode=1)
  
    $this->addScriptJs(ALK_ALKANET_ROOT_URL."scripts/crbn_cat/lib/alkhtmlformconsultcrbn_catform.js");
    $this->addOnload("init(0)");
    
    $this->addVarJs("config_wms", "'".config_wms."'");
    $this->addVarJs("config_layer_wms", "'".config_layer_wms."'");
    $oSheetFiche = $this;
    $oSheetFiche->setTemplate("crbn_cat", "alkhtmlformficheform.tpl");
    $oSheetFiche->assign("b_mode_update", 1);
    $oSheetFiche->assign("tabActivationChamps", $this->tabActivationChamps);
    
    $oSheetFiche->assign("bError", AlkRequest::getToken("bError", AlkRequest::_REQUESTint("bError", 0)));
    $iSelectWidth = 270;
    $iTxtWidth    = 38;
    $iWidthLabel = 150;
    $iWidthCtrl  = $iSelectWidth+10;
    $iWidthSelect= 290;
    $iSelectWidthCourt = 200;
    $iSelecttheme = "100%";
    $nbRows = 8;

    $iModeUpdate = 2;
    
    $oCtrlIntitule = AlkHtmlFactory::getHtmlText($this->etude_intitule, "intitulé", 1, $iTxtWidth*2, 255);
    $oCtrlIntitule->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 0, 255 );
    
    $oCtrlDroitAcces = AlkHtmlFactory::getHtmlSelect($this->etude_droit, "droits", 1, $iSelectWidthCourt);
    $oCtrlDroitAcces->setProperty("tabValTxt", array( 0 => "Libre de droit", 
                                                      1 => "Interne au service"
                                                      )
        );
    $oCtrlDroitAcces->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un droit d'accès à l'étude"));
    $oCtrlDroitAcces->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1);

    $oCtrlAuteurs = AlkHtmlFactory::getHtmlText($this->etude_auteurs, "auteurs de l'étude", 1, "width:25%; min-width:50px;", 255);
    $oCtrlAuteurs->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 0, 255);
    $oCtrlAuteurs->setLabelHelp("Chaque producteur est séparé d'un point virgule (;). Pour un nombre important  d’auteurs  non rattachés à une structure : inscrire « collectif d’auteurs »");
    
    $oCtrlRedacteurs = AlkHtmlFactory::getHtmlText($this->etude_redacteurs, "rédacteurs de l'étude", 1,  "width:25%; min-width:50px;", 255);
    $oCtrlRedacteurs->addValidator(ALK_VERIF_TEXT, 0, 255);
    $oCtrlRedacteurs->setLabelHelp("Première lettre du prénom en majuscule suivie d'un point et du nom en toutes lettres majuscules ; chaque rédacteur est séparé par un point virgule : ex : D. MARTIN ; J-L. DUPOND");
    
    //commanditaires
    
    $tabcomm = array();
    $oDsDataCommanditaires = $this->oAppli->oQuery->getDsByTableName("etude_commanditaires ec".
        " left join sit_service ss on ec.service_id = ss.service_id ".
        " where etude_id in (".$this->etude_id->value.")" );
    While ($oDrDataCommanditaires = $oDsDataCommanditaires->getRowIter()){
      $tabcomm[] =  $oDrDataCommanditaires->getValueName("service_id");
    }

    $this->listcommanditaire->value = $tabcomm;
    $oDsServiceCom = $this->oAppli->oQuery->getDsSelectCommanditaire($this->etude_id->value);
    //$oListCommanditaire = AlkHtmlFactory::getNewHtmlSelect($this, $iModeUpdate, "listCommanditaire", $tabcomm, "liste des commanditaires", 4, $iSelectWidthCourt);
    $oListCommanditaire = AlkHtmlFactory::getHtmlSelect($this->listcommanditaire, "liste des commanditaires", 4, $iSelectWidthCourt);   
    $oListCommanditaire->setProperty("strFieldValue", "SERVICE_ID");
    $oListCommanditaire->setProperty("strFieldText", "SERVICE_INTITULE_COURT");
    $oListCommanditaire->setProperty("tabValTxtDefault", array("-1", "Sélectionnez des commanditaires"));
    $oListCommanditaire->setProperty("oValTxt", $oDsServiceCom);
    $oListCommanditaire->setProperty("tabValTxt", array(-2 => "Autres"));
    $oListCommanditaire->AddEvent("onChange", "ChangeCommanditaire('-2')");
    $oListCommanditaire->setProperty("bMultiple", true);
    $oListCommanditaire->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1);
    $oListCommanditaire->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $this->addOnload("ChangeCommanditaire(-2)");
    // si autres commandiataire

    $oCtrlCommanditaire_autre = AlkHtmlFactory::getNewHtmlText($this, $iModeUpdate, "commanditaire_autre", "Nouveau commanditaire", "Nom de l'organisme", 1, 0, $iTxtWidth, 300);
    $oCtrlCommanditaire_autre->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 0, 70);   
    
    // contact
    $contactNom = "";
    $contactNomCourt ="";
    $contactAdresse = "";
    $contacttel = "";
    $contactWeb = "";
    $oDsDataPartenaires = $this->oAppli->oQuery->getDsByTableName("etude e ".
        " left join sit_service ss on e.etude_contact_service_id = ss.service_id ".
        " where etude_id in (".$this->etude_id->value.")" );
    if($oDrDataPartenaires = $oDsDataPartenaires->getRowIter()){
      $contactNom       =  $oDrDataPartenaires->getValueName("service_intitule");
      $contactNomCourt  =  $oDrDataPartenaires->getValueName("service_intitule_court");
      $contactAdresse   =  $oDrDataPartenaires->getValueName("service_adresse");
      $contacttel       =  $oDrDataPartenaires->getValueName("service_tel");
      if($contacttel!=""){
        $TabnumTel = str_split($contacttel, 2);
      }
      if((is_array($TabnumTel)) && (count($TabnumTel)>0)){
        $contacttel = "";
        foreach($TabnumTel as $k => $val){
          $contacttel.= $val.".";
        }
        $contacttel = substr($contacttel,0,-1);
      }
      $contactWeb       =  $oDrDataPartenaires->getValueName("service_web");
      $oSheetFiche->assign("contactNomConsult", $contactNom);
      $oSheetFiche->assign("contactAdresse", $contactAdresse);
      $oSheetFiche->assign("contacttel", $contacttel);
      $oSheetFiche->assign("contactWeb", $contactWeb);
      $oSheetFiche->assign("contactNomCourt", $contactNomCourt);
    }
    
    $oCtrlContactNom = AlkHtmlFactory::getNewHtmlText($this, $iModeUpdate, "service_intitule", "Nouvel organisme", "Nom de l'organisme", 1, 0, $iTxtWidth, 300);
    $oCtrlContactNom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);   
    $oSheetFiche->assign("contactNom", $oCtrlContactNom->getHtml());

    $oDsListServiceContact = $this->oAppli->oQuery->getDsSelectContact($this->etude_id->value);
    
    $oListContact = AlkHtmlFactory::getHtmlSelect($this->etude_contact_service_id, "Contacts",4, $iSelectWidthCourt);
    $oListContact->setProperty("oValTxt", $oDsListServiceContact);
    $oListContact->setProperty("strFieldValue", "service_id");
    $oListContact->setProperty("strFieldText", "SERVICE_INTITULE_COURT");
    $oListContact->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un contact"));
    $oListContact->setProperty("tabValTxt", array(-2 => "Autres (Organismes)" ));
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=8");
    $oListContact->AddEvent("onChange", "ChangeContact('".$strToken."', '-2')");
    $oListContact->setProperty("bMultiple", false);
    $oListContact->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $oListContact->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1);
    $this->addOnLoad("ChangeContact('".$strToken."', '-2')");
    // resume
    $oCtrlResume = AlkHtmlFactory::getHtmlText($this->etude_resume, "Résumé", 10, 100, 5000);
    $oCtrlResume->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 0, 5000);
    //mots cles
    $oCtrlMotCle = AlkHtmlFactory::getHtmlText($this->etude_mots_cles, "", 1, $iTxtWidth, 1000);
    $oCtrlMotCle->addValidator(ALK_VERIF_TEXT, 0, 1000);
    $oCtrlMotCle->setLabelHelp("Mots clés libres ; séparés par une virgule (,)");
    // description
    $oCtrlNbFasc = AlkHtmlFactory::getHtmlText($this->etude_desc_nb_fascicules, "Nombre de fascicules", 1, 3, 3);
    $oCtrlNbFasc->addValidator(ALK_VERIF_INT+ALK_IS_REQUIRED, 0, 999);
    
    $oCtrlNbPage = AlkHtmlFactory::getHtmlText($this->etude_desc_nb_pages, "Nombre de pages", 1, 4, 4);
    $oCtrlNbPage->addValidator(ALK_VERIF_INT+ALK_IS_REQUIRED, 0,9999);
    
    //iconographie
    $tabicono = array();
    $oDsDataIcono = $this->oAppli->oQuery->getDsByTableName("etude_iconographie ei".
        " left join iconographie i on ei.iconographie_id =  i.iconographie_id ".
        " where etude_id=".$this->etude_id->value );
    While ($oDrDataIcono = $oDsDataIcono->getRowIter()){
      $tabicono[] =  $oDrDataIcono->getValueName("iconographie_id");
    }
    
    $this->iconographie_intitule->value = $tabicono;
    
    $oDsDoci = $this->oAppli->oQuery->getDsByTableName("iconographie ORDER BY iconographie_intitule ASC" , false);
    $iconographie = AlkHtmlFactory::getHtmlSelect($this->iconographie_intitule, "iconographie",4, $iSelectWidthCourt);
    $iconographie->setProperty("oValTxt", $oDsDoci);
    $iconographie->setProperty("strFieldValue", "iconographie_id");
    $iconographie->setProperty("strFieldText", "iconographie_intitule");
    $iconographie->setProperty("tabValTxtDefault", array("-1", "Sélectionnez des iconographies"));
    $iconographie->setProperty("bMultiple", true);
    $iconographie->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $iconographie->addValidator(ALK_VERIF_SELECT, -1);
    
    //doc type
    $tabdoc = array();
    $oDsDataDocType = $this->oAppli->oQuery->getDsByTableName(" etude_document_type edt".
        " left join document_type dt on edt.document_type_id =  dt.document_type_id ".
        " where etude_id=".$this->etude_id->value );
    While ($oDrDataDocType = $oDsDataDocType->getRowIter()){
      $tabdoc[] =  $oDrDataDocType->getValueName("document_type_id");
    }
    $this->document_type_intitule->value = $tabdoc;
    
    $oDsDoc = $this->oAppli->oQuery->getDsByTableName("document_type ORDER BY document_type_intitule ASC" , false);
    $document_type_intitule = AlkHtmlFactory::getHtmlSelect($this->document_type_intitule, "type de document",4, $iSelectWidthCourt);
    $document_type_intitule->setProperty("oValTxt", $oDsDoc);
    $document_type_intitule->setProperty("strFieldValue", "document_type_id");
    $document_type_intitule->setProperty("strFieldText", "document_type_intitule");
    $document_type_intitule->setProperty("tabValTxtDefault", array("-1", "Sélectionnez des types de documents"));
    $document_type_intitule->setProperty("bMultiple", true);
    //$document_type_intitule->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $document_type_intitule->addValidator(ALK_VERIF_SELECT, -1);

    //Typologie
    $tab_typologie_intitule = array();
    $oDsDataTypoType = $this->oAppli->oQuery->getDsByTableName(" etude_typologie et".
        " left join typologie typo on et.typologie_id =  typo.typologie_id ".
        " where etude_id=".$this->etude_id->value );
    While ($oDrDataTypoType = $oDsDataTypoType->getRowIter()){
      $tab_typologie_intitule[] =  $oDrDataTypoType->getValueName("typologie_id");
    }
    
    $this->typologie_intitule->value = $tab_typologie_intitule;
    
    $oDsDotypo = $this->oAppli->oQuery->getDsByTableName("typologie ORDER BY typologie_intitule ASC" , false);
    $oTypo = AlkHtmlFactory::getHtmlSelect($this->typologie_intitule, "typologie",4, $iSelectWidthCourt);
    $oTypo->setProperty("oValTxt", $oDsDotypo);
    $oTypo->setProperty("strFieldValue", "typologie_id");
    $oTypo->setProperty("strFieldText", "typologie_intitule");
    $oTypo->setProperty("tabValTxtDefault", array("-1", "Sélectionnez des typologies"));
    $oTypo->setProperty("bMultiple", true);
    $oTypo->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");  
    $oTypo->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1);
    
    // cout 
    $oCtrlCout = AlkHtmlFactory::getHtmlText($this->etude_cout, "Coût de l'étude", 1, 10, 10);
    $oCtrlCout->addValidator(ALK_VERIF_TEXT, 0, 1000000000);  

    // pour le choix du perimetre principal :
    // 1. liste des types de territoire

    $oCtrlTypeTerritoire = AlkHtmlFactory::getHtmlSelect($this->selectTypeTerritoire, "'liste des Communes de la zone principale'",1);
    $oCtrlTypeTerritoire->setProperty("tabValTxt", $this->tabTypeTerritoire); 
    $oCtrlTypeTerritoire->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un type de territoire géographique"));
    //$oCtrlTypeTerritoire->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1); 
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=4");
    $oCtrlTypeTerritoire->AddEvent("onChange", "ChangeTypeTerritoire('".$strToken."')");
    
    // 2. choix des territoire : liste multiple   com_dispo
    $tabFields = array();
    $oCtrlChoixTerritoire = AlkHtmlFactory::getHtmlSelect($this->selectTerritoire, "Liste des Communes",$nbRows);       
    $oCtrlChoixTerritoire->setProperty("tabValTxt", $tabFields); 
    $oCtrlChoixTerritoire->setProperty("tabValTxtDefault", array("-1", "Sélectionnez des territoires"));
    $oCtrlChoixTerritoire->setProperty("bMultiple", true);
    $oCtrlChoixTerritoire->setLabelHelp("Vous pouvez sélectionner plusieurs items à l'aide de la touche schift ou Ctrl. <br> Vous pouvez aussi sélectionner un territoire en double-cliquant sur l'intitulé du territoire.");
    $strTokenAddCom = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=5");
    
    $oCtrlChoixTerritoire->AddEvent("ondblclick", "AddCom('".$strTokenAddCom."')");    
    //$oCtrlChoixTerritoire->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1);
        
    // 3. maj d'une liste des communes sélectionnées pour le rendu géographique
    // generation d'une geéographie -> union : enregsitre dans 
    $oProjCom = AlkHtmlFactory::getHtmlSelect($this->com_id, "Sélection d'un territoire", $nbRows);
    $oProjCom->setProperty("oValTxt", array());
    $oProjCom->setProperty("bMultiple", true);
    $oProjCom->setProperty("strFieldValue", "COM_ID");
    $oProjCom->setProperty("strFieldText", "COM_INTITULE");

    if($this->etude_perimetre_principal_geom->value != null){
      $this->com_id->value = -1;
      $oProjCom->setProperty("tabValTxtDefault", array("-1", "Territoire constitué"));      
      $oProjCom->addValidator(ALK_VERIF_SELECT, -1);
      $this->addJs("var initFeature = '".$this->etude_geom_astext->value ."';");
    }else{
      $oProjCom->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1);
    }
    // texte intitule perim principal
    $oCtrlEtude_perimetre_principal_intitule= AlkHtmlFactory::getHtmlText($this->etude_perimetre_principal_intitule, "intitulé du périmètre principal", 1, $iTxtWidth, 300);
    $oCtrlEtude_perimetre_principal_intitule->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 0, 300);  

    // texte intitule perim secondaire
    $oCtrlEtude_perimetre_secondaire_intitule= AlkHtmlFactory::getHtmlText($this->etude_perimetre_secondaire_intitule, "intitulé du périmètre secondaire", 1, $iTxtWidth, 300);
    $oCtrlEtude_perimetre_secondaire_intitule->addValidator(ALK_VERIF_TEXT);    
  
    // Bouton s bloc geog
    $strTokenAddCom = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=5");
    $oBtAddCom = AlkHtmlFactory::getHtmlButton("javascript:AddCom('".$strTokenAddCom."')", "+", "Ajouter les communes des territoires sélectionnés");
    $oBtDelCom = AlkHtmlFactory::getHtmlButton("javascript:removeGeoloc('com')", "-", "Retirer les communes sélectionnées");
    $oSheetFiche->assign("oBtAddCom", $oBtAddCom->getHtml());
    $oSheetFiche->assign("oBtDelCom", $oBtDelCom->getHtml());
     
    $oLienVider = AlkHtmlFactory::getHtmlLink("javascript:viderComm('com')", "Vider");
    $oSheetFiche->assign("oLienVider", $oLienVider->getHtml());
    
    
    // themes
    $oDsDataTheme = $this->oAppli->oQuery->getDsByTableName(" etude_thematique eth".
        " left join thematique t on eth.thematique_id =  t.thematique_id ".
        " where etude_id in (".$this->etude_id->value.")" );
    $tabTheme = array();
    $tabTheme2 = array();
    While ($oDrDataTheme = $oDsDataTheme->getRowIter()){
      if($oDrDataTheme->getValueName("etude_thematique_type")==1){  // theme princip
        $tabTheme[] = $oDrDataTheme->getValueName("thematique_id");
      }elseif($oDrDataTheme->getValueName("etude_thematique_type")==2){ // theme 2d
         $tabTheme2[] = $oDrDataTheme->getValueName("thematique_id");
      }
    }
    $this->thematique_id->value = $tabTheme;
    $this->thematique_id2->value = $tabTheme2;
    // ss theme
    $tabSSTheme = array();
    $tabSSTheme2 = array();
    $tabStrConcatThem1 = array();
    $tabStrConcatThem2 = array();
    $oDsDataSSTheme = $this->oAppli->oQuery->getDsByTableName(" etude_thematique eth".
        " left join sous_thematiques st on eth.sous_thematique_id =  st.sous_thematique_id ".
        " left join thematique th on eth.thematique_id =  th.thematique_id ".
        " where etude_id in(".$this->etude_id->value.")" );
    While ($oDrDataSSTheme = $oDsDataSSTheme->getRowIter()){
      if($oDrDataSSTheme->getValueName("etude_thematique_type")==1){  // theme princip
        // cas des ss-theme null
        if(is_null($oDrDataSSTheme->getValueName("sous_thematique_id"))){
          $tabSSTheme[] = -1;
          $id_concat_theme1 = $oDrDataSSTheme->getValueName("thematique_id")."/-1";
          $tabStrConcatThem1[$id_concat_theme1] =  $oDrDataSSTheme->getValueName("thematique_intitule")."/Aucun sous-thème";
          
        }else{
          $tabSSTheme[] = $oDrDataSSTheme->getValueName("sous_thematique_id");
          $id_concat_theme1 = $oDrDataSSTheme->getValueName("thematique_id")."/".$oDrDataSSTheme->getValueName("sous_thematique_id");
          $tabStrConcatThem1[$id_concat_theme1] =  $oDrDataSSTheme->getValueName("thematique_intitule")."/".$oDrDataSSTheme->getValueName("sous_thematique_intitule");
        }
      }elseif($oDrDataSSTheme->getValueName("etude_thematique_type")==2){
        
        
        // cas des ss-theme null
        if(is_null($oDrDataSSTheme->getValueName("sous_thematique_id"))){
          $tabSSTheme2[] = -1;
          $id_concat_theme2 = $oDrDataSSTheme->getValueName("thematique_id")."/-1";
          $tabStrConcatThem2[$id_concat_theme2] =  $oDrDataSSTheme->getValueName("thematique_intitule")."/Aucun sous-thème";
        
        }else{
          $tabSSTheme2[] =  $oDrDataSSTheme->getValueName("sous_thematique_id");
          $id_concat_theme2 = $oDrDataSSTheme->getValueName("thematique_id")."/".$oDrDataSSTheme->getValueName("sous_thematique_id");
          $tabStrConcatThem2[$id_concat_theme2] =  $oDrDataSSTheme->getValueName("thematique_intitule")."/".$oDrDataSSTheme->getValueName("sous_thematique_intitule");
        }
      }
    }

    $this->sous_thematique_id2->value = $tabSSTheme2;
    $this->sous_thematique_id->value = $tabSSTheme;
    $this->theme_type1->value = $tabStrConcatThem1;
    $this->theme_type2->value = $tabStrConcatThem2;    
    
    //print_r($this->thematique_id->value);
        
    $oDsTheme = $this->oAppli->oQuery->getDsByTableName("thematique ORDER BY thematique_intitule ASC" , false);
    //$oDsSSTheme = $this->oAppli->oQuery->getDsByTableName("sous_thematiques where thematique_id = ".$this->thematique_id->value[0]." ORDER BY sous_thematique_intitule ASC" , false);
        
    $theme1 = AlkHtmlFactory::getHtmlSelect($this->thematique_id, "Thèmes",4, $iSelecttheme);
    $theme1->setProperty("oValTxt", $oDsTheme);
    $theme1->setProperty("strFieldValue", "thematique_id");
    $theme1->setProperty("strFieldText", "thematique_intitule");
    $theme1->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un thème"));
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=6");
    $theme1->AddEvent("onDblclick", "AddTheme1onDblclick()");
    $theme1->AddEvent("onChange", "ChangeTheme('".$strToken."')");
    $theme1->setProperty("bMultiple", false);
    $theme1->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl. <br> Vous pouvez aussi directement ajouter un thème <br/>en double-cliquant sur un thème sélectionné.");
    $theme1->addValidator(ALK_VERIF_SELECT, -1);
    
    $oSStheme1 = AlkHtmlFactory::getHtmlSelect($this->sous_thematique_id, "Sous-thématiques",4, $iSelecttheme);    
    //$oSStheme1->setProperty("oValTxt", $oDsSSTheme);
    //$oSStheme1->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un sous-thème"));
    $oSStheme1->setProperty("strFieldValue", "sous_thematique_id");
    $oSStheme1->setProperty("strFieldText", "sous_thematique_intitule");
    $oSStheme1->setProperty("bMultiple", false);
    $oSStheme1->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $oSStheme1->addValidator(ALK_VERIF_SELECT, -1);
    $oSStheme1->AddEvent("onDblclick", "AddTheme1onDblclick()");        

    //  maj d'une liste des theme et ss theme principaus
    // generation d'une geéographie -> union : enregsitre dans
    $oCtrlListTheme1 = AlkHtmlFactory::getHtmlSelect($this->theme_type1, "thèmes principaux", $nbRows, $iSelectWidth);
    $oCtrlListTheme1->setProperty("oValTxt", array());
    $oCtrlListTheme1->setProperty("bMultiple", true);
    $oCtrlListTheme1->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $oCtrlListTheme1->setProperty("tabValTxt", $this->theme_type1->value);
    $oCtrlListTheme1->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED);
    $this->addOnLoad("selectAllTheme1()");
    // Bouton s bloc geog
    //$strTokenAddCom = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=5");
    $oBtAddTheme1 = AlkHtmlFactory::getHtmlButton("javascript:AddTheme1()", "Ajouter", "Ajouter les thèmes et sous-thèmes associés");
    $oBtDelTheme1 = AlkHtmlFactory::getHtmlButton("javascript:removeTheme1()", "Retirer", "Retirer les thèmes et sous thèmes sélectionnées");
    
    $oSheetFiche->assign("oBtAddTheme1", $oBtAddTheme1->getHtml());
    $oSheetFiche->assign("oBtDelTheme1", $oBtDelTheme1->getHtml());
    $oSheetFiche->assign("oCtrlListTheme1", $oCtrlListTheme1->getHtml());    
    

    $theme2 = AlkHtmlFactory::getHtmlSelect($this->thematique_id2, "Thèmes",4, $iSelecttheme);
    $theme2->setProperty("oValTxt", $oDsTheme);
    $theme2->setProperty("strFieldValue", "thematique_id");
    $theme2->setProperty("strFieldText", "thematique_intitule");
    $theme2->setProperty("tabValTxtDefault", array("-1", "Aucun thème"));
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=7");
    $theme2->AddEvent("onChange", "ChangeTheme2('".$strToken."')");
    $theme2->AddEvent("onDblclick", "AddTheme2onDblclick()");
    $theme2->setProperty("bMultiple", false);
    $theme2->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl. <br/> Vous pouvez aussi directement ajouter un thème <br/>en double-cliquant sur un thème sélectionné.");
    $theme2->addValidator(ALK_VERIF_SELECT);
        
    $oSStheme2 = AlkHtmlFactory::getHtmlSelect($this->sous_thematique_id2, "Sous-thématiques",4, $iSelecttheme);
    //$oDsSSTheme2 = $this->oAppli->oQuery->getDsByTableName("sous_thematiques where thematique_id = ".$this->thematique_id2->value[0]." ORDER BY sous_thematique_intitule ASC" , false);
    //$oSStheme2->setProperty("oValTxt", $oDsSSTheme2);
    //$oSStheme2->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un sous-thème"));
    $oSStheme2->setProperty("strFieldValue", "sous_thematique_id");
    $oSStheme2->setProperty("strFieldText", "sous_thematique_intitule");
    $oSStheme2->setProperty("bMultiple", false);
    $oSStheme2->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $oSStheme2->addValidator(ALK_VERIF_SELECT, -1);
    $oSStheme2->AddEvent("onDblclick", "AddTheme2onDblclick()");
        
    //  maj d'une liste des theme et ss theme principaus
    // generation d'une geéographie -> union : enregsitre dans
    $oCtrlListTheme2 = AlkHtmlFactory::getHtmlSelect($this->theme_type2, "theme_type2", $nbRows, $iSelectWidth);
    $oCtrlListTheme2->setProperty("oValTxt", array());
    $oCtrlListTheme2->setProperty("bMultiple", true);
    $oCtrlListTheme2->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $oCtrlListTheme2->setProperty("tabValTxt", $this->theme_type2->value);
    $oCtrlListTheme2->addValidator(ALK_VERIF_SELECT, -1);
    $this->addOnLoad("selectAllTheme2()");
    
    
    // Bouton s bloc geog
    //$strTokenAddCom = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=5");
    $oBtAddTheme2 = AlkHtmlFactory::getHtmlButton("javascript:AddTheme2()", "Ajouter", "Ajouter les thèmes et sous-thèmes associés");
    $oBtDelTheme2 = AlkHtmlFactory::getHtmlButton("javascript:removeTheme2()", "Retirer", "Retirer les thèmes et sous-thèmes sélectionnées");
    
    $oSheetFiche->assign("oBtAddTheme2", $oBtAddTheme2->getHtml());
    $oSheetFiche->assign("oBtDelTheme2", $oBtDelTheme2->getHtml());
    $oSheetFiche->assign("oCtrlListTheme2", $oCtrlListTheme2->getHtml());
        
    
    // prod
    //methodologie
    
    $tabmethodo = array();
    
    $oDsDatamethodoType = $this->oAppli->oQuery->getDsByTableName(" etude_methodologie em".
        " left join methodologie methodo on em.methodologie_id =  methodo.methodologie_id ".
        " where etude_id=".$this->etude_id->value );
    While ($oDrDatamethodoType = $oDsDatamethodoType->getRowIter()){
      $tabmethodo[] =  $oDrDatamethodoType->getValueName("methodologie_id");
    }
    $this->methodologie_intitule->value = $tabmethodo;
    $oDsDocm = $this->oAppli->oQuery->getDsByTableName("methodologie ORDER BY methodologie_intitule ASC" , false);
    $oMethodo = AlkHtmlFactory::getHtmlSelect($this->methodologie_intitule, "Intitule de la methodologie",4, $iSelectWidthCourt);
    $oMethodo->setProperty("oValTxt", $oDsDocm);
    $oMethodo->setProperty("strFieldValue", "methodologie_id");
    $oMethodo->setProperty("strFieldText", "methodologie_intitule");
    $oMethodo->setProperty("tabValTxtDefault", array("-1", "Sélectionnez des methodologies"));
    $oMethodo->setProperty("bMultiple", true);
    $oMethodo->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/> à l'aide de la touche schift ou Ctrl.");
    $oMethodo->addValidator(ALK_VERIF_SELECT, -1);    
    
    //Partenaires asscoiés
    //partenaires
    
    $oDsListServicePart = $this->oAppli->oQuery->getDsSelectPartenaire($this->etude_id->value);
    
    
    $tabPartenaire = array();
    $oDsDataPartenaires = $this->oAppli->oQuery->getDsByTableName("etude_partenaire ep".
        " left join sit_service ss on ep.service_id = ss.service_id ".
        " where etude_id in (".$this->etude_id->value.")" );
    While ($oDrDataPartenaires = $oDsDataPartenaires->getRowIter()){
      $tabPartenaire[] =  $oDrDataPartenaires->getValueName("service_id");
    }

    if(count($tabPartenaire)==0 && $this->iMode==ALK_FORM_MODE_ADD){
      $tabPartenaire[0]=-1; // à sélectionner
    }elseif(count($tabPartenaire)==0 && $this->iMode==ALK_FORM_MODE_UPDATE){
      $tabPartenaire[0]=-2; // pas de partenaire
    }
    
    $this->partenaire->value = $tabPartenaire;
    $oPartenaires = AlkHtmlFactory::getHtmlSelect($this->partenaire, "Partenaire",4, $iSelectWidthCourt);
    $oPartenaires->setProperty("oValTxt", $oDsListServicePart);
    $oPartenaires->setProperty("strFieldValue", "service_id");
    $oPartenaires->setProperty("strFieldText", "SERVICE_INTITULE_COURT");
    $oPartenaires->setProperty("tabValTxt", array(-2 => "Pas de partenaires", -3 => "Autres"));
    $oPartenaires->setProperty("tabValTxtDefault", array("-1", "Sélectionnez des partenaires"));
    $oPartenaires->AddEvent("onChange", "ChangePartenaire('-3')");
    $oPartenaires->setProperty("bMultiple", true);
    $oPartenaires->setLabelHelp("Vous pouvez sélectionner plusieurs items <br/>à l'aide de la touche schift ou Ctrl.");
    $oPartenaires->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, -1);    
    $this->addOnload("ChangePartenaire(-3)");
    // bloc pour saisir un autre parteniaire
    $oCtrlPartenaire_autre = AlkHtmlFactory::getNewHtmlText($this, $iModeUpdate, "partenaire_autre", "Nouveau partenaire", "Nom de l'organisme", 1, 0, $iTxtWidth, 300);
    $oCtrlPartenaire_autre->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 0, 70);

    // periode prod
    $oCtrlPeriodProd = AlkHtmlFactory::getHtmlText($this->etude_prod_periode, "période de production", 1, 9, 9);
    $oCtrlPeriodProd->addValidator(ALK_VERIF_TEXT, 0, 9);
    $oCtrlPeriodProd->setLabelHelp("Début et fin de période matérialisées par deux années séparées d'un / (Ex : 1999/2005)");
    // annee acchev
    $oCtrlAnneeAchev = AlkHtmlFactory::getHtmlText($this->etude_annee_achevement, "Année d'achèvement", 1, 4, 4);
    $oCtrlAnneeAchev->addValidator(ALK_VERIF_INT+ALK_IS_REQUIRED, 1900, 2100);
    //annee maj
    $oCtrlAnneeMaj = AlkHtmlFactory::getHtmlText($this->etude_annee_maj, "Année de mise à jour", 1, 4, 4);
    $oCtrlAnneeMaj->addValidator(ALK_VERIF_INT, 1900, 2100);
    // sera maj à la validation
    
    if($this->iMode == ALK_FORM_MODE_ADD){
      $this->etude_date_publication->value = 	date("d/m/Y");
      $oCtrlDatePublication = AlkHtmlFactory::getHtmlText($this->etude_date_publication, "Date de publication", 1, 12, 12 );
      $oCtrlDatePublication->setProperty("bReadOnly", true );      
      //$oCtrlDatePublication = AlkHtmlFactory::getHtmlHidden($this->etude_date_publication);
      $oCtrlDatePublication->addValidator(ALK_VERIF_DATE10);
    }else{
      $oCtrlDatePublication = AlkHtmlFactory::getHtmlText($this->etude_date_publication, "Date de publication", 1, 12, 12 );
      $oCtrlDatePublication->addValidator(ALK_VERIF_DATE10);
      $oCtrlDatePublication->setProperty("bReadOnly", true );
    }
    // cote
    $oCtrlCote = AlkHtmlFactory::getHtmlText($this->etude_cote, "côte", 1,  "width:25%; min-width:50px;", 20);
    $oCtrlCote->addValidator(ALK_VERIF_TEXT, 0 ,20);
    //isrn
    $oCtrlIsrn= AlkHtmlFactory::getHtmlText($this->etude_isrn, "isrn", 1,  "width:25%; min-width:50px;", 36);
    $oCtrlIsrn->addValidator(ALK_VERIF_TEXT, 0, 36);
   
    
    // vignette de couverture
    // générér l'image automatiquement
    // lien de téléchargement de l'étude
    

/*
    if ( $this->iMode==ALK_FORM_MODE_ADD){
      $data_pj_pdf = AlkHtmlFactory::getHtmlFile($this->data_pj_pdf, _t("Pièce jointe"), $iTxtWidth-12, 255);
      $data_pj_pdf->setFileUrl($this->oAppli->getUrlUpload(), $this->data_pj_pdf->value);
      if ( !is_null($data_pj_pdf) ){
          $data_pj_pdf->setDualMode(true);
      }
    }else*/
    $htmlTelePdf = "";
    if ( $this->iMode==ALK_FORM_MODE_UPDATE){  
      $data_pj_pdf = AlkHtmlFactory::getNewHtmlUpload(null, 3, $this->data_pj_pdf->name, "Pièces jointes", "etude_pj",
          $this->etude_id->value, AlkFactory::getModuleName($this->oAppli->atype_id)."/".$this->oAppli->cont_id."/");
      $data_pj_pdf->setProperty("oForm", $this);
      $data_pj_pdf->setProperty("formName", $this->name);  
      $data_pj_pdf->setProperty("width", "95%");
      $htmlTelePdf = $data_pj_pdf->getHtml();
    }    
   
    if ($this->iMode==ALK_FORM_MODE_ADD || $this->iMode==ALK_FORM_MODE_UPDATE){
     //champs pour saisir une url / qui pointe sur un site / pour une étude
      $oCtrlUrlEtude= AlkHtmlFactory::getHtmlText($this->etude_url, "url", 1,  "width:25%; min-width:50px;", 1500);
      $oCtrlUrlEtude->addValidator(ALK_VERIF_TEXT, 0, 1500);    
      $oCtrlUrlEtude->setLabelHelp("Vous pouvez saisir une url afin de pointer sur le rapport d'une étude. L'url doit être du type : http://www.xxxxxx.xxx . 
          Dans le cas où l'url et le fichier de l'étude sont à la fois renseignés, la priorité sera donnée à la pièce jointe lors de la consultation.");
    }

/*    if ( $this->iMode==ALK_FORM_MODE_ADD){
      $data_pj_cc = AlkHtmlFactory::getHtmlFile($this->data_pj_cc, _t("Pièce jointe"), $iTxtWidth-12, 255);
      if ( !is_null($data_pj_cc) ){
        //$data_pj_cc->setLabelAfter(_t("Vous pouvez ajouter une pièce jointe à la création et plusieurs pièces jointes en modification."));
        $data_pj_cc->setDualMode(true);
      }
    }else {
    */
    $htmlTeleCC = "";
    if ( $this->iMode==ALK_FORM_MODE_UPDATE){
      $data_pj_cc = AlkHtmlFactory::getNewHtmlUpload(null, 3, $this->data_pj_cc->name, "Pièces jointes", "etude_pj",
          $this->etude_id->value, AlkFactory::getModuleName($this->oAppli->atype_id)."/".$this->oAppli->cont_id."/");
      $data_pj_cc->setProperty("oForm", $this);
      $data_pj_cc->setProperty("formName", $this->name);
      
      $data_pj_cc->setProperty("width", "95%");
      $htmlTeleCC = $data_pj_cc->getHtml();
    } 


    
    // vignette image jpg
   /* if ( $this->iMode==ALK_FORM_MODE_ADD){
     
      $data_pj_vignette = AlkHtmlFactory::getHtmlFile($this->data_pj_vignette, _t("Vignette de la couverture"), $iTxtWidth-12, 255);
      if ( !is_null($data_pj_vignette) ){
        //$data_pj_vignette->setLabelAfter(_t("Vous pouvez ajouter une pièce jointe à la création et plusieurs pièces jointes en modification."));
        $data_pj_vignette->setDualMode(true);
      }
    }else {
     */ 
    $htmlVignette = "";
    if ( $this->iMode==ALK_FORM_MODE_UPDATE){
      $data_pj_vignette = AlkHtmlFactory::getNewHtmlUpload(null, 3, $this->data_pj_vignette->name, "Vignette de la couverture", "etude_pj",
                          $this->etude_id->value, AlkFactory::getModuleName($this->oAppli->atype_id)."/".$this->oAppli->cont_id."/");
      $data_pj_vignette->setProperty("oForm", $this);
      $data_pj_vignette->setNbMaxPj(1);      
      $data_pj_vignette->setProperty("formName", $this->name);
      $data_pj_vignette->setProperty("width", "95%");
      $htmlVignette = $data_pj_vignette->getHtml();
    }

    $oDsDocument = $this->oAppli->oQuery->getDsDataById($this->etude_id->value, "data_pj_pdf");
    
    $oListDocument = AlkHtmlFactory::getNewHtmlSelect(null, 0,"document_generate", -1, "Document", 1, "95%");
    $oListDocument->setProperty("oValTxt", $oDsDocument);
    $oListDocument->setProperty("strFieldValue", "data_id");
    $oListDocument->setProperty("strFieldText", "document_intitule");
    $oListDocument->setProperty("tabValTxtDefault", array("-1", "Sélectionnez un document"));

    // redacteur
    
    if($this->iMode == ALK_FORM_MODE_ADD){
      $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
      $dsAgent = $oQueryAnnu->getDs_ficheAgent($this->user_id);
      if($drAgent = $dsAgent->getRowIter()){
        $Pr =  substr($drAgent->getValueName("AGENT_PRENOM"), 0, 1);
        $Nom =  $drAgent->getValueName("AGENT_NOM");
        $this->etude_redacteur->value = strToUpper($Pr.". ".$Nom);
      }
    }
    
    $oCtrlRedacteur= AlkHtmlFactory::getHtmlText($this->etude_redacteur, "rédacteur", 1, $iTxtWidth, 255);
    $oCtrlRedacteur->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);    

    // champ sup
    
    $tabCtrl= array();
    $i = 0;
    $iWidth = 50;
    $const_valeur = "";
    $tabCorrespValChampSup = array();
    if($this->iMode == ALK_FORM_MODE_UPDATE){// on charge les valeurs
      $dsValChpSup = $this->oAppli->oQuery->getDsValChampSupplementaire($this->etude_id->value);
      while ($drValChpSup = $dsValChpSup->getRowIter()){
        $tabCorrespValChampSup[$drValChpSup->getValueName("etude_champ_nom")] = $drValChpSup->getValueName("etude_champ_valeur");
      }
    }
    $oDsDataListChampSup = $this->oAppli->oQuery->getDsListChampSupplementaire();
    While($oDrDataListChampSup = $oDsDataListChampSup->getRowIter()){     
      $oCtrl = "";
      $oCtrl = AlkHtmlFactory::getNewHtmlText(null, 0, $oDrDataListChampSup->getValueName("etude_champ_nom"), (isset($tabCorrespValChampSup[$oDrDataListChampSup->getValueName("etude_champ_nom")]) ? $tabCorrespValChampSup[$oDrDataListChampSup->getValueName("etude_champ_nom")] : $const_valeur), $oDrDataListChampSup->getValueName("etude_champ_desc"), 1, $iWidth, 255);
      //$oCtrl->addValidator(ALK_VERIF_TEXT, 0 ,255);
      $tabCtrl[$i] = $oDrDataListChampSup->getValueName("etude_champ_desc")." : ".$oCtrl->getHtml();
      $i++; 
    }
    

    $oSheetFiche->assign("helpMap","<a title=\"Afficher l'aide pour constituion du périmètre\" onclick=\"HelpShowHideLayer('selectTerritoireMap', '400')\" href=\"#helpMsg_selectTerritoireMap\" class=\"helpLien\"><img border=\"0\" src=\"/media/images/transp.gif\" class=\"helpButton alkimgpic alkimgpicaide\"><div class=\"helpMsg\" id=\"help_selectTerritoireMap\" style=\"\">
    Vous pouvez sélectionner plusieurs communes en cliquant sur ces communes sur la carte ou par dessin d'un rectangle en maintenant la touche shit enfoncée.</div></a>");
    
    $oSheetFiche->assign("oListContact", $oListContact->getHtml());
    $oSheetFiche->assign("etude_intitule", $oCtrlIntitule->getHtml());
    $oSheetFiche->assign("etude_droit_acces", $oCtrlDroitAcces->getHtml());
    //$oSheetFiche->assign("etude_statut", $oCtrlStatut->getHtml());
    $oSheetFiche->assign("etude_auteurs", $oCtrlAuteurs->getHtml());
    $oSheetFiche->assign("etude_redacteurs", $oCtrlRedacteurs->getHtml());
    $oSheetFiche->assign("tabcommanditaires", $oListCommanditaire->getHtml());  
    $oSheetFiche->assign("commanditaire_autre", $oCtrlCommanditaire_autre->getHtml());
    $oSheetFiche->assign("partenaire_autre", $oCtrlPartenaire_autre->getHtml());
    $oSheetFiche->assign("etude_resume",$oCtrlResume->getHtml());
    $oSheetFiche->assign("etude_mots_cles", $oCtrlMotCle->getHtml());
    $oSheetFiche->assign("etude_desc_nb_fascicules", $oCtrlNbFasc->getHtml());
    $oSheetFiche->assign("etude_desc_nb_pages", $oCtrlNbPage->getHtml());
    $oSheetFiche->assign("etude_cout", $oCtrlCout->getHtml());
    $oSheetFiche->assign("etude_prod_periode", $oCtrlPeriodProd->getHtml());
    $oSheetFiche->assign("etude_annee_achevement", $oCtrlAnneeAchev->getHtml());
    $oSheetFiche->assign("etude_annee_maj", $oCtrlAnneeMaj->getHtml());
    $oSheetFiche->assign("etude_date_publication", $oCtrlDatePublication->getHtml());
    $oSheetFiche->assign("etude_cote", $oCtrlCote->getHtml());
    $oSheetFiche->assign("etude_isrn", $oCtrlIsrn->getHtml());
    $oSheetFiche->assign("etude_redacteur", $oCtrlRedacteur->getHtml());
    $oSheetFiche->assign("selectTypeTerritoire", $oCtrlTypeTerritoire->getHtml());
    $oSheetFiche->assign("selectTerritoire", $oCtrlChoixTerritoire->getHtml());
    $oSheetFiche->assign("etude_perimetre_principal_intitule", $oCtrlEtude_perimetre_principal_intitule->getHtml());
    $oSheetFiche->assign("etude_perimetre_secondaire_intitule", $oCtrlEtude_perimetre_secondaire_intitule->getHtml());
    $oSheetFiche->assign("thematique_intitule", $theme1->getHtml());
    $oSheetFiche->assign("sous_thematique_intitule", $oSStheme1->getHtml());
    $oSheetFiche->assign("thematique_intitule2", $theme2->getHtml());
    $oSheetFiche->assign("sous_thematique_intitule2", $oSStheme2->getHtml());
    $oSheetFiche->assign("document_type_intitule", $document_type_intitule->getHtml());
    $oSheetFiche->assign("methodologie_intitule", $oMethodo->getHtml());
    $oSheetFiche->assign("tabtypologie_intitule", $oTypo->getHtml());
    $oSheetFiche->assign("iconographie_intitule", $iconographie->getHtml());
    $oSheetFiche->assign("partenaires", $oPartenaires->getHtml());
    //$oSheetFiche->assign("etude_id", $oCtrlEtudeId->getHtml());
    $oSheetFiche->assign("oProjCom", $oProjCom->getHtml());    
    $oSheetFiche->assign("oLienTelechargement", $htmlTelePdf);
    $oSheetFiche->assign("oLienTelechargementCC", $htmlTeleCC);    
    $oSheetFiche->assign("oLienVignette", $htmlVignette);
    $oSheetFiche->assign("oListDocument", $oListDocument->getHtml());
    $oSheetFiche->assign("oListChpSup", $tabCtrl);
    $oSheetFiche->assign("etude_url", $oCtrlUrlEtude->getHtml());
    
    // bt enregsitrer
    $strTokenEnr = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".$this->iMode."&bclose=0&id=".$this->etude_id->value);
    $ButtonEnr =  $this->addButton("btEnr",
        "javascript:alkFormValidation('".$this->name."', '".ALK_ALKANET_SITE_SQL."?token=".$strTokenEnr."')",
        "Enregistrer",
        "Enregistre la saisie en cours");
    $this->addSubmitButton($ButtonEnr);
    
    // bt enregsitrer et fermer 
    $strTokenEnrAndclose = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".$this->iMode."&bclose=1&id=".$this->etude_id->value);
    $ButtonEnrAndClose =  $this->addButton("btEnrAndClose",
        "javascript:alkFormValidation('".$this->name."', '".ALK_ALKANET_SITE_SQL."?token=".$strTokenEnrAndclose."')",
        "Enregistrer et fermer",
        "Enregistre la saisie en cours et retour à la liste"
        );
    $this->addSubmitButton($ButtonEnrAndClose);
    // bt fermer

    $strUrlCancel = ALK_ROOT_URL."/accueil";//ALK_ALKANET_SITE."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE);
    $ButtonFermer = $this->addButton("btCancel", $strUrlCancel, "Fermer", "Ferme le formulaire sans enregister");  
    
    
    if($this->etude_statut->value == 1){
      // bt depublier
      $strTokenDepublier = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".$this->iMode."&bclose=0&id=".$this->etude_id->value."&publi=0");
      $ButtonDepublier =  $this->addButton("btDepub",
          "javascript:alkFormValidation('".$this->name."', '".ALK_ALKANET_SITE_SQL."?token=".$strTokenDepublier."')",
          "Dépublier",
          "Bascule la fiche étude de l'état publié à dépublié"
      );
      $this->addSubmitButton($ButtonDepublier);
      $oHtmlButtonDepublier = $ButtonDepublier->getHtml();
    }else{
      $oHtmlButtonDepublier = "";
    }
    
    if($this->etude_statut->value == 0){
      // bt publier
      $strTokenpublie = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".$this->iMode."&bclose=0&id=".$this->etude_id->value."&publi=1");
      $ButtonPublier =  $this->addButton("btPublier",
          "javascript:alkFormValidation('".$this->name."', '".ALK_ALKANET_SITE_SQL."?token=".$strTokenpublie."')",
          "Publier",
          "Publie l'étude"
      );
      $this->addSubmitButton($ButtonPublier);
      $oHtmlButtonPublier = $ButtonPublier->getHtml();
    }else{
      $oHtmlButtonPublier = "";
    }
    
    if($this->etude_statut->value == 0){
      // bt archiver
      $strTokenarc = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".$this->iMode."&bclose=0&id=".$this->etude_id->value."&publi=-1");
      $ButtonArchive =  $this->addButton("btArch",
          "javascript:alkFormValidation('".$this->name."', '".ALK_ALKANET_SITE_SQL."?token=".$strTokenarc."')",
          "Archiver",
          "Bascule la fiche étude à l'état d'archive"
      );
      $this->addSubmitButton($ButtonArchive);
      $oHtmlButtonArchiver = $ButtonArchive->getHtml();
    }else{
      $oHtmlButtonArchiver = "";
    }

    
    if($this->etude_statut->value == 2){    
      // bt restaurer
      $strTokenrestau = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=".$this->iMode."&bclose=0&id=".$this->etude_id->value."&publi=2");
      $ButtonRestaurer =  $this->addButton("btArch",
          "javascript:alkFormValidation('".$this->name."', '".ALK_ALKANET_SITE_SQL."?token=".$strTokenrestau."')",
          "Restaurer",
          "Bascule la fiche étude de l'état d'archive à l'état en cours"
      );
      $this->addSubmitButton($ButtonRestaurer);
      $oHtmlButtonEnrRestaurer = $ButtonRestaurer->getHtml();
    }else{
      $oHtmlButtonEnrRestaurer = "";
    }

    $oHtmlButtonEnr = $ButtonEnr->getHtml();
    $oSheetFiche->assign("oHtmlButtonEnr", $oHtmlButtonEnr);
    
    $HtmlButtonEnrAndClose = $ButtonEnrAndClose->getHtml();
    $oSheetFiche->assign("oHtmlButtonEnrAndClose", $HtmlButtonEnrAndClose);
    
    $oHtmlButtonFermer = $ButtonFermer->getHtml();
    $oSheetFiche->assign("oHtmlButtonFermer", $oHtmlButtonFermer);
    
    
    $oSheetFiche->assign("oHtmlButtonDepublier", $oHtmlButtonDepublier);
    
    
    $oSheetFiche->assign("oHtmlButtonPublier", $oHtmlButtonPublier);
    
    
    $oSheetFiche->assign("oHtmlButtonArchiver", $oHtmlButtonArchiver);
    
    
    $oSheetFiche->assign("oHtmlButtonEnrRestaurer", $oHtmlButtonEnrRestaurer);
  }
  
  /**
   * incrémanete le nb de consult en fonction de l'etude_id
   * @etude_id
   * @$strFieldEtude : le champ appartenant à etude qui est à incrémaneter
   * @return string
   */
	private function CompteurConsult($etude_id, $strFieldEtude){
	  // compteur nb consult pour une etude id
	  $oDsDataEtude = $this->oAppli->oQuery->getDsByTableName(" etude".
	      " where etude_id =".$etude_id );
	  if($oDrDataEtude = $oDsDataEtude->getRowIter()){
	    $nbConsult = $oDrDataEtude->getValueName($strFieldEtude);
	  }
	  $this->oAppli->oQueryAction->updateNbConsult($etude_id, $nbConsult+1, $strFieldEtude);
	}
	
	/**
	 * Ajout d'un service
	 * @param $intitule_propose : intitule nx serv
	 * @param $etude_intitule : intitule de l'etude
	 * @param $strTypeListService : string du type de service (partenaire commandiataire, contact)
	 * @return int
	 */
	private function addServ($intitule_propose, $etude_intitule, $strTypeListService)
	{
	  $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
	  $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
	
	  $tabQuery = array();
	  $tabQuery["SERVICE_ETAT"] = array(ALK_SQL_NUMBER,   "1");
	  $tabQuery["SERVICE_PERE"] = array(ALK_SQL_NUMBER,   "1");
	  $tabQuery["CONT_ID_START"] = array(ALK_SQL_NUMBER,   "1");
	  $tabQuery["SERVICE_INTITULE"] = array(ALK_SQL_TEXT, $intitule_propose);
	  $tabQuery["SERVICE_INTITULE_COURT"] = array(ALK_SQL_TEXT, "");
	  $tabQuery["SERVICE_TEL"]   = array(ALK_SQL_TEXT, "");
	  $tabQuery["SERVICE_EMAIL"]   = array(ALK_SQL_TEXT, "");
	  $tabQuery["SERVICE_VALIDE"]   = array(ALK_SQL_NUMBER, -2); // en attente d'activation
	  $tabFields = array("field" => $tabQuery, "pk" => array());

	  $serv_id = $oAppliAnnu->addService($tabFields);

	  //envoie mesg à l'admin
	  
      $tabAssoc = array();
      $tabAssoc["msgTitle"] = "Demande de validation d'un service pour l'étude ".$etude_intitule.".";
      $tabAssoc["etude_intitule"] = $etude_intitule;
      $tabAssoc["type_service"] = $strTypeListService;
      $tabAssoc["msgUrlSite"] = ALK_ROOT_URL_BACKOFFICE."/admin";
      
      $this->oAppli->SendMailToAgent($tabAssoc, "CRBN_MAIL_CREA_SERV", $intitule_propose); 

	  return $serv_id;
	}
	
	
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/help/crbn_cat_01_consult_list.htm");
  }
}
?>