<?php

/*licence/

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

require_once(AlkFactory::getModulePath(ALK_ATYPE_ID_CRBN_CAT)."classes/alkimportetude.class.php");

/**
 * @class AlkHtmlFormAdminCrbn_catList
 * @brief Description de la classe
 */
class AlkHtmlFormPopupCrbn_import extends AlkHtmlForm
{

	/**
	 * constructeur par défaut
	 * @param oAppli Référence sur l'appli en cours
	 */



	public function __construct(AlkAppli &$oAppli)
	{

		parent::__construct($oAppli, "formImport");

		$this->iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
		$strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM, "&iMode=".$this->iMode."&mode=import");
		$strAction = ALK_ALKANET."?token=".$strToken;

		$this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, $strAction);


	}

	protected function setData($iTypeInit) {

			
	}

	/**
	 * Traitements Sql
	 */
	public function doSql(){

	}

	/**
	 *  Retourne le titre de la popup
	 * @return string
	 */
	public function getTitle()
	{
		return "Import de fiches études";
	}

	/*
	 * Contenu du formulaire
	 */
	public function setContents()
	{
		//formulaire
		
		//temporaire génération des fiches XML
		/*
		$dsRow = $this->oAppli->oQuery->getDsByTableName("etude");
		while ($drRow = $dsRow->getRowIter()){
			$etude_id = $drRow->getValueName("etude_id");
			$etude_xml = $drRow->getValueName("etude_xml"); 
			file_put_contents(AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT)."indexFiles/fiche_".$etude_id."xml", $etude_xml);
		}
		die();*/
		
		
		
		
		$mode = AlkRequest::getToken("mode", "form");
		if($mode=="form"){
			//paramètres communs à toutes les URL de ce fichier
			$user_id = AlkFactory::getSProperty("user_id", "-1");
			$user_priv = AlkFactory::getSProperty("user_priv", "0");
			$service_id = AlkFactory::getSProperty("service_id", "-1");
			$imp_fic      = new AlkFormData($this, "imp_fic", "", ALK_SQL_TEXT);
			$contenuFile  = new AlkFormData($this, "contenuFile", "1", ALK_SQL_TEXT);
			
			$iWidthLabel = 220;
			$iWidthCtrl  = 280;
			$iWidthLabelRight = 10;
			$iWidthCtrlRight  = 160;
			$iTxtWidth = 48;

			//TODO ecrire texte + fichier référence
			$urlFileRegleImport = AlkFactory::getModuleUrl(ALK_ATYPE_ID_CRBN_CAT)."import_regles_etudes.pdf";
			$urlFileModeleImport = AlkFactory::getModuleUrl(ALK_ATYPE_ID_CRBN_CAT)."modele_import.zip";			
			$strHtml = "L'import d'études doit être réalise par le chargement d'une archive au format zip. Pour réaliser un import de données dans l'annuaire, vous devez au préalable prendre connaissance ".
			"<a target='blank' href=".$urlFileRegleImport.">des règles d'importation des études</a>. Un exemple de fichier d'import est disponible : ".
			"<a target='blank' href=".$urlFileModeleImport.">exemple.zip</a>.<br>";  
			
      $otext = AlkHtmlFactory::getHtml($strHtml);
      
			$oCtrlFile = AlkHtmlFactory::getHtmlFile($imp_fic, "Cliquez sur le bouton [Parcourir] et sélectionnez un fichier", "", $iTxtWidth, 255);
			/** ajout de blocs et association des controles */
			$oBlockProp = $this->addBlock("block_1", "Importer un tableau d'études", "", $iWidthLabel, $iWidthCtrl, true);
      $oBlockProp->addCtrl($otext, ALK_HTMLFORM_1L1C);
			$oBlockProp->addCtrl($oCtrlFile);
			
      // si on ne souahite pas faire un import reel si oui pa sd'import reel
			$oCtrlRadioMode = AlkHtmlFactory::getHtmlRadio($contenuFile, "Souhaitez vous faire un import simulé? (Génération des fichiers d'erreurs et d'alertes sans insertions en base.)");
      $oCtrlRadioMode->AddRadio(0, "oui");
      $oCtrlRadioMode->AddRadio(1, "non");				
      $oBlockProp->addCtrl($oCtrlRadioMode);
      
			$strTokenImportLdap = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_IMPORT_USER, ALK_SHEET_NONE, "&imp=1");
			$oButton = $this->addButtonPage("bt_1", "javascript:document.form.submit()",
	                         "Valider", "Démarrer l'import");  
			$this->addSubmitButton($oButton);

			$strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_IMPORTEXPORT, ALK_SHEET_FORM);
			$oButton =  $this->addButtonPage("bt_2", "javascript:closeWindow()", "Annuler", "Annuler la modification");

		}else{
			$tabQuery = $this->getTabQuery(array());
			$strToken = $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_VALIDATION, $this->iSSheet);

			$appli_id = 0;
			$cont_id = AlkRequest::getToken("cont_id", "-1");
			$strParam = "cont_id=".$cont_id."&appli_id=".$appli_id;
			$iMode = AlkRequest::_REQUEST ("iMode", ALK_FORM_MODE_ADD);

			$fin = AlkRequest::_REQUESTint("fin", "0");

			$strParam = "appli_id=".$appli_id."&cont_id=".$cont_id;
			$user_id = AlkFactory::getSProperty("user_id", "-1");
			$ag_id = $user_id;

			// associée l'interface action à l'espace
			//$oSpace->setQueryAction($queryContAction);

			$urlFileError = AlkFactory::getUploadUrl(ALK_ATYPE_ID_CRBN_CAT).$ag_id."_err.txt";
			$strFileError = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$ag_id."_err.txt";
			$urlFileWarning = AlkFactory::getUploadUrl(ALK_ATYPE_ID_CRBN_CAT).$ag_id."_warning.txt";
			$strFileWarning = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$ag_id."_warning.txt";
			SupprFichier($strFileError);
			SupprFichier($strFileWarning);

			$pathFile = "";
			$strFileName = "";

			if( $fin != "1" ) {
				$strParam = "appli_id=".$appli_id."&cont_id=".$cont_id;
				if( $iMode != "annuler" ) {
				  //upload du fichier
					$strFileName = DoUpload("imp_fic", "", AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT, true), 1, "");
					if( !is_string($strFileName))
					  $strFileName = "";
					if( $strFileName!="" )
					  $pathFile = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT)."/".$strFileName;
				}
			}
		
			$dirname = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT)."/".substr($strFileName, 0, -4);
			if($strFileName!="")
			  $this->rrmdir($dirname); // suprime tout le rep

			$strCmd = "unzip -d ".AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT)."/"." ".$pathFile; 
			$tabOutput = array();
			exec($strCmd, $tabOutput);
			 
			
			$dir = opendir($dirname);
			$GLOBALS["rootDirPath"] = $dirname;

			$strFichier_Import = "";
			while($file = readdir($dir)) {
		  
				if($file != '.' && $file != '..' && !is_dir($dirname.$file))
				{			  
				  if (strtolower(getFileExtension($file))=="csv"){//premier fichier csv trouvé
						$strFichier_Import = $dirname."/".$file;			
						// on impose un contenu utf8 au fichier
						$str = file_get_contents($strFichier_Import);
						$newStr = mb_convert_encoding($str, ALK_HTML_ENCODING, mb_detect_encoding($str, "UTF-8, ISO-8859-15, ISO-8859-1, ISO-8859-14", false));
						file_put_contents($strFichier_Import, $newStr); // ecrase l'ancien fichier
						break;
					}
				}
			}


			closedir($dir);

			$strFichier_Erreur = $strFileError;
			$strFichier_Warning = $strFileWarning;

			$intSeparateur = 44;
			$tabImport = array (
			array("name" => "MODE", "oblig" => 1,"type" =>array("C") ,"lg" => 0,"index" => 0 ,"mode" => 1),
			array("name" => "dc:title",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:rights",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:publisher",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:creator",        "oblig" => 0, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:subject",        "oblig" => 0, "type" => "string",  "lg" => 1000, "index" => 0 ,"mode" => 0),
			array("name" => "dc:owner",        "oblig" => 1, "type" => "string",  "lg" => 1000, "index" => 0 ,"mode" => 0),
			array("name" => "dc:contact",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:description",        "oblig" => 1, "type" => "string",  "lg" => 5000, "index" => 0 ,"mode" => 0),
			array("name" => "dct:created",        "oblig" => 1, "type" => "numeric",  "lg" => 4, "index" => 0 ,"mode" => 0),
			array("name" => "dct:dateSubmitted",        "oblig" => 1, "type" => "date",  "lg" => 10, "index" => 0 ,"mode" => 0),
			array("name" => "dct:modified",        "oblig" => 0, "type" => "numeric",  "lg" => 4, "index" => 0 ,"mode" => 0),
			array("name" => "dc:identifier",        "oblig" => 0, "type" => "string",  "lg" => 36, "index" => 0 ,"mode" => 0),
			array("name" => "dc:principal_keywords_theme",        "oblig" => 1, "type" => "string",  "lg" => 10000, "index" => 0 ,"mode" => 0),
			array("name" => "dc:principal_keywords_subtheme",        "oblig" => 0, "type" => "string",  "lg" => 10000, "index" => 0 ,"mode" => 0),
			array("name" => "dc:primary_area",        "oblig" => 1, "type" => "string",  "lg" => 10000, "index" => 0 ,"mode" => 0),
			array("name" => "dc:secondary_area",        "oblig" => 0, "type" => "string",  "lg" => 10000, "index" => 0 ,"mode" => 0),
			array("name" => "dc:secondary_keywords_theme",        "oblig" => 0, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:secondary_keywords_subtheme",        "oblig" => 0, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:booklet",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:page",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:iconography",        "oblig" => 0, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:type",        "oblig" => 0, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:typology",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:cost",        "oblig" => 0, "type" => "numeric",  "lg" => 11, "index" => 0 ,"mode" => 0),
			array("name" => "dc:methodology",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:partner",        "oblig" => 1, "type" => "string",  "lg" => 10000, "index" => 0 ,"mode" => 0),
			array("name" => "dc:cote",        "oblig" => 0, "type" => "string",  "lg" => 20, "index" => 0 ,"mode" => 0),
			array("name" => "dc:period",        "oblig" => 0, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:author",        "oblig" => 1, "type" => "string",  "lg" => 256, "index" => 0 ,"mode" => 0),
			array("name" => "dc:etude_url",     "oblig" => 0, "type" => "string",  "lg" => 1500, "index" => 0 ,"mode" => 0)
			);

			$bTes = true;
			$intTes = 1;
			$tabSup = array();
			$tabAjout = array ("dc:title");
			$tabModif = array();
			$objErreur = new AlkImportError($strFichier_Erreur);
			$objWarning = new AlkImportWarning($strFichier_Warning);
			$objImport = new AlkImportEtude($strFichier_Import, $tabImport, $tabSup, $tabAjout, $tabModif,
			$objErreur, $objWarning, $this->oAppli->oQuery, $this->oAppli->oQueryAction,
			$this->oAppli->getProperty("oSpace"), $this->oAppli);
			$iTes = 0;
			$intTest = $objImport->parseFile($intSeparateur);
			if( $intTest == 0 ) {
				$intTes = $objImport->parseLines($intSeparateur);
				if( $intTes == 0 ) {
					$iTes = $objImport->integrate($intSeparateur);
				}
			}
			$this->modeImport = AlkRequest::_REQUESTint("contenuFile", 1); // si 1 -> import notrmal si 0 -> import simule : pas d'insertion en base		
			if($this->modeImport == 1){
			  $strtitre = "Importation des fiches études";
			}elseif($this->modeImport == 0){
			  $strtitre = "Simulation d'une importation des fiches études";			  
			}
					
			$this->setLabel($strtitre);
			$strHtml = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>";
			if( $intTes == 0 && $iTes == 0 ) {
				$strHtml .= "Importation effectuée avec succès.";
			} else {
				if( $intTes > 0 ) {
					$strHtml .= "Importation non effectuée pour cause de fichier mal formaté.";
				}
				if( $iTes > 0 ) {
					$strHtml .= "Importation effectuée avec des alertes ou des erreurs.";
				}
				$bFileAlert = @file_exists($strFichier_Warning) && @is_file($strFichier_Warning);
				$bFileError = @file_exists($strFichier_Erreur) && @is_file($strFichier_Erreur);

				if( $bFileAlert || $bFileError ) {
					$strHtml .= "<br/><span style='color:red;'>Attention</span> : Vous pouvez consulter ";

					if( $bFileAlert ) {
						$oLink = AlkHtmlFactory::getHtmlButton($urlFileWarning, "les alertes", "", true, "_blank");
						$strHtml .= $oLink->getHtml();
						if( $bFileError )
						$strHtml .=  " et ";
					}
					if( $bFileError ) {
						$oLink = AlkHtmlFactory::getHtmlButton($urlFileError, "les erreurs", "", true, "_blank");
						$strHtml .= $oLink->getHtml();
					}
					$strHtml .= ".";
				}
			}
			$strHtml .= "</div>";
			$oBlock = $this->addBlock("blockMsg", "", "");
			$otext = AlkHtmlFactory::getHtml($strHtml);
			$oBlock->addCtrl($otext, ALK_HTMLFORM_1L1C);
			// url de retour après traitement


		}
	}


  private function rrmdir($dir)
  {
      foreach(glob($dir . '/*') as $file) {
          if(is_dir($file))
              $this->rrmdir($file);
          else
              unlink($file);
      }
      @rmdir($dir);
  }
	
	/**
	 * Retourne l'aide associée au formulaire
	 * @return string
	 */
	public function getHelp()
	{
		return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/help/crbn_cat_01_admin_form.htm");
	}
}
?>