<?php

/*licence/

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Crbn_cat
Module Crbn_cat.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Crbn_cat
 * @class AlkQueryCrbn_cat
 *
 * Ensemble des requetes de selection de l'application
 */
class AlkQueryCrbn_cat extends AlkQuery
{
	/**
	 * Constructeur par défaut
	 * @param dbConn     Classe de connection à la base
	 */
	public function __construct(&$dbConn)
	{
		parent::__construct($dbConn);
	}

	/**
	 * Description de la fonction
	 *
	 * @param param  description du parametre
	 * @return Retourne un dataset
	 */
	function getEtudeConfig()
	{
		$strSql = "SELECT * from etude_config"; 
		return $this->dbConn->initDataset( $strSql );
	}


	function getDataEtudeById($etude_id)
	{
		$strSql = "SELECT etude_id, etude_intitule, etude_statut, etude_auteurs, etude_redacteurs, etude_resume, etude_mots_cles, 
		           etude_desc_nb_fascicules, etude_desc_nb_pages, etude_cout, etude_prod_periode, etude_annee_achevement, etude_annee_maj,". 
		           $this->dbConn->getDateFormat("DD/MM/YYYY","etude_date_publication", false). " as etude_date_publication,  etude_cote, etude_isrn,  etude_redacteur,  ".
		           "etude_agent_id,  etude_contact_service_id, etude_perimetre_principal_intitule, etude_perimetre_secondaire_intitule, etude_perimetre_principal_geom, ST_AsText(etude_perimetre_principal_geom) as geom_astext, etude_date_maj, ".
		           "etude_nb_consult, etude_nb_telechargement, etude_droit, etude_url  from etude e where etude_id=".$etude_id;

		return $this->dbConn->initDataset( $strSql );
	}

	 
	function getListTableFromSchema($nomSchema)
	{
		// connection à la base de données Prodige
		$oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
		$oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
		$oDbConnProdige->setProperty('strSchemaRead', '');
		$oDbConnProdige->connect();

		$strSql = "SELECT tablename FROM pg_tables WHERE schemaname = '".$this->dbConn->analyseSql($nomSchema)."' order by tablename";

		return $oDbConnProdige->initDataset( $strSql );
	}
	 

	function getDsDomForComboDomaine($nomChamp , $strFieldId, $strwhere="")
	{
		// connection à la base de données Prodige
		$oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
		$oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
		$oDbConnProdige->setProperty('strSchemaRead', '');
		$oDbConnProdige->connect();


		$strSql = "select distinct ".$nomChamp." as DATATYPE_INTITULE, ".$strFieldId." as DATATYPE_ID
                  from catalogue.couche_donnees where couchd_type_stockage IN (1, -4) ".
		$strwhere.
              " order by DATATYPE_INTITULE";

		return $oDbConnProdige->initDataset( $strSql );
	}

	function getDsListChmpCoucheByIdForCombo($couche_donnees, $bLimit=false){

		// connection à la base de données
		$oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
		$oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
		$oDbConnProdige->setProperty('strSchemaRead', '');
		$oDbConnProdige->connect();

		($bLimit ? $strWhere = " LIMIT 10 " : $strWhere = "");
		$strSql = "select * from public.".$couche_donnees.$strWhere ;
		return $oDbConnProdige->initDataset( $strSql, 0, -1, true );

	}

	function getListDico()
	{
		$strSql = "select * from ETUDE_ADMIN_DICO";

		return $this->dbConn->initDataset($strSql);
	}
	/**
	 * Retourne la liste des dictionnaires administrables
	 * @return dataset
	 */
	public function getListColonnesByDico($dico_id)
	{
		$strSql = "select * from ETUDE_ADMIN_DICO_CHAMP where DICO_ID =".$dico_id." order by CHAMP_RANG";
		return $this->dbConn->initDataset($strSql);
	}

	function getDsByTableName($strTableName, $bProdige=false, $strWhere="")
	{

		$strSql = "select * from ".$strTableName.($strWhere!="" ? $strWhere :"");

		if($bProdige){
			$oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
			$oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
			$oDbConnProdige->setProperty('strSchemaRead', '');
			$oDbConnProdige->connect();
			return $oDbConnProdige->initDataset($strSql);
		}else{
			return $this->dbConn->initDataset($strSql);
		}
	}

	function getDsEtude($strTableJoin, $strWhere, $strSelect="", $iFirst = 0, $iLast=-1)
	{
		if($strSelect!="" ){
			$strSelect = trim($strSelect);
			$strSelect = ( substr($strSelect, 0, 1) != "," ? "," : "" ).( substr($strSelect, -1) == "," ? substr($strSelect,0,-1) : $strSelect );
		}
		$strSql = "select distinct e.etude_id, e.etude_statut, e.etude_annee_achevement, e.etude_intitule, ".$this->dbConn->getDateFormat("YYYY/MM/DD", "etude_date_maj", false)." as etude_date_maj, ".$this->dbConn->getDateFormat("YYYY/MM/DD", "etude_date_publication", false)."as etude_date_publication, etude_nb_telechargement, etude_nb_consult,
   			      ST_AsText(etude_perimetre_principal_geom) as etude_perimetre_principal_geom, etude_agent_id ".$strSelect.            
   			      ",(case when e.etude_statut=0 then 'Etude en cours' else (case when e.etude_statut=1 then 'Etude publiée' else (case when e.etude_statut=2 then 'Etude archivée' else null end) end) end) as name_statut ".             
              " from etude e".$strTableJoin."".
              " ".$strWhere." ORDER BY etude_intitule ASC";
		
		return $this->dbConn->initDataset($strSql, $iFirst, $iLast);
	}

	
	function getDsLastEtude($strWhere){

		$strSql = "Select etude_id, etude_intitule, etude_date_maj from etude ".
		($strWhere!="" ? $strWhere : "").  		
		"Group by etude_id, etude_date_maj, etude_intitule order by etude_date_maj desc limit 4";
		return $this->dbConn->initDataset($strSql);
	}

	function getDsEtudeMostVisited($strWhere){
		$strSql = "Select etude_id, etude_intitule, etude_nb_consult from etude ".
		($strWhere!="" ? $strWhere : "").
		"Group by etude_id, etude_nb_consult, etude_intitule order by etude_nb_consult desc limit 4";
		return $this->dbConn->initDataset($strSql);
	}

	function getDsGeomByCoordinates($x,$y){
		$strSql = "SELECT ".config_id_com.",".config_nom_coml.",ST_AsText(the_geom) FROM \"".config_table_com."\" WHERE  ST_INTERSECTS(ST_GeomFromText('POINT(".$x." ".$y.")',2154),the_geom);";
		$oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
		$oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
		$oDbConnProdige->setProperty('strSchemaRead', '');
		$oDbConnProdige->connect();
		return $oDbConnProdige->initDataset($strSql);
	}
	
  function getDsGeomByBox($box){
    $strSql = "SELECT ".config_id_com.",".config_nom_coml.",ST_AsText(the_geom) FROM \"".config_table_com."\" WHERE  ST_INTERSECTS(ST_GeomFromText('".$box."',2154),the_geom);";
    $oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
    $oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
    $oDbConnProdige->setProperty('strSchemaRead', '');
    $oDbConnProdige->connect();
    return $oDbConnProdige->initDataset($strSql);
  }
	
	function getDsGeomByCode($idComm){
		
	  //hack for jquery datatable problem ????
    $strSql = "SELECT 1 as etude_intitule, ST_AsText(the_geom) as geom FROM \"".config_table_com."\" WHERE \"".config_id_com."\"='".$idComm."'";
    $oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
    $oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
    $oDbConnProdige->setProperty('strSchemaRead', '');
    $oDbConnProdige->connect();
    return $oDbConnProdige->initDataset($strSql);
  }

  /**
     * retourne une liste de territoire à partir de la table contenant les intitules des territoire
     *
     * @strTableName : table contanent les intile de territoire
     * @$strFieldId : champ contenant les id des territoire
     * @$strFieldName : champ contenant les intitule des territoire
     * @return Retourne un dataset
     */
  function getDsListTerritoireByType($strTableName, $strFieldId, $strFieldName){
      $strSql = "select distinct ".$strFieldName." as DATATYPE_INTITULE, ".$strFieldId." as DATATYPE_ID from \"".$strTableName."\" ORDER BY DATATYPE_INTITULE ASC"; 
      $oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
		  $oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
		  $oDbConnProdige->setProperty('strSchemaRead', '');
		  $oDbConnProdige->connect();
		  return $oDbConnProdige->initDataset($strSql);      
  }
  
    /**
     * retourne une liste de communes à partir de la table contenant les intitules des territoire
     *
     * @strTableName : table contanent les intile de territoire
     * @$strFieldId : champ contenant les id des territoires sélectionner
     * @$strFieldNameCom : champ contenant les intitule des communes
     * @$strFieldId : champ contenant les id des communes
     * @listterritoireSelected : liste des identifiant des territoire selected
     * @return Retourne un dataset
     */    
  function getDsListCommuneByTypeAndListId($strTableName, $strFieldId, $strFieldNameCom, $strFieldIdCom, $listterritoireSelected){
      $strSql = "select distinct ".$strFieldNameCom." as DATATYPE_INTITULE, ".$strFieldIdCom." as DATATYPE_ID, ST_AsText(the_geom) as geom  from \"".$strTableName."\" WHERE ".$strFieldId." IN (".$listterritoireSelected.") ORDER BY DATATYPE_INTITULE ASC";
      $oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
      $oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
      $oDbConnProdige->setProperty('strSchemaRead', '');
      $oDbConnProdige->connect();
      return $oDbConnProdige->initDataset($strSql);  
  }
    
    
   /**
   * retourne lunion des geomtry des communes 
   * @param $tabQuery    list des code insee
   * @param $field_idcommune  : nom du champ contenant les code insee dans la table contenant les geomtries des communes
   * @param $tablecommune  : nom de la table contenant les geomtries des communes
   * @param $field_geom_commune : nom du champ portant la geomtrie dans la table commune
   * @return une geomtry
   */
  function GetUnionTheGeomByListComId($tabQuery, $field_idcommune, $tablecommune, $field_geom_commune){

      $strListInsee = "'-1',";
      foreach ($tabQuery as $k => $codeInsee){
        $strListInsee.= "'".$codeInsee."',";
      }
      $strListInsee = substr($strListInsee, 0, -1);
      
      $strSqlUnion = " (select ST_BUFFER(ST_COLLECT( commune.".$field_geom_commune."),0) as the_geom from ".$tablecommune." commune where $field_idcommune IN(".$strListInsee."))";
      //(select ST_BUFFER(ST_COLLECT(wdpa.polygon_geom),0) as polygon_geom, wdpa.desig_eng as desig_eng from wdpa where gid IN(".$strListGidByaPays.") and wdpaid = wdpa_pid and WDPA_VALIDE =1 and STATUS = 'Designated' group by wdpa.desig_eng)";
      
      //$strSqlUnion = " (select ST_Union(commune.polygon_geom) as the_geom, ".$code_idcommune." as gid from ".$tablecommune." commune where gid IN(".$strListInsee.")";         
      $oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
      $oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
      $oDbConnProdige->setProperty('strSchemaRead', '');
      $oDbConnProdige->connect();
      return $oDbConnProdige->initDataset($strSqlUnion);

  }
    
	/**
	 * retourne l'identifiant d'un service à partir de son intitulé
	 * @param $service_intitule
	 * @return unknown_type
	 */
  function getServiceByName($service_intitule)
  {
    $strSql = "select SERVICE_ID from SIT_SERVICE where SERVICE_INTITULE ilike '".$this->dbConn->AnalyseSql($service_intitule)."'".
              "or service_intitule_court  ilike '".$this->dbConn->AnalyseSql($service_intitule)."'";
    return $this->dbConn->InitDataSet($strSql);
  }
  
  /**
   * retourne les documents concernes par une étude
   * @param $etude_id
   * @return unknown_type
   */
  function getDsDataById($etude_id, $pj_champ=""){
  	$strSql = "select pj_name, pj_id, pj_agentcrea, pj_file, pj_champ from etude_pj where data_id=".$etude_id.
  	          ($pj_champ!="" ? " and pj_champ='".$this->dbConn->analyseSql($pj_champ)."'"  : ""); 
    return $this->dbConn->InitDataSet($strSql);
  }
  
/**
   * retourne un document par son identifiant
   * @param pj_id
   * @return unknown_type
   */
  function getDsDataByPjId($pj_id){
    $strSql = "select pj_name, pj_agentcrea, pj_file, pj_champ from etude_pj where pj_id=".$pj_id;
    return $this->dbConn->InitDataSet($strSql);
  }
  
  
  function getDsSelectCommanditaire($etude_id){
    $strSql = "select service_id, service_intitule, service_intitule_court from sit_service where service_valide = 1 and service_niveau = 1
    UNION SELECT ss.service_id, ss.service_intitule, service_intitule_court from 
    sit_service ss left join etude_commanditaires ec on ec.service_id = ss.service_id WHERE service_valide = -2 and etude_id = ".$etude_id." ORDER BY service_intitule_court ASC";
    return $this->dbConn->InitDataSet($strSql);
  }  

  function getDsSelectPartenaire($etude_id){
    $strSql = "select service_id, service_intitule, service_intitule_court from sit_service where service_valide = 1 and service_niveau = 1
    UNION SELECT ss.service_id, ss.service_intitule, service_intitule_court from
    sit_service ss left join etude_partenaire ec on ec.service_id = ss.service_id WHERE service_valide = -2 and etude_id = ".$etude_id." ORDER BY service_intitule_court ASC";

    return $this->dbConn->InitDataSet($strSql);
  }
  
  function getDsSelectContact($etude_id){
    $strSql = "select service_id, service_intitule, service_intitule_court from sit_service where service_valide = 1 and service_niveau = 1
    UNION SELECT ss.service_id, ss.service_intitule, service_intitule_court from
    sit_service ss left join etude ec on ec.etude_contact_service_id = ss.service_id WHERE service_valide = -2 and etude_id = ".$etude_id." ORDER BY service_intitule_court ASC";
  
    return $this->dbConn->InitDataSet($strSql);
  }
  
  function getDsActivationChamp(){
  	$strSql = "select etude_activation_champ_champ, etude_activation_champ_statut from etude_activation_champ";
    return $this->dbConn->InitDataSet($strSql);
  	
  }

  function getDsListChampSupplementaire(){
    $strSql = "select etude_champ_nom, etude_champ_desc, etude_activation_champ_statut from etude_activation_champ eac INNER JOIN etude_champ ec ON eac.etude_activation_champ_champ = ec. etude_champ_nom WHERE etude_activation_champ_statut = 1";
    return $this->dbConn->InitDataSet($strSql);
     
  }  
  function getDsValChampSupplementaire($etude_id){
    $strSql = "select etude_champ_nom, etude_champ_valeur from etude_champ_supplementaire WHERE etude_id = ".$etude_id;
    return $this->dbConn->InitDataSet($strSql);
     
  }
  
  /**
   * function qui retouren la liste des administrateur generaux (admin de tout l'annuaire et de tous les espaces)
   * @param $id_admin_general : id du privilege
   */
  function getDsListAdmin($id_admin_general){
    $strSql = "select a.* from sit_agent a WHERE agent_priv = ".$id_admin_general;
    return $this->dbConn->InitDataSet($strSql);
  }
  
   /** function qui fabrqiue la geometry de la region à partir de la table des communes et return un booleen en fonction du contains vis à vis de la geometry de l'etude
   * @param $config_id_reg : le champ correspondant à l'id de la region 
   * @param $tablecommune : table contenant les commune
   * @param $val_id_region : la valeur de l'id de la region 
   * @param $field_geom_commune : le champ geometry des com
   * @param $val_geom_etude : la geometry de l'etude
   */
  
  function getDsGeomRegion ($config_id_reg, $tablecommune, $val_id_region, $field_geom_commune, $the_geom_region) {

    // SELECT ST_Contains($the_geom_union, $theGeomRegion ) ->return true si la geometry de l'etude contient la geom de la region
    
    // SELECT ST_Contains(smallc, bigc) As smallcontainsbig,
    // FROM (SELECT ST_Buffer(ST_GeomFromText('POINT(1 2)'), 10) As smallc,
    //     ST_Buffer(ST_GeomFromText('POINT(1 2)'), 20) As bigc) As foo;
    
    $strSqlUnion = 
    
    " SELECT ST_Contains('".$the_geom_region."', the_geom_region) As b_is_regional FROM ".
    " (select ST_BUFFER(ST_COLLECT( commune.".$field_geom_commune."),0) as the_geom_region from ".$tablecommune." commune where ".$config_id_reg." = '".$val_id_region."' GROUP BY ".$config_id_reg.") as the_geom_region";
    
    $oDbConnProdige = new AlkDbPgSql(ALK_PRODIGE_LOGIN, ALK_PRODIGE_HOST, ALK_PRODIGE_PWD, ALK_PRODIGE_BD, ALK_PRODIGE_PORT);
    $oDbConnProdige->setProperty('strSchema', 'public', 'catalogue');
    $oDbConnProdige->setProperty('strSchemaRead', '');
    $oDbConnProdige->connect();
    
    
    //echo $strSqlUnion; die();
    
    return $oDbConnProdige->initDataset($strSqlUnion);
  }
  
  
  function getDsListCommanditaire(){
    $strSql = "select distinct (service_intitule_court) from etude_commanditaires sc left join sit_service ss on ss.service_id = sc.service_id ORDER BY service_intitule_court asc";
    return $this->dbConn->InitDataSet($strSql);
  }
  
  function getDsListAnneePubli(){
    $strSql = "select distinct (etude_annee_achevement) from etude ORDER BY etude_annee_achevement asc";
    return $this->dbConn->InitDataSet($strSql);
  }
  
  
}
?>