<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module fournissant les pages adressables Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once("../../../lib/lib_session.php");

AlkRequest::readToken();
$strIdentification = AlkRequest::getToken("alk_identification", "");

/** connexion SSO utilisée */
/*$iSSO = ( defined("ALK_AUTH") && defined("ALK_AUTH_SSO") && ALK_AUTH==ALK_AUTH_SSO 
          ? AlkRequest::_GETint("sso", "0")
          : "0" );*/
$iSSO = AlkRequest::_GETint("sso", "0");


/** login */
if( /*defined("ALK_AUTH") && defined("ALK_AUTH_SSO") && ALK_AUTH==ALK_AUTH_SSO &&*/ $iSSO=="1" ) {
  if( !class_exists("phpCAS") ) {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."auth_cas/CAS.php");
    phpCAS::client(CAS_VERSION_2_0, ALK_SSO_URL, ALK_SSO_PORT, ALK_SSO_URI, false);
    
  } 
  phpCAS::setNoCasServerValidation();
  if( phpCAS::isAuthenticated() ) {
    $strLogin = phpCAS::getUser();
  }
} else {
  $strLogin = AlkRequest::_POST("strLogin", "");
}

/** mot de passe crypté md5 */
$strPwd = AlkRequest::_POST("strPwd", "");

/** caractéristique écran du client */
$windSize = AlkRequest::_POST("windSize", "");

/** décalage horaire par rapport à GMT */
$deltaGMT = AlkRequest::_POST("deltaGMT", -date("Z", time())/3600);

/** durée chargement page d'accueil */
$perf_id = AlkRequest::_POSTint("perf_id", "-1");

/** Adresse ip du client */
$clientIp = ( isset($_SERVER["REMOTE_ADDR"]) ? $_SERVER["REMOTE_ADDR"] : AlkRequest::_POST("client", "") );

/** alias de l'espace : non utilisé */
$cont_alias = ""; //AlkRequest::_GET("nc", "");

/** nom de fenêtre cible à ouvrir après authentification */
$target = AlkRequest::_GET("t", "");

/** Url de redirection après authentification, cette url ne doit pas être une page en popup */
$strUrlTo = AlkRequest::getDecodeParam("url", ""); 

/** 
 * authentification en mode ajax : ecrit un entier si erreur, une url de redirection si ok 
 */
$iAjax = AlkRequest::_POSTint("ijx", "0");

/**
 * Précise si la connexion concerne le backoffice = 0 ou un extranet frontoffice=1
 * En mode connectFrontOffice, on ne vérifie pas la restriction alk_userAdminAuth=1
 */
$iConnectFrontOffice = AlkRequest::_POSTint("icfo", $iAjax);

/** nécessaire pour avoir les constantes */
define("ALK_B_ATYPE_ESPACE", true);
define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE, "Espace");
define("ALK_B_ATYPE_ANNU", true);
define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ANNU, "Annu");

/** chargement des constantes */

$tabCont = array();
$tabAppli = array();
$tabAtype = array();

// chargement des constantes génériques
$tabCont[] = -1;
$tabAppli[] = -1;
$tabAtype[] = -1;
$tabAtype[] = 1;
$tabAtype[] = 0;

//AlkFactory::loadConstants(-1, -1);
AlkFactory::loadConstants($tabCont, $tabAppli, $tabAtype);

$oSpace = AlkFactory::getSpace();
$oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);

$oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
$oQueryCont = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
$oQueryActionCont = AlkFactory::getQueryAction(ALK_ATYPE_ID_ESPACE);

/** connexion sur cet alkanet */
$_sit_urlHomePage = "";
$_sit_targetHomePage = ( defined("ALK_DEFAULT_TARGET")==true ? ALK_DEFAULT_TARGET : "");
// vérifie la connexion
if ( $strIdentification!="" ){
  $dsAgent = $oQueryAnnu->getDs_ficheAgentByMarkupIdentification($strIdentification);
}
else {
  $dsAgent = $oQueryAnnu->getDs_ficheAgentByLoginPwd($strLogin, $strPwd, ">-3", $iSSO);
}

if( $drAgent = $dsAgent->getRowIter() ) {  
  // connexion ok
  $_SESSION["alk_idUser"]       = $drAgent->getValueName("AGENT_ID");
  list($_SESSION["alk_idAbonne"], $_SESSION["alk_pseudoAbonne"]) = $oQueryAnnu->getAbonneIdByAgentId($_SESSION["alk_idUser"]);
  $_SESSION["alk_idProfil"]     = $drAgent->getValueName("PROFIL_ID");
  $_SESSION["alk_idService"]    = $drAgent->getValueName("SERVICE_ID");
  $_SESSION["alk_serviceName"]  = $drAgent->getValueName("SERVICE_INTITULE");
  $_SESSION["alk_serviceSigle"] = $drAgent->getValueName("SERVICE_SIGLE");
  $_SESSION["alk_idDept"]       = $drAgent->getValueName("DEPT_ID");
  $_SESSION["alk_userPriv"]     = $drAgent->getValueName("AGENT_PRIV");
  $_SESSION["alk_userLogin"]    = $drAgent->getValueName("AGENT_LOGIN");
  $_SESSION["alk_userPwd"]      = $drAgent->getValueName("AGENT_PWD");
  $_SESSION["alk_userName"]     = $drAgent->getValueName("NOM");
  $_SESSION["alk_userFirstName"]= $drAgent->getValueName("AGENT_PRENOM");
  $_SESSION["alk_userLastName"] = $drAgent->getValueName("AGENT_NOM");
  $_SESSION["alk_userMail"]     = $drAgent->getValueName("AGENT_MAIL");
  $agent_valide                 = $drAgent->getValueName("AGENT_VALIDE");
  $_SESSION["alk_userAdminAuth"]= $drAgent->getValueName("AGENT_ADMINAUTH");
  $_SESSION["alk_userLg"]       = $drAgent->getValueName("AGENT_LG");
  $_SESSION["alk_userHome"]     = "";
  $_SESSION["alk_userHomeSite"] = "";
  $_SESSION["alk_idPerf"]       = $perf_id;
  $_SESSION["alk_userDeltaGMT"] = $deltaGMT;
  $_SESSION["alk_idHpaUser"]    = "";
  $_SESSION["alk_userDateConn"] = $drAgent->getValueName("AGENT_DATE_CONN");

  $cont_id_start = $drAgent->getValueName("CONT_ID_START");
  
  AlkFactory::initUserSProperties();

  /** l'utilisateur est authentifié, recherche l'espace et l'appli cible */
  if( $_SESSION["alk_idUser"] != ALK_USER_ID_INTERNET &&
      ( $iConnectFrontOffice=="1" && $agent_valide == "1" ||
        $iConnectFrontOffice=="0" && $agent_valide == "1" && $_SESSION["alk_userAdminAuth"]=="1" ||
        $iConnectFrontOffice=="0" && defined("ALK_B_USER_CANCONNECT_EXTRANET") && ALK_B_USER_CANCONNECT_EXTRANET==true && $agent_valide == "1" && $_SESSION["alk_userAdminAuth"]=="0") ) {
  
    if( $iSSO == "1" ) {
      $_SESSION["alk_ssoUser"] = true; 
    }
  
    if( $agent_valide == "1" ) {
    
      if( defined("ALK_B_SPACE_LOG") && ALK_B_SPACE_LOG ) {
        /** mémorisation du log */
        $oQueryActionCont->add_log($_SESSION["alk_idUser"], 1);
      }
      $strServiceSigle = $oQueryAnnu->getStr_ServiceSigle($_SESSION["alk_idService"]);
      $strDefaultPwd = $oQueryAnnu->verifyPassword($strServiceSigle);
    
      $bChangePwd = ( defined("ALK_B_ANNU_DESACTIVER_CHGTPWD") && ALK_B_ANNU_DESACTIVER_CHGTPWD==true
                      ? false
                      : ( $strPwd==AlkFactory::encrypt($strDefaultPwd) || $strPwd==AlkFactory::encrypt(ALK_ANNU_DEFAULTPWD) ) );
    
      $strCondProfil = "";
      if( ALK_B_SPACE_REMOVE_PRIV_ADMINALL == true ) {
        if( AlkFactory::isSpaceAnimAll() )
          $strCondProfil = " and c.CONT_RESERVE=0 ";
      }
      
      // identification classique
      // détermine l'espace cible
      $strContId = "";
      /*if( $cont_alias != "" ) {
        $dsCont = $oQueryCont->GetDs_ficheEspaceByAgentIntitule($_SESSION["alk_idUser"], $cont_alias, $strCondProfil);
        if( $drCont = $dsCont->getRowIter() )
          $strContId = $drCont->getValueName("CONT_ID");
      }*/
    
      // regarde l'espace par défaut
      if(  $cont_id_start != "" && $cont_id_start != "0" && $strContId == "" ) {
        // vérifie que l'espace est toujours accessible
        $dsCont = $oQueryCont->getDs_accesEspaceAgentById($cont_id_start, $_SESSION["alk_idUser"], $strCondProfil);
        if( $drCont = $dsCont->getRowIter() ) {
          $strContId = $cont_id_start;
        } else {
          // init l'espace par défaut pour l'utilisateur
          $oQueryActionCont->maj_agentContIdStart($_SESSION["alk_idUser"], 0);
        }
      }
    
      // calcule la redirection vers l'appli par défaut
      $tabAppli = $oQueryCont->getTab_appliDefautByAgent($_SESSION["alk_idUser"], $strContId);
      $cont_id = $tabAppli["cont_id"]; 
      $appli_id = $tabAppli["appli_id"]; 
    } else {
      $cont_id = -1;
      $appli_id = -1;
      $bChangePwd = false;
    }
      
    if( $cont_id > 0 || $strUrlTo != "" ) {
    	
      // réinitialisation des variables de session liées aux statistiques
      if ( isset($_SESSION["ALK_bStatConnectSIT"]) )   unset($_SESSION["ALK_bStatConnectSIT"]);
      if ( isset($_SESSION["ALK_tabStatAccesCont"]) )  unset($_SESSION["ALK_tabStatAccesCont"]);
      if ( isset($_SESSION["ALK_tabStatAccesAppli"]) ) unset($_SESSION["ALK_tabStatAccesAppli"]);
      
      /** protocole de la partie connecté */
      $ALK_ROOT_URL = ALK_ROOT_URL;
      $bRedirectHttps = false;
      if( defined("ALK_B_HTTP_SWITCH_PROTOCOL") && ALK_B_HTTP_SWITCH_PROTOCOL==true ) {
        // redirection en mode https
        $ALK_ROOT_URL = "https://".( defined("ALK_HTTPS_HOST") ? ALK_HTTPS_HOST : $_SERVER["HTTP_HOST"] );
        $bRedirectHttps = true;
      }
      
      // enregistrement de la date de derniere connexion
      $oQueryActionCont->maj_agentDateConn($_SESSION["alk_idUser"], $_SERVER["HTTP_USER_AGENT"], $windSize, $clientIp);
      $strUrl = ( $cont_id > 0
                  ? ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id)
                  : ( isset($_SESSION["alk_userHomeSite"]) && $_SESSION["alk_userHomeSite"]!="" 
                      ? $_SESSION["alk_userHomeSite"]
                      : "/accueil" ));                   
      $_SESSION["alk_userHome"] = $strUrl; 
      AlkFactory::setSProperty("user_home",  $_SESSION["alk_userHome"]);
      
      $strUrl = ( $strUrlTo != "" && !preg_match("!alkanet_sql.php!", $strUrlTo) 
                  ? ( stripos($strUrlTo, "http")===false 
                      ? $ALK_ROOT_URL.$strUrlTo
                      : $strUrlTo )
                  : $strUrl ); 
  			
      // redirection en javascript pour forcer l'enregistrement des variables de session    
      $strTokenChangePwd = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CHANGEPWD.
                                                      "&tokenClose=".ALK_ALKANET_IDENT);
      if( $iAjax == "0" ) {
        echo "<html><head>".
          "<script type='text/javascript' src='".ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_js.js'></script>".
          "<script type='text/javascript'>".
          " function Redirection() {".
          ( $bChangePwd == true
            ? " OpenWindow('".ALK_ALKANET_SITE."?token=".$strTokenChangePwd."', '190', '500', 'windPwdForm');"
            : ( $target != "" 
                ? " oWind = window.open('".$_sit_urlHomePage."', ".
                  (strpos($target, "window")===false && strpos($target, "opener")===false ? "'".$target."'" : $target).");" .
                  " if( oWind ) {" .
                  "  oWind.focus();" .
                  "  if( oWind != window ) closeWindow();".
                  " }" 
                : " document.location.href = '".$strUrl."';" )).
          "}</script></head>".
          "<body onload='Redirection()'><!--<a href='javascript:Redirection()'>go</a>--></body></html>";
      } else {
        // succès, écriture de l'url de redirection
        echo $strUrl;
      }
      exit();
    } elseif( $cont_id <= 0 ) {
      echo "ici0"; die();
      /** redirection avec le cas où non invité à un espace, alors que le compte existe et est validé */
      if( $iAjax == "0" ) {
        //echo "<a href='../ident/".ALK_INDEX_AUTH."?err=3'>Personne authentifiée, invité à aucun espace.</a>";
        header("location:".ALK_ALKANET_ROOT_URL."admin?err=3&nc=".$cont_alias);
      } else {
        echo "3"; 
      }
      exit();
    }
  } else {
    
    $err = "1";
    switch( $agent_valide ) {
    case 0  : $err = "4"; break;
    case -2 : $err = "5"; break;
    }
    if( $iAjax == "0" ) {
      //echo "<a href='../ident/".ALK_INDEX_AUTH."?err=".$err."'>Personne authentifiée, compte non valide ou en cours de validation.</a>";
      header("location:".ALK_ALKANET_ROOT_URL."accueil/admin?err=".$err."&nc=".$cont_alias);
    } else {
      echo $err;
    }
    exit();
  }
}
if( $iAjax == "0" ) {
  //echo "<a href='../ident/".ALK_INDEX_AUTH."?err=1'>erreur authentification ou compte n'existe pas</a>";  die();
  header("location: ".ALK_ALKANET_ROOT_URL."accueil/admin?err=1&nc=".$cont_alias);
} else { 
  echo "1"; 
}
exit();

?>