<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Dico
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @brief Compare 2 éléments du tableau contenant les infos de tous les dictionnaires simples
 *        pour effectuer un tri selon le champ titre
 * @param elt1  premier élément à comparer (tableau)
 * @param elt2  second élément à comparer (tableau)
 * @return Retourne un int : 0 si égal, 1 si $elt1 > $elt2, -1 sinon
 */
function compareArray($elt1, $elt2)
{
  $elt1 =strtr($elt1["title"],
               "\xe1\xc1\xe0\xc0\xe2\xc2\xe4\xc4\xe3\xc3\xe5\xc5".
               "\xaa\xe7\xc7\xe9\xc9\xe8\xc8\xea\xca\xeb\xcb\xed".
               "\xcd\xec\xcc\xee\xce\xef\xcf\xf1\xd1\xf3\xd3\xf2".
               "\xd2\xf4\xd4\xf6\xd6\xf5\xd5\x8\xd8\xba\xf0\xfa".
               "\xda\xf9\xd9\xfb\xdb\xfc\xdc\xfd\xdd\xff\xe6\xc6\xdf",
               "aAaAaAaAaAaAacCeEeEeEeEiIiIiIiInNoOoOoOoOoOoOoouUuUuUuUyYyaAs");
  $elt2 =strtr($elt2["title"],
               "\xe1\xc1\xe0\xc0\xe2\xc2\xe4\xc4\xe3\xc3\xe5\xc5".
               "\xaa\xe7\xc7\xe9\xc9\xe8\xc8\xea\xca\xeb\xcb\xed".
               "\xcd\xec\xcc\xee\xce\xef\xcf\xf1\xd1\xf3\xd3\xf2".
               "\xd2\xf4\xd4\xf6\xd6\xf5\xd5\x8\xd8\xba\xf0\xfa".
               "\xda\xf9\xd9\xfb\xdb\xfc\xdc\xfd\xdd\xff\xe6\xc6\xdf",
               "aAaAaAaAaAaAacCeEeEeEeEiIiIiIiInNoOoOoOoOoOoOoouUuUuUuUyYyaAs");

  return strcoll($elt1, $elt2);
}

/**
 * @package Alkanet_Module_Dico
 * @class AlkHtmlDico
 * 
 * Classe fournissant les interfaces list, form et sql pour la gestion des dictionnaires
 */
class AlkHtmlDico extends AlkHtmlForm 
{
  /** URL de la liste */
  protected $urlList;

  /** URL du formulaire */
  protected $urlForm;

  /** URL du fichier recevant les données et demandant au dictionnaire d'effectuer les requêtes Sql avant redirection */
  protected $urlSql;

  /** URL du fichier recevant les données et demandant au dictionnaire d'effectuer les requêtes Sql avant redirection */
  protected $defaultDico;

  /** Table dictionnaire */
  protected $tabDico;

  /** Mode d'affichage : ALK_DICO_LIST, ALK_DICO_FORM, ALK_DICO_SQL ou ALK_DICO_HIDDEN */
  protected $iModeAff;

  /** nombre d'éléments par page */
  protected $iNbEltParPage;
  
  /** référence sur le formulaire intégrant le bloc fourni par cette classe */
  protected $oFormDico;
  
  protected $bFiltre = false;
  
  /** nom du champ file **/
  protected $fichier ; 
  /**
   * @brief constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formDicoInternal");
    
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }

  /**
   * @brief Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit  type de récupération
   */
  protected function setData($iTypeInit) { }

  /**
   * Initialise les données du dictionnaire
   *
   * @param tabDico      Tableau de paramétrage du dictionnaire
   */
  public function setDataDico(&$tabDico)
  {
    $this->tabDico = $tabDico;
    uasort($this->tabDico, "compareArray");    
  }
 
  /**
   * @brief Appel des actions SQL sur les données du formulaire
   */
  public function doSql() 
  { 
    $iMode = AlkRequest::_GETint("iMode", "1");
    $id    = AlkRequest::_GETint("id", "-1");
    $dico  = AlkRequest::_REQUEST("dico", $this->defaultDico);
    $page  = AlkRequest::_GETint("page", "1");

    $strUrlBack = $this->urlList."&dico=".$dico."&page=".$page;

    //$bRedirect = (  isset($this->tabDico[$dico]["redirect"]) 
    //                && isset($this->tabDico[$dico]["redirect"][$this->iModeAff]));
     
    switch( $iMode ) {
    case "1": // mode ajout
    case "2": // mode modif
      /*if ($bRedirect && isset($this->tabDico[$dico]["redirect"][$this->iModeAff][$iMode])){
        $urlRedirect = $this->tabDico[$dico]["redirect"][$this->iModeAff][$iMode];
        $oHide = new HtmlHidden("urlBack", $strUrlBack);
        foreach ($_POST as $key=>$value){
          $oHide->AddHidden($key, $value);
        }
          
        $strHtml = "";
        $strHtml .= "<form name='formTransit' action='".$urlRedirect."' method='post'>";
        $strHtml .= $oHide->GetHtml();
        $strHtml .= "</form>";
        return array("redirect", $strHtml, "RedirigeFormulaire()");
      }*/
      
      $strAlias = strtolower(Request("ALIAS", REQ_POST, ""));
      $strFieldKey = "";
      $tabValue = array();
      foreach ($this->tabDico[$dico] as $strKey => $oElt ) {
        if( $strKey == "title" || $strKey == "id" || $strKey == "search" || $strKey == "redirect" ) { 
          if( $strKey == "id" ) $strFieldKey = $oElt;
          continue; 
        }
        $strField = ( is_array($oElt) ? $oElt[0] : $oElt );
        $strType  = ( is_array($oElt) ? (count($oElt)>3 ? $oElt[3] : "text") : "int" );
        switch( $strType ) {
         
        case "file":
          $iSupPhoto = RequestCheckbox("del_".$strField, REQ_POST);
          $strPathUpload = $this->tabDico[$dico][$strKey][4];
          
          $strFileName = DoUpload($strField, $id."_", $strPathUpload, $iSupPhoto, $id."_*");
          if (is_string($strFileName))
            $tabValue[$strField] = array(ALK_SQL_TEXT, $strFileName);
          break;
        /* 
        case "list_join":
          $bVisible  = (count($oElt)>5 ? $oElt[5] : true);
          if (!$bVisible) continue;
          $tabDescSql  = ( is_array($oElt) && count($oElt)>4 ? $oElt[4] : array() );
          if (isset ($tabDescSql["chpjoin"])){
            $chpjoin = $tabDescSql["chpjoin"];
            $tabValue[$chpjoin] = array(TYPE_LISTE, Request($chpjoin, REQ_POST, array()), $tabDescSql);
          }
          break;
          
        case "text_join":
          $bVisible  = (count($oElt)>5 ? $oElt[5] : true);
          if (!$bVisible) continue;
          $tabDesc  = ( is_array($oElt) && count($oElt)>0 ? $oElt[0] : array() );
          $tabDesc  = ( is_array($tabDesc) && count($tabDesc)>1 ? $tabDesc[1] : array() );
          $chpRequest  = ( is_array($tabDesc) && count($tabDesc)>0 ? $tabDesc[0] : "" );
          $chpRequest = str_replace("[]", "", $chpRequest);
          $tabDescSql  = ( is_array($oElt) && count($oElt)>4 ? $oElt[4] : array() );
          $chpjoin = $tabDescSql["chpjoin"];
          $tabValue[$chpjoin] = array(TYPE_TEXT_LISTE, Request($chpRequest, REQ_POST, array()), $tabDescSql, $chpRequest);
          
          break;
          
        case "check":
          $typeCheck  = ( is_array($oElt) && count($oElt)>4 ? $oElt[4] : TYPE_NUMBER );
          $tabValue[$strField] = array($typeCheck, Request($strField, REQ_POST, ($typeCheck==TYPE_NUMBER ? "0" : ""), ($typeCheck==TYPE_NUMBER ? "is_numeric" : "is_string")));
          break;
        */
        case "hidden":
          $typeCheck  = ( is_array($oElt) && array_key_exists(6, $oElt) ? $oElt[6] : ALK_SQL_NUMBER );
          $tabValue[$strField] = array($typeCheck, ( $typeCheck== ALK_SQL_NUMBER? AlkRequest::_POSTint($strField, "0" ) : AlkRequest::_POSTint($strField, "")));
          break;
          
        case "date10":
          $tabValue[$strField] = array(ALK_SQL_DATE, AlkRequest::_POST($strField, ""));
          break;

        case "int":
        case "combo_num":
          $tabValue[$strField] = array(ALK_SQL_NUMBER, AlkRequest::_POSTint($strField, "0"));
          break;

        case "combo_text":
        case "text": 
        case "radio":   
        default: 
          $tabValue[$strField] = array(ALK_SQL_TEXT, AlkRequest::_POST($strField, ""));
          break;
        }
      }
      
      $strFieldOrder = ( array_key_exists("Ordre", $this->tabDico[$dico])   
                         ? ( is_array($this->tabDico[$dico]["Ordre"])
                             ? $this->tabDico[$dico]["Ordre"][0]
                             : $this->tabDico[$dico]["Ordre"] )
                         : "" );
      $oldOrder = AlkRequest::_POSTint("a".$strFieldOrder, "-1");
      
      $tSearch = $this->tabDico[$dico]["search"];   
      $real_dico = (array_key_exists("table", $tSearch) ? $tSearch["table"] : $dico);

      if( $iMode == "1" ) {
        $id = $this->oAppli->oQueryAction->add_ficheDico($real_dico, $strFieldKey, $tabValue, $oldOrder, $strFieldOrder);
      } else {
        $this->oAppli->oQueryAction->update_ficheDico($real_dico, $strFieldKey, $id, $tabValue, $oldOrder, $strFieldOrder);
      }
      break;

    case "3": // mode suppr
      /*if ($bRedirect && isset($this->tabDico[$dico]["redirect"][$this->iModeAff][$iMode])){
        $strSql = $this->tabDico[$dico]["redirect"][$this->iModeAff][$iMode].$id;
        if (preg_match("!^delete!", $strSql))
          $bRes = $this->oQueryAction->ExecuteSql($strSql);
        else {
          $oHide = new HtmlHidden("urlBack", $strUrlBack);
          foreach ($_POST as $key=>$value){
            $oHide->AddHidden($key, $value);
          }
            
          $strHtml = "";
          $strHtml .= "<form name='formTransit' action='".$strSql."' method='post'>";
          $strHtml .= $oHide->GetHtml();
          $strHtml .= "</form>";
          return array("redirect", $strHtml, "RedirigeFormulaire()");
        }
      }
      else {*/ 
      $bRes = true;
      foreach ($this->tabDico[$dico] as $strKey => $oElt ) {
        if( $strKey == "title" || $strKey == "id" || $strKey == "search" || $strKey == "redirect" ) { 
          if( $strKey == "id" ) $strFieldKey = $oElt;
          continue; 
        }
        $strField = ( is_array($oElt) && count($oElt)>0 ? $oElt[0] : $oElt );
        $strType  = ( is_array($oElt) ? (count($oElt)>3 ? $oElt[3] : "text") : "int" );
        /*switch( $strType ) {    
        case "list_join":
          $tabDescSql  = ( is_array($oElt) && count($oElt)>4 ? $oElt[4] : array() );
          $bRes &= $this->oQueryAction->del_listeJoin($tabDescSql, $id);
          break;
            
        case "text_join":
          $bVisible  = (count($oElt)>5 ? $oElt[5] : true);
          $tabDescSql  = ( is_array($oElt) && count($oElt)>4 ? $oElt[4] : array() );
          $bRes &= $this->oQueryAction->del_textJoin($tabDescSql, $id);
          
          break;
        }*/
      }
      $strFieldKey = $this->tabDico[$dico]["id"];
      $tSearch = $this->tabDico[$dico]["search"];   
      
      $real_dico = (array_key_exists("table", $tSearch) ? $tSearch["table"] : $dico);

      $bRes = $this->oAppli->oQueryAction->del_ficheDico($real_dico, $strFieldKey, $id);
      //}
      if( $bRes == false ) {
        $strUrlBack .= "&err=1";
      }
      break;
    }
    return $strUrlBack;
  }
  
  /**
   * @brief Définition du contenu affiché du formulaire
   */
  protected function setContents() { }

  /**
   * Mémorise les paramètres de la page qui contiendra le bloc dicoList ou dicoForm
   * ou qui appellera le doSql() de cette classe.
   * 
   * @param oFormDico    Référence du formulaire contenant le bloc html dicoList ou dicoForm
   * @param strUrlList   URL de la liste
   * @param strUrlForm   URL du formulaire
   * @param strUrlSql    URL du fichier recevant les données et demandant au dictionnaire d'effectuer les requêtes Sql avant redirection
   * @param iDefaultDico  Identifiant du dico par défaut
   * @param iModeAff     Mode d'affichage du dictionnaire (list, form, sql ou caché)
   */
  public function setDataInfoDico($oFormDico, $strUrlList, $strUrlForm, $strUrlSql, $iDefaultDico, $iModeAff=ALK_SHEET_NONE)
  {
    if( !is_null($oFormDico) ) {
      $formName = $oFormDico->getName();
    } else {
      $formName = "dicoForm";
    }
    $this->setName($formName."Internal");
    $this->oFormDico    = $oFormDico; 
    $this->urlList      = $strUrlList;
    $this->urlForm      = $strUrlForm;
    $this->urlSql       = $strUrlSql;
    $this->iModeAff     = $iModeAff;
    $this->defaultDico  = $iDefaultDico;  
  }

  /**
   * @brief Définition du contenu affiché du formulaire
   * 
   * @param strUrlList   URL de la liste
   * @param strUrlForm   URL du formulaire
   * @param strUrlSql    URL du fichier recevant les données et demandant au dictionnaire d'effectuer les requêtes Sql avant redirection
   * @param iDefaultDico  Identifiant du dico par défaut
   * @param iModeAff     Mode d'affichage du dictionnaire (list, form, sql ou caché)
   */
  public function getPanelContents() 
  {
    $oPanel = null;
    switch( $this->iModeAff ) {
    case ALK_SHEET_FORM : 
      $oPanel = $this->getHtmlFormDico(); 
      break;
    
    case ALK_SHEET_LIST :
    default: 
      $oPanel = $this->getHtmlListDico(); 
      break;
    }
    
    return $oPanel;
  }
  
  /**
   * @brief Retoure un tableau associatif utilisable pour un combo
   *
   * @param tabDico  Tableau contenant les infos de tous les dictionnaires simples
   * @return Retourne un array
   */
  private function _getTabDicoListForCombo()
  {
    $tabRes = array();
    foreach($this->tabDico as $strTable => $tabElt) {
      if ( array_key_exists("category", $tabElt["search"])){
        $tabRes[$tabElt["search"]["category"]][$strTable] = $tabElt["title"];
      }
      else {
        $tabRes[$strTable] = $tabElt["title"];
      }
    }
    return $tabRes;
  }

  /**
   * Retourne une liste d'éléments d'un dictionnaire
   *
   * @return AlkHtmlList
   */
  protected function getHtmlListDico()
  {
//  	$bAdmin = $this->iTypeSheet==2;
	$bAdmin = AlkFactory::getSProperty("user_right",0);
  	$iErr = AlkRequest::_GETint("err", "0");
    $dico = AlkRequest::_REQUEST("dico", $this->defaultDico);
    $page = AlkRequest::_GETint("page", "1"); 
    $this->iNbEltParPage = AlkRequest::_GETint("nbItemsPerPage", -1);
    if( $this->iNbEltParPage == -1 ) {
      $this->iNbEltParPage = ( isset($_SESSION["alk_dicoNbEltParPage"]) ? $_SESSION["alk_dicoNbEltParPage"] : ALK_ITEMS_PER_PAGE ) ;
    }
    $_SESSION["alk_dicoNbEltParPage"] = $this->iNbEltParPage; 
   
    $oBtAdd = AlkHtmlFactory::getHtmlButtonPage($this->urlForm."&dico=".$dico."&page=".$page."&iMode=".ALK_FORM_MODE_ADD,
        	                                        "Ajouter", "Ajouter un nouvel élément à la liste");

    $oCtrlDico = AlkHtmlFactory::getNewHtmlSelect($this, 0, "dico", $dico, "Dictionnaire : ", 1);
    $oCtrlDico->addEvent("onChange", "onChangeCtrlDico('".$this->oFormDico->getName()."', '".$this->urlList."')");
    $oCtrlDico->setProperty("tabValTxt", $this->_getTabDicoListForCombo());

    // liste des éléments du dictionnaire sélectionné
    $iNbEltParPage = $this->iNbEltParPage;
    $iFirst = ($page-1)*$iNbEltParPage;
    $iLast = $iFirst+$iNbEltParPage-1;

    $tSearch = $this->tabDico[$dico]["search"];   
   
   if( isset($tSearch["sql"]) ) {
      $dsDico = $this->oAppli->oQuery->getDs($tSearch["sql"], $iFirst, $iLast);
    } else {
      $dsDico = $this->oAppli->oQuery->getDs_listeDico($dico, $this->tabDico[$dico], $iFirst, $iLast);
    }
    
    $iNbElt = $dsDico->getCountTotDr();
    $strUrlPagine = $this->urlList."&dico=".$dico;

    $oBlockDicoList = AlkHtmlFactory::getHtmlList($this->oFormDico, $iNbElt, $page, $iNbEltParPage, 
                                                  true, $strUrlPagine, "Aucune information.", false, "dicoList");
    
    // détection du nombre de colonne et création de l'entete des colonnes
    $bAdd = (isset($tSearch["bAdd"]) ? $tSearch["bAdd"] : true);
    $bAdd = ($bAdmin ? $bAdd : false);
    
    $tabCol = array();
    $tabTitle = array();
    $tabTmp = array();
    foreach ($tSearch["titles"] as $tabT){
      if( is_array($tabT) && count($tabT)==3 && $tabT[0]!="") {
        $tabCol[] = array($tabT[2], $tabT[1]);
        $tabTmp[] = $tabT[0];
      } else {
        $tabTmp[] = $tabT;
      }
    }
    $tSearch["titles"] = $tabTmp;
    if( count($tabCol) != count($tabTmp ) ) {
      $tabCol = array();
    }
    
    $nbCol = count($tSearch["titles"]);
    $wAddDel = ($bAdmin ? 120 : 0);
    if( empty($tabCol) ) { 
      $width = 700;
      $wCol = ($width-$wAddDel)/count($tSearch["titles"]);

      for($i = 0; $i < $nbCol; $i++) {
        $tabCol[$i] = array("center", $wCol);
      }
    }
    $tabCol[$nbCol] = array("center", $wAddDel);
    $tabTitle = $tSearch["titles"];
    $tabTitle[$nbCol] = ($bAdmin ? "Actions" : "");
    $nbCol++;
    
    $oBlockDicoList->SetColumnsByArray($tabCol);
    if( $iErr == "1" ) {
      $oBlockDicoList->setLabelDesc("<div class='txtWarning' align='center'>Impossible de supprimer cet enregistrement car il est encore utilisé.</div>");
    }
    $oBlockDicoList->AddTitleRow(array("Dictionnaire ".$oCtrlDico->getHtml(), $nbCol, 1));
    $oBlockDicoList->AddTitleRow(array($iNbElt." enregistrement".($iNbElt>1 ? "s" : ""), $nbCol-1, 1), ($bAdd ? $oBtAdd->getHtml() : "&nbsp;"));
    $oBlockDicoList->addTitleRowByArray($tabTitle);
 
    $keys = array_keys($this->tabDico[$dico]);
  
    $pattern = $tSearch["pattern"];
    $tabChp = array();
    preg_match_all("/<\d+>/", $pattern, $tabChp, PREG_PATTERN_ORDER);
    $tabChp = array_unique($tabChp[0]);
    $tabChp = $this->getArrayKeys($tabChp, $keys);
    
    $tabPattern = array_slice(preg_split("/\|/", $pattern), 1);
	  	
    $strUrlBack = $this->urlList."&dico=".$dico."&page=".$page;
    /*$bRedirect = (  isset($this->tabDico[$dico]["redirect"]) 
                    && isset($this->tabDico[$dico]["redirect"][ALK_DICO_SQL])
                    && isset($this->tabDico[$dico]["redirect"][ALK_DICO_SQL][3]));*/

    while( $drDico = $dsDico->getRowIter() ) {
      $id           = $drDico->getValueName("ID");
      $bSupprimable = $drDico->GetValueName("B_SUPPRIMABLE");
      $bEditable    = $drDico->GetValueName("B_EDITABLE");
      if ( $bSupprimable==="" )
        $bSupprimable = 1;
      if ( $bEditable==="" )
        $bEditable = 1;
      
      $tabRow = array();
      $tabVal = array();

      foreach ($tabChp as $champ){
        $tabVal[$champ] = $drDico->getValueName($champ);
      }

      $urlDest = $this->urlForm."&iMode=2&dico=".$dico."&id=".$id."&page=".$page."&bEditable=".$bEditable."&bSupprimable=".$bSupprimable;
      
      if( count($tabPattern) > 0 ) {
        $tabRes = array_fill(0, count($tabPattern), "");
        for($i=0; $i<count($tabPattern); $i++) {
          $match_keys = array();
          $separators = array();
          $pI = trim($tabPattern[$i]);
          $matches = preg_match_all("/<\d+>/ui", $pI, $match_keys, PREG_PATTERN_ORDER);//"![A-Za-z]+(_[A-Za-z]+)+\d*!i"
          preg_match_all("![^(<\d+>)]+!ui", $pI, $separators, PREG_PATTERN_ORDER);
          $match_keys = $match_keys[0];
          $match = $this->getArrayKeys($match_keys, $keys);
          $separators = $separators[0];
          $tabRes[$i] = $pI;
          for($j=0; $j<count($match_keys); $j++) {
            $tabRes[$i] = preg_replace("/".$match_keys[$j]."/ui", "".$tabVal[$match[$j]]."", $tabRes[$i]);
          }
        }
        
        $tabRow[0] = ($bAdmin ? "<a href='".$urlDest."'>".$tabRes[0]."</a>" : $tabRes[0]);
        for($i=1; $i<count($tabPattern); $i++) {
          $tabRow[$i] = $tabRes[$i];
        }
      }
       
      $iPage = ( $iNbElt-1 <= ($page-1)*$iNbEltParPage ? ($page-1>0 ? $page-1 : 1) : $page);
      if( $bSupprimable && $bAdmin ) {
        $strAction = $this->urlSql."&dico=".$dico."&id=".$id."&iMode=3&page=".$iPage;
        /*if ($bRedirect){
          $strAction = $this->tabDico[$dico]["redirect"][ALK_DICO_SQL][3].$id."&urlBack=".EncodeRequest($strUrlBack);
        }*/
        $oBtSuppr =AlkHtmlFactory::getHtmlButtonIcon("javascript:SupprElt('".$this->oFormDico->getName()."', '".$strAction."')", "Supprimer", "Supprimer cet élément");
        $tabRow[] = $oBtSuppr->getHtml();
      } else {
        $tabRow[] = "&nbsp;";
      }

      $oBlockDicoList->AddRowByArray($tabRow);
    }
   
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."dico/lib/lib_dico.js");
   
    return $oBlockDicoList;
  }

  /**
   * Retourne le code html d'un formulaire dictionnaire simple
   * Si le formulaire est réduit à une redirection, un tableau est retourné.
   *
   * @return Retourne un string ou un array
   */
  protected function getHtmlFormDico()
  {
  	$bEditable = AlkRequest::_GETint("bEditable", "1");
    $bSupprimable = AlkRequest::_GETint("bSupprimable", "1");

   
    $id   = AlkRequest::_GETint("id", "-1");
    $dico = AlkRequest::_GET("dico", $this->defaultDico);
    $page = AlkRequest::_GETint("page", "1");
    
    $strParam = "&page=".$page."&dico=".$dico."&id=".$id;
  
    $strSubtitle = ( $bEditable ? ($id==-1 ? "Création" : "Modification") : "");
    
    $this->iMode = $iMode = ( $bEditable
                              ? ( $id=="-1" ? ALK_FORM_MODE_ADD : ALK_FORM_MODE_UPDATE )
                              : ALK_FORM_MODE_READ );
    
    $oBlockForm = $this->oFormDico->addBlock("BlockProp", "Gestion ".$this->tabDico[$dico]["title"]." : ".$strSubtitle, "", "200", "390", true); 
 
    /*$bAddHidden = false;
    $strUrlBack = $this->urlForm.$strParam.ALK_DICO_LIST;
    $bRedirect = (  isset($this->tabDico[$dico]["redirect"]) 
                    && isset($this->tabDico[$dico]["redirect"][ALK_DICO_SQL]));
    if ($bRedirect && isset($this->tabDico[$dico]["redirect"][ALK_DICO_SQL][$iMode])){
      $strAction = $this->tabDico[$dico]["redirect"][ALK_DICO_SQL][$iMode];
      $oHideUrl = new HtmlHidden("urlBack", $strUrlBack);
      $bAddHidden = true;
    }

    if ($bAddHidden){
      $oBlock->AddCtrl($oHideUrl);
    }*/

    // gestion des boutons
    $tabBoutons = ( isset($this->tabDico[$dico]["boutons"]) ? $this->tabDico[$dico]["boutons"] : array() );
    if( $bEditable==1 ) {
      $tabValider = ( isset($tabBoutons["valider"]) ? $tabBoutons["valider"] : array() );
      if( !empty($tabValider) ) {
        //$strExec = "\$oForm->AddLink(\"btVal\", \"".implode("\", \"", $tabValider)."\");";
        //eval($strExec);
      } else {
        $oBlockForm->addButtonPage("btValid", "javascript:ValiderDico('".$this->oFormDico->getName()."', '".$this->urlSql.$strParam."&iMode=".$iMode."')", "Valider", "Valider la fiche"); 
      }
    }
    
    $tabAnnuler = (isset($tabBoutons["annuler"]) ? $tabBoutons["annuler"] : array());
    if( !empty($tabAnnuler) ) {
      //$strExec = "\$oForm->AddLink(\"btAnn\", \"".implode("\", \"", $tabAnnuler)."\");";
      //eval($strExec);
    } else {
      $oBlockForm->addButtonPage("btCancel", $this->urlList.$strParam, "Annuler", "Annuler les modifications"); 
    }
    
    if( $bSupprimable==1 && $id!=-1 ) {
      $tabSuppr = ( isset($tabBoutons["supprimer"]) ? $tabBoutons["supprimer"] : array() );
      if( !empty($tabSuppr) ) {
        //$strExec = "\$oForm->AddLink(\"btDel\", \"".implode("\", \"", $tabSuppr)."\");";
        //eval($strExec);
      } else {
        //$urlDest = $this->urlSql."&iModeAff=".ALK_DICO_SQL."&dico=".$dico."&iMode=3&id=";
        //if ($bRedirect && isset($this->tabDico[$dico]["redirect"][ALK_DICO_SQL][3])){
        //  $urlDest = $this->tabDico[$dico]["redirect"][ALK_DICO_SQL][3];
        //}
        $oBlockForm->addButtonPage("btDel", "javascript:SupprElt('".$this->oFormDico->getName()."', '".$this->urlSql.$strParam."&iMode=3')", "Supprimer", "Supprimer cet élément");
      }
    }

    /*if( isset($this->tabDico[$dico]["redirect"]) && isset($this->tabDico[$dico]["redirect"][$this->iModeAff]) ) {
      // ecrit un formulaire auto validé sur le onload de la page

      $strUrlBack = $this->urlForm.$strParam.ALK_DICO_LIST;
      $urlRedirect = $this->tabDico[$dico]["redirect"][$this->iModeAff].$id;

      $oHide = new HtmlHidden("urlBack", $strUrlBack);
      $oHide->AddHidden("bEditable", $bEditable);
      $oHide->AddHidden("bSupprimable", $bSupprimable);
      $oHide->AddHidden("strTitle", $this->tabDico[$dico]["title"]);
      
      header("location:".$this->tabDico[$dico]["redirect"][$this->iModeAff].$id.
              "&urlBack=".EncodeRequest($strUrlBack).
              "&bEditable=".$bEditable."&bSupprimable=".$bSupprimable."&strtitle=".$this->tabDico[$dico]["title"]);
      exit();
      $strHtml = "";
      $strHtml .= "<form name='formTransit' action='".$urlRedirect."' method='post'>";
      $strHtml .= $oHide->GetHtml();
      $strHtml .= "</form>";

      return array("redirect", $strHtml, "RedirigeFormulaire()");       
    }*/
    
    // lecture des informations
    $tabVal = array();
   
    $tSearch = $this->tabDico[$dico]["search"];   
    $real_dico = (array_key_exists("table", $tSearch) ? $tSearch["table"] : $dico);
    $dsDico = $this->oAppli->oQuery->getDs_ficheDico($real_dico, $this->tabDico[$dico], $id);
     
    if( $drDico = $dsDico->getRowIter() ) {
      foreach($this->tabDico[$dico] as $strLabel => $tabDesc) {
        if( $strLabel != "title" ) {
          $tabVal[$strLabel] = $drDico->getValueName($strLabel);
        }
      }
    }
     
    // génération du formulaire
    $iWidthTxt = 48;
    $iWidthMemo = 46;
    $iHeightMemo = 4;
    $iWidthSelect = 380;
    $i = 0;
    $tabCtrl = array();
    foreach ($this->tabDico[$dico] as $strLabel => $tabDesc ) {
      if( $strLabel == "title" || $strLabel == "search" || $strLabel == "redirect") continue;
      
      $strField = ( is_array($tabDesc) ? $tabDesc[0] : $tabDesc );
      $iMaxLg   = ( is_array($tabDesc) ? $tabDesc[1] : 50 );
      $bReq     = ( is_array($tabDesc) && array_key_exists(2, $tabDesc) ? $tabDesc[2] : false );
      $strType  = ( is_array($tabDesc) ? (array_key_exists(3, $tabDesc) ? $tabDesc[3] : "text") : "int" );
      $strParam4= ( is_array($tabDesc) && array_key_exists(4, $tabDesc) ? $tabDesc[4] : ""); 
      $strParam5= ( is_array($tabDesc) && array_key_exists(5, $tabDesc) ? $tabDesc[5] : "");
      $strValue = ( array_key_exists($strLabel, $tabVal) ? $tabVal[$strLabel] : "" );
      
      $strLib = str_replace("_", " ", $strLabel);
      
      $iModeCtrl = 0;
      if( is_array($tabDesc) && array_key_exists("evalMode", $tabDesc) )
        $iModeCtrl = eval("return (".$tabDesc["evalMode"]." ? 1 : 0);");
        
      if( $strLabel == "id") {
        $strType = 'hidden';
      }
      
      if( $strLabel == "Ordre" ) {
        // enregistrement de l'ancien rang d'affichage, nécessite d'avoir le label Ordre dans la liste des champs
        if( $iMode == 1 ) {
          $dbConn = AlkFactory::getDbConn();
          $strValue = $dbConn->getNextRank($dico, $strField, "");
        }
        $tabCtrl[$i] = AlkHtmlFactory::getNewHtmlHidden($this->oFormDico, "a".$strField, $strValue);
        $oBlockForm->AddCtrl($tabCtrl[$i]);
        $i++;
      }
      
      if( $strType == 'hidden' ) {
        $strValue = ( $strParam4 == "not_null" && $strValue=="" ? $strParam5 : $strValue );
        $tabCtrl[$i] = AlkHtmlFactory::getNewHtmlHidden($this->oFormDico, $strField, $strValue);
      } 
      elseif( $strType == 'file' ) {
        $strPath = $strParam4;
        $this->fichier  = new AlkFormData($this->oFormDico, $strField,  $strValue, ALK_SQL_TEXT);   
        $oCtrlFile = AlkHtmlFactory::getHtmlFile($this->fichier,$strLib,45,255);
        $oCtrlFile->setDualMode(true);
        $oCtrlFile->setFileUrl("/".AlkFactory::getUploadPath(ALK_ATYPE_ID_PROFITSOFT,true), $this->fichier->value);
        
        $tabCtrl[$i] = $oCtrlFile;
        //$tabCtrl[$i]->bDualMode = true;
        //$tabCtrl[$i]->cbName = "sup_".$strField;
        /*if( $strValue != "" ) {
          $tabCtrl[$i]->urlFile = ALK_SIALKE_URL.$strPath.$strValue;
        }*/
      } /*
      elseif( $strType == 'check' ) {        
        $strValue = ( array_key_exists($strLabel, $tabVal) ? $tabVal[$strLabel] : $iMaxLg );
        $tabCtrl[$i] = new HtmlCheckbox($iModeCtrl, $strField, $strValue, $strLib);
        $tabCtrl[$i]->AddValidator("formDico", "check", $bReq);
      } 
      elseif( $strType == 'list_join' ) {
        $tabListe1 = $strField[0];
        $tabListe2 = $strField[1];
        $bVisible  = (array_key_exists(5, $tabDesc) ? $tabDesc[5] : true);
        if( !$bVisible ) continue;
        $tabDesc = $strParam4;
        
        $strField1 = $tabListe1[0];
        $strValue1 = ( count($tabListe1)>1 ? $tabListe1[1] : "-1");
        $default1 = ( count($tabListe1)>2 ? $tabListe1[2] : null);

        $oCtrl1 = new HtmlSelect($iModeCtrl, $strField1, $strValue1, "", 1, $iMaxLg);
        $oCtrl1->oValTxt = $this->oQuery->getDs_JoinNotIn($tabDesc, $id);
        $oCtrl1->tabValTxtLast = $default1;
        $oCtrl1->AddEvent("onkeypress", "onKeyPressSelect");
        $oCtrl1->AddEvent("onblur", "onBlurSelect");
        
        $strField2 = $tabListe2[0];
        $strSql2 = $tabListe2[1];
        $strValue2 = ( count($tabListe2)>2 ? $tabListe2[2] : "-1");
        $default2 = ( count($tabListe2)>3 ? $tabListe2[3] : array("null", ""));
        $oCtrl2 = new HtmlSelect($iModeCtrl, $strField2, $strValue2, $strLib, 5, $iMaxLg);
        $oCtrl2->oValTxt = $this->oQuery->getDs_JoinIn($tabDesc, $id);
        $oCtrl2->tabValTxtLast = $default2;
        $oCtrl2->bMultiple = true;
        $oCtrl2->addValidator("formDico", "multiselect", $bReq);

        $oAdd = new HtmlLink("javascript:FlipLists('$strField1', '$strField2')", "Ajouter à la sélection", "tabp_fleche_bas.gif", "tabp_fleche_bas_rol.gif");
        $oDel = new HtmlLink("javascript:FlipLists('$strField2', '$strField1')", "Retirer de la sélection", "tabp_fleche_haut.gif", "tabp_fleche_haut_rol.gif");
        
        $str = "";
        $str .= "<table border=0 cellspacing=0 cellpadding=0 align=left>";
        $str .= "<tr>" .
                  "<td>".$oCtrl1->GetHtml()."</td>" .
                  "<td width=5></td>" .
                  "<td>".$oAdd->GetHtml()."</td>" .
                "</tr>";
        $str .= "<tr height=4><td></td></tr>";
        $str .= "<tr>" .
                  "<td>".$oCtrl2->GetHtml()."</td>" .
                  "<td width=5></td>" .
                  "<td valign=top>".$oDel->GetHtml()."</td>" .
                "</tr>";
        $str .= "</table>";
        
        $tabCtrl[$i] = new Html($str);
        $tabCtrl[$i]->label = $oCtrl2->label;                 
        
      }  
      elseif( $strType == 'text_join' ) {
        $tabListe1 = $strField[0];
        $tabListe2 = $strField[1];
        $bVisible  = (array_key_exists(5, $tabDesc) ? $tabDesc[5] : true);
        if (!$bVisible) continue;
        $tabDesc = $strParam4;
        
        $strFieldList = "new Array(";
        $strFieldHidden = "";
        $strCtrl1 = "";
        foreach ($tabListe1 as $iListe=>$tabListe){
          $strField1 = $tabListe[0];
          $strFieldList .= ($iListe>0 ? "," : "")."'".$strField1."'";
          $strValue1 = ( count($tabListe)>1 ? $tabListe[1] : "");
          if ($strValue1=="this")
            $strValue1 = $id;
          $strTypeField = ( count($tabListe)>2 ? $tabListe[2] : "text");
          $strLabelField = ( count($tabListe)>3 ? $tabListe[3] : "");
          $iMaxLgField = ( count($tabListe)>4 ? $tabListe[4] : 1);
          $oHide = new HtmlHidden("DEFAULT_".$strField1, $strValue1);
          switch ($strTypeField){
            case "text" :
              $oCtrl1 = new HtmlText($iModeCtrl, $strField1, $strValue1, $strLabelField, 1, min(25, $iMaxLgField), $iMaxLgField);
            break;
            case "hidden" :
              $strFieldHidden .= ($strFieldHidden!="" ? "," : "")."'".$strField1."'";
              $oCtrl1 = new HtmlHidden( $strField1, $strValue1);
            break;
            default :
              $oCtrl1 = new HtmlText($iModeCtrl, $strField1, $strValue1, $strLabelField, 1, min(30, $iMaxLgField), $iMaxLgField);
            break;
          }
          $strCtrl1 .= $oHide->GetHtml();
          if ($strTypeField!="hidden")
            $strCtrl1 .= "<span class='formLabel'>".$oCtrl1->label."</span>&nbsp;".$oCtrl1->GetHtml()."&nbsp;";
          else
            $strCtrl1 .= $oCtrl1->GetHtml();
        }
        $oCtrl1 = new Html($strCtrl1);
        $strFieldList .= ")";
        
        $strField2 = $tabListe2[0];
        $strSql2 = $tabListe2[1];
        $strValue2 = ( count($tabListe2)>2 ? $tabListe2[2] : "-1");
        $default2 = ( count($tabListe2)>3 ? $tabListe2[3] : array("null", ""));
        $oCtrl2 = new HtmlSelect($iModeCtrl, $strField2, $strValue2, $strLib, 5, $iMaxLg);
        $oCtrl2->oValTxt = $this->oQuery->getDs_JoinIn($tabDesc, $id);
        $oCtrl2->tabValTxtLast = $default2;
        $oCtrl2->bMultiple = true;
        $oCtrl2->addValidator("formDico", "multiselect", $bReq);

        $oAdd = new HtmlLink("javascript:FlipMultiLists(".$strFieldList.", '$strField2', 1, new Array(".$strFieldHidden."))", "Ajouter à la sélection", "tabp_fleche_bas.gif", "tabp_fleche_bas_rol.gif");
        $oSuppr = new HtmlLink("javascript:Clear(".$strFieldList.")", "Effacer les champs de saisie", "tabp_gomme.gif", "tabp_gomme_rol.gif");
        $oDel = new HtmlLink("javascript:FlipMultiLists(".$strFieldList.", '$strField2', 0, new Array(".$strFieldHidden."))", "Retirer de la sélection", "tabp_fleche_haut.gif", "tabp_fleche_haut_rol.gif");
        
        $str = "";
        $str .= "<table border=0 cellspacing=0 cellpadding=0 align=left>";
        $str .= "<tr>" .
                  "<td>".$oCtrl1->GetHtml()."</td>" .
                  "<td width=5></td>" .
                  "<td>".$oAdd->GetHtml()."&nbsp;".$oSuppr->GetHtml()."</td>" .
                "</tr>";
        $str .= "<tr height=4><td></td></tr>";
        $str .= "<tr>" .
                  "<td>".$oCtrl2->GetHtml()."</td>" .
                  "<td width=5></td>" .
                  "<td valign=top>".$oDel->GetHtml()."</td>" .
                "</tr>";
        $str .= "</table>";
        
        $tabCtrl[$i] = new Html($str);
        $tabCtrl[$i]->label = $oCtrl2->label;                 
      } */
      elseif( $strType == 'combo_num' || $strType == 'combo_text') {
        $strSql = $strParam4;
        $tabValTxtDefault = ( is_array($strParam5) ? $strParam5 : array());
        $tabCtrl[$i] = AlkHtmlFactory::getNewHtmlSelect($this->oFormDico, $iModeCtrl, $strField, $strValue, $strLib, 1, ( is_numeric($iMaxLg) ? min($iMaxLg, $iWidthSelect) : ""));
        
        if( is_array($strSql) ) {
          $tabCtrl[$i]->setProperty("tabValTxt", $strSql);
        } else {
          $tabCtrl[$i]->setProperty("oValTxt", $this->oAppli->oQuery->getDs($strSql));
        }
        if( is_array($tabValTxtDefault) && !empty($tabValTxtDefault) ) {
          $tabCtrl[$i]->setProperty("tabValTxtDefault", $tabValTxtDefault);
        }
      }
      elseif( $strType == 'int' ) {
        $iMin = $strParam4;
        $iMax = $strParam5;
        $tabCtrl[$i] = AlkHtmlFactory::getNewHtmlText($this->oFormDico, $iModeCtrl, $strField, $strValue, $strLib, 1, $iMaxLg, $iMaxLg);
        $tabCtrl[$i]->addValidator(ALK_VERIF_INT+( $bReq ? ALK_IS_REQUIRED : 0 ), $iMin, $iMax);
      }
      elseif( $strType == 'radio' ) {
        $tabOptions = $strParam4;
        $tabCtrl[$i] = AlkHtmlFactory::getNewHtmlRadio($this->oFormDico, $iModeCtrl, $strField, $strValue, $strLib);
        
        foreach($tabOptions as $value =>$strText){
          $tabCtrl[$i]->addRadio($value, $strText);
        }
      }
      elseif( $strType == 'date10' ) {
        $tabCtrl[$i] = AlkHtmlFactory::getNewHtmlText($this->oFormDico, $iModeCtrl, $strField, $strValue, $strLib, 1, 10, 10);
        $tabCtrl[$i]->addValidator(ALK_VERIF_DATE10+( $bReq ? ALK_IS_REQUIRED : 0 ));
      }
      else  { // type text
        $iHeight = ( $iMaxLg > 255 ? $iHeightMemo : 1 );
        $iWidth = ( $iHeight > 1   ? $iWidthMemo  : ( $iMaxLg > $iWidthTxt ? $iWidthTxt : $iMaxLg ));
        $tabCtrl[$i] = AlkHtmlFactory::getNewHtmlText($this->oFormDico, $iModeCtrl, $strField, $strValue, $strLib, $iHeight, $iWidth, $iMaxLg);
        $tabCtrl[$i]->addValidator(( $iHeight > 1 ? ALK_VERIF_MEMO : ALK_VERIF_TEXT)+( $bReq ? ALK_IS_REQUIRED : 0 ), 0, $iMaxLg);
      }

      $oBlockForm->AddCtrl($tabCtrl[$i]);
      $i++;
    }

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."dico/lib/lib_dico.js");
    
    return $oBlockForm;
  }

  /**
   * Retourne un tableau 
   * 
   * @param tabPattern 
   * @param tabKeys    
   * @return array
   */
  private function getArrayKeys($tabPattern, $tabKeys)
  {
    $tmp = array();
    for ($i=0; $i<count($tabPattern); $i++){
      $key = substr($tabPattern[$i], 1, strlen($tabPattern[$i])-2);
      $tmp[$i] = trim($tabKeys[$key]);
    }
    return $tmp;     
  }
    
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return ""; 
  }  

}

?>