﻿﻿/*
Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'textarea', function( editor )
{
	return {
		title : editor.lang.textarea.title,
		minWidth : 350,
		minHeight : 250,
		onShow : function()
		{
			delete this.textarea;

			var element = this.getParentEditor().getSelection().getSelectedElement();
			if ( element && element.getName() == "textarea" )
			{
				this.textarea = element;
				this.setupContent( element );
			}
		},
		onOk : function()
		{
			var editor,
				element = this.textarea,
				isInsertMode = !element;

			if ( isInsertMode )
			{
				editor = this.getParentEditor();
				element = editor.document.createElement( 'textarea' );
			}
			this.commitContent( element );

			if ( isInsertMode )
				editor.insertElement( element );
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.textarea.title,
				title : editor.lang.textarea.title,
				elements : [
					{
						id : '_cke_saved_name',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						setup : function( element )
						{
							this.setValue(
									element.data( 'cke-saved-name' ) ||
									element.getAttribute( 'name' ) ||
									'' );
						},
						commit : function( element )
						{
							if ( this.getValue() )
								element.data( 'cke-saved-name', this.getValue() );
							else
							{
								element.data( 'cke-saved-name', false );
								element.removeAttribute( 'name' );
							}
						}
					},
					{
						type : 'hbox',
						widths:['50%','50%'],
						children:[
							{
								id : 'cols',
								type : 'text',
								label : editor.lang.textarea.cols,
								'default' : '',
								accessKey : 'C',
								style : 'width:50px',
								validate : CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed ),
								setup : function( element )
								{
									var value = element.hasAttribute( 'cols' ) && element.getAttribute( 'cols' );
									this.setValue( value || '' );
								},
								commit : function( element )
								{
									if ( this.getValue() )
										element.setAttribute( 'cols', this.getValue() );
									else
										element.removeAttribute( 'cols' );
								}
							},
							{
								id : 'rows',
								type : 'text',
								label : editor.lang.textarea.rows,
								'default' : '',
								accessKey : 'R',
								style : 'width:50px',
								validate : CKEDITOR.dialog.validate.integer( editor.lang.common.validateNumberFailed ),
								setup : function( element )
								{
									var value = element.hasAttribute( 'rows' ) && element.getAttribute( 'rows' );
									this.setValue( value || '' );
								},
								commit : function( element )
								{
									if ( this.getValue() )
										element.setAttribute( 'rows', this.getValue() );
									else
										element.removeAttribute( 'rows' );
								}
							}
						]
					},
					
					
					{
                      type : 'hbox',
                      widths : [ '50%', '50%' ],
                      children :
                      [
                          {
                              id : 'obligatoire',
                              type : 'checkbox',
                              label : editor.lang.checkboxAndRadio.required,
                              'default' : 0,
                              setup : function( element )
                              {
                                  var value = element.hasAttribute( 'obligatoire' ) && element.getAttribute( 'obligatoire' );
                                  this.setValue( value || '' );
                              },
                              commit : function( element )
                              {
                                  var value = this.getValue();
                                  if ( value )
                                      element.setAttribute( 'obligatoire', '1' );
                                  else
                                      element.removeAttribute( 'obligatoire' );
                              }
                          },
                          {
                              id : 'typejs',
                              type : 'select',
                              label : editor.lang.textfield.typeData,
                              'default' : 'text',
                              accessKey : 'M',
                              items :
                              [
                                  [ editor.lang.textfield.typeText, 'text' ],
                                  [ editor.lang.textfield.typeInt, 'int' ],
                                  [ editor.lang.textfield.typeDate, 'date10' ],
                                  [ editor.lang.textfield.typeMail, 'mail' ]
                              ],
                              setup : function( element )
                              {
                                var value = element.hasAttribute( 'typejs' ) && element.getAttribute( 'typejs' );
                                this.setValue( value || '' );
                              },
                              commit : function( element )
                              {
                                  element.setAttribute( 'typejs', this.getValue() );
                              }
                          }
                      ]
                  },
					
					
					
					{
						id : 'value',
						type : 'textarea',
						label : editor.lang.textfield.value,
						'default' : '',
						setup : function( element )
						{
							this.setValue( element.$.defaultValue );
						},
						commit : function( element )
						{
							element.$.value = element.$.defaultValue = this.getValue() ;
						}
					}

				]
			}
		]
	};
});
