<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormAnimForm
 * Classe d'affichage de la page gestion des animateurs
 */
class AlkHtmlFormAnimForm extends AlkHtmlForm
{
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'appli associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formSpace");
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

  /**
   * Déclaration et récupération des données du formulaire
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);

    $cont_id = $this->oAppli->cont_id;
    
    // enregistrement des modifications
    $this->oAppli->addUserToSpace("", $cont_id, ALK_PRIV_SPACE_ANIM);

    $strToken = $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_ANIMATEUR, ALK_SHEET_NONE);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {    
    $this->setData(ALK_INIT_MODE_DATAROW);

    // création des controles
    $iWidthTxt      = 40;
    $iWidthTxtRight = 35;
    $iWidthMemo     = 38;
    $iHeightMemo    = 4;

    $iWidthLabelLeft  = 150;
    $iWidthCtrlLeft   = 470;

    $cont_id   = $this->oAppli->cont_id;
    $cont_reserve = new AlkFormData($this, "cont_reserve", $this->oAppli->getAppliProperty("CONT_RESERVE"));
    $acont_reserve = new AlkFormData($this, "acont_reserve", $this->oAppli->getAppliProperty("CONT_RESERVE"));

    // gestion de l'accès réservé
    $oCtrlH = AlkHtmlFactory::getHtmlHidden($acont_reserve);
    if( ALK_B_SPACE_REMOVE_PRIV_ADMINALL == true &&
        ((AlkFactory::isSpaceAnimAll() && $cont_reserve->value==0) || 
         (AlkFactory::isSpaceAnim() && $cont_reserve->value==1)) ) {
      $oCtrlCB = AlkHtmlFactory::getHtmlCheckbox($cont_reserve, "Accès réservé");
      if( $cont_reserve->value==0 ) {
        $oCtrlCB->addEvent("onchange", "onChangeContReserve('listUsersId[]')");
        $oCtrlCB->setLabelAfter(" ("._t("Cocher pour interdire l'accès aux animateurs de tous les espaces").")");
      } else {
        $oCtrlCB->setLabelAfter(" ("._t("Décocher pour rendre l'accès aux animateurs de tous les espaces").")");
      }
    } else {
      $oCtrlCB = AlkHtmlFactory::getHtmlHidden($cont_reserve);
    }
    
    $bAddAdmin = ( ALK_B_SPACE_ANIM_ADD_ANIM==true && AlkFactory::isSpaceAnim() || AlkFactory::isSpaceAnimAll() );
    
    // affiche la gestion des admins de conteneur : uniquement pour les admins principaux
    $oCtrlSelect = null;
    if( $bAddAdmin == true ) {
      $bDept = false;
      $cont_public = $this->oAppli->getAppliProperty("CONT_PUBLIC", 0);
      if( ALK_B_SPACE_ADMIN_ALL_DEPT == true ) {
        $nbDeptVisible = $this->oAppli->oQuery->getNbDeptVisible();
        $bDept = ( $nbDeptVisible > 0 ? true : false ); 
      } 
      
      require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlselect.class.php");
      $oCtrlSelect = new AlkHtmlSelect($this, 0, "listUsersId[]", "", _t("Animateurs de cet espace"), 10, "360");
      $oCtrlSelect->setProperty("bMultiple", true);
      $oCtrlSelect->setProperty("tabValTxtLast", array("", " "));
      $oCtrlSelect->setProperty("oValTxt", $this->oAppli->oQuery->getDs_listeAnimateurByEspaceForCombo($cont_id, true, !$bDept));
      $oCtrlSelect->setProperty("strFieldValue", "AGENT_ID");
      $oCtrlSelect->setProperty("strFieldText", "PRENOM_NOM_SERV");

      $strToken = EncodeRequest("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER_LIST.
                                "&dest=document.formSpace.elements['listUsersId[]']");
      $oCtrlSelect->addButtonForm("btAdd", "javascript:addAnim('".$strToken."')", _t("Ajouter"), _t("Ajouter un nouvel animateur"));
      $oCtrlSelect->addButtonForm("btDel", "javascript:delAnim()", _t("Supprimer"), _t("Supprimer l'animateur sélectionné"));
      
      $strTxt = ( $bDept
                  ? ( $cont_public == 0
                      ? _f("Cet espace est privé.%nlSeul le créateur de cet espace est ajouté automatiquement.", "<br/>")
                      : _f("Les animateurs de tous les espaces appartenant aux départements%nlliés à cet espace sont automatiquement ajoutés.", "<br/>") )
                  : _f("Les animateurs de tous les espaces sont automatiquement ajoutés.%nlIls sont caractérisés par un astérisque.", "<br/>") );
      $oCtrlSelect->setLabelAfter($strTxt);
      $oCtrlSelect->setTemplate("espace", "alkhtmlctrllistanim.tpl");
    }

    $oBlockProp =& $this->addBlock("block_1", _t("Gestion des animateurs de cet espace"), "", $iWidthLabelLeft, $iWidthCtrlLeft, true);
    $oBlockProp->addCtrl($oCtrlCB);
    $oBlockProp->addCtrl($oCtrlH);
    $oBlockProp->addCtrl($oCtrlSelect);

    $strToken = $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_ANIMATEUR, ALK_SHEET_NONE);
    $oButton = $this->addButtonPage("bt_1", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider la liste des animateurs"));
    $this->addSubmitButton($oButton);
    if( $this->iTypeSheet == ALK_TYPESHEET_POPUP ) {
      $this->addButtonPage("bt_2", "javascript:closeWindow()", _t("Annuler"), _t("Annuler les modifications"));
    } else {
      $this->addButtonPage("bt_2", "javascript:Annuler('".$strToken."')", _t("Annuler"), _t("Annuler les modifications"));
    }
    
    /** ajout des javascripts */
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformanimform.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
  }
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_03_agent_admin_list.htm"); 
  }
}
?>