<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormAppliForm
 * Classe d'affichage de la page gestion des domainess blocs de controle d'un formulaire
 */
class AlkHtmlFormAppliForm extends AlkHtmlForm
{
  protected $appli_intitule;
  protected $atype_id;
  protected $appli_defaut;
  protected $appli_rang;
  protected $appli_date_crea;
  protected $appli_date_maj;
  protected $agent_nomcrea;
  protected $agent_nommaj;
  
  /** true si l'appli peut être par défaut, faux sinon */
  protected $bAppliDefault;

  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formAppli");

    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strAction = "";
    $this->bAppliDefault = true;

    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {
    $appli_id = AlkRequest::getToken("idAppli", -1);

    $this->appli_intitule      = new AlkFormData($this, "appli_intitule", "", ALK_SQL_TEXT);
    $this->atype_id            = new AlkFormData($this, "atype_id", -1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->appli_defaut        = new AlkFormData($this, "appli_defaut", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->appli_rang          = new AlkFormData($this, "appli_rang", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cont_date_crea      = new AlkFormData($this, "appli_date_crea", "");
    $this->cont_date_maj       = new AlkFormData($this, "appli_date_maj", "");
    $this->agent_nomcrea       = new AlkFormData($this, "agent_nomcrea", "");
    $this->agent_nommaj        = new AlkFormData($this, "agent_nommaj", "");
    
    $oDrData = null;
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
    	$oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $oDsData = $oQuery->GetDs_ficheAppliById($appli_id, true);
      if( !($oDrData = $oDsData->GetRowIter()) )
        $oDrData = null;
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    
    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
    if( !is_null($oDrData) ) {
      $this->bAppliDefault = ( $oDrData->getValueName("CAN_DEFAULT") == "1" );
    }  
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
  	$this->setData(ALK_INIT_MODE_REQUEST);
  
    $iMode = AlkRequest::getToken("iMode", -1);
    $page = AlkRequest::getToken("page", 1);
    $appli_id = AlkRequest::getToken("idAppli", -1);

    switch( $iMode ) {
    case ALK_FORM_MODE_ADD:
      $tabFields = $this->getTabQuery(array(), array("APPLI_DATE_CREA", "APPLI_DATE_MAJ", "AGENT_NOMCREA", "AGENT_NOMMAJ"));
      $this->oAppli->addAppli($tabFields);
      break;

    case ALK_FORM_MODE_UPDATE:
      $tabFields = $this->getTabQuery(array(), array("APPLI_DATE_CREA", "APPLI_DATE_MAJ", "AGENT_NOMCREA", "AGENT_NOMMAJ"));
      $tabFields["pk"]["APPLI_ID"] = array(ALK_SQL_NUMBER, $appli_id);
      $this->oAppli->updateAppli($appli_id, $tabFields);
      break;
    }
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_LIST, "&page=".$page);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformappliform.js");

    if( $this->iMode == "4" ) {
      $this->setContentsImport();
      return; 
    }
    
  	$this->setData(ALK_INIT_MODE_DATAROW);

    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    $page = AlkRequest::getToken("page", 1);
    $idAppli = AlkRequest::getToken("idAppli", -1);

    $iWidthTxt = 30;
    $iWidthLabelLeft = 130;
    $iWidthCtrlLeft  = 250;
    $iWidthLabelRight = 100;
    $iWidthCtrlRight = 280;


    $this->setLabel( $this->iMode == ALK_FORM_MODE_ADD
                     ? _t("Ajout d'une application &agrave; cet espace")."</div>"
                     : _t("Modification des propri&eacute;t&eacute;s de l'application")."</div>" );

    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->appli_intitule, _t("Intitulé"), 1, $iWidthTxt, 32);
    $oCtrlTxt->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT); 
 
    $oCtrlSelect = AlkHtmlFactory::getHtmlSelect($this->atype_id, _t("Type d'application"), 1);
    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
    	$oCtrlSelect->setMode(1);
      $oCtrlSelect->setWriteHiddenOnReadOnly(true);
    }    
    $oCtrlSelect->tabValTxtDefaut = array("-1", " ");
    $oCtrlSelect->setProperty("oValTxt", $this->oAppli->oQuery->GetDs_listeTypeAppliByListId("", "", $user_priv, true));
    $oCtrlSelect->AddEvent("onchange", "AffNomAppli()");
    
    $oCtrlRang = AlkHtmlFactory::getHtmlText($this->appli_rang, _t("Ordre d'affichage"), 1, 5, 3);
    $oCtrlRang->addValidator(ALK_VERIF_INT, 0, 999, "", "", false);
    
    $oCtrlCB = AlkHtmlFactory::getHtmlCheckbox($this->appli_defaut, _t("Application par défaut"), 1, 0);
    $oCtrlCB->setLabelAfter(" ("._t("pour cet espace").")");
    if( !$this->bAppliDefault ) {
      $oCtrlCB->setHidden(true);
    }
    
    $oCtrlDate = null;
    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      $strHtml = ( $this->cont_date_crea->value != ""
                   ? _t("Créé le ").$this->cont_date_crea->value." "._t("par")." ".$this->agent_nomcrea->value."<br/>".
                     ( $this->cont_date_maj->value != ""
                       ? _t("Modifié le")." ".$this->cont_date_maj->value." "._t("par")." ".$this->agent_nommaj->value
                       : "" )
                   : "" );
      $oCtrlDate = AlkHtmlFactory::getHtml($strHtml);
    }

    /** ajout de blocs et association des controles */
    $oBlockProp =& $this->addBlock("block_1", _t("Propriétés de l'application").($this->iMode == ALK_FORM_MODE_UPDATE ? " (id=".$idAppli.")" : ""), "", $iWidthLabelLeft, $iWidthCtrlLeft, true);
    $oBlockProp->addCtrl($oCtrlTxt);
    $oBlockProp->addCtrl($oCtrlSelect);
    $oBlockProp->addCtrl($oCtrlRang);
    $oBlockProp->addCtrl($oCtrlCB);

    if( $this->iMode==ALK_FORM_MODE_UPDATE && $oCtrlDate != null ) {
      $oBlockDate =& $this->addBlock("block_2", _t("Méta-information"), "", $iWidthLabelLeft, $iWidthCtrlLeft, false);
      $oBlockDate->addCtrl($oCtrlDate, ALK_HTMLFORM_1L1C);
    }

    $oBlockRight = $this->getRightPanel();
    $oBlockRight->enableBlock(_t("Gestion des droits"), "", $iWidthLabelRight, $iWidthCtrlRight, false);
    $this->addPanel($oBlockRight);

    $oBlockUsers = self::getUsersPanel();
    $oBlockUsers->enableBlock(_f("%ss ayant le profil sélectionné", ALK_S_AGENT2), "", $iWidthLabelRight, $iWidthCtrlRight, false);
    $oBlockUsers->setProperty("cssStyle", "overflow:auto; height:150px; witdh:380px; border:1px solid;");
    $this->addPanel($oBlockUsers);
    
    /** Ajout des boutons */
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_FORM, 
                                        "&idAppli=".$idAppli."&iMode=".$this->iMode."&page=".$page);
    $oButton = $this->addButtonPage("bt_1", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider les modifications"));
    $this->addSubmitButton($oButton);

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_LIST, "&page=".$page);
    $this->addButtonPage("bt_2", ALK_ALKANET."?token=".$strToken, _t("Annuler"), _t("Annuler les modifications"));
        
    
    $this->setTemplate("espace", "alkhtmlformappliform.tpl");  
  }

  /**
   * Retourne le block liste des groupes avec la gestion de droits
   * @return AlkHtmlList
   */
  private function getRightPanel()
  {
    // liste des groupe de cet espace
    $cont_id   = $this->oAppli->cont_id;
    $appli_id  = AlkRequest::getToken("idAppli", "-1");
    $dsProfil = $this->oAppli->oQuery->getDsProfilListByAppli($appli_id, $cont_id);

    // nombre de profil
    $nbElt = $dsProfil->getCountTotDr()+1;

    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, 1, $nbElt, false, "",
                                            _t("Aucun profil n'a été défini dans l'annuaire."), false, "tabRight");
    $oTabPage->SetColumns(array("left",   "160"),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false));
    
    $oTabPage->setProperty("strTableAlign", "center");
    $oTabPage->AddTitleRow(_t("Profil"), _t("Aucun"), _t("Consult."), _t("Admin."), _t("Publi."));

    $strToken = "";

    // selectionne la liste des profils
    $cpt = 0;
    while( $drProfil = $dsProfil->getRowIter() ) {
      $profil_id = $drProfil->getValueName("PROFIL_ID");
      $strProfil = mb_ereg_replace("_", " ", $drProfil->getValueName("PROFIL_INTITULE"));
      $droit_id  = $drProfil->GetValueName("DROIT_ID");
      $idCont    = $drProfil->GetValueName("CONT_ID");

      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_USERS_LIST, "&profil_id=".$profil_id);
      $strProfil = '<a title="'._t("Afficher les utilisateurs concernés par les droits du profil")." ".$strProfil.
                   ' "onclick="javascript:showUsers(\''.$strToken.'\')">'.$strProfil.( $idCont==0 ? "*"  : "" ).'</a>';

      $check0 = "-0'";
      $check1 = "-1'";
      $check2 = "-2'";
      $check4 = "-4'";
      switch( $droit_id )	{
      case ALK_APPLI_RIGHT_NONE:	$check0 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_READ:	$check1 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_ADMIN:	$check2 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_PUBLI:	$check4 .= " checked='checked'"; break;
      }

      $strBR0 = "<input type='radio' name='listRight[".$cpt."]' value='".$profil_id.$check0."/>";
      $strBR1 = "<input type='radio' name='listRight[".$cpt."]' value='".$profil_id.$check1."/>";
      $strBR2 = "<input type='radio' name='listRight[".$cpt."]' value='".$profil_id.$check2."/>";
      $strBR4 = "<input type='radio' name='listRight[".$cpt."]' value='".$profil_id.$check4."/>";

      $oTabPage->AddRow($strProfil, $strBR0, $strBR1, $strBR2, $strBR4);
      $cpt++;
    }
    return $oTabPage;
  }
  
  /**
   * Retourne un block 
   * @
   */
  public static function getUsersPanel()
  {
    // liste des profils pour cet espace
    $cont_id   = AlkRequest::getToken("cont_id", "-1");
    $profil_id = AlkRequest::getToken("profil_id", "-1");
    $iDel      = AlkRequest::getToken("idel", "0");

    $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $dsUser = $oQuery->getDsUserListByProfilCont($cont_id, $profil_id);
    
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $strProfil = $oQueryAnnu->GetStr_profilIntitule($profil_id);

    // nombre de groupe
    $nbElt = $dsUser->getCountTotDr();
    $strTitle = $strProfil." : ".
      ( $nbElt == 0 
        ? _f("Aucun %s", ALK_S_AGENT)
        : ($nbElt == 1 
          ? _f("%s %s",  $nbElt, ALK_S_AGENT)
          : _f("%s %s",  $nbElt, ALK_S_AGENTS)
          )
       );
    $oTabPage = AlkHtmlFactory::getHtmlList(null, $nbElt, 1, $nbElt, false, "",
                                            _t("Cliquez sur un profil ci-dessus")."<br/>".
                                            _f("pour afficher la liste des %s concernés.", ALK_S_AGENTS), false, "tabUsers");
    if( $iDel == "0" ) {
      $oTabPage->SetColumns(array("left",   "250"),
                            array("center", "100"));
      $oTabPage->AddTitleRow($strTitle, _t("Service"));
    } else {
      $oTabPage->SetColumns(array("left",   "250"),
                            array("center", "100"),
                            array("center", "120"));

      // les méthodes SelectAllCB() et SupprAll sont à implémenter sur la page qui demande ce bloc

      $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN.
                                             "&iSheet=".ALK_SHEET_APPLICATION."&iSSheet=".ALK_SHEET_USERS_LIST.
                                             "&profil_id=".$profil_id."&idel=1&idelact=1");
      $oBtDel  = AlkHtmlFactory::getHtmlButtonForm("javascript:SupprAll('".$strToken."');", _t("Dissocier"), 
                                                   _f("Dissocier les %s sélectionnés de ce profil", ALK_S_AGENTS));
    
      $oCtrlCB = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "iCheckAll", 0, "");
      $oCtrlCB->addEvent("onclick", "SelectAllCB()");
      
      $oTabPage->AddTitleRow($strTitle, _t("Service"), "<table><tr><td>".$oCtrlCB->getHtml()."</td><td>".$oBtDel->getHtml()."</td></tr></table>");
    }
    $oTabPage->setProperty("strTableAlign", "center");
    // selectionne la liste des profils
    while( $drUser = $dsUser->getRowIter() ) {
      $iUserId      = $drUser->getValueName("USER_ID");
      $strUserName  = $drUser->getValueName("USER_NAME");
      $iServId      = $drUser->GetValueName("SERVICE_ID");
      $strServSigle = $drUser->GetValueName("SERVICE_SIGLE");

      $strUserName = '<a title="'._t("Afficher les informations de l'agent").' '.$strUserName.
        ' "onclick="javascript:OpenPopupFiche(\'agent\', '.$iUserId.')">'.$strUserName.'</a>';
      $strServSigle = '<a title="'._t("Afficher les informations du service").' '.$strServSigle.
        ' "onclick="javascript:OpenPopupFiche(\'service\', '.$iServId.')">'.$strServSigle.'</a>';

      if(  $iDel == "0" ) {
        $oTabPage->AddRow($strUserName, $strServSigle);
      } else {
        $oCBUser = new AlkHtmlCheckbox(null, 0, "listUserId[]", -1, "", $iUserId, -1);
        $oCBUser = $oCBUser->getHtml();
        $oTabPage->AddRow($strUserName, $strServSigle, $oCBUser);
      }
    }

    return $oTabPage;
  }
  
  /**
   * Construit le formulaire d'import d'application 
   */
  private function setContentsImport()
  {
    $page      = AlkRequest::getToken("page", 1);
    $idAppli   = AlkRequest::getToken("idAppli", -1);
    $user_id   = AlkFactory::getSProperty("user_id", "-1");
    $user_name = AlkFactory::getSProperty("user_name", "-1");
    
    $iWidthLabel = 210;
    $iWidthCtrl  = 330;
    $iTxtWidth = 28;
    $this->iMode = 2;
       
    $user_id = AlkFactory::getSProperty("user_id", "-1");
      
    $importfile = AlkRequest::_POST("importfile", "");
    $agent_id   = AlkRequest::_POST("agent_id", "-1");

    if( $importfile != "" && $agent_id != "-1" ) {
      // traitement 

      $oBlockProp = $this->addBlock("block_1", _t("Exécution de l'import"), "", 1, $iWidthLabel+$iWidthCtrl-1, true);
      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_LIST, "&page=".$page);
      
      $strHtmlRes = nl2br($this->oAppli->import($agent_id, $importfile)).
        '<br/><div align="center"><a title='._t("Afficher la liste des applications de cet espace").
        '" href="'.ALK_ALKANET.'?token='.$strToken.'">'._t("Afficher la liste des applications de cet espace").'</a></div>';
      $oCtrlHtml = AlkHtmlFactory::getHtml($strHtmlRes);
      $oBlockProp->addCtrl($oCtrlHtml);
            
      return;
    }
    
    // affichage
    $strPathFtp = ALK_ROOT_PATH.ALK_UPLOAD_FTP_PATH;
    $tabPrefix = array("alkxmlimp_");
    $tabFiles = getTabFilesByDir($strPathFtp, array("xml"), false, $tabPrefix);

    if( !empty($tabFiles) ) {
      
      $strDesc = '<p>'._t("Vous devez déposer dans le répertoire ftp, deux fichiers ayant le même nom (sans accent, ni espace)").','.
                 _t("l'un avec l'extension .xml et l'autre avec l'extension .zip et préfixés par").
                 '<b>alkxmlimp_</b>.</p>'.
                 '<p>'._t("Exemple").' : alkxmlimp_mesactus.xml '._t("et").' alkxmlimp_mesactus.zip</p>'. 
                 '<p>'._t("Le fichier xml contient les informations à importer dans la base de données et doit respecter").
                 '<a target="_blank" href="'.ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE.'espace/alk_import.dtd">'._t("la DTD suivante").'</a>.</p>'.
                 '<p>'._t("Le fichier xml peut faire référence à des noms de fichiers. Ces fichiers sont à inclure dans le fichier zip.").
                 _t("La présence du fichier zip est facultative").'.</p>'; 

      $oBlockProp = $this->addBlock("block_1", _t("Ajouter des applications dans l'espace par import"), $strDesc, $iWidthLabel, $iWidthCtrl, true);
      
      $oDataFormFile      = new AlkFormData($this, "importfile", "", ALK_SQL_NONE);
      $oDataFormAgentName = new AlkFormData($this, "agent_name", $user_name, ALK_SQL_NONE);
      $oDataFormAgentId   = new AlkFormData($this, "agent_id", $user_id, ALK_SQL_NONE);
      
      $oCtrlSelect = AlkHtmlFactory::getHtmlSelect($oDataFormFile, _t("Fichier à importer"), 1);
      $oCtrlSelect->tabValTxtDefaut = array("-1", _t("Sélectionner un ficher d'import"));
      $oCtrlSelect->setProperty("tabValTxt", $tabFiles);
      $oBlockProp->addCtrl($oCtrlSelect);
      
      $oCtrlH = AlkHtmlFactory::getHtmlHidden($oDataFormAgentId);
      $oBlockProp->addCtrl($oCtrlH);

      $oCtrlUser = AlkHtmlFactory::getHtmlText($oDataFormAgentName, _t("Propriétaire des informations ajoutées"), 1, $iTxtWidth, 255);
      $oCtrlUser->setReadOnly(true);
      $strToken = EncodeRequest("cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER_LIST.
                                "&dest=&destId=document.".$this->name.".elements['agent_id']&destTxt=document.".$this->name.".elements['agent_name']");
      $oCtrlUser->addButtonForm("btAdd", "javascript:changeUser('".$strToken."')", _t("Sélectionner"), 
                                _t("Sélectionner le propriétaire des informations à ajouter"), true);
      $oBlockProp->addCtrl($oCtrlUser);

      /** Ajout des boutons */
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_FORM, 
                                          "&idAppli=".$idAppli."&iMode=4&page=".$page);
      $oButton = $this->addButtonPage("bt_1", "javascript:ValiderImport('".$strToken."')", _t("Valider"), _t("Valider les modifications"));
      $this->addSubmitButton($oButton);
      
  
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_LIST, "&page=".$page);
      $this->addButtonPage("bt_2", ALK_ALKANET."?token=".$strToken, _t("Annuler"), _t("Annuler les modifications"));

    } else {
      $oBlockProp = $this->addBlock("block_1", _t("Ajouter des applications dans l'espace par import"), "", 1, $iWidthLabel+$iWidthCtrl, true);
      
      $strDesc = _t("Pas de fichier d'import disponible").'.<br/><br/>'.
        '<p>'._t("Vous devez déposer dans le répertoire ftp, deux fichiers ayant le même nom (sans accent, ni espace),").
        ' '._t("l'un avec l'extension .xml et l'autre avec l'extension .zip et préfixés par").'<b>alkxmlimp_</b>.</p>'.
        '<p>'._t("Exemple").' : alkxmlimp_mesactus.xml '._t("et").' alkxmlimp_mesactus.zip</p>'. 
        '<p>'._t("Le fichier xml contient les informations à importer dans la base de données et doit respecter").
        ' <a target="_blank" href="'.ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE.'espace/alk_import.dtd">'._t("la DTD suivante").'</a>.</p>'.
        '<p>'._t("Le fichier xml peut faire référence à des noms de fichiers. Ces fichiers sont à inclure dans le fichier zip.").
        ' '._t("La présence du fichier zip est facultative.").'</p>'; 
      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_LIST, "&page=".$page);
      $strDesc .= '<br/><p align="center">' .
                  '<a href="'.ALK_ALKANET.'?token='.$strToken.'">'._t("Afficher la liste des applications de cet espace").'</a></p>'; 
      
      $oCtrlHtml = AlkHtmlFactory::getHtml($strDesc);
       
      $oBlockProp->addCtrl($oCtrlHtml);
    }
    
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_07_appli_form.htm"); 
  }
}
?>