<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupUserRight
 * Classe de gestion de droit par utilisateur sur les applis d'un espace
 */
class AlkHtmlVerifLink extends AlkHtmlForm 
{
  
  /**
   * Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formVerifLink");
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->setProperties($iModeForm, ALK_FORM_METHOD_GET, "");
  }

   /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  
  public function doSql(){
    $this->setData(ALK_INIT_MODE_REQUEST);
  }
  
    /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    $iModeAjax = AlkRequest::_REQUEST("iModeAjax", 0);
    $tabModule = array(ALK_ATYPE_ID_GEDIT => "Gestion Editoriale", 
     ALK_ATYPE_ID_IEDIT => "Informations Editoriales",
     ALK_ATYPE_ID_FDOC  => "Fonds Documentaire", 
     ALK_ATYPE_ID_COMMENT=> "Commentaires",
     ALK_ATYPE_ID_FORM => "Formulaire",
     ALK_ATYPE_ID_FORUM => "Forum",
     ALK_ATYPE_ID_GEOLOC => "Géolocalisation");
    
    // traitement ajax
    if($iModeAjax ==1){
       $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
       $atype_id = AlkRequest::_REQUEST("atype_id", -1);
       switch($iModeForm){
         case 2: 
           $tabLink = $this->oAppli->verifLinks($atype_id);
           $oHtmlList = $this->construireUneListe($tabLink, $tabModule[$atype_id], $atype_id);
           echo "<br/><br/>".$oHtmlList;exit;
       }
         break;
    }
    
    // onload
    $dsAppliType = $this->oAppli->oQuery->getDs_listeTypeAppliByListId("", "", "1", true);
    while( $drAppliType = $dsAppliType->getRowIter() ) {
       $atype_id = $drAppliType->getValueName("ATYPE_ID");
       if ($atype_id==ALK_ATYPE_ID_CEDIT || $atype_id==ALK_ATYPE_ID_GEOLOC || $atype_id== ALK_ATYPE_ID_PRODIGEDIST || $atype_id==ALK_ATYPE_ID_COLLAB  
            || $atype_id==ALK_ATYPE_ID_LSDIF || $atype_id==ALK_ATYPE_ID_GRAPHE || $atype_id==ALK_ATYPE_ID_NEWSLETTER)
         continue;
       $tabAtypeID[] = $atype_id;
    }
    $strChaine = implode(",", $tabAtypeID);           
    $this->setLabelDesc(_t("Cette page permet de vérifier les liens contenus dans toutes les applications"));
    $oBlock = $this->addBlock("blockModules", "", "", 120, 200, true, $this);
    $oHtml = AlkHtmlFactory::getHtml("<div id='tblist'>&nbsp;</div>");
    $oBlock->addCtrl($oHtml, ALK_HTMLFORM_1L1C);
    
    // Bouton de  vérification de liens
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=2");
    $this->addButtonPage("apercu", "javascript:go('".$this->getName()."', '".$strToken."','".$strChaine."')", _t("Démarrer"), _t("Démarrer le vérificateur de liens"));
    
    $this->addScriptJs(AlkFactory::getModuleUrl($this->oAppli->atype_id)."lib/alkhtmlveriflink.js");

  }
  
  /**
   * retourne la liste de liens cassés par application
   * @param $tabLink tableau résultat contenant les liens cassés
   * @param strModule nom de l'application ou module
   * @param $atype_id
   * @return le contenu html d'une liste
   */
  protected function construireUneListe($tabLink, $strModule, $atype_id){
      
    // création de liste qui correspond
    $oList = AlkHtmlFactory::getHtmlList($this, count($tabLink),1, count($tabLink), false,"", _t("Aucun Lien mis en cause."),
                                         false,"list_modules".$atype_id);
  
    $tabColumns = array(    
      array("center", 200),
      array("center", 100),
      array("left", 300)             
     );

    $oList->setColumnsByArray($tabColumns);
    $oList->addTitleRow(array("<div align='center'>Module : ".$strModule."</div>", 3, 1)); 
    $oList->addTitleRow(_t("Nom du module"), _t("Lien pour la correction"), _t("Description"), _t("Liens mis en cause"));
    foreach ($tabLink as $tableau){
      $tabRow[] = '<a  title="'._t("Accéder au lien pour la correction").'" href="'.ALK_ALKANET.'?token='.
                   $tableau["token"].'">Correction</a>';
      $tabRow[] = $tableau["desc"];
      
      // liste des liens cassés
      $strUrl = "<ul>";
      foreach ($tableau["url"] as $url){
        $glue ="";
        if (strlen($url)> 70)
         $glue="...";
         $strUrl.="<li title=\"".$url."\""."><a href=\"".$url."\" target=\"_blank\">".substr($url, 0, min(70, strlen($url))).$glue."</a></li>";
      }
      $tabRow[] = ($atype_id==ALK_ATYPE_ID_GEDIT ? "bloc ":"").$tableau["data_id"]."<br/>".$strUrl;
      $oList->addRowByArray($tabRow);
      $tabRow = array();
    }
    
    return $oList->getHtml();

  }

}