/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * Effectue une requete ajax en téchargeant 128ko de données pour obtenir le temps mis
 * Retourne le temps mis en seconde
 * @param strToken   token de la page test appelée
 * @return int
 */
function getTimerEnd(strToken)
{
  var d0 = new Date();
  var t0 = d0.getTime();
  // la requête ajax retourne un contenu de 128ko.
  var oAjax = new AlkAjax('nameLoadEndTimer', '', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_PROCESS+'?token='+strToken+"&iMode=4", null, false);
  var d1 = new Date();
  var t1 = d1.getTime();

  // on retire le temps de la requete ajax
  return (t1-t0)/1000;  
}

function onLoadWindPerf(strToken)
{
  var oLayer = document.getElementById("layerPerf");
  var iTime  = getTimerEnd(strToken);
  var iDebit = new Number(128/iTime);
  
  var iPerc = ( iDebit >= 120 ? 100 : Math.round(iDebit*100/120) );   
  
  oLayer.innerHTML = _gt("Temps mis :")+" "+iTime.toFixed(4)+"s<br/>"+
    _gt("Débit mesuré :")+" "+iDebit.toFixed(2)+"ko/s<br/><br/>"+
    "<div align='center'><b>"+_gt("Niveau de performance")+"</b><br/><br/>" +
    "<table border='0' cellpadding='0' cellspacing='0'><tr><td>"+
    "<table border='0' cellpadding='0' cellspacing='0' style='width:354px;'><tr>" +
    "<td style='width:"+iPerc+"%; height:4px;'></td>" +
    "<td style='width:"+(100-iPerc)+"%; height:4px; font-size:0px; text-align:left;'><img class='alkimgicon alkimgiconpointeurbas' src='../../media/images/transp.gif'></td>" +
    "</tr></table>" +
    "</td></tr><tr><td>" +
    "<table border='0' cellpadding='0' cellspacing='0' style='width:350px; height:5px; border:1px solid #000000; text-align:center; color:#000000;'><tr>"+
    "<td style='width:25%; background-color:#fb5b12;' >"+_gt("Très faible")+"</td>" +
    "<td style='width:25%; background-color:#fbda9b;'>"+_gt("Faible")+"</td>" +
    "<td style='width:25%; background-color:#efee90;'>"+_gt("Bon")+"</td>" +
    "<td style='width:25%; background-color:#b4ee06;'>"+_gt("Excellent")+"</td>" +
    "</tr></table>" +
    "</td></tr><tr><td>" +
    "<table border='0' cellpadding='0' cellspacing='0' style='width:354px;'><tr>" +
    "<td style='width:"+iPerc+"%; height:4px;'></td>" +
    "<td style='width:"+(100-iPerc)+"%; height:4px; font-size:0px; text-align:left;'><img class='alkimgicon alkimgiconpointeurhaut' src='../../media/images/transp.gif'></td>" +
    "</tr></table>" +
    "</td></tr></table>" +
    "</div><br>";
}
