<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


include_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkappli.class.php";
include_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/lib/app_conf_form.php";
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/lib/simple_html_dom.php");
/**
 * @package Alkanet_Module_Form
 * Module formulaire
 *
 * @class AlkAppliForm
 * Classe de l'application formulaire
 */
class AlkAppliForm extends AlkAppli implements AlkIntAppli, AlkIntRights, AlkIntGEdit
{
  
  /**
   * Constructeur par défaut
   * @param appli_id   Identifiant de l'application
   */
  function  __construct($appli_id)
  {
    parent::__construct(ALK_ATYPE_ID_FORM, $appli_id);
    //$this->loadConstant(ALK_ATYPE_ID_GEDIT);
    
    $this->iTypeSheet = ALK_TYPESHEET_ADMIN;
    $this->iSheet = ALK_SHEET_ENCOURS; 
    $this->iSSheet = ALK_SHEET_NONE;
  }
  
  /**
   * Destructeur par défaut
   */
  public function __destruct() { }

  /**
   * Vérifie les droits spécifiques à l'application
   *        Retourne vrai si l'utilisateur connecté possède les droits, faux sinon
   * @return booleen
   */
  public function verifSecuAppli()
  { 
    return true;
  }

  /**
   * Ajout d'une application à un espace. Retourne l'identifiant de l'appli créée
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   * @return int
   */
  public function addAppli($tabFields) { /** rien à faire */ }

  /**
   * Modification d'une application
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   */
  public function updateAppli($tabFields) { /** rien à faire */ }

  /**
   * Suppression d'une application d'un espace
   */
  public function delAppli()
  {
    $this->oQueryAction->delAppli($this->appli_id);
  }

  /**
   * Déplacement d'une application d'un espace vers un autre
   *        Cette méthode se charge d'appelé la recopie des droits
   * @param $appli_id  identifiant de l'appli
   * @param $idContTo  identifiant de l'espace recevant l'appli
   */
  public function moveAppli($idContTo) { /** rien à faire */ }

  /**
   * Duplication de la structure et du paramètrage de l'application src à la courante
   * @param appli_id_src  identifiant de l'application source
   * @param iTypeDup      type de duplication : 0 = application vierge (ne fait rien) 
   *                                            1 = structure et paramétrage
   *                                            2 = structure, paramétrage et données  
   */
  public function dupAppli($appli_id_src, $iTypeDup) 
  { 
    // on recopie les formulaires
    if( $iTypeDup==0 ) return;
    
    $this->oQueryAction->dupAppli($appli_id_src, $this->appli_id, $iTypeDup);
  }

  /**
   * Transfère de propriété d'un utilisateur à un autre
   *        Méthode à appeler avant suppression définitive d'un utilisateur
   * @param idUserFrom  identifiant de l'utilisateur perdant la propriété des ses données
   * @param idUserTo    identifiant de l'utilisateur récupérant la propriété des données
   */
  public function replaceUser($idUserFrom, $idUserTo)
  {
    $this->oAppli->oQueryAction->replaceUser($idUserFrom, $idUserTo);
  }

  /**
   * Invitation d'un utilisateur à un espace (tous si cont_id=-1, tous les espaces publics si cont_id=-2)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces. -2 tous les espaces publics
   * @param priv_id  identifiant du privilège
   */
  public function addUserToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   * Modification du privilège espace pour l'utilisateur à un espace (tous si cont_id=-1)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   * @param priv_id  identifiant du privilège
   */
  public function updateUserPrivToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   * Suppression de l'accès à un espace (ou tous si cont_id=-1) pour un utilisateur
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   */
  public function removeUserFromSpace($user_id, $cont_id) { /** rien à faire */ }

  /**
   * Personnalisation des droits d'un utilisateur
   * @note Appelé en admin. annuaire avec gestion des droits sur un profil sur l'espace courant
   * @param cont_id       identifiant de l'espace
   * @param user_id       identifiant de l'utilisateur sélectionné
   * @param iRight        non utilisé
   * @param iDefaultRight non utilisé
   */
  public function setUserRightsOnSpace($cont_id, $user_id, $iRight=-1, $iDefaultRight=-1) { /** rien à faire */ }
  
  /**
   * Enregistre les droits des profils sur les applications d'un espace
   * @param cont_id       identifiant d'utilisateur
   * @param tabRight      non utilisé dans le cas espace, 
   *                      sinon tableau de type "_".idProfil => droid_id pour les autres applis
   */
  public function setProfilRightsOnSpace($cont_id, $tabRight=array()) { /** rien à faire */ }
   
   
  /**
  * Applique les droits d'un utilisateur par rapport à ses profils
  * @param user_id  identifiant de l'utilisateur 
  */
  public function setProfilRightToUser($user_id){}
  
  
  /**
   * Application de droits sur les profils pour l'application
   * @note Appelé en config. espace avec gestion des droits sur les profils pour l'appli
   * @param atype_id  type d'application
   * @param appli_id  identifiant de l'application
   */
  public function setRightsOnAppli($atype_id, $appli_id)  { /** rien à faire */ }

  /** 
   * Ajout d'un profil sur l'extranet.
   *        Si l'application gère des droits, il faut y associer le droit NONE
   * @param profil_id  identifiant du profil à supprimer
   * @param cont_id    identifiant de l'espace associé, =0 pour tous les espaces (par défaut)
   */
  public function addProfil($profil_id, $cont_id=0) { /** rien à faire */ }
  
  /** 
   * Suppression du profil sur la gestion des droits interne à l'appli
   * @param profil_id  identifiant du profil à supprimer
   */
  public function delProfil($profil_id) { /** rien à faire */ } 

  /** interface GEDIT */

  /**
   * Méthode appelée à l'ajout d'un bloc gedit
   *        Implémenter les actions effectuant l'ajout de ce bloc sur ce type d'application
   * @param bloc_id     identifiant du bloc
   * @param typeIdBloc  type de bloc 
   * @param atypeIdBloc type de l'application associé au type de bloc
   */
  public function addGEditBloc($bloc_id, $typeIdBloc, $atypeIdBloc) { /** rien à faire */ }
  
  /**
   * Méthode appelée avant suppression définitive d'une application de type gedit
   *        ou avant suppression d'une page gedit
   *        ou avant suppression d'un bloc gedit
   *        Implémenter les actions effectuant le ménage interne à l'application
   * @param page_id     identifiant de la page
   * @param bloc_id     identifiant du bloc
   * @param typeIdBloc  type de bloc 
   * @param atypeIdBloc type de l'application associé au type de bloc
   */
  public function delGEditBloc($page_id, $bloc_id, $typeIdBloc, $atypeIdBloc)
  {
    $this->oQueryAction->delGEditBloc($bloc_id);
  }

  /**
   * Recopie les associations d'un bloc à un autre bloc
   * 
   * @param bloc_id_src  identifiant du bloc source
   * @param bloc_id_dest identifiant du bloc destination
   */
  public function dupGEditBloc($bloc_id_src, $bloc_id_dest)
  { 
    $this->oQueryAction->copyGEditBlocData($bloc_id_src, $bloc_id_dest, "FORM_01_FORM_BLOC", "FORM_ID, FORM_RANG");
  }
  
  /**
   * Retourne un tableau contenant l'information sélectionnée par cette méthode (appel régulier de getDataContents())
   * @param typeAff         type d'affichage, permet d'établir une conditionnelle dans cette méthode pour gérer plusieurs type d'affichage
   * @param cont_id         Identifiant de l'espace, pris en compte si appli_id vaut -1
   * @param appli_id        Identifiant de l'application, peut valoir =-1 pour toutes les applis de cont_id
   * @param cat_id          Identifiant de la catégorie, peut valoir =-1 pour toutes les infos de appli_id
   * @param data_id         Identifiant de la données, différent de -1 pour afficher la fiche, =-1 sinon par défaut
   * @param lg              langue utilisé, _FR par défaut
   * @param page_typeassoc  Type d'association des données à la page
   * @param page_ordre      Ordre des données dans la page
   * @param page_datedeb    Contient la date de début pour un filtre éventuel en fonction de la valeur de page_typeassoc
   * @param page_datefin    Contient la date de début pour un filtre éventuel en fonction de la valeur de page_typeassoc 
   * @return array
   */
  public function getGEditDataContents($typeAff, $cont_id, $atype_id, $appli_id, $cat_id, $data_id="-1", $lg=ALK_LG_BDD, $page_typeassoc=0, $page_ordre="", $page_datedeb="", $page_datefin="")
  {
    return array(); 
  }
  
  /**
   * Retourne dans un tableau contenant une sélection d'informations de l'application
   * 
   * @param object_id   identifiant de la donnée : 
   *                      cont_id si typeassoc3&=0, 
   *                      appli_id si typeassoc&1=1, 
   *                      cat_id si typeassoc&2=2, 
   *                      data_id si typeassoc&3=3
   * @param typeAssoc   type d'association : 0=cont, 1=appli, 2=cat, 3=data
   *                    si bit 2 on : présente les news uniquement
   *                    si bit 3 on : présente les docs publiés passés
   *                    si bit 4 on : présente les docs publiés présents
   *                    si bit 5 on : présente les docs à valider
   *                    si bit 6 on : ordre les éléments d'abord par intitulé de catégorie (non utilisé)
   *                    si bit 7 on : présente les docs syndiqués
   *                    si <=3, présente tous les docs publiés : passés, présent, à venir
   * @param user_id     identifiant de l'utilisateur pour vérifier les droits, =-1 pour non vérification
   * @param lg          langue utilisé, _FR par défaut
   * @param atypeIdBloc type de l'application liée, =-1 si non utilisé
   * @return array
   */
  public function getDataContents($object_id, $typeAssoc, $user_id, $lg=ALK_LG_BDD, $atypeIdBloc=-1)
  {
    $tabContent = array();
    $i = 0;
    $dsDoc = $this->oQuery->getDsListFormById($object_id, $typeAssoc, $user_id, $lg);
    while( $drDoc = $dsDoc->getRowIter() ) {
      $tabContent[$i]["cont_id"]     = $drDoc->getValueName("CONT_ID");
      $tabContent[$i]["appli_id"]    = $drDoc->getValueName("APPLI_ID");
      $tabContent[$i]["cat_name"]    = $drDoc->getValueName("CAT_INTITULE".$lg);
      $tabContent[$i]["data_id"]     = $drDoc->getValueName("DATA_ID");
      $tabContent[$i]["data_rank"]   = $drDoc->getValueName("DATA_RANG");
      $tabContent[$i]["data_title"]  = $drDoc->getValueName("DATA_TITRE".$lg);
      $tabContent[$i]["data_descl"]  = $drDoc->getValueName("DATA_DESCL".$lg);
      $tabContent[$i]["data_date"]   = $drDoc->getValueName("DATA_DATE_PFIN"); //date limite pour saisir l'information
      $tabContent[$i]["data_datemaj"]= $drDoc->getValueName("DATA_DATE_MAJ");  //date de dernière modif
      $tabContent[$i]["data_url"]    = "";
      $tabContent[$i]["data_img"]    = "";
      $tabContent[$i]["data_sondage"]= $drDoc->getValueName("DATA_SONDAGE");  //booléen indiquant si il s'agit d'un formulaire ou d'un sondage
      $tabContent[$i]["data_type"]   = ALK_ATYPE_ID_FORM;
      $tabContent[$i]["data_nbrep_max"] = $drDoc->getValueName("DATA_NBREP_MAX");
      $tabContent[$i]["data_btsave"]    = $drDoc->getValueName("DATA_BTSAVE");
      $tabContent[$i]["data_secure"]    = $drDoc->getValueName("DATA_SECURE");
      $tabContent[$i]["data_rep_unique"]    = $drDoc->getValueName("DATA_REP_UNIQUE");
      
      $strParamValid = "cont_id=".$tabContent[$i]["cont_id"]."&appli_id=".$tabContent[$i]["appli_id"].
        "&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_RESULTAT."&form_id=".$tabContent[$i]["data_id"]."&unique=".$tabContent[$i]["data_rep_unique"]."&secure=".$tabContent[$i]["data_secure"];
      $tabContent[$i]["data_token"] = AlkRequest::getEncodeParam($strParamValid);
      $i++;
    }
    return $tabContent;
  }

  /**
   * Retourne le contenu raccourci d'un bloc éditorial
   * pour un affichage de gestion ou d'aperçu
   * @param bloc_id        Identifiant du bloc
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param atypeIdBloc    type de l'application liée, =-1 si non utilisé
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     contient le nbre de résultats à afficher
   * @return array
   */
  public function getGEditBlocShortContents($bloc_id, $bloc_typeassoc, $atypeIdBloc=-1, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $tabContent = array();
    $i = 0;
    $dsDoc = $this->oQuery->getDsListFormByBlocId($bloc_id, $bloc_typeassoc, $user_id, true,
                                                  ALK_LG_BDD, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
    while( $drDoc = $dsDoc->getRowIter() ) {
      $tabContent[$i]["data_id"]     = $drDoc->getValueName("DATA_ID");
      $tabContent[$i]["data_rank"]   = $drDoc->getValueName("DATA_RANG");
      $tabContent[$i]["data_title"]  = $drDoc->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_TITRE"));
      $tabContent[$i]["data_desc"]   = "";
      $tabContent[$i]["data_type"]   = $drDoc->getValueName("DATA_TYPE");
      $tabContent[$i]["data_sondage"]= $drDoc->getValueName("DATA_SONDAGE");  //booléen indiquant si il s'agit d'un formulaire ou d'un sondage
      $tabContent[$i]["data_secure"]= $drDoc->getValueName("DATA_SECURE");  //booléen indiquant si il s'agit d'un formulaire ou d'un sondage
      $tabContent[$i]["data_rep_unique"]= $drDoc->getValueName("DATA_REP_UNIQUE");  //booléen indiquant si il s'agit d'un formulaire ou d'un sondage
      $i++;
    }
    return $tabContent;
  }

  /**
   * Retourne le contenu complet d'un bloc éditorial dans la langue sélectionnée
   * pour un affichage de consultation
   * @param bloc_id   Identifiant du bloc
   * @param lg        clé de la langue sélectionnée
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param atypeIdBloc    type de l'application liée, =-1 si non utilisé
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     contient le nbre de résultats à afficher
   * @return array
   */
  public function getGEditBlocContents($bloc_id, $lg, $bloc_typeassoc, $atypeIdBloc=-1, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $user_id = AlkFactory::getSProperty("user_id", "2");
    $tabContent = array();
    $i = 0;
    $dsDoc = $this->oQuery->getDsListFormByBlocId($bloc_id, $bloc_typeassoc, $user_id, false, 
                                                  $lg, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
    while( $drDoc = $dsDoc->getRowIter() ) {
      $tabContent[$i]["cont_id"]     = $drDoc->getValueName("CONT_ID");
      $tabContent[$i]["appli_id"]    = $drDoc->getValueName("APPLI_ID");
      $tabContent[$i]["cat_name"]    = $drDoc->getValueName("CAT_INTITULE".$lg);
      $tabContent[$i]["data_id"]     = $drDoc->getValueName("DATA_ID");
      $tabContent[$i]["data_rank"]   = $drDoc->getValueName("DATA_RANG");
      $tabContent[$i]["data_title"]  = $drDoc->getValueName("DATA_TITRE".$lg);
      $tabContent[$i]["data_type"]   = ALK_ATYPE_ID_FORM;
      $tabContent[$i]["data_sondage"]= $drDoc->getValueName("DATA_SONDAGE");  //booléen indiquant si il s'agit d'un formulaire ou d'un sondage
      $tabContent[$i]["data_nbrep_max"] = $drDoc->getValueName("DATA_NBREP_MAX");
      $tabContent[$i]["data_btsave"]    = $drDoc->getValueName("DATA_BTSAVE");
      $tabContent[$i]["data_secure"]    = $drDoc->getValueName("DATA_SECURE");
      $tabContent[$i]["data_rep_unique"]    = $drDoc->getValueName("DATA_REP_UNIQUE");
      
      //cas du sondage
      // si c'est un sondage pour lequel l'internaute a déja participé on renvoie le résultat du sondage
      if ($drDoc->getValueName("DATA_SONDAGE")==1 && isset($_COOKIE["sondage".$tabContent[$i]["data_id"]])) 
      {
        $tabContent[$i]["data_text"]         = $this->GetSondageResult($drDoc->getValueName("DATA_ID"));//"<p>graphique des résultats</p>"; 
        $tabContent[$i]["data_already_vote"] = 1;
      }
      else
      {
        $strHtmlForm = $drDoc->getValueName("DATA_DESCL".$lg);
        if(isset($strHtmlForm)){
          $strHtmlForm = htmlspecialchars_decode(htmlentities($drDoc->getValueName("DATA_DESCL".$lg), ENT_NOQUOTES, "UTF-8"));
          if($strHtmlForm != ''){
            $html = str_get_html($strHtmlForm);
            $html->find('span.alkFormBuilder',0)->outertext = '';
            foreach($html->find('input') as $input) {
              $input->outertext = ( preg_match("#/>$#i", $input->outertext) ? $input->outertext : preg_replace("#>$#", "/>",$input->outertext));
            }
            foreach($html->find('div.form_inputText, div.form_inputPassword, div.form_textarea, div.form_combobox, div.form_radio, div.form_checkbox') as $div) {
              $div->tag = "p";
              $div->class = '';
            }
            foreach($html->find('br') as $br) {
              $br->outertext = "<br/>";
            }
            foreach($html->find('div.form_paragraphe, div.form_checkboxGrid, div.form_radioGrid') as $div) {
              $div->outertext = $div->innertext;
            }
            $strHtmlForm = (string)$html->save();
            $strHtmlForm = htmlspecialchars_decode(htmlentities($strHtmlForm, ENT_NOQUOTES, "UTF-8"));
            $strHtmlForm .= "";
            $html->clear();
          }
        }
        $tabContent[$i]["data_text"]          = ($strHtmlForm != "" ? $strHtmlForm : $drDoc->getValueName("DATA_DESCL".$lg));
        $tabContent[$i]["data_text_original"] = $drDoc->getValueName("DATA_DESCL".$lg);
        $tabContent[$i]["data_already_vote"]  = 0;
      }
      
      // calcul du nombre de réponses du formulaire
          
      $nbReponses                            = $this->getNbReponsesFormulaires($drDoc->getValueName("DATA_ID"));
      $form_nb_rep_max                       = $drDoc->getValueName("FORM_NBREP_MAX");
      $tabContent[$i]["data_brepmax"]        = ($form_nb_rep_max > 0 ?
                                                                      ($nbReponses < $form_nb_rep_max 
                                                                                     ? "0" 
                                                                                     : "1")
                                                                     : 0);  
      $strParamValid = "cont_id=".$tabContent[$i]["cont_id"]."&appli_id=".$tabContent[$i]["appli_id"].
        "&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_RESULTAT."&form_id=".$tabContent[$i]["data_id"]."&unique=".$tabContent[$i]["data_rep_unique"]."&secure=".$tabContent[$i]["data_secure"]."&bloc_id=".$bloc_id."&lg=".$lg."&bloc_typeassoc=".$bloc_typeassoc."&atypeIdBloc=".$atypeIdBloc;
      $tabContent[$i]["data_token"] = AlkRequest::getEncodeParam($strParamValid);
      $i++;
    }
    return $tabContent;
  }

  /**
   * Retourne le type de méthode pour mettre à jour les blocs
   *        Retourne un tableau en fonction du type sélectionné.
   * @param typeIdBloc   type de bloc
   * @param atypeIdBloc  type de l'application associée au type de bloc
   * @return array
   */
  public function getGEditBlocTypeUpdate($typeIdBloc, $atypeIdBloc)
  {
    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true).$this->cont_id."/"; 
    if( !(@file_exists(ALK_ALKANET_ROOT_PATH.$strPathUpload) && @is_dir(ALK_ALKANET_ROOT_PATH.$strPathUpload)) ) {
      $bRes = @mkdir(ALK_ALKANET_ROOT_PATH.$strPathUpload, 0770);
      if( !$bRes ) {
        $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true);
      } 
    }
    
    return array("type"            => ALK_GEDIT_TYPEUPDATE_SELECTEDIT, 
                 "iColumn"         => ( defined("ALK_B_GEDIT_BLOC_COLONNE") && ALK_B_GEDIT_BLOC_COLONNE==false ? 0 : 1),
                 "newsTitle"       => "",
                 "iFilterSpace"    => 1,
                 "iAssocAppli"     => 1,
                 "iAssocAppliPage" => 2,
                 "iAssocAType"     => $this->atype_id,
                 "iAssocCat"       => 0,
                 "catTableName"    => "", 
                 "dataTableName"   => "V_GEDIT_FORM_DATA",
                 "catTitle"        => "",
                 "dataTitle"       => "formulaire",
                 "xmltag"          => "form",
                 "iFields"         => 0, // pas d'ordre puisque un seul form / bloc
                 "iFieldsPage"     => 0, // pas d'ordre puisque un seul form / page
                 "uploadDir"       => $strPathUpload);
  }
  
  /**
   * Associe une catégorie appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param cat_id      Identifiant de la catégorie
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function assocCatToBloc($bloc_id, $cat_id, $atypeIdBloc=-1, $appliIdBloc=-1) { /** rien à faire */ }
  
  /**
   * Associe un ensemble de données appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param tabDataId   Tableau contenant les identifiants des données à associer
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function assocDataToBloc($bloc_id, $tabDataId, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->assocDataToBloc($bloc_id, $tabDataId);
  }

  /**
   * Supprime une association entre une catégorie appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param cat_id      Identifiant de la catégorie, =-1 pour supprimer toutes les catégories du bloc
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function removeCatFromBloc($bloc_id, $cat_id, $atypeIdBloc=-1, $appliIdBloc=-1) { /** rien à faire */ }
  
  /**
   * Supprime une association entre une donnée appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la données à associer, =-1 pour supprimer toutes les données du bloc
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function removeDataFromBloc($bloc_id, $data_id, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->removeDataFromBloc($bloc_id, $data_id);
  }
  
  /**
   * Met à jour le rang d'une donnée dans un bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la donnée
   * @param iRank       Rang actuel de la donnée
   * @param iDelta      Entier : 1 pour descendre d'un rang, -1 pour monter d'un rang
   * @param atypeIdBloc Type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta);
  }
  
  /**
   * Retourne l'objet Panel correspondant au iSheet et iSSheet sélectionné
   * 
   * @param oAppliFrom    AlkAppli   Application appelant cette fonction (principe call services par dérivation)
   * 
   * @return AlkHtmlPanel
   */
  public function getPanel(AlkAppli $oAppliFrom=null)
  {  
    $oPanel = null;
    switch( $this->iTypeSheet ) {
    case ALK_TYPESHEET_CONSULT: // partie admin
      switch( $this->iSheet ) {
      case ALK_SHEET_LIST :       //onglet de consult : liste de formulaire
        break;
      case ALK_SHEET_FORM :       //onglet de consult : formulaire
        break;
      case ALK_SHEET_RESULTAT :   //enregistrement saisie d'un formulaire
        $tabRes  = $this->saveForm();
        $form_id = AlkRequest::getToken("form_id", "-1");
        $strUrl  = ALK_ALKANET."?token=".$this->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_ENCOURS, ALK_SHEET_LIST, 
                                           "&form_id=".$form_id."&iMode=9&etat=".ALK_FORM_ETAT_REPONSE_ATTENTE);
        echo getBodyOnLoadExec("alkAlert('".$tabRes[1]."');top.displayReponses('".$strUrl."');closeWindow();");
        break;
      }
      break;//consult
      
    case ALK_TYPESHEET_ADMIN: // partie admin
      switch( $this->iSheet ) {
        case ALK_SHEET_ENCOURS :   //onglet en cour
        case ALK_SHEET_AVENIR :    // onglet a venir
        case ALK_SHEET_PASSES :    // onglet Passes
        case ALK_SHEET_AVALIDER :  // onglet validation
        switch( $this->iSSheet ) {
          case ALK_SHEET_FORM:
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/classes/alkhtmlformform.class.php");
          $oPanel = new AlkHtmlFormForm($this);
          break;
        default:
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/classes/alkhtmlformlist.class.php");
          $oPanel = new AlkHtmlFormList($this);        
          break;
        }
        break;  
      }
      break;//admin
 	
    case ALK_TYPESHEET_POPUP: // partie popup
      switch ( $this->iSheet ){
      case ALK_SHEET_CONT_FORM :
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."editeur/classes/alkhtmlformediteurform.class.php");
        $oPanel = new AlkHtmlFormEditeurForm($this);
        break;
      case ALK_SHEET_APERCU :
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/classes/alkhtmlpopupapercuform.class.php");
        $oPanel = new AlkHtmlPopupApercuForm($this);
        break;      
      case ALK_SHEET_FORM :
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/classes/alkhtmlformbuilder.class.php");
        $oPanel = new AlkHtmlFormBuilder($this);
        break;
      case ALK_SHEET_LIST :
        // pour l'accès à l'export et à la purge à partir de la syndication
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/classes/alkhtmlformlist.class.php");
        $oPanel = new AlkHtmlFormList($this);  
        break;
      case ALK_SHEET_CONTRIB:
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/classes/alkhtmlpopupformulairereponse.class.php");
        //$this->loadConstant(ALK_ATYPE_ID_SYND);
        $oPanel = new AlkHtmlPopupFormulaireReponse($this);
      case ALK_SHEET_MAIL:// formulaire d'envoi de mail
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/classes/alkhtmlpopupformmail.class.php");
        $oPanel = new alkhtmlpopupformmail($this);
      }
      break;//Popup 
      
     case ALK_TYPESHEET_PROPRIETE:
       switch($this->iSheet){
         case ALK_SHEET_PARAMETRE:
           require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/classes/alkhtmlformparametreform.class.php");
           $oAppliEspace = AlkFactory::getAppli(ALK_ATYPE_ID_ESPACE);
           $oPanel = new AlkHtmlFormParametreForm($this, $oAppliEspace, $this->atype_id);
         break;
       }
       
       break;
    }
    
    return $oPanel; 
  }
  
  /**
   * Fonction virtuelle appelée par le constructeur permettant d'initialiser 
   * le tableau this->tabSheets
   */
  function setTabSheets() 
  { 
    
    if( $this->iTypeSheet == ALK_TYPESHEET_POPUP ) {
    	return;
    }
    
    $strUrl = ALK_ALKANET;
    $user_id = AlkFactory::getSProperty("user_id", -1);
    
    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_ENCOURS, ALK_SHEET_NONE, 
                    _t("En cours"), $strUrl, "", _t("Formulaires actuellement publiés"),
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true );

    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_AVENIR, ALK_SHEET_NONE, 
                    _t("A venir"), $strUrl, "", _t("Formulaires publiés prochainement"),
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);

    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_PASSES,  ALK_SHEET_NONE, 
                    _t("Périmées"), $strUrl, "", _t("Formulaires n'étant plus publiés"),
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);

    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_AVALIDER, ALK_SHEET_NONE, 
                    _t("Validation"), $strUrl, "", _t("Formulaires à valider"),
                    ALK_APPLI_RIGHT_PUBLI, ALK_PRIV_SPACE_USER, true );
                    
    // onglet property
    if ($user_id == ALK_USER_ID_ADMINALK)
      $this->addSheet(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_PARAMETRE, ALK_SHEET_LIST, _t("Paramètres"), $strUrl, "",
                    _t("Gérer les constantes de l'application"), 
                    ALK_APPLI_RIGHT_READ, ALK_PRIV_SPACE_ANIM+ALK_PRIV_SPACE_ADMIN);
  }

  /**
   * Enregistrement des données postées par validation d'un formulaire
   * Retourne chaine vide si ok, l'erreur rencontrée sinon
   * @return string
   */
  public function saveForm()
  {
    $user_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET);
    $form_id = AlkRequest::getToken("form_id", "-1");
     
    $strMessage  = _t("Problème de validation du formulaire");
    $strXml      = "";
    $strFileSave = $this->strPathUpload."formulaire_".$form_id.".xml";
    $bAr         = ALK_B_FORM_AR;
    $strMailAr   = "";
        
    $bOk = false;
    $bPost = false;
    $nbRep = 0;
    
    $tabInfoMail = array("titre" => "", "info" => array(), "file" => array());
    
    if( !file_exists($strFileSave) ) {
      $strXml = "<?xml version=\"1.0\" encoding=\"".ALK_HTML_ENCODING."\"?>\n".
        "<formulaire id=\"".$form_id."\">\n";
    }
    // on trouve le nombre de noeud réponses
    $nbRep = $this->getNbReponsesFormulaires($form_id);
    
    $hFile = @fopen($strFileSave, "a+");
    
    if ( !$hFile){
      return _t("Impossible de créer le fichier de sauvegarde.");
    }

    $form_mailto    = "";
    $form_intitule  = "";
    $form_sondage   = 0;
    $strFilePdf     = ""; 
    $form_msg_ar    = "";
    $dsForm = $this->oQuery->GetDs_formulaire($form_id);
    
    if( $drForm = $dsForm->getRowIter() ) {
      $form_intitule  = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
      $form_contenu   = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_CONTENU"));
      $form_mailto    = $drForm->getValueName("FORM_MAIL");
      $form_sondage   = $drForm->getValueName("FORM_SONDAGE");
      $form_envoi_pdf = $drForm->getValueName("FORM_ENVOI_PDF");
      $form_nb_rep_max= $drForm->getValueName("FORM_NBREP_MAX");
      
      $bcompare = ($form_nb_rep_max >0
                   ? true
                   : false);
       
      if ( ($nbRep <= $form_nb_rep_max && $bcompare) || (!$bcompare)){
        if(defined("ALK_B_FORM_EXPORT_PDF") && ALK_B_FORM_EXPORT_PDF==true){
          $strFilePdf = $this->saveFormPdf($form_contenu, $form_sondage);
          if(!$form_envoi_pdf)
            $strFilePdf ="";
        }
        $tabInfoMail["titre"] = $form_intitule;
        
        if( $bAr ) {        
          $bEnvoiAr       = $drForm->getValueName("FORM_ENVOI_AR");
          $bDonneesAr     = $drForm->getValueName("FORM_DONNEES_AR");
          $strMsgAr       = $drForm->getValueName("FORM_CONTENU_AR");         
          $strChampMailAr = $drForm->getValueName("FORM_CHAMPMAIL_AR");
          $form_msg_ar    = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_MSG_AR"));
          $strMailAr      = "";
        }
        
        if( $_POST ) {
          //$strMessage = "<table width=500 cellspacing=0 cellpadding=2 border=0 style=''>";
          $strXml .= "<reponse>\n".
                   "<userid>".$user_id."</userid>\n". 
                   "<daterep>".date("d/m/Y")."</daterep>\n".
                   "<etat>".ALK_FORM_ETAT_REPONSE_ATTENTE."</etat>\n";
        
         // on récupère la dernière réponse id       
         $rep_id = AlkFactory::getDbConn()->getNextId("FORM_01_FORM", "FORM_ID", "SEQ_FORM_01_REPONSE");
         $strXml.= "<reponse_id>".$rep_id."</reponse_id>\n";
             
         foreach($_POST as $strParamName => $strParamValue) {
            $valItem = "";
            if( is_array($strParamValue) ) {
              foreach ($strParamValue as $val)
                $valItem .= /*utf8_encode*/($val)."|";
              
              if( mb_substr($valItem, -1) == "|" )
                $valItem = mb_substr($valItem, 0, -1);
            } else {
              $valItem = /*utf8_encode*/($strParamValue);
            }
            
            $valItem = mb_ereg_replace("\'", "'", $valItem);
          
            if( $bAr == true && $strParamName == /*"form_".$form_id."_".*/$strChampMailAr && $bEnvoiAr==1) {
              //il s'agit du champ contenant l'adresse mail de l'expéditeur du formulaire
              //= mail du destinataire de l'AR              
              $strMailAr = $valItem;            
            }
          
            // le test sur le sondage est indispensable sinon l'affichage des résultats du sondage ne fonctionne pas
            if( $form_sondage!=1 && !(($iPos = strpos($strParamName, "_radio")) === false) ) {
              $strParamName = mb_substr($strParamName, 0, $iPos);
            }
          
            // On ne stocke pas dans les résultats les information d'un bouton submit
            if( strpos($strParamName, "_valider") === false ) {
              $strTagMail = "";
              //if (mb_substr(mb_strTolower($strParamName), 0, mb_strlen("form_".$form_id."_")) == "form_".$form_id."_") {
                $strTagMail = mb_strTolower($strParamName);//mb_substr(mb_strTolower($strParamName), mb_strlen("form_".$form_id."_"));
              //}
              $strTag = mb_strTolower($strParamName);
            
              if ($valItem != ""){
                $strXml .= "<".$strTag.">".
                  mb_ereg_replace("<", "&lt;", mb_ereg_replace(">", "&gt;", mb_ereg_replace("&", "&amp;", $valItem))).
                  "</".$strTag.">\n";
              } else {
                $strXml .= "<".$strTag."/>\n";
              }

              if( $strTagMail != "" ) {
                $tabInfoMail["info"][$strTagMail] = $valItem;//utf8_encode($valItem);
              }
              $bPost = true;
            }
          }        
          foreach($_FILES as $strParamName => $strParamValue) {
            $strDateHeure = date("dmy_His");             
            $strFileName = DoUpload($strParamName, $form_id."_pj_".$strDateHeure."_",  AlkFactory::getUploadPath($this->atype_id, true));
            $strTag = mb_strTolower($strParamName);
            
            if ($strFileName ==""){
              $strXml .= "<".$strTag."/>";
            }else {
              $tabFileName = array($strFileName);
              $strXml .= "<".$strTag.">";
              foreach($tabFileName as $key => $strFileName) {
                if( is_string($strFileName) ) { 
                  $valItem = $this->strUrlUpload.$strFileName;
                  $pathValItem = $this->strPathUpload.$strFileName;

                  //if (mb_substr(mb_strTolower($strParamName), 0, mb_strlen("form_".$form_id."_")) == "form_".$form_id."_"){
                    $strTagMail = mb_strTolower($strParamName);//mb_substr(mb_strTolower($strParamName), mb_strlen("form_".$form_id."_"));
                    $strTagMail = $strTagMail.$key;
                    $tabInfoMail["file"][$strTagMail] = array("fileName" => $strFileName, "urlfile" => $valItem, "pathFileName" => $pathValItem);      
                  //}
                  //$strTag = mb_strTolower($strParamName);
                 //$strXml .= "<".$strTag.">".
                  $strXml .="<a href=\"".$valItem."\">".
                  mb_ereg_replace("<","&lt;", mb_ereg_replace(">","&gt;", mb_ereg_replace("&", "&amp;", $valItem)))." ".
                  "</a>";                  
               }              
            }
            $strXml .= "</".$strTag.">\n";
          }
        } 
          $strXml .= "</reponse>\n";
        }
        
        $strXml = mb_convert_encoding($strXml, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
        fwrite($hFile, $strXml);
        
        $bOk = true;
      }else {
        $strMessage = _t("Le nombre maximal de réponses est atteint.");
      }
      
    }
    fclose ($hFile);
    
    if( $bOk && $bPost && $form_mailto!="" ) {
      $tabAssoc = array();
      $tabAssoc["msgTitle"] = _f("Formulaire %s", $form_intitule);
      $tabAssoc["agent_mail"]    = $form_mailto;
      $tabAssoc["agent_nom"]     = $form_mailto;
      $tabAssoc["agent_prenom"]  = "";
      $tabAssoc["form_intitule"] = $form_intitule;
      
      $this->SendMailToAgent($tabAssoc, $tabInfoMail, "FORM_SAVE_DATA", $strFilePdf); 
    }
    
	  if( $bOk && $bAr==true && $bEnvoiAr==1) {
      //Envoi de l'accusé de réception
  		$tabAssoc = array();
      $tabAssoc["msgTitle"] = _f("Accusé réception du formulaire %s", $form_intitule);
      $tabAssoc["agent_mail"]    = $form_mailto;
      $tabAssoc["agent_nom"]     = "Administrateur du formulaire";
      $tabAssoc["agent_prenom"]  = "";
      $tabAssoc["form_intitule"] = $form_intitule;
      $tabAssoc["msg"]           = $form_msg_ar;
      $this->SendMailARToAgent($tabAssoc, $tabInfoMail, "FORM_SAVE_DATA_AR", $strMailAr, $strFilePdf); 
    }
    
    $bAjax = ( AlkRequest::_GETint("ijx", "0") == "1" ? true : false );
    
    /* si il s'agit d'un sondage on retourne le résultat du sondage */
    if ($form_sondage==1){
      /* création du cookie pour bloquer la participation au sondage */
      if (!isset($_COOKIE['sondage'.$form_id])){
        setcookie("sondage".$form_id, $form_id, time()+60*60*24*30, ALK_ROOT_DIR);
      }
      $tabRes = array(true, $this->GetSondageResult($form_id));
      return ( $bAjax ? json_encode($tabRes) : $tabRes );  
    } 
    
    if ($bOk)
      $strMessage = _t("Votre saisie a bien été prise en compte.");
    $tabRes = array($bOk, $strMessage);
    
    return ( $bAjax ? json_encode($tabRes) : $tabRes );
  }
  
  /**
   * retourne le nombre de réponses d'un formulaire
   * @param form_id identifiant du formulaire
   * @return int
   */
  public function getNbReponsesFormulaires($form_id){
    $nbRep = 0;
    $strFileSave = $this->strPathUpload."formulaire_".$form_id.".xml";
    $hFile = @fopen($strFileSave, "r");
        
    if( !file_exists($strFileSave) ) {
       return $nbRep;
    }else {
      if ($hFile){
        $strXmlRep = file_get_contents($strFileSave);
        $strXmlRep .= "</formulaire>";
        $strXmlRep = str_replace(ALK_HTML_ENCODING, ALK_EXPORT_ENCODING, $strXmlRep);
        $oDom = DOMDocument::loadXML($strXmlRep);
        $oXPath = new DomXPath($oDom);
        $oNodeListReponses = $oXPath->query("/formulaire/reponse");
        $nbRep = $oNodeListReponses->length;
      }
    }
    fclose ($hFile);
    return $nbRep;
  }
  
 /**
   * Enregistrement des données postées par enregistrement d'un formulaire dans un cookie
   * @return string
   */
  public function saveFormInCookie()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $form_id = AlkRequest::getToken("form_id", "-1");
    
    $strCookie      = "";
        
    $bOk = false;
    $bPost = false;
        
    if( $_POST ) {
      foreach($_POST as $strParamName => $strParamValue) {
        $valItem = "";
        if( is_array($strParamValue) ) {
          foreach ($strParamValue as $val)
            $valItem .= /*utf8_encode*/($val)."|";
            
          if( mb_substr($valItem, -1) == "|" )
            $valItem = mb_substr($valItem, 0, -1);
        } else {
          $valItem = /*utf8_encode*/($strParamValue);
        }
          
        $valItem = mb_ereg_replace("\'", "'", $valItem);

        
        // On ne stocke pas dans les résultats les information d'un bouton submit
        if( strpos($strParamName, "_submit") === false ) {
          $strTag = $strParamName;//mb_strTolower(substr($strParamName, strlen("form_".$form_id."_")));
          
          $strCookie .= $strTag."##".mb_ereg_replace("&", "&amp;", $valItem)."\n";
        }
      }
    }
     
    //$strCookie = mb_convert_encoding($strCookie, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
    //fichier temporaire 
    $strTempFilePath = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."form/";
    $strTempFileName = session_id()."_cookie.txt";
    $handle = fopen($strTempFilePath.$strTempFileName, "w");
    fwrite($handle,$strCookie);
    fclose($handle); 
    //unlink($strTempFilePath.$strTempFileName);
    setcookie("backup_form_".$form_id, $strTempFileName, time()+60*60*24*30, '/');     
  }
  
  /**
   * Génère le formulaire complété au format pdf
   * Retourne le nom du fichier généré
   * @param $form_contenu contenu HTML du formulaire vide
   * @param $form_sondage booléen qui indique si le formulaire est de type sondage
   * @return string
   */
  private function saveFormPdf($form_contenu, $form_sondage)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."html2pdf/html2fpdf.php");
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $form_id = AlkRequest::getToken("form_id", "-1");
     
    $strHtml = "";
    $strFileSave = "formulaire_".$form_id."_".time();
        
    $bOk = false;
    
    /*$hFile = @fopen($strFileSave, "w+");
    if( !$hFile ) {
      return "Impossible de créer le fichier pdf.";
    }*/
    $strHTML = "";
    $dsForm = $this->oQuery->GetDs_formulaire($form_id);
    
    foreach($_POST as $strParamName => $strParamValue) {
      $valItem = $strParamValue;
      $valItem = mb_ereg_replace("\'", "'", $valItem);
      if( $form_sondage!=1 && !(($iPos = strpos($strParamName, "_radio")) === false) ) {
              $strParamName = mb_substr($strParamName, 0, $iPos);
      }
      if (mb_substr(($strParamName), 0, mb_strlen("form_".$form_id."_")) == "form_".$form_id."_")
        $strTag = mb_substr(($strParamName), mb_strlen("form_".$form_id."_"));
      else
        $strTag = ($strParamName);
      $formPostData[$strTag]= $valItem;  
    }
    $xml_contenu = @DOMDocument::loadHTML($form_contenu);
    $nodeTag = $xml_contenu->getElementsByTagName("input");
    
    for($i=0; $i<$nodeTag->length; $i++){
      $node = $nodeTag->item($i);
      //echo ($i." ".$node->getAttribute("name")). " ".$node->getAttribute("type"). "<br>";
      if($node->getAttribute("type") == "radio"){
        if(isset($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")))])){
          $valItem = $formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")))];  
          if($node->getAttribute("value") == mb_ereg_replace("<", "&lt;", mb_ereg_replace(">", "&gt;", mb_ereg_replace("&", "&amp;", $valItem)))){
              $node->setAttribute("checked", "");
          }
        }
      }
      if($node->getAttribute("type") == "checkbox"){
        if(isset($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")))])){
          $valItem = $formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")))];  
          if($node->getAttribute("value")!="" && $node->getAttribute("value") == mb_ereg_replace("<", "&lt;", mb_ereg_replace(">", "&gt;", mb_ereg_replace("&", "&amp;", $valItem)))){
              $node->setAttribute("checked", "");
          }
        }
      }
      if($node->getAttribute("type") == "text"){
        //echo $node->getAttribute("name")."<br>";
        if(isset($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")))])){
          $valItem = htmlentities($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")), ALK_HTML_ENCODING)], ALK_HTML_ENCODING);
          $newNode = $xml_contenu->createElement('span', $valItem);
          $node->parentNode->appendChild($newNode);
          $node->parentNode->removeChild($node);
          $i--;
        }
      }
    }
    $nodeTag = $xml_contenu->getElementsByTagName("textarea");
    for($i=0; $i<$nodeTag->length; $i++){
      $node = $nodeTag->item($i);
      //echo $strTag ." ". html_entity_decode($node->getAttribute("name"))."<br>";
      if(isset($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")))])){
        $valItem = htmlentities($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")), ALK_HTML_ENCODING)], ALK_HTML_ENCODING);
        $newNode = $xml_contenu->createElement('span', $valItem);
        $node->parentNode->appendChild($newNode);
        $node->parentNode->removeChild($node);
        $i--;
      }
    }
    $nodeTag = $xml_contenu->getElementsByTagName("select");
    for($i=0; $i<$nodeTag->length; $i++){
      $node = $nodeTag->item($i);
      //echo $strTag ." ". html_entity_decode($node->getAttribute("name"))."<br>";
      if(isset($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")))])){
        $valItem = htmlentities($formPostData[html_entity_decode(str_replace(" ", "_", $node->getAttribute("name")), ALK_HTML_ENCODING)], ALK_HTML_ENCODING);
        $newNode = $xml_contenu->createElement('span', $valItem);
        $node->parentNode->appendChild($newNode);
        $node->parentNode->removeChild($node);
        $i--;
      }
    }
    
    $strHTML = $xml_contenu->saveHTML();
    
    $strHTML = "<html>".
      "<head>".
      ( defined("ALK_EDITEUR_CSS") && ALK_EDITEUR_CSS!="" 
        ? "<link rel='stylesheet' href='".substr(ALK_ALKANET_ROOT_URL, 0, -1).ALK_EDITEUR_CSS."' type='text/css'>"
        : "" ).
      "</head>".
      "<body ".( defined("ALK_EDITEUR_BODYCSS") && ALK_EDITEUR_BODYCSS!="" ? " class='".ALK_EDITEUR_BODYCSS."'" : "" ).">".
      $strHTML.
      "</body>".
      "</html>";
    //echo $strHTML;die();
   
    $oPdf = AlkFactory::getHtml2Pdf(ALK_ROOT_PDF_URL.ALK_ROOT_DIR.ALK_ROOT_UPLOAD."cache/", ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."cache/",
                                      $strFileSave."_".$_SESSION["alk_idUser"].".htm", $strHTML, $this->strPathUpload, $strFileSave, true, true);
    $oPdf->setModeOutput("FILE");
    $oPdf->getPdf();
    
    $bOk = true;
    return $strFileSave.".pdf";
    
  }

  /**
   * Retourne le contenu XML d'une fiche documentaire
   * fonction obsolete à ne plus utiliser (appli syndication à modifier)
   * 
   * @param tabObject  tableau contenant 2 références au doc xml
   * @param idForm     identifiant du formulaire
   * 
   * @return  chaine vide, resultats places dans oRes
   */
  function GetXmlData(&$tabObject, $idForm)
  {
    $oDoc =& $tabObject[0];   
    $oNodeParent =& $tabObject[1];
    
    $strParamValid = "cont_id=".$this->cont_id."&appli_id=-3".
      "&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_RESULTAT."&form_id=".$idForm;  
    $dsForm = $this->oQuery->GetDs_formulaire($idForm); 
    if ($drForm = $dsForm->getRowIter()) {
      $nodeForm = $oDoc->createElement("form");
      $nodeToken = $oDoc->createElement("valid_token");
      $nodeToken->nodeValue = AlkRequest::getEncodeParam($strParamValid);
      $nodeForm->appendChild($nodeToken);
      $nodeField = $oDoc->createElement("id");       
      $nodeField->nodeValue = $drForm->getValueName("FORM_ID");    
             
      $nodeField = $nodeForm->appendChild($nodeField);
      
      $tabFields = $drForm->getFields();
      foreach($tabFields as $valueName){         
        $nodeField = $oDoc->createElement($valueName);
        $nodeField = $nodeForm->appendChild($nodeField);  
        $strContenu = $drForm->getValueName($valueName);
        if ( !(strpos($valueName, "contenu")===false ) && $strContenu!="") {
          $oHtmlCleaner = AlkFactory::getHtmlCleaner();
          $oHtmlCleaner->cleanWithTidy($strContenu, true, true);
          
          $nodeFrag = $oDoc->createDocumentFragment();  
          $nodeFrag->appendXML($strContenu);
          $nodeField->appendChild($nodeFrag);
        }
        else {      
          $nodeField->nodeValue = $strContenu;               
          $nodeField = $nodeForm->appendChild($nodeField);
        } 
      } 
      $nodeField = $oDoc->createElement("APPLI_ID");       
      $nodeField->nodeValue = -3;
      $nodeField = $nodeForm->appendChild($nodeField);
      
      $nodeField = $oDoc->createElement("CONT_ID");        
      $nodeField->nodeValue = $this->cont_id;
      $nodeField = $nodeForm->appendChild($nodeField);
                    
      $oNodeParent->appendChild($nodeForm);
      return $nodeForm;    
    }     
    return null;             
  }

  /**
   * Envoi un mail à un agent
   *
   * @param tabAssoc    tableau associatif contenant les données relatives à l'agent
   * @param tabInfoMail mode d'envoi de mail
   * @param strType     cle servant à identifier le type de mail à expédier
   * @param $strFileName nom du fichier à joindre au mail
   */
  public function SendMailToAgent($tabAssoc, $tabInfoMail, $strType, $strFileName ="") 
  {
    // initialisation de l'objet mail
    setMailAlkLocale(ALK_MAIL_ADMIN_LG);
    $oAlkMail = AlkFactory::getMail();
    
    $strMailFrom = (AlkFactory::getSProperty("user_mail", ALK_MAIL_ADMIN_MAIL) == "" ? ALK_MAIL_ADMIN_MAIL: AlkFactory::getSProperty("user_mail", ALK_MAIL_ADMIN_MAIL));
    $strNomFrom  = (AlkFactory::getSProperty("user_name", ALK_MAIL_ADMIN_NAME) == "Utilisateur anonyme" ? ALK_MAIL_ADMIN_MAIL: AlkFactory::getSProperty("user_mail", ALK_MAIL_ADMIN_NAME));  

    if ($strMailFrom==""){
      $strMailFrom = ALK_MAIL_ADMIN_MAIL;
    }
    
    $oAlkMail->SetFrom($strNomFrom, $strMailFrom);
        
    $strMailTo = $tabAssoc["agent_mail"];
    $strNomTo  = trim($tabAssoc["agent_prenom"]." ".$tabAssoc["agent_nom"]);
    $oAlkMail->AddTo($strNomTo, $strMailTo);
    
    if($strFileName!="")
      $oAlkMail->AddFile($this->strPathUpload.$strFileName, $strFileName);
    
    $tabAssoc["msg"] = 
      _f("Une nouvelle information vient d'être ajoutée au formulaire %s le %s à %s.", 
         $tabAssoc["form_intitule"], date("d/m/Y", AlkFactory::getLocalDate()), date("H:i", AlkFactory::getLocalDate())).
      '<br/>'.
      _t("Les informations suivantes ont été saisies :").
      '<ul>';
      
    foreach($tabInfoMail["info"] as $strField => $strValue) {
      $tabAssoc["msg"] .= '<li><b>'.trim($strField).'</b> : '.
        trim(nl2br($strValue)).'</li>';
    }
    foreach($tabInfoMail["file"] as $strField => $tabFile) {
      $tabAssoc["msg"] .= '<li><b>'.trim($strField).'</b> : ' .
        '<a href="'.$tabFile["urlfile"].'">'.$tabFile["fileName"].'</a></li>';
      $oAlkMail->addFile($tabFile["pathFileName"], $tabFile["fileName"]);
    }
    $tabAssoc["msg"] .= '</ul>';
        
    AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);
    setCurrentAlkLocale();
  }
  
  /**
   * Envoi un mail Accusé Réception à un agent
   *
   * @param tabAssoc     tableau associatif contenant les données relatives à l'agent
   * @param tabInfoMail  mode d'envoi de mail
   * @param strType      cle servant à identifier le type de mail à expédier
   * @param strMailTo    mail de la personne ayant saisie l'info et destinataire de l'AR
   * @param $strFileName nom du fichier à joindre au mail
   */
  public function SendMailARToAgent($tabAssoc, $tabInfoMail, $strType, $strMailTo, $strFileName ="") 
  {
    // initialisation de l'objet mail
    setMailAlkLocale();
    $oAlkMail = AlkFactory::getMail();
  
    $user_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET);
    if( $user_id == ALK_USER_ID_INTERNET && $strMailTo != "") {
      $strNomTo = "";
    } else {
      // récupère les infos de l'annuaire
      if( $strMailTo == "" ) {
        $strMailTo = AlkFactory::getSProperty("user_mail", "");
      }
      $strNomTo  = AlkFactory::getSProperty("user_name", "");
    }
    $oAlkMail->AddTo($strNomTo, $strMailTo);
        
    $strMailFrom = $tabAssoc["agent_mail"];
    $strNomFrom  = trim($tabAssoc["agent_prenom"]." ".$tabAssoc["agent_nom"]);
    $oAlkMail->setFrom($strNomFrom, $strMailFrom);
    
    if($strFileName!="")
      $oAlkMail->AddFile($this->strPathUpload.$strFileName, $strFileName);
    
    $tabAssoc["msg"].= 
       ($tabAssoc["msg"] == "" 
         ? ""
         : "<br/>").
      _f("Les informations suivantes ont été saisies sur le formulaire %s le %s à %s :", 
        $tabAssoc["form_intitule"], date("d/m/Y", AlkFactory::getLocalDate()), date("H:i", AlkFactory::getLocalDate())).
      '<ul>';
    foreach($tabInfoMail["info"] as $strField => $strValue) {
      $tabAssoc["msg"] .= '<li><b>'.trim($strField).'</b> : '.
        trim(nl2br($strValue)).'</li>';
        //$strValue ou mb_convert_encoding($strValue, ALK_HTML_ENCODING, ALK_EXPORT_ENCODING) ?
    }
    foreach($tabInfoMail["file"] as $strField => $tabFile) {
      $tabAssoc["msg"] .= '<li><b>'.trim($strField).'</b> : ' .
        '<a href="'.$tabFile["urlfile"].'">'.$tabFile["fileName"].'</a></li>';
      $oAlkMail->addFile($tabFile["pathFileName"], $tabFile["fileName"]);
    }
    $tabAssoc["msg"] .= '</ul>';    
     
    AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);
    setCurrentAlkLocale();
  }  
  
  /**
   * Lit le fichier xml correspondant à la réponse d'un sondage et renvoie les id des agent qui ont répondu
   * @param: $idSondage identifiant du sondage
   * @return : un tableau avec les identifiants des agent ayant rpéondu au sondage
   */
  function GetIdUserByFormId($idSondage)
  {
    $strHtml = "";
    $strXmlRep = "";
    $tabUser_id = array();
    //$strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true).$this->cont_id."/";
    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, false);
    $strFileGabarit = $strPathUpload."formulaire_".$idSondage.".xml";
    
    if ( !(file_exists($strFileGabarit) && is_file($strFileGabarit)) ) {
      return "";
    }
    
    $handle = fopen ($strFileGabarit, "r");
    $dsSondage = $this->oQuery->GetDs_formulaire($idSondage);
    if( $handle && ($drSondage = $dsSondage->getRowIter()) ) {
      $strXmlRep =  fread ($handle, filesize ($strFileGabarit));
      //$strXmlRep = file_get_contents($strFileGabarit);
      $strXmlRep .= "</formulaire>";
      
      if ( !$dom = DOMDocument::loadXML($strXmlRep) ) { //, DOMXML_LOAD_PARSING + DOMXML_LOAD_DONT_KEEP_BLANKS) ){
        echo _t("Erreur lors de l'analyse du document")."\n";
        exit;
      }
      $oNodeRoot = $dom->documentElement;

      if( $oNodeRoot->hasChildNodes() ) {
        $oNodesList = $oNodeRoot->childNodes;

        // build the array
        $nodeArray = array();
        $nbRep = 0;
        for($i=0; $i<$oNodesList->length; $i++) {
          // niveau reponse
          $oNode = $oNodesList->item($i);
          if ($oNode->hasChildNodes()==true) {
            $oNodesSubList =  $oNode->childNodes;
            for($j=0; $j<$oNodesSubList->length; $j++) {
              $oSubNode = $oNodesSubList->item($j);
              if ( $oSubNode->nodeName == "userid" ) {                               
                if (! in_array($oSubNode->nodeValue, $tabUser_id)){
                	$tabUser_id[] = $oSubNode->nodeValue;
                }
              }
            }
          }
        }
      }
    }
  
  return $tabUser_id;
  }
  
  /**
   * Renvoi le contenu html du  ondage sous la forme résultat (graphique)
   *
   * @param: $idSondage identifiant du sondage
   * @return chaine contenant le code html du résultat du sondage
   */
  function GetSondageResult($idSondage, $bBlocPage=false, $strClassTitre="titre", 
                            $strClassTxt="txt", $strClassTxtResult="txt", $strClassTxtLien = "txt")
  {
    $strHtml = "";
    $strXmlRep = "";
    //$strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true).$this->cont_id."/";
    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, false);
    $strFileGabarit = $strPathUpload."formulaire_".$idSondage.".xml";
    
    if ( !(file_exists($strFileGabarit) && is_file($strFileGabarit)) ) {
      return "";
    }
    
    $handle = fopen ($strFileGabarit, "r");
    $dsSondage = $this->oQuery->GetDs_formulaire($idSondage);
    if( $handle && ($drSondage = $dsSondage->getRowIter()) ) {
      $strXmlRep =  fread ($handle, filesize ($strFileGabarit));
      //$strXmlRep = file_get_contents($strFileGabarit);
      $strXmlRep .= "</formulaire>";
      
      if ( !$dom = DOMDocument::loadXML($strXmlRep) ) { //, DOMXML_LOAD_PARSING + DOMXML_LOAD_DONT_KEEP_BLANKS) ){
        echo _t("Erreur lors de l'analyse du document")."\n";
        exit;
      }
      $oNodeRoot = $dom->documentElement;

      if( $oNodeRoot->hasChildNodes() ) {
        $oNodesList = $oNodeRoot->childNodes;

        // build the array
        $nodeArray = array();
        $nbRep = 0;
        for($i=0; $i<$oNodesList->length; $i++) {
          // niveau reponse
          $oNode = $oNodesList->item($i);
          if ($oNode->hasChildNodes()==true) {
            $oNodesSubList =  $oNode->childNodes;
            for($j=0; $j<$oNodesSubList->length; $j++) {
              $oSubNode = $oNodesSubList->item($j);
              if ( $oSubNode->nodeName!= "daterep" && substr($oSubNode->nodeName, -6) == "_radio" ) {
                if ( array_key_exists (substr($oSubNode->nodeName, 0, -6), $nodeArray)==true ) {
                  if ( array_key_exists( $oSubNode->nodeValue, $nodeArray[substr($oSubNode->nodeName, 0, -6)])==true ){
                    $nodeArray[substr($oSubNode->nodeName, 0, -6)][$oSubNode->nodeValue] += 1;
                  } else {
                    $nodeArray[substr($oSubNode->nodeName, 0, -6)][$oSubNode->nodeValue] = 1;
                  }
                } else {
                  $tmpArray = array($oSubNode->nodeValue => 1);
                 $nodeArray[substr($oSubNode->nodeName, 0, -6)] = $tmpArray;
                }
              }
            }
            $nbRep++;
          }
        }
                
        if ( $bBlocPage==true ){
          $iWidthGraph = 250;
          $iHeightGraph = 250;
        } else {
          $iWidthGraph = 212;
          $iHeightGraph = 212;
        }

        $strHtml .= "<dl id=\"csschart\">";        
        foreach ($nodeArray as $keyAnswer => $valueArray) {
          arsort($valueArray);
          $keysArray = array_keys($valueArray);


          for ( $i=0; $i<count($valueArray); $i++ ) {
            $strClassSondage = "type".(($i%4)+1);
              
            if ( $bBlocPage==true ) {
              $strHtml .= "<dt>".$keysArray[$i]."</dt>".
                "<dd><span class=\"".$strClassSondage."\" style=\"width:".(($valueArray[$keysArray[$i]]/$nbRep)*100)."%;\"><em>".intval(($valueArray[$keysArray[$i]]/$nbRep)*100)."%</em></span></dd>";
            } else {
              $strHtml .= "<dt>".$keysArray[$i]."</dt>".
                "<dd><span class=\"".$strClassSondage."\" style=\"width:".(($valueArray[$keysArray[$i]]/$nbRep)*100)."%;\"><em>".intval(($valueArray[$keysArray[$i]]/$nbRep)*100)."%</em></span></dd>";
            }
          }
        }
        
        $strHtml .= "</dl>";
        $strHtml .= "<p>"._f("Le %s &agrave; %s <br/>", date("d/m/Y"), date("H:i"));      
        $strHtml .= _nf("<b> %s personne </b>&nbsp;a particip&eacute; au sondage", 
                        "<b> %s personnes </b>&nbsp;ont particip&eacute; au sondage", 
                        $nbRep)."</p>\n";
      }
    }
           
    fclose ($handle);
    return $strHtml;
  }
  
   /**
   * vérifie les liens gérés par l'application et retourne le résultat sous forme de tableau
   * format du tableau retourné : [][ "data_id", "token", "url", "desc"]
   * @return array
   * 
   */
  public function verifLinks(){
    
   $dsForm = $this->oQuery->GetDs_ListeFormulairesByAppli(-1, 1);
   $tabLink = array();
   while ($drForm = $dsForm->getRowIter()){
     $tabUrl = array();
     foreach($this->tabLangue as $key => $tabLg) {
        // on vérifie le champ contenu
        $champ = "form_contenu_".$tabLg["rep"];
        $valueChamp = $drForm->getValueName($champ);
        if($valueChamp !=""){
          //on cherche les liens
          $tab = verifTextLink($valueChamp);
          if (!empty($tab))
            $tabUrl = array_merge($tab, $tabUrl);
          //on cherche les images
          $tab = verifTextImage($valueChamp);
          if (!empty($tab))
            $tabUrl = array_merge($tab, $tabUrl);
        }
        $champ = "form_titre_".$tabLg["rep"];
        $valueChamp = $drForm->getValueName($champ);
        if($valueChamp !="")
          $strTitre = $valueChamp;
     }
     
     if (!empty($tabUrl)){
      $tabTemp["url"] = $tabUrl;
      $tabTemp["desc"] = "Contenu";
      $tabTemp["data_id"] = $strTitre;
      $appli_id = $drForm->getValueName("APPLI_ID");
      $cont_id = $drForm->getValueName("CONT_ID");
      $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id.
      "&form_id=".$drForm->getValueName("FORM_ID")."&iMode=".ALK_FORM_MODE_UPDATE.
      "&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_ENCOURS."&iSSheet=".ALK_SHEET_FORM); 
      $tabTemp["token"] = $strToken;
      array_push($tabLink, $tabTemp);
      $tabTemp = array();
    }
     
  }
  return $tabLink;
  }
  
  /**
   * Retourne le libellé de la page d'aide associée à l'application
   * @return string
   */
  public function getHelp(){
    return _t("Formulaire");
  }  
}
?>