<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Form
 * @class AlkHtmlFormForm
 * Classe d'affichage de la boite de reception et d'envois de la liste de diffusion
 */
class AlkHtmlFormForm extends AlkHtmlForm
{
  protected $form_id;

  /** controle de saisie */
  protected $form_titre;
  protected $form_contenu;
  protected $form_javascript;
  protected $form_date_crea;
  protected $form_date_maj;
  protected $agent_nomcrea;
  protected $agent_nommaj;
  protected $form_mail;
  protected $form_sondage;
  protected $form_envoi_pdf;
  protected $form_datepdeb;
  protected $form_datepfin;
  protected $form_validepub;
  protected $form_envoi_ar;
  protected $form_donnees_ar;
  protected $form_contenu_ar;
  protected $form_champmail_ar;
  protected $form_alaune;
  protected $form_nbrep_max;
  protected $form_btsave;
  protected $form_msg_ar;
  
  protected $form_secure;
  protected $form_rep_unique;
  
  protected $bAccuseReception;
 
  protected $oSheetPrinc = null;
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formulaireForm");

    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) 
  {	
    $this->form_id = AlkRequest::getToken("form_id", "-1");

    $this->bAccuseReception = ALK_B_FORM_AR;

    $this->bcopier            = new AlkFormData($this, "bcopier",                   0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->form_titre         = new AlkFormData($this, "form_titre",               "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->form_contenu       = new AlkFormData($this, "form_contenu",             "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->form_javascript    = new AlkFormData($this, "form_javascript",          "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->form_date_crea     = new AlkFormData($this, "form_date_crea",           "", ALK_SQL_NONE);
    $this->form_date_maj      = new AlkFormData($this, "form_date_maj",            "", ALK_SQL_NONE);
    $this->agent_nomcrea      = new AlkFormData($this, "agent_nomcrea",            "", ALK_SQL_NONE );
    $this->agent_nommaj       = new AlkFormData($this, "agent_nommaj",             "", ALK_SQL_NONE );
    $this->form_mail          = new AlkFormData($this, "form_mail",                "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    $this->form_sondage       = new AlkFormData($this, "form_sondage",              0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->form_envoi_pdf     = new AlkFormData($this, "form_envoi_pdf",            0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->form_datepdeb      = new AlkFormData($this, "form_datepdeb", date("d/m/Y"), ALK_VERIF_DATE10);
    $this->form_datepfin      = new AlkFormData($this, "form_datepfin",            "", ALK_VERIF_DATE10);
    $this->form_validepub     = new AlkFormData($this, "form_validepub",            0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->form_envoi_ar      = new AlkFormData($this, "form_envoi_ar",             0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->form_donnees_ar    = new AlkFormData($this, "form_donnees_ar",           0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->form_contenu_ar    = new AlkFormData($this, "form_contenu_ar",          "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    $this->form_champmail_ar  = new AlkFormData($this, "form_champmail_ar",        "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    $this->form_alaune        = new AlkFormData($this, "form_alaune",               0, ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->form_nbrep_max     = new AlkFormData($this, "form_nbrep_max",            0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->form_btsave        = new AlkFormData($this, "form_btsave",               0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->form_msg_ar        = new AlkFormData($this, "form_msg_ar",               "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true );
    
    $this->form_secure        = new AlkFormData($this, "form_secure",               0, ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->form_rep_unique    = new AlkFormData($this, "form_rep_unique",           0, ALK_SQL_NUMBER, ALK_VERIF_CHECK);

    if (!(defined("ALK_B_FORM_REPONSE") && ALK_B_FORM_REPONSE) && !$this->bAccuseReception){
      $this->form_champmail_ar->setIsVisible(false);
    }
    
    if (!(defined("ALK_B_FORM_ALAUNE") && ALK_B_FORM_ALAUNE)){
      $this->form_alaune->setIsVisible(false);
    }
    
    if( !$this->bAccuseReception ) {
    	$this->form_envoi_ar->setIsVisible(false);
      $this->form_donnees_ar->setIsVisible(false);
      $this->form_contenu_ar->setIsVisible(false);
    }

    $tabData = array(null);
    $reqMethod = -1;
    
    if( $this->iMode== ALK_FORM_MODE_UPDATE ) {
      if( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {            
        $oDsData = $this->oAppli->oQuery->GetDs_formulaire($this->form_id);
        $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
      }
    }
    
    if( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;

    foreach ($tabData as $oDrData) {
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
  }

  /**
   * Traitement 
   */
  public function doSql() 
  {
    $this->setData(ALK_INIT_MODE_REQUEST);       
    $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_ENCOURS);
    
    foreach($this->tabLangue as $key => $tabLg) {
      $tab_form_titre[$key] = AlkRequest::_POST("form_titre".$tabLg["bdd"], "");
    }
    
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD : // ajout
      $path_Form = AlkFactory::getModulePath(ALK_ATYPE_ID_FORM);   
      $strPathFileGabarit = $path_Form."gabarit.html";
      $strContenu = "";
      if( file_exists($strPathFileGabarit) && is_file($strPathFileGabarit) ) {
        $handle = fopen($strPathFileGabarit, "r");
        $strContenu = trim(fread($handle, filesize($strPathFileGabarit)));
        fclose($handle);
      } 
      $form_id = $this->oAppli->oQueryAction->addFormulaire($tab_form_titre, $this->form_mail->value, $strContenu, 
                                                            $this->oAppli->appli_id, $this->form_datepdeb->value, 
                                                            $this->form_datepfin->value, $this->form_validepub->value, 
                                                            $this->form_envoi_ar->value, $this->form_contenu_ar->value, 
                                                            $this->form_donnees_ar->value, $this->form_champmail_ar->value,
                                                            $this->form_sondage->value, $this->form_envoi_pdf->value,  
                                                            $this->form_alaune->value, $this->form_nbrep_max->value, 
                                                            $this->form_btsave->value, $this->form_msg_ar->value, $this->form_secure->value, $this->form_rep_unique->value);
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_FORM, 
                                          "&iMode=".ALK_FORM_MODE_UPDATE."&form_id=".$form_id); 
      break;

    case ALK_FORM_MODE_UPDATE :// Modif
      $this->oAppli->oQueryAction->updateFormulaire($this->form_id, $tab_form_titre, $this->form_mail->value, $this->bcopier->value, 
                                                    $this->form_datepdeb->value, $this->form_datepfin->value, $this->form_validepub->value, 
                                                    $this->form_envoi_ar->value, $this->form_contenu_ar->value, $this->form_donnees_ar->value, 
                                                    $this->form_champmail_ar->value, $this->form_sondage->value, $this->form_envoi_pdf->value, 
                                                    $this->form_alaune->value, $this->form_nbrep_max->value, 
                                                    $this->form_btsave->value, $this->form_msg_ar->value, $this->form_secure->value, $this->form_rep_unique->value);
                                                    
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_NONE); 
      break;
    }
    return ALK_ALKANET."?token=".$strToken; 
  }
  
  /**
   * Construction de la liste 
   */
  public function setContents()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    
    $this->oSheetPrinc = $this;
    $this->oSheetSec = $this;
    
    /* =============== Template et boutons du formulaire ================ */
    $this->oSheetPrinc->setTemplate("alkanet", "form_bicolumn.tpl");
    $this->oSheetSec->setTemplate("alkanet", "form_bicolumn.tpl");
    
    $this->setData(ALK_INIT_MODE_DATAROW);
    $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_ENCOURS);
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    
    $iTxtWidth = 30;

    $strTitre = ( $this->iMode == ALK_FORM_MODE_UPDATE 
                  ? _t("Modification du formulaire")
                  : _t("Ajout d'un Formulaire") );
    
    $oBlockProp = $this->oSheetPrinc->addBlock("blocProp", $strTitre, "", "150", "255", true);

    $oCtrlTitre = AlkHtmlFactory::getHtmlText($this->form_titre, _t("Titre"), 1, $iTxtWidth, 255);
    $oCtrlTitre->setBMultiLanguage(true);
    $oCtrlTitre->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    $oBlockProp->addCtrl($oCtrlTitre);

    $oCtrlMail = AlkHtmlFactory::getHtmlText($this->form_mail, _t("Email du destinataire"), 1, $iTxtWidth, 255);
    $oCtrlMail->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    $oBlockProp->addCtrl($oCtrlMail);
    
    if(defined("ALK_B_FORM_EXPORT_PDF") && ALK_B_FORM_EXPORT_PDF) {
      $oCtrlPdfCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->form_envoi_pdf, _t("Fiche pdf"));
      $oCtrlPdfCheckbox->setLabelAfter("("._t("Envoyée par mail après validation et génération recueil").")");
      $oCtrlPdfCheckbox->addEvent("onChange", "onChangeSondagePDF('form_sondage')");
      $oBlockProp->addCtrl($oCtrlPdfCheckbox);
    }
    $oCtrlSondageCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->form_sondage, _t("Sondage"));
    $oCtrlSondageCheckbox->addEvent("onChange", "onChangeSondagePDF('form_envoi_pdf')");
    $oBlockProp->addCtrl($oCtrlSondageCheckbox);
    
    if(defined("ALK_B_FORM_ALAUNE") && ALK_B_FORM_ALAUNE) {
      $oCtrlAlauneCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->form_alaune, _t("A la une"));
      $oBlockProp->addCtrl($oCtrlAlauneCheckbox);
    }
    
    if ((defined("ALK_B_FORM_REPONSE") && ALK_B_FORM_REPONSE) || $this->bAccuseReception){
      $oCtrlstrChampMailAr = AlkHtmlFactory::getHtmlText($this->form_champmail_ar, _f("Nom du champ du formulaire%nlcontenant l'email de l'expéditeur", "<br/>"), 1, $iTxtWidth, 100);
      $oCtrlstrChampMailAr->addValidator(($this->bAccuseReception ? ALK_IS_REQUIRED+ALK_VERIF_TEXT : ALK_VERIF_TEXT));
      $oBlockProp->addCtrl($oCtrlstrChampMailAr);
    }
    if(defined("ALK_B_FORM_SECURE") && ALK_B_FORM_SECURE) {
      $oCtrlSecureCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->form_secure, _t("Sécurisé (certificat SSL)"));
      $oBlockProp->addCtrl($oCtrlSecureCheckbox);
    }
    if(defined("ALK_B_FORM_REP_UNIQUE") && ALK_B_FORM_REP_UNIQUE) {
      $oCtrlRepUniqueCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->form_rep_unique, _t("Réponse unique ( 1 réponse par adresse IP)"));
      $oBlockProp->addCtrl($oCtrlRepUniqueCheckbox);
    }
    
    if( $this->bAccuseReception ) {    
      $oCtrlCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->form_envoi_ar, _t("Envoi d'un AR"));
      $oBlockProp->addCtrl($oCtrlCheckbox);
      
      $oCtrlstrChampMailAr = AlkHtmlFactory::getHtmlText($this->form_msg_ar, 
                             _t("Message à insérer dans le courriel AR"), 7, $iTxtWidth-2, 100);
      $oCtrlstrChampMailAr->setBMultiLanguage(true);
      $oBlockProp->addCtrl($oCtrlstrChampMailAr); 
  
     // if ( $iIdFormulaire != "0" ) {
        /*$oCtrlTxtEditor = new HtmlTextEditor(0, "strMsgAr", $strMsgAr, "Message AR", 4, 46, 
                                             "FORM_01_FORM", "FORM_CONTENU_AR", "FORM_ID", $iIdFormulaire, 
                                             ALK_PATH_UPLOAD_FORMULAIRE.$oSpace->cont_id."/", $strFormActionParam);
        $oCtrlTxtEditor->bShowMultiLangue = false;        
        AffTableCtrlLigne($oCtrlTxtEditor->label,$oCtrlTxtEditor->getHtml());*/
      //}                                                    
      $oCtrlbDonneesAr = AlkHtmlFactory::getHtmlCheckbox($this->form_donnees_ar, _t("Insérer les données dans le message AR"));
      $oBlockProp->addCtrl($oCtrlbDonneesAr);       
    }
    
    if(defined("ALK_B_FORM_NBREPONSE_MAX") && ALK_B_FORM_NBREPONSE_MAX) {
      $oCtrlform_nbrep_max = AlkHtmlFactory::getHtmlText($this->form_nbrep_max, _t("Nombre maximal de réponses"), 1, 10, 100);
      $oCtrlform_nbrep_max->addValidator(ALK_VERIF_INT);
      $oCtrlform_nbrep_max->setLabelAfter("&nbsp;("._t("0= nombre illimité de réponses").")");
      $oBlockProp->addCtrl($oCtrlform_nbrep_max);
    }

    if(defined("ALK_B_FORM_ENREGISTREMENT") && ALK_B_FORM_ENREGISTREMENT) {
      $oCtrlBtSave = AlkHtmlFactory::getHtmlCheckbox($this->form_btsave, _t("Afficher le bouton \"Enregistrer\""));
      $oCtrlBtSave->setHidden(!ALK_B_FORM_MODE_COOKIE);
      $oBlockProp->addCtrl($oCtrlBtSave);
    }
  
    if ( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      if( count($this->tabLangue) > 1 ) {
        $oCtrlbcopier = AlkHtmlFactory::getHtmlCheckbox($this->bcopier, _t("Dupliquer le contenu français"));
        $oBlockProp->addCtrl($oCtrlbcopier);
      }
        
      $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true).$cont_id."/";
      if( !(@file_exists(ALK_ALKANET_ROOT_PATH.$strPathUpload) && @is_dir(ALK_ALKANET_ROOT_PATH.$strPathUpload)) ) {
        $bRes = @mkdir(ALK_ALKANET_ROOT_PATH.$strPathUpload, 0770);
        if( !$bRes ) {
          $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true);
        } 
      }
      
      $strHtmlLg = "";
      foreach($this->tabLangue as $key => $tabLg) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE,
                                            "&applitype_id=".ALK_ATYPE_ID_FORM.
                                            "&form_id=".$this->form_id."&table=FORM_01_FORM".
                                            "&lang=".$tabLg["bdd"]."&repUpload=".$strPathUpload);
        
        $oBtMaj = AlkHtmlFactory::getHtmlButtonImg("javascript:OpenPopupEditeur('".$strToken."')", 
                                                   "icon_drapeau_".$tabLg["rep"].".gif",
                                                   _f("Contenu %s de ce formulaire", $tabLg["rep"]), "17", "12");
        $strHtmlLg .= ( $strHtmlLg!="" ? "&nbsp;&nbsp;" : "" ).$oBtMaj->getHtml();
      }
      $oCtrlLg = AlkHtmlFactory::getHtml($strHtmlLg, _t("Gérer le contenu :"));
      $oBlockProp->addCtrl($oCtrlLg);
    }  
    
    $oBlockPub  = $this->oSheetSec->addBlock("blockPub", _t("Publication"), "", "150", "150");

    $oCtrlVPub = AlkHtmlFactory::getHtmlCheckbox($this->form_validepub, _t("Publier ce formulaire"));
    $oCtrlVPub->setHidden(!($user_right==ALK_APPLI_RIGHT_PUBLI && $this->iMode == ALK_FORM_MODE_UPDATE));
    $oBlockPub->addCtrl($oCtrlVPub);

    $oCtrldDatePDeb = AlkHtmlFactory::getHtmlDate($this->form_datepdeb, _t("Date de publication"));
    $oCtrldDatePDeb->addValidator(ALK_VERIF_DATE10);
    $oBlockPub->addCtrl($oCtrldDatePDeb);
    
    $oCtrldDatePFin = AlkHtmlFactory::getHtmlDate($this->form_datepfin, _t("Date de fin de publication"));
    $oCtrldDatePFin->addValidator(ALK_VERIF_DATE10);
    $oBlockPub->addCtrl($oCtrldDatePFin);

    /*$oCtrlDateCreation = AlkHtmlFactory::getHtmlText($this->form_date_creation, "Date de création", 1, 12, 10);
    $oCtrlDateCreation->setProperty("bDisabled", true);
    $oBlockProp->addCtrl($oCtrlDateCreation);
    $oCtrlDateCreation = AlkHtmlFactory::getHtmlText($this->form_date_creation, "Date de création", 1, 12, 10);
    $oCtrlDateCreation->setProperty("bDisabled", true);
    $oBlockProp->addCtrl($oCtrlDateCreation);*/

    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      $strHtml = ( $this->form_date_crea->value != ""
                   ? _f("Créé le %s par %s", $this->form_date_crea->value, $this->agent_nomcrea->value)."<br/>".
                   ( $this->form_date_maj->value != ""
                     ? _f("Modifié le %s par %s", $this->form_date_maj->value, $this->agent_nommaj->value)
                     : "" )
                   : "" );
      $oCtrlDate = AlkHtmlFactory::getHtml($strHtml);

      $oBlockMeta = $this->oSheetSec->addBlock("blockMeta", _t("Méta-information"), "",  "150", "150", false);
      $oBlockMeta->addCtrl($oCtrlDate, ALK_HTMLFORM_1L1C);
    }
      
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_FORM, 
                                        "&form_id=".$this->form_id."&iMode=".$this->iMode);
    $oButton = $this->AddButtonPage("btValid", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider les modifications"));
    $this->addSubmitButton($oButton);
      
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, $iSheet, ALK_SHEET_NONE, 
                                        "&form_id=".$this->form_id."&iMode=".$this->iMode);
    $this->AddButtonPage("btAnnul", "javascript:AlkGoUrl('".ALK_ALKANET."?token=".$strToken."')", _t("Annuler"), _t("Annuler les modifications")); 
 
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/alkhtmlformform.js");    
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/alkhtmlformlist.js");
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/help/form_01_formulaire_form.htm");   
  }
}
?>