<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

class alkhtmlpopupformmail extends AlkHtmlForm {
  
  protected $form_exp_mail;
  protected $form_id;
  protected $form_message;
  protected $type_adr_from;
  protected $reponse_message;
  protected $reponse_nom;
  protected $reponse_mail;
  protected $reponse_agent_id;
  protected $reponse_agent_nom;
  protected $reponse_agent_mail;
  protected $reponse_id;
  
  public function __construct(AlkAppli &$oAppli) 
  {
    parent::__construct($oAppli, "formReponseMail");

    // récupération du mode formulaire
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=".$iMode);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;    
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, $strAction);
  }
  
  protected function setData($iTypeInit) 
  {
    $this->form_exp_mail  = new AlkFormData($this, "form_exp_mail", AlkRequest::getToken("form_exp_mail", ""), ALK_SQL_TEXT);
    $this->form_exp_mail_aff  = new AlkFormData($this, "form_exp_mail_aff", AlkRequest::getToken("form_exp_mail_aff", ""), ALK_SQL_TEXT);
    $this->reponse_message  = new AlkFormData($this, "reponse_message", "", ALK_SQL_TEXT);
    $this->type_adr_from = new AlkFormData($this, "type_adr_from[]", "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->reponse_nom  = new AlkFormData($this, "reponse_nom", ALK_MAIL_ADMIN_NAME, ALK_SQL_TEXT);
    $this->reponse_mail  = new AlkFormData($this, "reponse_mail", ALK_MAIL_ADMIN_MAIL, ALK_SQL_TEXT);
    $this->reponse_agent_id  = new AlkFormData($this, "reponse_agent_id", $_SESSION["alk_idUser"], ALK_SQL_TEXT);
    $this->reponse_agent_mail  = new AlkFormData($this, "reponse_agent_mail", $_SESSION["alk_userMail"], ALK_SQL_TEXT);
    $this->reponse_agent_nom  = new AlkFormData($this, "reponse_agent_nom", $_SESSION["alk_userName"], ALK_SQL_TEXT);
    $this->reponse_id  = new AlkFormData($this, "reponse_id", AlkRequest::getToken("reponse_id", ""), ALK_SQL_TEXT);
    $this->form_id  = new AlkFormData($this, "form_id", AlkRequest::getToken("form_id", ""), ALK_SQL_TEXT);
    $this->form_message = new AlkFormData($this, "form_message", $this->AfficherReponse(AlkRequest::getToken("form_id", ""),  AlkRequest::getToken("reponse_id", "")), ALK_SQL_TEXT);
 
    // on récupère le mail du destinataire 
    $reqMethod = REQ_POST;
      
    $this->initData($iTypeInit, null, $reqMethod);
    
  }
  
  public function getTitle(){
    return "Envoi d'un message";
  }
  
  public function SendMailToUser() 
  {
    // initialisation de l'objet mail
    setMailAlkLocale(ALK_MAIL_ADMIN_LG);
    
    $oAlkMail = AlkFactory::getMail();
    $strMailExp = "";
    $strNomExp = "";
    $strIdExp ="";
  
    if ( $this->type_adr_from->value[0]=="0" ){// adresse émettrice
      $strNomExp = $this->reponse_nom->value;
      $strMailExp = $this->reponse_mail->value;
      $strIdExp = $this->reponse_agent_id->value;
    } else {// adresse personnelle
      $strNomExp = $this->reponse_agent_nom->value;
      $strMailExp = $this->reponse_agent_mail->value; 
      $strIdExp = $this->reponse_agent_id->value;  
    }
    
    $oAlkMail->SetFrom($strNomExp, $strMailExp);
    $oAlkMail->AddTo("", $this->form_exp_mail->value);
    $titreForm="";
    
    $dsForm = $this->oAppli->oQuery->GetDs_formulaire($this->form_id->value);
    if( $drForm = $dsForm->getRowIter() ) {
      $titreForm = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
    }
    
    $tabAssoc["agent_mail"] = $this->form_exp_mail->value;
    $tabAssoc["msgTitle"] = _f("Formulaire %s : Réponse à votre message",  $titreForm);
    $tabAssoc["msg"] = 
      _f("Veuillez trouver ci-dessous notre réponse à votre message envoyé via le formulaire %s :", 
         '<b>'.$titreForm.'</b>').
      '<br/>'.$this->reponse_message->value;
    
    AlkMailing::SendMailType($oAlkMail, "FORM_MAIL_REPONSE", $tabAssoc);
    setCurrentAlkLocale();
    
    return array ($strMailExp, $strNomExp, $strIdExp);
  }  
  
  public function doSql()
  {
    // envoi du mail
    $this->setData(ALK_INIT_MODE_REQUEST);
    $result = $this->SendMailToUser();
    // modification du fichier xml
    $this->UpdateFichierXMLByReponseID($this->reponse_id->value, $this->form_id->value, $this->reponse_message->value, $result[0],$result[1],$result[2]);
    echo getBodyOnLoadExec("", "closeWindow('reload')");
    exit();
  }
   
   private function UpdateFichierXMLByReponseID($reponse_id, $form_id, $reponse_message="Vu", $agent_mail="", $agent_nom="", $agent_id=""){
    $strFileXml = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM)."formulaire_".$form_id.".xml";
   
    if ($agent_nom=="") $agent_nom= $_SESSION["alk_userName"];
    if ($agent_mail=="") $agent_mail = $_SESSION["alk_userMail"];
    if ($agent_id=="") $agent_id = $_SESSION["alk_idUser"];
    
    if (file_exists($strFileXml)){
      $handleXml = fopen ($strFileXml, "r+"); 
      // parcours     
      $strXmlRep = file_get_contents($strFileXml);
      $strXmlRep .= "</formulaire>";
             
      $strXmlRep = str_replace(ALK_HTML_ENCODING, ALK_EXPORT_ENCODING , $strXmlRep);
      //$strXmlRep = mb_convert_encoding($strXmlRep, ALK_HTML_ENCODING, ALK_EXPORT_ENCODING);
      $oDom = DOMDocument::loadXML($strXmlRep);
      
      // on cherche le noeud reponse correspondant
      $oXPath = new DomXPath($oDom);
      $oNodeList = $oXPath->query("/formulaire/reponse[normalize-space(reponse_id)='".$reponse_id."']");
      if ( $oNodeList->length==0 ){
        return;
      }
      $oReponse = $oNodeList->item(0);
  
      // on crée les noeuds
      // 1. noeud message
      $NoeudMsg = $oDom->createElement("message", utf8_encode($reponse_message));
      // 2. noeud date_traitement
      $NoeudDate = $oDom->createElement("date_traitement", date("d/m/Y"));
      // 3. noeud agent_id
      $noeudAgent = $oDom->createElement("agent_id", $agent_id);
      // 4. Nouveau etat de reponse
      $noeudEtatReponse = $oDom->createElement("etat", ALK_FORM_ETAT_REPONSE_TRAITE);
      // 5. Noeud mail de l'agent qui répond
      $noeudAgentMail = $oDom->createElement("agent_mail", $agent_mail);
      // 6. Noeud nom de l'agent qui répond
      $noeudAgentNom = $oDom->createElement("agent_nom", $agent_nom);
      // 5. Noeud Traitement
      $Newnode = $oDom->createElement("traitement", ""); // Noeud Traitement
      
      $AncienNoeudEtat = $oReponse->getElementsByTagName("etat")->item(0); 
       
       // suppression du noeud Etat
      $oReponse->removeChild($AncienNoeudEtat);
      
      $Newnode->appendchild($NoeudMsg);
      $Newnode->appendchild($NoeudDate);
      $Newnode->appendchild($noeudAgent); 
      $Newnode->appendchild($noeudAgentMail);  
      $Newnode->appendchild($noeudAgentNom);  
      $oReponse->appendchild($Newnode);
      $oReponse->appendchild($noeudEtatReponse);
      $cat = str_replace ("</formulaire>","", $oDom->saveXml());
      $cat = mb_convert_encoding($cat, ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      fwrite($handleXml,$cat);

    }
  }  
   
  protected function AfficherReponse($form_id, $reponse_id){
    $chaine ="";  
    
    $strFileXml = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM)."formulaire_".$form_id.".xml";     
    if (file_exists($strFileXml)){
      $handleXml = fopen ($strFileXml, "r"); 
      // parcours     
      $strXmlRep = file_get_contents($strFileXml);
      $strXmlRep .= "</formulaire>";
             
      $strXmlRep = str_replace(ALK_EXPORT_ENCODING, ALK_HTML_ENCODING, $strXmlRep);
      $strXmlRep = mb_convert_encoding($strXmlRep, ALK_HTML_ENCODING, ALK_EXPORT_ENCODING);
      $oDom = DOMDocument::loadXML($strXmlRep);
      
      // on cherche le noeud reponse correspondant
      $oXPath = new DomXPath($oDom);
      $oNode = $oXPath->query("/formulaire/reponse[normalize-space(reponse_id)='".$reponse_id."']");
      if ( $oNode->length==0 ){
        return;
      }
      $oReponse = $oNode->item(0);
      
      if ($oReponse->hasChildNodes()){
        $oNodesSubList = $oReponse->childNodes;                       
        for ($j=0; $j< $oNodesSubList->length;$j++){
            if ($oNodesSubList->item($j)->nodeName!="#text"){
              if ($oNodesSubList->item($j)->nodeName=="traitement"){
                if ($oNodesSubList->item($j)->hasChildNodes()){
                    $nodeTraitement = $oNodesSubList->item($j)->childNodes;
                    $chaine.="<br/><b>Traitement</b><br/>";
                    for ($k=0;$k<$nodeTraitement->length;$k++){
                      if ($nodeTraitement->item($k)->nodeName!="#text"){
                      $chaine.= "&nbsp;&nbsp;<b>".$nodeTraitement->item($k)->nodeName." :</b>&nbsp;".$nodeTraitement->item($k)->nodeValue."<br/>";
                      }
                    }
                }
              } else {
                $strParamName = $oNodesSubList->item($j)->nodeName;
                if (mb_substr(mb_strTolower($strParamName), 0, mb_strlen("form_".$form_id."_")) == "form_".$form_id."_")
                  $strParamName = mb_substr(mb_strTolower($strParamName), mb_strlen("form_".$form_id."_"));              
                $chaine .="<b>".$strParamName.": </b>".$oNodesSubList->item($j)->nodeValue."<br>";
              }
            }
        }
      }
    }
    
    return $chaine."<br/>";
  }
  
  protected function setContents()
  {
    
    $this->setData(ALK_INIT_MODE_REQUEST);

    $strTitle = _t("Formulaire Envoi message");
    
    $this->setLabel($strTitle);
    $oBlock = $this->addBlock("block_prop", "", "", "300", "490", true);
    // recueil de l'adresse mail du destinataire
    
    // champs cachés reponse_id et form_id et form_exp_mail
    $oHide = AlkHtmlFactory::getHtmlHidden($this->reponse_id);
    $oHide->addDataHidden($this->form_id);
    $oHide->addDataHidden($this->form_exp_mail);
    $oHide->addDataHidden($this->reponse_agent_id);
    
    // champ contenant le rappel du message envoyé par l'internaute
    $octrMsg = AlkHtmlFactory::getHtml($this->form_message, _t("Informations relatives à la réponse"));
    $oBlock->addCtrl($octrMsg);
    
    // Champ form_exp_mail
    $oCtrlFormExpMail = AlkHtmlFactory::getHtmlText($this->form_exp_mail, _t("Adresse mail destinataire"), 1, 50, 80);
    $oCtrlFormExpMail->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $oCtrlFormExpMail->setDisabled(true);
    $oBlock->addCtrl($oCtrlFormExpMail);
    
    // champ message
    $oCtrlReponseMessage = AlkHtmlFactory::getHtmlText($this->reponse_message, _t("Message"), 10, 50, 80);
    $oCtrlReponseMessage->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    $oBlock->addCtrl($oCtrlReponseMessage);
    
    // champs Emetteurs
    
    $oCtrlTypeFrom = AlkHtmlFactory::getHtmlRadio($this->type_adr_from, "");
    $oCtrlTypeFrom->addRadio(0, _t("Nom & Adresse émétrice"));
    $oCtrlTypeFrom->addEventToRadio(0, "onclick", "AfficherCacher(this);");
    $oBlock->addCtrl($oCtrlTypeFrom);
    
    $this->addOnload("AfficherCacher(document.getElementById('".$oCtrlTypeFrom->getGUID()."_0'))");
    
    // champ nom_alk
    $oCtrlReponseNom = AlkHtmlFactory::getHtmlText($this->reponse_nom, _t("Nom/Signature"), 1, 50, 80);
    $oCtrlReponseNom->addValidator(ALK_VERIF_TEXT);
    // champ Mail_Alk
    $oCtrlReponseMail = AlkHtmlFactory::getHtmlText($this->reponse_mail, _t("Adresse"), 1, 50, 80);
    $oCtrlReponseMail->addValidator(ALK_VERIF_TEXT);
    
    $oBlock->addCtrl($oCtrlReponseNom);
    $oBlock->addCtrl($oCtrlReponseMail);
    
    $oCtrlTypeFrom = AlkHtmlFactory::getHtmlRadio($this->type_adr_from, "");
    $oCtrlTypeFrom->addRadio(1, _t("Nom & Adresse personnelle"));
    $oCtrlTypeFrom->addEventToRadio(1, "onclick", "AfficherCacher(this);");
    $oBlock->addCtrl($oCtrlTypeFrom);
    
    
    // champ mail_perso
    $oCtrlReponseAgentNom = AlkHtmlFactory::getHtmlText($this->reponse_agent_nom, _t("Nom/Signature"), 1, 50, 80);
    $oCtrlReponseAgentNom->setDisabled(true);
    
    //champ Mail Perso
    $oCtrlReponseAgentMail = AlkHtmlFactory::getHtmlText($this->reponse_agent_mail, _t("Adresse"), 1, 50, 80);
    $oCtrlReponseAgentMail->setDisabled(true);
    
    $oBlock->addCtrl($oCtrlReponseAgentNom);
    $oBlock->addCtrl($oCtrlReponseAgentMail);
    
    $this->addValidButton("", "", _t("Valider"), _t("Valider"));
    $this->addButtonPage("cancel", "javascript:closeWindow()", _t("Annuler"), _t("Fermer la fenêtre"));
    
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/alkhtmlpopupformulaireform.js");
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."form/help/form_01_formulaire_list.htm");   
  }
}

?>