<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_B_ATYPE_GEDIT", true);



// table GEDIT_01_APPLI_TYPE : liste des types d'appli proposant des interfaces pour pages éditoriales
$tabTable["gedit_01_appli_type"] = array(
  "atype_id"      => array("type" => "int", "dn" => "NOT NULL"),
);

$tabPk["gedit_01_appli_type"]["pk_gedit_01_appli_type"] = "atype_id";

// pas de contrainte FK pour atype_id

// table GEDIT_01_APPLI_TYPE : liste des types d'interface par type d'application pour pages éditoriales
// ptype_id vaut de 1 à n pour chaque atype_id 
$tabTable["gedit_01_page_type"] = array(
  "atype_id"          => array("type" => "int", "dn" => "NOT NULL"),  
  "ptype_id"          => array("type" => "int", "dn" => "NOT NULL"),
  "ptype_intitule"    => array("type" => "varchar(50)", "dn" => "NOT NULL"),
  "ptype_desc"        => array("type" => "varchar(255)", "dn" => ""),
  "ptype_servicename" => array("type" => "varchar(80)", "dn" => ""),
);

$tabPk["gedit_01_page_type"]["pk_gedit_01_page_type"] = "atype_id, ptype_id";

// pas de contrainte FK pour atype_id

//   Table : GEDIT_01_PAGE
$tabTable["gedit_01_page"] = array(
  "page_id"                => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id"               => array("type" => "int", "dn" => "NOT NULL"),
  "page_titre_fr"          => array("type" => "varchar(255)", "dn" => ""),
  "page_titre_en"          => array("type" => "varchar(255)", "dn" => ""),
  "page_titre_court_fr"    => array("type" => "varchar(255)", "dn" => ""),
  "page_titre_court_en"    => array("type" => "varchar(255)", "dn" => ""),
  "page_titrenav_fr"       => array("type" => "varchar(255)", "dn" => ""),
  "page_titrenav_en"       => array("type" => "varchar(255)", "dn" => ""),
  "page_alias"             => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "page_alias_fr"          => array("type" => "varchar(255)", "dn" => ""),
  "page_alias_en"          => array("type" => "varchar(255)", "dn" => ""),
  "page_desc_fr"           => array("type" => "varchar(255)", "dn" => ""),
  "page_desc_en"           => array("type" => "varchar(255)", "dn" => ""),
  "page_motcle_fr"         => array("type" => "varchar(1000)", "dn" => ""),
  "page_motcle_en"         => array("type" => "varchar(1000)", "dn" => ""),
  "page_lock"              => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "page_visible"           => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "page_visible_menu"      => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "page_validepub"         => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "page_validesynd"        => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "page_datepdeb"          => array("type" => "datetime", "dn" => ""),
  "page_datepfin"          => array("type" => "datetime", "dn" => ""),
  "page_datecrea"          => array("type" => "datetime", "dn" => ""),
  "agent_id_crea"          => array("type" => "int", "dn" => "NOT NULL"),
  "page_datemaj"           => array("type" => "datetime", "dn" => ""),
  "agent_id_maj"           => array("type" => "int", "dn" => "NOT NULL"),
  "page_racine_droit"      => array("type" => "int", "dn" => ""),
  "page_parent"            => array("type" => "int", "dn" => ""),
  "page_niveau"            => array("type" => "int", "dn" => ""),
  "page_arbre"             => array("type" => "varchar(255)", "dn" => ""),
  "page_public"            => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "page_rang"              => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "agent_id"               => array("type" => "int", "dn" => "DEFAULT 0"),
  "page_repertoire"        => array("type" => "varchar(80)", "dn" => ""),
  "page_url_redirection"    => array("type" => "varchar(255)", "dn" => ""),
  "page_target_redirection" => array("type" => "int", "dn" => "DEFAULT 0"),
  "doc_id"                  => array("type" => "int", "dn" => ""),
  "atype_id"                => array("type" => "int", "dn" => "DEFAULT 23 NOT NULL"),
  "ptype_id"                => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "page_appliid"            => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  "page_catid"              => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  "page_template"           => array("type" => "varchar(255)", "dn" => ""),
  "page_ordre"              => array("type" => "varchar(255)", "dn" => ""),
  "page_typeassoc"          => array("type" => "int", "dn" => "DEFAULT 16 NOT NULL"),
  "page_datedeb"            => array("type" => "datetime", "dn" => ""),
  "page_datefin"            => array("type" => "datetime", "dn" => ""),
  "page_brouillon"          => array("type" => "int", "dn" => ""),
  "page_nb_elements"        => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  );

$tabPk["gedit_01_page"]["pk_gedit_01_page"] = "page_id";

$tabIdx["gedit_01_page"] = array(
  "geditpage_agentidc_fk" => "agent_id_crea",
  "geditpage_agentidm_fk" => "agent_id_maj",
  "geditpage_appliid_fk" => "appli_id",
  "geditpage_aptypeid_fk" => "atype_id, ptype_id",
  "geditpage_pagebrouillon_fk" => "page_brouillon",
  "geditpage_pageparent_fk" => "page_parent",
  "geditpage_pagerdroit_fk" => "page_racine_droit",
  );

$tabFk["gedit_01_page"] = array(
  "fk_geditpage_agentidc" => array("ffk" => "agent_id_crea", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_geditpage_agentidm" => array("ffk" => "agent_id_maj", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_geditpage_aptypeid" => array("ffk" => "atype_id, ptype_id", "tpk" => "gedit_01_page_type", "fpk" => "atype_id, ptype_id"),
  );

$tabSeq["seq_gedit_01_page"] = "10";

//   Table : GEDIT_01_PROFIL                                    
$tabTable["gedit_01_profil"] = array(
  "profil_id" => array("type" => "int", "dn" => "NOT NULL"),
  "page_id" => array("type" => "int", "dn" => "NOT NULL"),
  "droit_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["gedit_01_profil"]["pk_gedit_01_agentpage"] = "profil_id, page_id";

$tabIdx["gedit_01_profil"] = array(
  "geditprofil_pageid_fk" => "page_id",
  "geditprofil_profilid_fk" => "profil_id",
  );

$tabFk["gedit_01_profil"] = array(
  "fk_geditprofil_pageid" => array("ffk" => "page_id", "tpk" => "gedit_01_page", "fpk" => "page_id"),
  "fk_geditprofil_profilid" => array("ffk" => "profil_id", "tpk" => "sit_profil", "fpk" => "profil_id"),
  );

//   Table : GEDIT_01_DROIT    
$tabTable["gedit_01_droit"] = array(
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "page_id" => array("type" => "int", "dn" => "NOT NULL"),
  "droit_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["gedit_01_droit"]["pk_gedit_01_droit"] = "agent_id, page_id";

$tabIdx["gedit_01_droit"] = array(
  "geditdroit_agentid_fk" => "agent_id",
  "geditdroit_pageid_fk" => "page_id",
  );

$tabFk["gedit_01_droit"] = array(
  "fk_geditdroit_agentid" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_geditdroit_pageid" => array("ffk" => "page_id", "tpk" => "gedit_01_page", "fpk" => "page_id"),
  );

//   Table : GEDIT_01_TYPEBLOC                             
$tabTable["gedit_01_typebloc"] = array(
  "tb_id" => array("type" => "int", "dn" => "NOT NULL"),
  "atype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "tb_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["gedit_01_typebloc"]["pk_gedit_01_typebloc"] = "tb_id";

//   Table : GEDIT_01_BLOC                       
$tabTable["gedit_01_bloc"] = array(
  "bloc_id" => array("type" => "int", "dn" => "NOT NULL"),
  "page_id" => array("type" => "int", "dn" => ""),
  "tb_id" => array("type" => "int", "dn" => ""),
  "bloc_nom" => array("type" => "varchar(80)", "dn" => ""),
  "bloc_rang" => array("type" => "int", "dn" => ""),
  "bloc_une" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "bloc_colonne" => array("type" => "int", "dn" => ""),
  "bloc_lock" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "bloc_datecrea" => array("type" => "datetime", "dn" => ""),
  "agent_id_crea" => array("type" => "int", "dn" => "NOT NULL"),
  "bloc_datemaj" => array("type" => "datetime", "dn" => ""),
  "agent_id_maj" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_id" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "bloc_pere" => array("type" => "int", "dn" => ""),
  "bloc_arbre" => array("type" => "varchar(255)", "dn" => ""),
  "bloc_niveau" => array("type" => "int", "dn" => ""),
  "bloc_nom_fr" => array("type" => "varchar(255)", "dn" => ""),
  "bloc_nom_en" => array("type" => "varchar(255)", "dn" => ""),
  "bloc_typeassoc" => array("type" => "int", "dn" => "DEFAULT 0 "),
  "bloc_ordre"     => array("type" => "varchar(255)", "dn" => ""),
  "bloc_datedeb"   => array("type" => "datetime", "dn" => ""),
  "bloc_datefin"   => array("type" => "datetime", "dn" => ""),
  "bloc_desc"     => array("type" => "varchar(255)", "dn" => ""),
  "bloc_limit"   => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  );

$tabPk["gedit_01_bloc"]["bloc_pk"] = "bloc_id";

$tabIdx["gedit_01_bloc"] = array(
  "geditbloc_agentidc_fk" => "agent_id_crea",
  "geditbloc_agentidm_fk" => "agent_id_maj",
  "geditbloc_pageid_fk" => "page_id",
  "geditbloc_tbid_fk" => "tb_id",
  );

$tabFk["gedit_01_bloc"] = array(
  "fk_geditbloc_agentidc" => array("ffk" => "agent_id_crea", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_geditbloc_agentidm" => array("ffk" => "agent_id_maj", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_geditbloc_pageid" => array("ffk" => "page_id", "tpk" => "gedit_01_page", "fpk" => "page_id"),
  "fk_geditbloc_tbid" => array("ffk" => "tb_id", "tpk" => "gedit_01_typebloc", "fpk" => "tb_id"),
  );

$tabSeq["seq_gedit_01_bloc"] = "10";
 
//   Table : GEDIT_01_CONTENU                             
$tabTable["gedit_01_contenu"] = array(
  "contenu_id" => array("type" => "int", "dn" => "NOT NULL"),
  "bloc_id" => array("type" => "int", "dn" => "NOT NULL"),
  "contenu_fr" => array("type" => "text", "dn" => ""),
  "contenu_en" => array("type" => "text", "dn" => ""),
  );

$tabPk["gedit_01_contenu"]["pk_gedit_01_contenu"] = "contenu_id";

$tabIdx["gedit_01_contenu"] = array(
  "geditcontenu_blocid_fk" => "bloc_id",
  );

$tabFk["gedit_01_contenu"] = array(
  "fk_geditcontenu_blocid" => array("ffk" => "bloc_id", "tpk" => "gedit_01_bloc", "fpk" => "bloc_id"),
  );

$tabSeq["seq_gedit_01_contenu"] = "10";

//   Table : GEDIT_01_APPLI_BLOC
$tabTable["gedit_01_appli_bloc"] = array(
  "bloc_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["gedit_01_appli_bloc"]["pk_gedit_01_appli_bloc"] = "appli_id, bloc_id";

$tabIdx["gedit_01_appli_bloc"] = array(
  "geditapplibloc_appliid_fk" => "appli_id",
  "geditapplibloc_blocid_fk" => "bloc_id",
  );

$tabFk["gedit_01_appli_bloc"] = array(
  "fk_geditapplibloc_appliid" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  "fk_geditapplibloc_blocid" => array("ffk" => "bloc_id", "tpk" => "gedit_01_bloc", "fpk" => "bloc_id"),
  );

//   Table : GEDIT_01_STYLETYPE                                    
// STYLETYPE = {Document (blocs de titres), Page, Bloc, ...}
$tabTable["gedit_01_styletype"] = array(
  "styletype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "styletype_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  );

$tabPk["gedit_01_styletype"]["pk_gedit_01_styletype"] = "styletype_id";

/*
   Table : GEDIT_01_STYLE

  Permet la mise en page des blocs de titres (TB_ID=12) dans 
 un document ou dans une page ou individuellement, ... et ce
 par niveau                                   
 STYLE_ID : ID de l'élément auquel s'applique le style {doc_id, page_id, bloc_id, ...}
 STYLETYPE_ID : Type d'élément auquel on applique un style
 STYLE_NIVEAU : Niveau des blocs mis en page
*/
$tabTable["gedit_01_style"] = array(
  "style_id" => array("type" => "int", "dn" => "NOT NULL"),
  "styletype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "style_niveau" => array("type" => "int", "dn" => "NOT NULL"),
  "style_bold" => array("type" => "int", "dn" => "NOT NULL"),
  "style_italic" => array("type" => "int", "dn" => "NOT NULL"),
  "style_underline" => array("type" => "int", "dn" => "NOT NULL"),
  "style_smallcaps" => array("type" => "int", "dn" => "NOT NULL"),
  "style_ffamily" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "style_fsize" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "style_fcolor" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "style_halign" => array("type" => "varchar(80)", "dn" => ""),
  "style_typesection" => array("type" => "varchar(80)", "dn" => ""),
  "style_typenum" => array("type" => "varchar(80)", "dn" => ""),
  );

$tabPk["gedit_01_style"]["pk_gedit_01_style"] = "style_id, styletype_id, style_niveau";

$tabIdx["gedit_01_style"] = array(
  "geditstyle_styletypeid_fk" => "styletype_id",
  );

$tabFk["gedit_01_style"] = array(
  "fk_geditstyle_styletypeid" => array("ffk" => "styletype_id", "tpk" => "gedit_01_styletype", "fpk" => "styletype_id"),
  );

// table GEDIT_01_BLOC_RSS
$tabTable["gedit_01_bloc_rss"] = array(
  "rss_id" => array("type" => "int", "dn" => "NOT NULL"),
  "bloc_id" => array("type" => "int", "dn" => "NOT NULL"),
  "rss_titre_fr" => array("type" => "varchar(255)", "dn" => ""),
  "rss_titre_en" => array("type" => "varchar(255)", "dn" => ""),
  "rss_url" => array("type" => "varchar(255)", "dn" => ""),
  "rss_nb_elt_aff" => array("type" => "int", "dn" => "DEFAULT 1"),
  "rss_aff_detail" => array("type" => "int", "dn" => "DEFAULT 0"),
  "rss_aff_date" => array("type" => "int", "dn" => "DEFAULT 0"),
  "agent_id"    => array("type" => "int", "dn" => ""), 
);

$tabSeq["seq_gedit_01_bloc_rss"] = "10";

$tabPk["gedit_01_bloc_rss"]["pk_gedit_01_bloc_rss"] = "rss_id";

$tabIdx["gedit_01_bloc_rss"] = array(
  "geditblocrss_blocid_fk" => "bloc_id",
  );

$tabFk["gedit_01_bloc_rss"] = array(
  "fk_geditblocrss_blocid" => array("ffk" => "bloc_id", "tpk" => "gedit_01_bloc", "fpk" => "bloc_id"),
  "fk_gedit_01_bloc_rss_agent_id"  => array("ffk" => "AGENT_ID", "tpk" => "SIT_AGENT", "fpk" => "AGENT_ID")
);

// table GEDIT_01_TAGCLOUD
$tabTable["gedit_01_tagcloud"] = array(
  "tagcloud_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id"       => array("type" => "int", "dn" => "NOT NULL"),
  "tagcloud_mot"   => array("type" => "varchar(80)", "dn" => ""),
  "tagcloud_poids" => array("type" => "int", "dn" => "default 0 NOT NULL"),
);

$tabSeq["seq_gedit_01_tagcloud"] = "10";

$tabPk["gedit_01_tagcloud"]["pk_gedit_01_tagcloud"] = "tagcloud_id";

$tabIdx["gedit_01_appli_bloc"] = array(
  "gedittagcloud_appliid_fk" => "appli_id",
);

$tabFk["gedit_01_appli_bloc"] = array(
  "fk_gedittagcloud_appliid" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
);

// table GEDIT_01_SEARCH_STAT
$tabTable["gedit_01_search_stat"] = array(
  "sstat_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "sstat_mot"   => array("type" => "varchar(80)", "dn" => ""),
  "sstat_nb"    => array("type" => "int", "dn" => "NOT NULL"),
);

$tabSeq["seq_gedit_01_search_stat"] = "10";

$tabPk["gedit_01_search_stat"]["pk_gedit_01_search_stat"] = "sstat_id";

// table GEDIT_01_PAGE_LISTE (liaison uniquement avec les pages publiées)
$tabTable["gedit_01_page_liste"] = array(
  "page_id"     => array("type" => "int", "dn" => "NOT NULL"),
  "liste_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "msg_id"      => array("type" => "int", "dn" => "NOT NULL"),
  "abonnement"  => array("type" => "int", "dn" => "DEFAULT 0"),
);

$tabPk["gedit_01_page_liste"]["pk_gedit_01_page_liste"] = "page_id, liste_id, msg_id";

$tabIdx["gedit_01_page_liste"] = array(
  "geditpageliste_pageid_fk"  => "page_id",
  "geditpageliste_listeid_fk" => "liste_id",
  "geditpageliste_msgid_fk" => "msg_id",
  );

$tabFk["gedit_01_page_liste"] = array(
  "fk_geditpageliste_pageid"  => array("ffk" => "page_id", "tpk" => "gedit_01_page", "fpk" => "page_id"),
  "fk_geditpageliste_listeid" => array("ffk" => "liste_id", "tpk" => "sit_liste", "fpk" => "liste_id"),
  "fk_geditpageliste_msgid" => array("ffk" => "msg_id", "tpk" => "lsdif_msg", "fpk" => "msg_id"),
  );

//   Table : GEDIT_PJ                                    
$tabTable["gedit_pj"] = array(
  "pj_id" => array("type" => "int", "dn" => "NOT NULL"),
  "pj_champ" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "data_id" => array("type" => "int", "dn" => "NOT NULL"),
  "pj_name" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "pj_file" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "pj_type" => array("type" => "int", "dn" => ""),
  "pj_taille" => array("type" => "int", "dn" => "DEFAULT 0"),
  "pj_duration" => array("type" => "float", "dn" => ""),
  "pj_bitrate" => array("type" => "int", "dn" => ""),
  "pj_lang" => array("type" => "int", "dn" => "DEFAULT 1"),
  "pj_datecrea" => array("type" => "datetime", "dn" => ""),
  "pj_agentcrea" => array("type" => "int", "dn" => ""),
  "pj_datecreafile" => array("type" => "datetime", "dn" => ""),
  "pj_title" => array("type" => "varchar(64)", "dn" => ""),
  "pj_copyright" => array("type" => "varchar(128)", "dn" => ""),
  "pj_auteur" => array("type" => "varchar(32)", "dn" => ""),
  "pj_desc" => array("type" => "varchar(2000)", "dn" => ""),
  "pj_keywords" => array("type" => "varchar(64)", "dn" => ""),
  );
  
$tabPk["gedit_pj"]["pk_gedit_pj"] = "pj_id";

$tabIdx["gedit_pj"] = array(
  "geditpj_dataid_fk" => "data_id",
  "geditpj_pjagentcrea_fk" => "pj_agentcrea",
  );
  
$tabFk["gedit_pj"] = array(
  "fk_geditpj_dataid" => array("ffk" => "data_id", "tpk" => "gedit_01_page", "fpk" => "page_id"),
  );

// Types de style prédéfinis

$tabIns[] = "insert into GEDIT_01_STYLETYPE (STYLETYPE_ID, STYLETYPE_INTITULE) values (1, 'Document')"; 
$tabIns[] = "insert into GEDIT_01_STYLETYPE (STYLETYPE_ID, STYLETYPE_INTITULE) values (2, 'Page')";
$tabIns[] = "insert into GEDIT_01_STYLETYPE (STYLETYPE_ID, STYLETYPE_INTITULE) values (3, 'Bloc')";

$tabIns[] = "delete from GEDIT_01_TYPEBLOC";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (1,  20, 'Editorial')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (2,   8, 'Carto')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (3,   4, 'Document')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (4,  22, 'Lien')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (5,  26, 'Syndication')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (6,  27, 'Abonnement newsletter')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (7,  32, 'Formulaire')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (8,  33, 'Sondage')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (9,  21, 'Actualite')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (10, 41, 'Explorateur')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (11, 24, 'Glossaire')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (12, 47, 'Titre éditorial')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (13,  1, 'Annuaire économique')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (14, 52, 'Communiqué de presse')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (15, 25, 'Faqs/suggestion')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (16, 23, 'RSS')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (17, 55, 'Géo-localisation')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (18, 44, 'Forum')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (19, 95, 'Graphe')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (20, 97, 'Tâche')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (21, 88, 'Document Editorial')";
$tabIns[] = "insert into GEDIT_01_TYPEBLOC (TB_ID, ATYPE_ID, TB_INTITULE) values (22, 89, 'Evénement')";

$tabIns[] = "insert into SIT_APPLI (APPLI_ID, ATYPE_ID, APPLI_INTITULE, APPLI_RANG, AGENT_IDCREA, AGENT_IDMAJ, APPLI_DATECREA, APPLI_DATEMAJ)".
  " values (0, 23, 'Dossier de base', 0, 1, 1, ".$dbConn->getDateCur().", ".$dbConn->getDateCur().")";

$tabIns[] = "insert into GEDIT_01_PAGE (PAGE_ID, AGENT_ID_CREA, AGENT_ID_MAJ, PAGE_PARENT,PAGE_NIVEAU, PAGE_ARBRE, APPLI_ID)".
  " values (0, 1, 1, 0, 0, '-0-', 0)";

//  Type application
$tabIns[] = "INSERT INTO SIT_APPLI_TYPE (ATYPE_ID, ATYPE_ID_DIST, ATYPE_INTITULE, ATYPE_ABREV, ATYPE_URL, ATYPE_URL_ADMIN, ATYPE_URL_SITE,".
  " ATYPE_DROIT, ATYPE_DISPO, ATYPE_DESC, ATYPE_URL_TARGET, ATYPE_COMPATIBLE, ATYPE_LOGO, ATYPE_ADMIN_LOGO)".
  " VALUES (23, -1, 'Pages', 'gedit', '', '', NULL, 0, 1, '', '', 1, 'picto23_gedit.gif', '')";

// Type de page

$tabIns[] = "INSERT INTO GEDIT_01_APPLI_TYPE (ATYPE_ID) values (23)";

$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 0, 'Page éditoriale', '', 'Data|Page')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 1, 'Plan du site', '', 'Data|Map')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 2, 'Nous contacter', '', 'Data|Contact')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 3, 'Crédits', '', 'Data|Credit')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 4, 'Newsletter', '', 'Data|Newsletter')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 5, 'Rss', '', 'Data|Rss')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 6, 'Moteur de recherche', '', 'Data|Recherche')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (23, 7, 'Mobile', '', 'Data|Page')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) VALUES (23, 8, 'Webapp', '', 'Data|Page')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) VALUES (23, 9, 'Syndication', '', 'Data|Page')";

// ajouter ici car l'annuaire est créé au préalable
$tabIns[] = "INSERT INTO GEDIT_01_APPLI_TYPE (ATYPE_ID) values (1)";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (1, 0, 'Annuaire téléphonique', '', 'Data|AnnuTel')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (1, 1, 'Trombinoscope', '', 'Data|AnnuTrombi')";
$tabIns[] = "INSERT INTO GEDIT_01_PAGE_TYPE (ATYPE_ID, PTYPE_ID, PTYPE_INTITULE, PTYPE_DESC, PTYPE_SERVICENAME) values (1, 2, 'Annuaire', '', 'Data|Annuaire')";

// Vue
$tabView["v_gedit_user_right_page" ] = " (CONT_ID, APPLI_ID, USER_ID, PAGE_ID, RIGHT_ID) as
  select ac.CONT_ID, ac.APPLI_ID, agc.AGENT_ID as USER_ID, p.PAGE_ID, ".
  $dbConn->compareSql("p.ATYPE_ID", "=", "87", 
                      $dbConn->compareSql("agc.CONT_ADMIN", "=", "1",
                                          "4",
                                          "1"), 
                      "d.DROIT_ID")." as RIGHT_ID
  from GEDIT_01_DROIT d 
    inner join SIT_AGENT_CONT agc on agc.AGENT_ID=d.AGENT_ID
    inner join SIT_APPLI_CONT ac  on ac.CONT_ID=agc.CONT_ID
    inner join GEDIT_01_PAGE  p   on (p.PAGE_ID=d.PAGE_ID and (p.appli_id = ac.appli_id and p.atype_id <> 87 or (p.page_appliid = ac.appli_id or p.page_appliid = (-1)) and p.atype_id = 87))
  where p.PAGE_ID>0";

//  Constante PHP
$tabIns[] = "delete from SIT_CONSTANTE where ATYPE_ID=23";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (-1,-1,'ALK_B_ATYPE_GEDIT','true',3,'Module installé',0)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_CARTO','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs carto")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_LIEN','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs liens")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_FDOC','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs documents")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_SYND','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs syndication")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_LETTRE','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs formulaire d'abonnement")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_FORM','true',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs formulaires")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_SONDAGE','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs sondage")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_ACTU','true',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs actualités site")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
    " values (23,-1,'ALK_B_GEDIT_EVENT','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs évènements site")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_EXPLORER','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs explorer")."',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_GLOS','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs glossaires")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_COMMPRESS','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs communiqués de presse")."',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_FAQS','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs faqs")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_GEOLOC','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs geoloc")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_FORUM','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs forum")."',1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN, CONST_LEVEL)".
  " values (23,-1,'ALK_GEDIT_PATH_XSL','".$dbConn->analyseSql("ALK_ALKANET_ROOT_PATH.'styles/'")."',4,'Répertoire contenant les feuilles de style xsl',0,1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_REPERTOIRE_LIE','false',3, '".$dbConn->analyseSql("Possibilité d'associer un répertoire physique à une page editoriale")."', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_VISIBLE_MENU', 'false', 3, 'Possibilité de rendre la page visible dans le menu', 1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_GEDIT_TYPEUPDATE_EDITEUR', '1', 1, 'Type màj de bloc : éditeur', 0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_GEDIT_TYPEUPDATE_SELECTEDIT', '2', 1, 'Type màj de bloc : sélection par appli-thème-info', 0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_TYPEPUBLI', 'false', 3, 'Type de publication à la sélection de données aux blocs',1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE,  CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
    " VALUES (23,  -1, 'ALK_B_GEDIT_RSS', 'false', 'Possibilité de syndiquer au format rss2.0', 3, 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE,  CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
    " VALUES (23,  -1, 'ALK_B_GEDIT_REFINTERNET', 'false', 'Possibilité de personnaliser les entêtes pour le référencement Internet', 3, 1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE,  CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
    " VALUES (-1,  -1, 'ALK_B_GEDIT_BLOC_COLONNE', 'true', 'Gestion éditoriale des blocs en colonne', 3, 1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,  APPLI_ID, CONST_INTITULE,  CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
    " VALUES (-1,  -1, 'ALK_B_GEDIT_TAGCLOUD', 'false', 'Gestion du bloc nuage de mots clés', 3, 2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_RIGHT_BY_ANIM_ONLY','false',3,'".$dbConn->analyseSql("Possibilité de modifier les droits que si on est animateur", true)."',1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23, -1,'ALK_B_GEDIT_GRAPHE','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs graphes")."',1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23, -1,'ALK_B_GEDIT_TACHE','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs de type tâche")."',1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_ABONNEMENT','false',3,'".$dbConn->analyseSql("Possibilité d'abonnement sur les pages")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23,-1,'ALK_B_GEDIT_NOTIFICATION','false',3,'".$dbConn->analyseSql("Possibilité de notifier une action sur les pages")."',1)";
  
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (23, -1,'ALK_B_GEDIT_DOC','false',3,'".$dbConn->analyseSql("Possibilité d'inclure des blocs de type document éditorial")."',1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)".
  " VALUES (23, -1, 'ALK_B_GEDIT_CONSULT', 'false', 'Disponibilité de la consultation', 3, 1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_TYPE, CONST_LABEL, CONST_ADMIN)".
  " values (23, -1,'ALK_GEDIT_NB_VISUEL','1',1,'".$dbConn->analyseSql("Possibilité de définir le nombre maximum de visuels associables à une page, si égal à zéro, le composant se désactive, -1 pour aucune limite")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_TYPE, CONST_LABEL, CONST_ADMIN)".
  " values (23, -1,'ALK_GEDIT_NB_BANDEAU','1',1,'".$dbConn->analyseSql("Possibilité de définir le nombre maximum d'images de bandeau associables à une page, si égal à zéro, le composant se désactive, -1 pour aucune limite")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE, CONST_VALEUR, CONST_TYPE, CONST_LABEL, CONST_ADMIN)".
  " values (23, -1,'ALK_GEDIT_ALL_ADMIN_MOVE_PAGE','false',3,'".$dbConn->analyseSql("Si vrai, toutes personnes ayant les droits d'administration pourra modifier le rang d'une page, sinon seul les animateurs le peuvent")."',1)";

$tabIns[] = "INSERT INTO SIT_DATATYPE (DATATYPE_ID, ATYPE_ID, DATATYPE_INTITULE, TABLE_REF, TABLE_ALIAS," .
  " FIELD_PK, FIELDS_TEXT, SELECTING_WHERE, SELECT_APPLI_ID, SELECT_ATYPE_ID, APPLI_GEOLOC, APPLI_SEARCH, APPLI_MDATA, APPLI_STAT) " .
  " VALUES(26, 23, 'Page éditoriale', 'GEDIT_01_PAGE', 'gpage', 'PAGE_ID', 'PAGE_TITRE_FR|PAGE_TITRE_EN|PAGE_TITRE_PT|PAGE_TITRE_ES', " .
  " 'PAGE_ID in " .
  " (select p.PAGE_ID" .
  "  from GEDIT_01_PAGE p" .
  "   inner join V_GEDIT_USER_RIGHT_PAGE r on p.PAGE_ID=r.PAGE_ID" .
  "   where p.PAGE_VALIDEPUB=1 and p.PAGE_BROUILLON is null and r.RIGHT_ID>0".
  "   and p.APPLI_ID =_APPLI_ID_ and r.USER_ID=_USER_ID_) order by INTITULE',".
  " '__ALIAS__.APPLI_ID', 'atype.ATYPE_ID::inner join SIT_APPLI atype on (__ALIAS__.APPLI_ID=atype.APPLI_ID)', 0, 0, 0, 1)";

//   Mailing
$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES('GEDIT_ENVOYER_AMI', '".$dbConn->analyseSql("Mailing envoyer lors de l'utilisation par internaute de la fonctionnalité envoyer à un ami", false)."',".
  "'{\$apptitle} : {\$mail_sujet}',".
  " '".$dbConn->analyseSql("<html><p>Bonjour,<br/>{\$mail_exp} vous conseille de lire cet article <a href='{\$page_url}'>{\$page_url}</a></p>".
  "<p>Voici ci-dessous son message : </p><p>{\$mail_message}</p><p>{\$dest},<br/><br/>Le {\$date}.<br/>{\$apptitle} est accessible à l'adresse : <a href=\"{\$url_site}\">{\$url_site}</a><br/><br/>Cordialement.<br/>{\$exp}<br/><br/><i>ps:  Ce message est généré puis envoyé automatiquement par {\$apptitle}</i></p></html>", false)."', NULL)";
?>