<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_GEdit
 * @class AlkHtmlPopupUserList
 * @brief Classe affichant une popup de paramétrage d'un bloc Editorial
 */
class AlkhtmlPopupEditeur extends AlkHtmlForm {
  
    /** identifiant ou liste d'identifiant (séparateur pipe) caractérisant l'information concernée */
  protected $idEnt;

  /** nom de la table sql où est enregistré le contenu edit */
  protected $strTable;

  /** nom du champ sql recevant la donnée edit */
  protected $strChampHtml;

  /** nom du champ ou liste de nom de champ (séparateur pipe) correspondant à la clé primaire de strTable */
  protected $strChampId;

  /** chemin relatif du répertoire upload à partir de ALK_ALKANET_ROOT_[PATH|URL] */
  protected $strRepUpload;

  /** =0 par défaut, =1 si outil de formulaire */
  protected $iForm;

  /** =0 par défaut, =1 si reload de la page parente à la fermeture */
  protected $iReload;

  /** Type de toolbar affichée = normal =0, basique = 1 */
  protected $iBasicMenuBar;

  /** gcoedit : identifiant de l'appli chargée de faire les actions Pre et Post update bloc, =-1 par défaut */
  protected $post_appli_id;

  /** gcoedit : identifiant du bloc sur lequel se font les Pre et Post update bloc, =-1 par défaut */
  protected $bloc_id;

  /** ensemble des paramètres nécessaires à l'url de validation */
  protected $strParam;
  
  /** type de bloc **/
  protected $atypeIdBloc;
  
  protected $contenu;
  
  protected $bloc_colonne;
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formEditeur");
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");

    $this->idEnt         = AlkRequest::getToken("idEnt","-1");
    $this->strTable      = AlkRequest::getToken("table", "");
    $this->strChampHtml  = AlkRequest::getToken("champsHtml","");
    $this->strChampId    = AlkRequest::getToken("champsId", "");
    $this->strRepUpload  = AlkRequest::getToken("repUpload", "");
    $this->iReload       = AlkRequest::getToken("bReload",  0);
    $this->iForm         = AlkRequest::getToken("bForm", 0);
    $this->iBasicMenuBar = AlkRequest::getToken("bBasicMenuBar", 0);
    $this->post_appli_id = AlkRequest::getToken("post_appli_id", "-1");
    $this->bloc_id       = AlkRequest::getToken("bloc_id", "-1");
    $this->atypeIdBloc   = AlkRequest::getToken("atypeIdBloc", "-1");
        
    $this->strParam = "&idEnt=".$this->idEnt."&table=".$this->strTable.
      "&champsHtml=".$this->strChampHtml."&champsId=".$this->strChampId.
      "&repUpload=".$this->strRepUpload."&bReload=".$this->iReload."&bForm=".$this->iForm.
      "&bBasicMenuBar=".$this->iBasicMenuBar.
      "&post_appli_id=".$this->post_appli_id."&bloc_id=".
      $this->bloc_id."&atypeIdBloc=".$this->atypeIdBloc;
  }
  
  /**
   * Traitement 
   */
  public function doSql() 
  { 
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    // pas d'encodate pour l'instant
    $strTextHtml = AlkRequest::_REQUEST($this->strChampHtml, "");

    $strTextHtml = mb_ereg_replace("<p>", "", $strTextHtml);
    $strTextHtml = mb_ereg_replace("</p>", "", $strTextHtml);
   
    $strTextHtml = AlkRequest::decodeValue($strTextHtml);
    
    $oQueryActionEditeur = AlkFactory::getQueryAction(ALK_ATYPE_ID_EDITEUR);
    if ($oQueryActionEditeur !== null)
      $res = $oQueryActionEditeur->updateContenu($this->idEnt, $this->strTable, 
                                                 $this->strChampHtml, $strTextHtml, $this->strChampId); 
                                                 
    //enregistrement des attributs du bloc
    $tab_bloc_nom    = array();
    foreach($this->tabLangue as $key => $tabLg) {
      $tab_bloc_nom[$key] = AlkRequest::_POST("bloc_nom".$tabLg["bdd"], "");
    }
    $this->oAppli->oQueryAction->updateBlocColumn($this->bloc_id, $this->bloc_colonne->value, TASSOC_EMPTY, AlkFactory::getSProperty("user_id", -1), "", "", 
                                                      "", $tab_bloc_nom);
    
    /** gcoedit */
    if( defined("ALK_B_ATYPE_GCOEDIT") && ALK_B_ATYPE_GCOEDIT==true && $this->post_appli_id != "-1" ) {
      $oAppliGCoEdit = AlkFactory::getAppli(ALK_ATYPE_ID_GCOEDIT, $this->post_appli_id);
      $oRes = null;

      $strScript = $oAppliGCoEdit->CallServicePreUpdateBloc($oRes, $this->bloc_id, $user_id, true); 
    }
    
    if ($this->iReload==3){
       // fermeture de la popup avec rechargement ajax
       $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          "&iMode=10&bloc_id=".$this->bloc_id."&atypeIdBloc=".$this->atypeIdBloc.
                                          "&bloc_colonne=".$this->bloc_colonne->value);
       $strHtmlJs = "top.updateDataBloc('".$strToken."');";
       echo getBodyOnLoadExec($strHtmlJs);
    }else {
       //code permettant de fermer la popup tout en rappelant la page située en dessous
       // petite astuce avec onload et onunload pour laisser le temps à la page de charger
       echo getBodyOnLoadExec("",
                           "closeWindow(".( $this->iReload ==1 ? "'reload'" : "" ).")");
    }
    
    return "";
  }
  
  /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { 
    
    $tabMultilingue         = array();
    $this->contenu          = new AlkFormData($this, $this->strChampHtml, "", ALK_SQL_HTML_ENCODE); 
    $this->bloc_nom         = new AlkFormData($this, "bloc_nom",        $tabMultilingue,        ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->bloc_colonne     = new AlkFormData($this, "bloc_colonne",    "0",                    ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    // initialisation des propriétés par REQUEST ou DATAROW
    $tabData = null;
    $reqMethod = -1;
    $oDrData   = null;
    
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->getDsBlocById($this->bloc_id, -1, -1);
      $oDrData = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
    // Nettoyage
    $strContenu = "";
    $oQueryEditeur = AlkFactory::getQuery(ALK_ATYPE_ID_EDITEUR);
    if ($oQueryEditeur !== null)
      $strContenu = $oQueryEditeur->getContenu($this->idEnt, $this->strTable, $this->strChampHtml, $this->strChampId);
    $oHtmlCleaner = AlkFactory::getHtmlCleaner();
    $oHtmlCleaner->getCleanHtml($strContenu, false);
    $this->contenu->value = $strContenu;
    
  }
  
    /**
   * @brief Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmlpopupdataselect.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmlpopupediteur.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    
    $strPathFolder = ALK_ALKANET_ROOT_PATH.$this->strRepUpload;
    
    $iWidthSelect = 260;
    $user_id = AlkFactory::getSProperty("user_id", "-1"); 
    
    $oBlock = $this->addBlocNom($iWidthSelect);
    $oCtrlMemo = AlkHtmlFactory::getHtmlText($this->contenu, "", 90, 100);
    
    if (defined("ALK_B_GEDIT_BLOC_COLONNE") && ALK_B_GEDIT_BLOC_COLONNE) {
      $oCtrlCheckbox = AlkHtmlFactory::getHtmlCheckbox($this->bloc_colonne, _t("Affichage en colonne"));
      $oBlock->addCtrl($oCtrlCheckbox);
    } else {
      $oHide = AlKHtmlFactory::getHtmlHidden($this->bloc_colonne);
      $oBlock->addCtrl($oHide);
    }

    // ajout de l'éditeur
      if( !(@file_exists($strPathFolder) && @is_dir($strPathFolder)) ) {
        $bRes = @mkdir($strPathFolder, 0770);
        if( !$bRes ) {
          $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_GEDIT, true);
        } 
      } else {
        $strPathFolder = $this->strRepUpload;
      }
      
      $oCtrlMemo->setEditor(true);
      $oCtrlMemo->setParamEditor("openPopup", false);
      $oCtrlMemo->setParamEditor($this->strChampId, $this->idEnt);
      $oCtrlMemo->setParamEditor("tableName", $this->strTable);
      $oCtrlMemo->setParamEditor("fieldPk", $this->strChampId);
      $oCtrlMemo->setParamEditor("userForm", false);
      $oCtrlMemo->setParamEditor("lg", ALK_LG_REP);
      $oCtrlMemo->setParamEditor("pathUpload", $strPathFolder);
      $oCtrlMemo->setParamEditor("tokenStart", "cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id);
      $oCtrlMemo->setParamEditor("styleCss", ( ALK_EDITEUR_CSS != "" ? ALK_EDITEUR_CSS : "editeur.css"));
      $oCtrlMemo->setParamEditor("bodyId", ( defined("ALK_EDITEUR_BODYID") ? ALK_EDITEUR_BODYID : "" ));
      $oCtrlMemo->setParamEditor("toolbarSet", "Full");
     
      
    $oBlock->addCtrl(AlkHtmlFactory::getHtml("<div style='height:5px;'></div>"), ALK_HTMLFORM_1L1C); 
    $oBlock->addCtrl($oCtrlMemo, ALK_HTMLFORM_1L1C);  
    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, $this->strParam);
    
    $oButton = $this->addButtonPage("btValid", "javascript:Validation('".$this->getName()."','".ALK_ALKANET_SQL."?token=".$strToken."')", _t("Valider"), _t("Valider"));
    $this->addSubmitButton($oButton);
    
    $this->addButtonPage("btPublier", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
      
    $this->addVarJs("ALK_B_EDITEUR_CKEDITOR", "true");   
  }
  
  /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return "Editeur";
  }
  
    /**
   * fabrique le bloc des informations attributaires du bloc
   */
  public function addBlocNom($iWidthSelect){
    $iWidthLabel = "130";
    $strDesc     = "";
    $tabTitle = array();
    $oCtrlSelect = null;
        
    $cont_id = AlkRequest::getToken("cont_id", -1);
    $tabTitle = array();
    if (isset($GLOBALS["tabBlocTitle".$cont_id])){
      $tabTitle = $GLOBALS["tabBlocTitle".$cont_id];
    } elseif (isset($GLOBALS["tabBlocTitle"])){
      $tabTitle = $GLOBALS["tabBlocTitle"];
    }
    
    if (!empty($tabTitle)){
      $strDesc = "Vous avez la possibilité de choisir un nom dans la liste des noms prédéfinis";
          // ajout d'un champ combo qui contient la liste des blocs prédéfinis
      $oCtrlSelect = AlkHtmlFactory::getNewHtmlSelect($this, "0", "title", -1, "Noms prédéfinis", 1, $iWidthSelect+28);
      $tabResTitle = array();
      foreach ($tabTitle as $title){
        $tabResTitle[$title]=$title;
      }
      $oCtrlSelect->setProperty("tabValTxt", $tabResTitle);
      
      $oCtrlSelect->addEvent("onchange", "fillBlocNom('".$this->getName()."')");
    }
    $oBlock = $this->addBlock("blockNom", _t("Informations sur le bloc"), $strDesc, $iWidthLabel, $iWidthSelect+220, true);
    
    if ( !is_null($oCtrlSelect)){
      $oBlock->addCtrl($oCtrlSelect);
    }
    $this->addVarJs("tabTitle", json_encode($tabTitle));
    $this->addOnload("initCompletion()");
            
    $blocNom = AlkHtmlFactory::getHtmlText($this->bloc_nom, "Nom", 1, 44, 255);
    $blocNom->addValidator(ALK_VERIF_TEXT);
    $oBlock->addCtrl($blocNom);
    
    return $oBlock;
  }
}
?>