<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_GEdit
 * @class AlkHtmlPopupRss
 * Classe de modification d'un block de type rss
 */
class AlkHtmlPopupRss extends AlkHtmlForm 
{
  
  protected $cont_id_filter;
  protected $appli_id_filter;
  protected $rss_id_filter;
  
  protected $rss_id;
  protected $bloc_id;
  protected $bloc_colonne;
  protected $rss_titre;
  protected $rss_url;
  protected $rss_nb_elt_aff;
  protected $rss_aff_detail;
  protected $rss_aff_date;
  protected $close;
  
  /**
   * Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formRss");
    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=".ALK_FORM_MODE_UPDATE);
    $this->close = AlkRequest::_GET("close", "");
    $strAction = ALK_ALKANET_SQL."?token=".$strToken."&close=".$this->close;
        
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, $strAction);
  }

  /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit)
  { 
    $bloc_id = AlkRequest::getToken("bloc_id", AlkRequest::_GETint("bloc_id", "-1"));
    $cont_id_filter  = AlkRequest::_POSTint("cont_id_filter", AlkRequest::getToken("cont_id", "-1"));

    $this->cont_id_filter  = new AlkFormData($this, "cont_id_filter", $cont_id_filter, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->appli_id_filter = new AlkFormData($this, "appli_id_filter", "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rss_id_filter   = new AlkFormData($this, "rss_id_filter", "", ALK_SQL_TEXT);
    $this->rss_id         = new AlkFormData($this, "rss_id", "-1", ALK_SQL_NUMBER);
    $this->bloc_id        = new AlkFormData($this, "bloc_id", $bloc_id, ALK_SQL_NUMBER);
    $this->bloc_colonne   = new AlkFormData($this, "bloc_colonne", "0", ALK_SQL_NUMBER);
    $this->rss_titre      = new AlkFormData($this, "rss_titre", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    $this->rss_url        = new AlkFormData($this, "rss_url", "", ALK_SQL_TEXT);
    $this->rss_nb_elt_aff = new AlkFormData($this, "rss_nb_elt_aff", "8", ALK_SQL_NUMBER);
    $this->rss_aff_detail = new AlkFormData($this, "rss_aff_detail", "0", ALK_SQL_NUMBER);
    $this->rss_aff_date   = new AlkFormData($this, "rss_aff_date", "0", ALK_SQL_NUMBER);
    
    $tabData = array(null);
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->getDsRssByBlocId($bloc_id);
      $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
    
    if(mb_strpos($this->rss_url->value, ALK_ALKANET_RSS)!==false) {
      // url interne, retrouver cont_id et appli_id
      $old_token = $_REQUEST["token"];
      $token = mb_ereg_replace(".*token=([^&]*).*", "\\1", $this->rss_url->value);
      // recuperer les variables du token du RSS
      $_REQUEST["token"] = $token;
      AlkRequest::readToken();
      
      $cont_id  = AlkRequest::getToken("cont_id", $cont_id_filter);
      $datatype = AlkRequest::getToken("datatype_id", "-1");
      $user_id = AlkFactory::getSProperty("user_id", "-1");
      $appli_id = $this->oAppli->oQuery->getAppliIdBySpaceByDatatype($user_id, $cont_id, $datatype);
      
      $this->cont_id_filter->value = $cont_id;
      $this->appli_id_filter->value = $appli_id;
      
      // remettre en place l'ancien token
      $_REQUEST["token"] = $old_token;
      AlkRequest::readToken();
      
      // affecter le rss interne
      $this->rss_id_filter->value = $this->rss_url->value;
      // vide adresse externe
      $this->rss_url->value = "";
    }
  }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  { 
    $this->setData(ALK_INIT_MODE_REQUEST);
        
    // sélection de l'url (si externe est donnée, c'est cette dernière qui est enregistrée)
    if($this->rss_id_filter->value!=-1) $this->rss_url->value = $this->rss_id_filter->value;
    
    $tabQueryRss = $this->getTabQuery(array("RSS_ID"), 
                                      array("CONT_ID_FILTER", "APPLI_ID_FILTER", "RSS_ID_FILTER", "BLOC_ID", "BLOC_COLONNE"));
    $tabQueryBloc = $this->getTabQuery(array("BLOC_ID"), 
                                       array("CONT_ID_FILTER", "APPLI_ID_FILTER", "RSS_ID_FILTER", "RSS_ID", "RSS_TITRE", 
                                             "RSS_URL", "RSS_NB_ELT_AFF", "RSS_AFF_DETAIL", "RSS_AFF_DATE"));
    switch( $this->iMode ) {
      case ALK_FORM_MODE_UPDATE:
        $this->oAppli->oQueryAction->updateRss($tabQueryRss, $tabQueryBloc);
        break;
    }
    
    if ($this->close=="ok"){
       echo getBodyOnLoadExec("closeWindow('reload')");
    } else {
    
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                        "&iMode=10&bloc_id=".$this->bloc_id->value."&bloc_colonne=".$this->bloc_colonne->value.
                                        "&atypeIdBloc=".ALK_ATYPE_ID_GEDIT."&bloc_typeassoc=0");
      $strHtmlJs = "top.updateDataBloc('".$strToken."');";
      echo getBodyOnLoadExec($strHtmlJs);
    
     return "";
    }
  }
      
  /**
   * @brief Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return "<img class='alkimgicon alkimgicondocrss' src='".ALK_MEDIA_URL."images/transp.gif' border='0' valign='absmiddle'/>&nbsp;Edition d'un flux RSS";
  }
  
  /**
   * Retourne le code JS d'un retour Ajax
   * @param iMode
   */
  public function getPanelAjax($iMode)
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $user_right = AlkFactory::getSProperty("user_right", "0");
    $atypeIdAppli = AlkFactory::getMasterATypeId(ALK_ATYPE_ID_GEDIT);
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    
    switch($iMode) {
      case 4: // appli
        
        $cont_id_filter = AlkRequest::_GETint("idc", "-1");

        // liste des appli de l'espace de type sélectionné
        $strJsHtml = " var tabOptionsA = new Array();";
        $dsAppli = $oQueryEspace->getDsListAppliBySpaceByATypeIdForCombo($user_id, $cont_id_filter, $atypeIdAppli);
        $nbElt = $dsAppli->getCountTotDr();
        if( $nbElt > 0 ) { 
          $strJsHtml .= " tabOptionsA[tabOptionsA.length] = new Array('-1', ' "._t("Sélectionnez une application")."');";
        } else {
          $strJsHtml .= " tabOptionsA[tabOptionsA.length] = new Array('-1', ' "._t("Aucune accessible dans cet espace")."');";
        }
        while( $drAppli = $dsAppli->getRowIter() ) {
          $idAppli  = $drAppli->getValueName("APPLI_ID");
          $strAppli = $drAppli->getValueName("APPLI_INTITULE");
          $strAppli = addslashes(mb_ereg_replace('"', '', $strAppli));
          $strJsHtml .= " tabOptionsA[tabOptionsA.length] = new Array('".$idAppli."', '".$strAppli."');";
        }
  
        // liste des flux RSS de l'appli
        $strJsHtml .= " var tabOptionsR = new Array();";
        if( $nbElt > 0 ) { 
          $strJsHtml .= " tabOptionsR[tabOptionsR.length] = new Array('-1', ' "._t("Sélectionnez une application")."');";
        } else {
          $strJsHtml .= " tabOptionsR[tabOptionsR.length] = new Array('-1', ' "._t("Aucune accessible dans cette application")."');";
        }
        
        echo $strJsHtml; 
        
        break;
      case 5: // flux rss
        
        $cont_id_filter = AlkRequest::_GETint("idc", "-1");
        $appli_id_filter = AlkRequest::_GETint("ida", "-1");
        $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
        
        // liste des flux RSS de l'appli
        $strJsHtml = " var tabOptionsA = null;";
        $strJsHtml .= " var tabOptionsR = new Array(); ";
        $strJsHtml .= " tabOptionsR[tabOptionsR.length] = new Array('-1', '".t_("Aucune")."');";

        $oAppli = AlkFactory::getAppli($oQueryEspace->getATypeID($appli_id_filter), $appli_id_filter);
        if(!is_null($oAppli) && method_exists($oAppli->oQuery, "getDsDatatypeByAppli")) {
        
          $dsDataType = $oAppli->oQuery->getDsDatatypeByAppli($appli_id_filter, true);
          while( $drDataType = $dsDataType->getRowIter() ) {
            $countData = $drDataType->getValueName("COUNT_DATA");
            $datatype_id = $drDataType->getValueName("DATATYPE_ID");
            if( !(defined("ALK_SATYPE_ABREV_".$datatype_id) && defined("ALK_B_ATYPE_".mb_strtoupper(constant("ALK_SATYPE_ABREV_".$datatype_id)))) ||
                $datatype_id == ALK_ATYPE_ID_RDV )
              continue;
              
            $datatype_intitule = $drDataType->getValueName(AlkFactory::getDBCurrentLanguageField("DATATYPE_INTITULE"));
            
            $strTokenPub = $oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RSS, ALK_SHEET_NONE, "&datatype_id=".$datatype_id."&data_id=-2&pub=1");
            $strTokenValid = $oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RSS, ALK_SHEET_NONE, "&datatype_id=".$datatype_id."&data_id=-2&pub=0&user_id=".$user_id);
            
            $strUrlRssPub   = ALK_ALKANET_RSS."?token=".$strTokenPub;
            $strUrlRssValid = ALK_ALKANET_RSS."?token=".$strTokenValid;
            
            $strTxtPub = addslashes(mb_ereg_replace('"', '', _f("Toutes les informations publiées de type %s", $datatype_intitule)));
            $strTxtAValid = addslashes(mb_ereg_replace('"', '', _f("Toutes les informations à valider de type %s", $datatype_intitule)));
            $strJsHtml .= " tabOptionsR[tabOptionsR.length] = new Array('".$strUrlRssPub."', '".$strTxtPub."');";
            if($user_right == ALK_APPLI_RIGHT_PUBLI)
              $strJsHtml .= " tabOptionsR[tabOptionsR.length] = new Array('".$strUrlRssValid."', '".$strTxtAValid."');";
          }
          
        }
        echo $strJsHtml;
        
        break;
    }
    return "";
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    
    $iWidthSelect = 290;
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $user_right = AlkFactory::getSProperty("user_right", "0");
    $atypeIdAppli = AlkFactory::getMasterATypeId(ALK_ATYPE_ID_GEDIT);
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    
    $this->addCtrl(AlkHtmlFactory::getHtmlHidden($this->rss_id));
    $this->addCtrl(AlkHtmlFactory::getHtmlHidden($this->bloc_id));
    
    // creation des blocs
    $oBlockCol = $this->addBlock("blockCol", "", "", 210, 280);
    $oBlockOpt = $this->addBlock("blockOpt", "", "", 210, 280);
    $oBlockRss = $this->addBlock("blockRss", "", "", 210, 280);
    $oBlockPub = $this->addBlock("blockPub", "Liste des flux RSS disponibles", "", 210, 280);
    
    $oCbCol = AlkHtmlFactory::getHtmlCheckbox($this->bloc_colonne, _t("Affichage en colonne"));
    
    $oTitreFr = AlkHtmlFactory::getHtmlText($this->rss_titre, _t("Titre"), 1, 32, 255);
    $oUrl = AlkHtmlFactory::getHtmlText($this->rss_url, _t("Adresse externe"), 1, 39, 255);
    
    // selectionne les espaces accessibles contenant des applis de type atypeIdAppli
    $oCtrlSelectSpace = AlkHtmlFactory::getHtmlSelect($this->cont_id_filter, _t("Espace"), 1, $iWidthSelect);
    $oCtrlSelectSpace->setProperty("oValTxt", $oQueryEspace->getDsListSpaceByATypeIdForCombo($user_id, $atypeIdAppli));
    $strTokenCombo = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_RSS, ALK_SHEET_NONE, "&iMode=4");
    $oCtrlSelectSpace->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");

    // sélectionne les applis de type atypeIdAppli accessibles de l'espace sélectionné
    $cont_id_filter = $this->cont_id_filter->value;
    $oCtrlSelectAppli = AlkHtmlFactory::getHtmlSelect($this->appli_id_filter, _t("Application"), 1, $iWidthSelect);
    $oCtrlSelectAppli->setProperty("tabValTxtDefault", array("-1", _t(" Sélectionnez une application")));
    $bShow = ( $cont_id_filter != "-1" );
    if( $bShow ) {
      $oCtrlSelectAppli->setProperty("oValTxt", $oQueryEspace->getDsListAppliBySpaceForCombo($user_id,$cont_id_filter));
    }
    $strTokenCombo = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_RSS, ALK_SHEET_NONE, "&iMode=5");
    $oCtrlSelectAppli->AddEvent("onchange", "onChangeCombo('".$strTokenCombo."')");
    
    // affiche les flux rss de l'appli
    $oCtrlSelectRss = AlkHtmlFactory::getHtmlSelect($this->rss_id_filter, _t("Adresse Interne"), 1, $iWidthSelect);
    $tabValTxt = array();
    
    $oAppli = AlkFactory::getAppli($oQueryEspace->getATypeID($this->appli_id_filter->value), $this->appli_id_filter->value);
    if(!is_null($oAppli) && method_exists($oAppli->oQuery, "getDsDatatypeByAppli")) {
      
      $dsDataType = $oAppli->oQuery->getDsDatatypeByAppli($this->appli_id_filter->value, true);
      while ( $drDataType = $dsDataType->getRowIter() ) {
        $countData = $drDataType->getValueName("COUNT_DATA");
        $datatype_id = $drDataType->getValueName("DATATYPE_ID");
        if( !(defined("ALK_SATYPE_ABREV_".$datatype_id) && defined("ALK_B_ATYPE_".mb_strtoupper(constant("ALK_SATYPE_ABREV_".$datatype_id)))) ||
            $datatype_id == ALK_ATYPE_ID_RDV )
          continue;
          
        $datatype_intitule = $drDataType->getValueName(AlkFactory::getDBCurrentLanguageField("DATATYPE_INTITULE"));
        
        $strTokenPub = $oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RSS, ALK_SHEET_NONE, "&datatype_id=".$datatype_id."&data_id=-2&pub=1");
        $strTokenValid = $oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RSS, ALK_SHEET_NONE, "&datatype_id=".$datatype_id."&data_id=-2&pub=0&user_id=".$user_id);
        
        $strUrlRssPub   = ALK_ALKANET_RSS."?token=".$strTokenPub;
        $strUrlRssValid = ALK_ALKANET_RSS."?token=".$strTokenValid;
        
        $tabValTxt[$strUrlRssPub] = _f("Toutes les informations de type %s", $datatype_intitule);
        if($user_right == ALK_APPLI_RIGHT_PUBLI)
          $tabValTxt[$strUrlRssValid] = _f("Toutes les informations de type %s", $datatype_intitule);
      }
      
    }
    $oCtrlSelectRss->setProperty("tabValTxtDefault", array("-1", _t("Aucune")));
    $oCtrlSelectRss->setProperty("tabValTxt", $tabValTxt);
    
    // options    
    $oNbEltAff = AlkHtmlFactory::getHtmlSelect($this->rss_nb_elt_aff, _t("Nombre d'éléments à afficher"));
    $tabValTxt = array();
    for($i=1; $i<=10; $i++) $tabValTxt[$i] = $i;
    $tabValTxt[15] = 15; $tabValTxt[20] = 20; $tabValTxt[30] = 30; $tabValTxt[50] = 50;  
    $oNbEltAff->setProperty("tabValTxt", $tabValTxt);
    $oCbDetail = AlkHtmlFactory::getHtmlCheckbox($this->rss_aff_detail, _t("Affichage détaillé"));
    $oCbDate = AlkHtmlFactory::getHtmlCheckbox($this->rss_aff_date, _t("Afficher la date"));
    
    // ajout des controles
    $oBlockCol->addCtrl($oCbCol);
    
    $oBlockRss->addCtrl($oUrl);
    $oBlockRss->addCtrl(AlkHtmlFactory::getHtml("ou", ""));
    $oBlockRss->addCtrl($oCtrlSelectSpace);
    $oBlockRss->addCtrl($oCtrlSelectAppli);
    $oBlockRss->addCtrl($oCtrlSelectRss);
    
    $oBlockOpt->addCtrl($oTitreFr);
    $oBlockOpt->addCtrl($oNbEltAff);
    $oBlockOpt->addCtrl($oCbDetail);
    $oBlockOpt->addCtrl($oCbDate);
    
    $this->addValidButton();
    //$this->addCancelButton(ALK_TYPESHEET_ADMIN, ALK_SHEET_FORM, ALK_SHEET_NONE, "");
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmlpopuprss.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
  }


}

?>