<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkHtmlFormLsDifForm
 * Classe permettant de gérer l'onglet écriture de la liste de diffusion
 */
class AlkHtmlFormLsDifForm extends AlkHtmlForm
{
  /** affiche/masque la case à cocher de publication du message dans la boîte des messages publics envoyés */
  protected $bShowCbMsgPublic;
  
  /** Ctrl de formulaire */
  protected $msg_id;
  protected $msg_nomfrom;        
  protected $msg_idfrom;      
  protected $msg_nomreply;        
  protected $msg_idreply;      
  protected $msg_group;            
  protected $msg_sujet;        
  protected $msg_message;         
  protected $msg_public;
  protected $liste_id;
  protected $mailEnr;          
  protected $mailListe;        
  protected $mailListes;       
  protected $mailFjA;           
  protected $mailFjB;          
  protected $mailFjC;
  protected $msg_type;
  protected $msg_template;
  protected $gedit_cont_id;
  protected $gedit_appli_id;           
  protected $page_id;
  protected $langue_id;

  protected $tab_listes;
  protected $msg_pj;
  protected $atype_id_src; // atype id de l'application appelante
  protected $data_id; // identifiant de la donnée objet  de notification (exple : page_id, data_id)
 
 
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formMail");

    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, "");
    
    $this->bShowCbMsgPublic = true;
    
    $this->bNotification = AlkRequest::getToken("bNotification", AlkRequest::_REQUESTint("bNotification", "0"));
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {
    $oQueryAnnu   = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);

    $user_id   = AlkFactory::GetSProperty("user_id", "-1");
    $user_name = AlkFactory::getSProperty("user_name", "");
    $iMode     = AlkRequest::_GETint("iMode", "1");
    
    $msg_id = AlkRequest::getToken("msg_id", AlkRequest::_REQUEST("msg_id", -1));
    $this->msg_id           = new AlkFormData($this, "msg_id",            $msg_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->liste_id         = new AlkFormData($this, "liste_id",             "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC ); 
    $this->msg_idfrom       = new AlkFormData($this, "msg_idfrom",       $user_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC ); 
    $this->msg_nomfrom      = new AlkFormData($this, "msg_nomfrom",    $user_name, ALK_SQL_TEXT );
    $this->msg_idreply      = new AlkFormData($this, "msg_idreply",      $user_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC ); 
    $this->msg_nomreply     = new AlkFormData($this, "msg_nomreply",   $user_name, ALK_SQL_TEXT );
    $this->msg_noreply      = new AlkFormData($this, "msg_noreply",           "0", ALK_SQL_NONE, ALK_VERIF_NUMERIC );
    $this->msg_group        = new AlkFormData($this, "msg_group",             "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC); 
    $this->msg_sujet        = new AlkFormData($this, "msg_sujet",              "", ALK_SQL_TEXT); 
    $this->msg_message      = new AlkFormData($this, "msg_message",            "", ( defined("ALK_B_LSDIF_EDITOR_LONGDESC") && ALK_B_LSDIF_EDITOR_LONGDESC==true ? ALK_SQL_HTML_ENCODE : ALK_SQL_TEXT)); 
    $this->msg_public       = new AlkFormData($this, "msg_public",            "0", ALK_SQL_TEXT);
    $this->msg_type         = new AlkFormData($this, "msg_type",              "0", ALK_SQL_TEXT); 
    $this->page_id          = new AlkFormData($this, "page_id",               "0", ALK_SQL_TEXT);    

    $this->mailListe         = new AlkFormData($this, "mailListe",            "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC ); 
    $this->mailListes        = new AlkFormData($this, "mailListes[]",      array(), ALK_SQL_TEXT); 

    $this->mailEnr           = new AlkFormData($this, "mailEnr",      "1", ALK_SQL_TEXT); 
    $this->mailFjA           = new AlkFormData($this, "mailFjA",      "", ALK_SQL_TEXT); 
    $this->mailFjB           = new AlkFormData($this, "mailFjB",      "", ALK_SQL_TEXT);     
    $this->mailFjC           = new AlkFormData($this, "mailFjC",      "", ALK_SQL_TEXT); 

    $eventTitle = urldecode(AlkRequest::getToken("eventTitle", AlkRequest::_REQUEST("eventTitle", "")));
    $eventDesc  = urldecode(AlkRequest::getToken("eventDesc", AlkRequest::_REQUEST("eventDesc", "")));
    $datedeb    = urldecode(AlkRequest::getToken("datedeb", AlkRequest::_REQUEST("datedeb", "")));
    $heuredeb   = urldecode(AlkRequest::getToken("heuredeb", AlkRequest::_REQUEST("heuredeb", "")));
    $datefin    = urldecode(AlkRequest::getToken("datefin", AlkRequest::_REQUEST("datefin", "")));
    $heurefin   = urldecode(AlkRequest::getToken("heurefin", AlkRequest::_REQUEST("heurefin", "")));
    $timerappel = urldecode(AlkRequest::getToken("timerappel", AlkRequest::_REQUEST("timerappel", "")));
    $this->eventTitle        = new AlkFormData($this, "eventTitle", $eventTitle, ALK_SQL_TEXT);
    $this->eventDesc         = new AlkFormData($this, "eventDesc",   $eventDesc, ALK_SQL_TEXT);
    $this->datedeb           = new AlkFormData($this, "datedeb",       $datedeb, ALK_SQL_TEXT);
    $this->heuredeb          = new AlkFormData($this, "heuredeb",     $heuredeb, ALK_SQL_TEXT);
    $this->datefin           = new AlkFormData($this, "datefin",       $datefin, ALK_SQL_TEXT);
    $this->heurefin          = new AlkFormData($this, "heurefin",     $heurefin, ALK_SQL_TEXT);
    $this->timerappel        = new AlkFormData($this, "timerappel", $timerappel, ALK_SQL_TEXT);
    
    $this->msg_type          = new AlkFormData($this, "msg_type",        "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->page_id           = new AlkFormData($this, "page_id",        "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC );
    $this->msg_template      = new AlkFormData($this, "msg_template",   "-1", ALK_SQL_NONE, ALK_VERIF_NUMERIC );
    $this->gedit_cont_id     = new AlkFormData($this, "gedit_cont_id",  "-1", ALK_SQL_NONE, ALK_VERIF_NUMERIC );
    $this->gedit_appli_id    = new AlkFormData($this, "gedit_appli_id", "-1", ALK_SQL_NONE, ALK_VERIF_NUMERIC );
    $this->langue_id         = new AlkFormData($this, "langue_id",       "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    $this->strFunctionJsAfter = urldecode(AlkRequest::getToken("strFunctionJsAfter", AlkRequest::_REQUEST("strFunctionJsAfter", "NothingToDo()")));
    
    //$strAbonneIdInclude = urldecode(AlkRequest::getToken("strAbonneIdInclude", AlkRequest::_REQUEST("strAbonneIdInclude", "")));
    //$this->strAbonneIdInclude  = new AlkFormData($this, "strAbonneIdInclude", $strAbonneIdInclude, ALK_SQL_TEXT);
    
    $atype_id_src = urldecode(AlkRequest::getToken("atype_id", AlkRequest::_REQUEST("atype_id", "")));
    $data_id      = urldecode(AlkRequest::getToken("data_id", AlkRequest::_REQUEST("data_id", "-1")));
    
    $this->atype_id_src    = new AlkFormData($this, "atype_id_src", $atype_id_src, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->data_id         = new AlkFormData($this, "data_id", $data_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    // on récupère la liste des abonnés
    $dsAbonnes = null;
    $tabAbonneIdInclude = array();
    if ($this->atype_id_src != ""){
      $oAppliSrc = AlkFactory::getAppli($atype_id_src);
      if ( !is_null($oAppliSrc) && method_exists($oAppliSrc, "getAbonneCanReadData")){
        $dsAbonnes = $oAppliSrc->getAbonneCanReadData($data_id);
        while ( $oDrAbonneId = $dsAbonnes->getRowIter() ) {
          $tabAbonneIdInclude[] = $oDrAbonneId->getValueName("ABONNE_ID");
        }
      }
    }
    $this->strAbonneIdInclude  = new AlkFormData($this, "strAbonneIdInclude", implode("|", $tabAbonneIdInclude), ALK_SQL_TEXT);
    
    // initialisation des propriétés par REQUEST ou DATAROW
    $tabData = null;
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {

      $oDsData = $this->oAppli->oQuery->getDsFicheMessage($msg_id);
      $oDrData = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
      
      if ( $oDrData ) {
        $this->msg_pj = $oDrData->getValueName("MSG_PJ"); 
      }
      
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
    //epurer le message
    $strCorps = html_entity_decode($this->msg_message->value);
    $this->msg_message->value = $strCorps;
    
    if( $this->page_id->value == "" ) {
      $this->page_id->value = "-1";
    }
    if( $this->msg_type->value == "3" ) {
      $this->msg_message->value = "";
    }
    if ( $this->bNotification ) {
      $tabInfo = AlkRequest::_REQUEST("tabInfo", array());
      foreach ( $tabInfo as $infoTitle => $infoValue ) {
        $this->msg_message->value.= ( !is_numeric(urldecode($infoTitle)) ? urldecode($infoTitle)." : " : "" ).urldecode($infoValue).( defined("ALK_B_LSDIF_EDITOR_LONGDESC") && ALK_B_LSDIF_EDITOR_LONGDESC ? "<br/>" : "\n" );
      }
    }
    
    // traitement des pièces jointes
    if($this->msg_pj !="||" && $this->msg_pj !=""){
      $tabFilePj = explode("|", $this->msg_pj);
      $i=0;
      foreach ($tabFilePj as $file){
        $i++;
        if( $i==1 ) {
          $this->mailFjA->value = $file;
        } else if( $i==2 ) {
          $this->mailFjB->value = $file;
        } else {
          // i = 3
          $this->mailFjC->value = $file;
        }
      }
    }
  }

  /**
   * Traitement du formulaire
   */
  public function doSql() 
  { 
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    switch( $this->iMode ) {
      
    case "4": // chargement du template sélectionné
      $msg_id    = AlkRequest::_GETint("mid", "-1");
      $dsMsg = $this->oAppli->oQuery->getDsFicheMessage($msg_id);
      if( $drMsg = $dsMsg->getRowIter() ) {
        $tabRes["msg_public"]  = $drMsg->getValueName("MSG_PUBLIC");
        $tabRes["msg_sujet"]   = $drMsg->getValueName("MSG_SUJET");
        $tabRes["msg_message"] = html_entity_decode($drMsg->getValueName("MSG_MESSAGE")); 
        $tabRes["msg_pj"]      = $drMsg->getValueName("MSG_PJ");
        $tabRes["msg_group"]   = $drMsg->getValueName("MSG_GROUP");

        $tabRes["tabFile"] = array_fill(0, 3, array("url" => "", "text" => ""));
        
        $msg_pj = $drMsg->getValueName("MSG_PJ");
        $tabPj = explode("|", $msg_pj);
        for($i=0; $i<count($tabPj); $i++) {
          $tabRes["tabFile"][$i]["url"]  = $tabPj[$i];
          $tabRes["tabFile"][$i]["text"] = $tabPj[$i];
        }
        
        echo json_encode($tabRes);
      } 
      break;
      
    case "5": // chargement de la liste des applis gedit de l'espace sélectionné
      $cont_id = AlkRequest::_GETint("cid", "-1");
      $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $oDsAppli = $oQueryEspace->getDsListAppliBySpaceByATypeIdForCombo($user_id, $cont_id, ALK_ATYPE_ID_GEDIT);
      
      $tabOptions = array(); 
      if( $oDsAppli->getCountTotDr() > 0 ) { 
        $tabOptions[] = array('-1', addslashes(_t("Sélectionnez une application")));
        while( $oDrAppli = $oDsAppli->getRowIter() ) {
          $tabOptions[] = array($oDrAppli->getValueName("APPLI_ID"), 
                                str_replace('"', '', $oDrAppli->getValueName("APPLI_INTITULE")));
        }
      } else {
        $tabOptions[] = array('-1', addslashes(_t("Aucune accessible dans cet espace")));
      }
      echo json_encode($tabOptions);
      break;

    case "6": // chargement de la liste des pages de type newsletter de l'appli sélectionnée
      $appli_id = AlkRequest::_GETint("aid", "-1");
      $oQueryGEdit = AlkFactory::getQuery(ALK_ATYPE_ID_GEDIT);
      $oDsPage = $oQueryGEdit->getArboAutorise($user_id, $appli_id, true, -1, false, ALK_ATYPE_ID_GEDIT, 4, -1);

      $tabOptions = array();
      if( $oDsPage->getCountTotDr()>0 ) { 
        $tabOptions[] = array('-1', addslashes(_t("Sélectionnez une page de type lettre")));
        while( $oDrPage = $oDsPage->getRowIter() ) {
          $tabOptions[] = array($oDrPage->getValueName("PAGE_ID"), 
                                str_replace('"', '', $oDrPage->getValueName("NOM".$this->tabLangue[ALK_LG]["bdd"])));
        }
      } else {
        $tabOptions[] = array('-1', addslashes(_t("Aucune page n'est accessible")));
      }
      echo json_encode($tabOptions);
      break;

    case "7": // chargement de la lettre à partir du contenu éditorial
      $msg_id    = AlkRequest::_GETint("mid", "-1");
      $appli_id  = AlkRequest::_GETint("aid", "-1");
      $page_id   = AlkRequest::_GETint("pid", "-1");
      $langue_id = AlkRequest::_GETint("lid", "-1");

      $oAppliGedit = AlkFactory::getAppli(ALK_ATYPE_ID_GEDIT, $appli_id);
      $strUrlPage = 
        ( defined("ALK_ALKANET_ROOT_URL_FRONTOFFICE") 
          ? ALK_ALKANET_ROOT_URL_FRONTOFFICE.ALK_ROOT_DIR
          : ALK_ALKANET_ROOT_URL ). 
        $oAppliGedit->oQuery->getPageUrl($page_id, "", false, $this->tabLangue[$langue_id]["bdd"])."?mode=newsletter";
      $msg_message = @file_get_contents($strUrlPage, false);
      
      $tabRes = array();
      $tabRes["msg_id"] = $msg_id;
      $tabRes["msg_sujet"] = "";
      $dsPage = $oAppliGedit->oQuery->getPageById($page_id, -1);
      if( $drPage = $dsPage->getRowIter() ) {
        $tabRes["msg_sujet"] = str_replace('"', '', $drPage->getValueName("PAGE_TITRE".$this->tabLangue[$langue_id]["bdd"]));
      }

      $tabRes["msg_id"] = $this->oAppli->oQueryAction->saveMsg($msg_id, $this->oAppli->appli_id, $user_id, $user_id, 
                                                               $tabRes["msg_sujet"], $msg_message, 0, 0, 3, $page_id, 
                                                               $langue_id, array());

      $strUrlPageLettre = AlkFactory::getUploadUrl(ALK_ATYPE_ID_LSDIF, false)."lettre_".$tabRes["msg_id"].".htm";
      $tabRes["htmlLink"] = '<a title="'._t('Voir la lettre').'" target="_blank" href="'.$strUrlPageLettre.'">'._t('Voir la lettre').' </a>';

      echo json_encode($tabRes);
      break;
    
    case 8: // retourne la liste des modèles et l'identifiant du modèle sélectionné
      $msg_id    = AlkRequest::getToken("msg_id", "-1");
      $oDsTmp = $this->oAppli->oQuery->getDsListeModeleMsg($this->oAppli->appli_id, $user_id);
      
      $tabOptions = array();
      if( $oDsTmp->getCountTotDr()>0 ) { 
        $tabOptions[] = array('-1', addslashes(_t("Sélectionnez un modèle")));
        while( $oDrTmp = $oDsTmp->getRowIter() ) {
          $tabOptions[] = array($oDrTmp->getValueName("MSG_ID"), 
                                str_replace('"', '', $oDrTmp->getValueName("MSG_SUJET")));
        }
      } else {
        $tabOptions[] = array('-1', addslashes(_t("Aucun modèle n'est accessible")));
      }
      
      $tabRes = array("msg_id" => $msg_id, "tabOptions" => $tabOptions);
      echo json_encode($tabRes);  
    }
  
    return "";
  }
  
  public function getTitle()
  {
    if ( $this->bNotification ) {
      return _t("Notifier des utilisateurs");
    }
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $this->appli_id = $appli_id = AlkRequest::getToken("appli_id", "-1");
   
    // Initialisation des longueurs de champs de formulaire
    $this->iWidthTxt = $iWidthTxt = 38;
    $iWidthMemo = 36;
    $this->iHeightMemo = $iHeightMemo = 20;
    $this->iHeightSelect = $iHeightSelect = 7;
    $this->iWidthSelect = $iWidthSelect = 247;
    $cont_id = $this->oAppli->cont_id;
    $this->user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    $this->user_id = $user_id    = AlkFactory::getSProperty("user_id", "-1");
       
    /*$strJs = " var strParam = '".$strParam."';";      
    $this->addJs($strJs);*/
    $this->addJs("var ALK_B_LSDIF_EDITOR_LONGDESC = ".( defined("ALK_B_LSDIF_EDITOR_LONGDESC") && ALK_B_LSDIF_EDITOR_LONGDESC ? 1 : 0 ).";");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");  
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_form.js");  
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_LIB."alkhtmlformlsdifform.js");  
    if ( $this->bNotification ) {
      $this->setLabel(_t("Édition de la notification"));
    } else {
      $this->setLabel(( $this->msg_id->value=="-1" ? _t("Nouveau message") : _("Modifier votre message") ));
    }

    //------------
    // formulaire
    //------------
    
    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->msg_idfrom);
    $oCtrlH->addDataHidden($this->msg_idreply);
    $oCtrlH->addDataHidden($this->msg_id);
    $oCtrlH->addDataHidden($this->liste_id);
    
    // block expéditeur
    if ( $this->bNotification ) {
    
    } else {
      $this->getBlockExpediteur($oCtrlH);
    }
    // block destinataire
    $this->getBlockDestinataire(true);
    // block mesg
    $this->getBlockMessage($oCtrlH, true);
     
    // block fichiers joints
    if ( !$this->bNotification ) {
      $strUrlUploadLsDif = AlkFactory::getUploadUrl(ALK_ATYPE_ID_LSDIF, true);
      $oBlock_Fichiers_Joints = $this->addBlock("block_fichiers_joints", _t("Fichiers joints"), "", "70", $iWidthSelect+75);
      $oCtrlFile[0] = AlkHtmlFactory::getHtmlFile($this->mailFjA, "Fichier 1", $iWidthTxt);   
      $oCtrlFile[0]->setFileUrl("/".$strUrlUploadLsDif, $this->mailFjA->value);
      $oCtrlFile[0]->setDualMode(true);
      $oCtrlFile[0]->setProperty("bDel", false);
      
      $oCtrlFile[1] = AlkHtmlFactory::getHtmlFile($this->mailFjB, _t("Fichier 2"), $iWidthTxt);   
      $oCtrlFile[1]->setFileUrl("/".$strUrlUploadLsDif, $this->mailFjB->value);
      $oCtrlFile[1]->setDualMode(true); 
      $oCtrlFile[1]->setProperty("bDel", false);
      
      $oCtrlFile[2] = AlkHtmlFactory::getHtmlFile($this->mailFjC, _t("Fichier 3"), $iWidthTxt);   
      $oCtrlFile[2]->setFileUrl("/".$strUrlUploadLsDif, $this->mailFjC->value);
      $oCtrlFile[2]->setDualMode(true);
      $oCtrlFile[2]->setProperty("bDel", false);
      
      $oBlock_Fichiers_Joints->addCtrl($oCtrlFile[0]);
      $oBlock_Fichiers_Joints->addCtrl($oCtrlFile[1]);
      $oBlock_Fichiers_Joints->addCtrl($oCtrlFile[2]);
      $strMaxUploadFile = ini_get("upload_max_filesize")."o";
      $strH2 = "<div class='divContenuTexte'>"._f("Le poids de l'ensemble des fichiers joints ne peut excéder %s", $strMaxUploadFile).".</div>";
      $oCtrlH2 = AlkHtmlFactory::getHtml($strH2);    
      $oBlock_Fichiers_Joints->addCtrl($oCtrlH2, ALK_HTMLFORM_1L1C);
    }
    
    // block archivage
    if ( $this->bNotification ) {
      $oCtrlH->addHidden($this->mailEnr->name, 0);  // ne sauvegarde pas les messages de notification
      $oCtrlH->addDataHidden($this->msg_public);
    } else {
      $oBlock_archivage = $this->addBlock("block_archivage", _t("Archivage"), "", "70", $iWidthSelect+75);
      $oCtrlCBs = AlkHtmlFactory::getHtmlCheckbox($this->mailEnr, "");
      $oCtrlCBs->AddEvent("onClick", "onChangeMsgSave()");
      $strmessage = _t("Enregistrer ce message");
      $oCtrlmessage = AlkHtmlFactory::getHtml($strmessage);
      $oCtrlCBs->addCtrl($oCtrlmessage);
      $oBlock_archivage->addCtrl($oCtrlCBs, ALK_HTMLFORM_1L1C);
      
      if ( $this->bShowCbMsgPublic ) {
        $oCtrlCBp = AlkHtmlFactory::getHtmlCheckbox($this->msg_public,"");
        $oCtrlCBp->AddEvent("onClick", "onChangeMsgSavePublic()");
        $oCtrlCBp->addOnload("onChangeMsgSavePublic()");
        $strmessage2 = _t("Publier ce message dans la boîte des messages publics envoyés");
        $oCtrlmessage2 = AlkHtmlFactory::getHtml($strmessage2);
        $oCtrlCBp->addCtrl($oCtrlmessage2);
        $oBlock_archivage->addCtrl($oCtrlCBp, ALK_HTMLFORM_1L1C);
      } else {
        $oCtrlH->addDataHidden($this->msg_public);
      }
    }
    
    if ( $this->bNotification ) {
      $oCtrlH->addDataHidden($this->eventTitle);
      $oCtrlH->addDataHidden($this->eventDesc);
      $oCtrlH->addDataHidden($this->datedeb);
      $oCtrlH->addDataHidden($this->heuredeb);
      $oCtrlH->addDataHidden($this->datefin);
      $oCtrlH->addDataHidden($this->heurefin);
      $oCtrlH->addDataHidden($this->timerappel);
      $oCtrlH->addDataHidden($this->atype_id_src);
      $oCtrlH->addDataHidden($this->data_id);
      $oCtrlH->addDataHidden($this->strAbonneIdInclude);
    } else {
      
    }
    
    $this->getButtons(true);
    $this->setTemplate("lsdif", "alkhtmlformlsdifform.tpl");
  }

  public function getButtons($bModele=true){ 
  	
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_AVALIDER, ALK_SHEET_NONE);     
    $strTokenAT = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_AVALIDER, ALK_SHEET_NONE, "&iMode=AddTemplate");     
    $strTokenUT = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_AVALIDER, ALK_SHEET_NONE, "&iMode=UpdateTemplate");     
    $strTokenC = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE);     
    
    $oButton = $this->addButtonPage("oBtV","javascript:Valider('".$strToken."')", _t("Envoyer"), _t("Envoyer le mail"));
    $this->addSubmitButton($oButton);
    if($bModele){
      if ( $this->bNotification ) {
        $this->addButtonPage("oBtCon", "javascript:GetWindowOpener().".$this->strFunctionJsAfter.";closeWindow();", _t("Continuer"), _t("Continuer la validation"));
        $this->addButtonPage("oBtF","javascript:closeWindow()", _t("Annuler"), _t("Annuler et Fermer la fenêtre"));
      } else {
        $oButton = $this->addButtonPage("oBtNM","javascript:addTemplate('".$strTokenAT."')", _f("Créer%nlmodèle", "<br/>"), _t("Créer un modèle à partir de ce message"));
        $this->addSubmitButton($oButton);
        $oButton = $this->addButtonPage("oBtMM","javascript:updateTemplate('".$strTokenUT."')", _f("Modifier%nlmodèle", "<br/>"), _t("Modifier le modèle sélectionné"));
        $this->addSubmitButton($oButton);
      }
    }
    $oButton = $this->addButtonPage("oBtE","javascript:Annuler()", _t("Effacer"), _t("Effacer ce mail"));
    $this->setResetButton($oButton);
  }
  
  
  public function getBlockExpediteur($oCtrlH ){ 
      
      $oBlock_Expediteur = $this->addBlock("block_exp", _t("Expéditeur"), "", "80", $this->iWidthSelect+45);
      $oCtrlTxtExp = AlkHtmlFactory::getHtmlText($this->msg_nomfrom, _t("Expéditeur"), 1, $this->iWidthTxt-12, 80);
      $oCtrlTxtExp->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
      $oCtrlTxtExp->setProperty("bReadOnly", true);
    
      // ajout des champs cachés
      $oCtrlH->addHidden("old_mailFjA", $this->mailFjA->value);
      $oCtrlH->addHidden("old_mailFjB", $this->mailFjB->value);
      $oCtrlH->addHidden("old_mailFjC", $this->mailFjC->value);

      if( $this->user_right == ALK_APPLI_RIGHT_PUBLI ) {
        $strToken = AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER_LIST.
                                               "&destTxt=document.formMail.msg_nomfrom&destId=document.formMail.msg_idfrom"); 
        $oCtrlTxtExp->addButtonForm("BtAddExp", "javascript:addAnim('".$strToken."')", _t("Modifier"), _t("Sélectionner l'expéditeur"));
        $oCtrlTxtExp->setTemplate("lsdif", "alkhtmlpopuplienctrl.tpl");
      } 
      
      $oBlock_Expediteur->addCtrl($oCtrlTxtExp);
      
      if( $this->user_right == ALK_APPLI_RIGHT_PUBLI ) {
        $oCtrlTxtRep = AlkHtmlFactory::getHtmlText($this->msg_nomreply, _t("Répondre à"), 1, $this->iWidthTxt-12, 80);
        $oCtrlTxtRep->setProperty("bReadOnly", true);
        $oCtrlTxtRep->addValidator(ALK_VERIF_TEXT); 
        $strToken = AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER_LIST.
                                               "&destTxt=document.formMail.msg_nomreply&destId=document.formMail.msg_idreply"); 
        $oCtrlTxtRep->addButtonForm("BtAddRep", "javascript:addReply('".$strToken."')", _t("Modifier"), _t("Sélectionner la personne à qui répondre"));
        $oCtrlTxtRep->setTemplate("lsdif", "alkhtmlpopuplienctrl2.tpl");
        $oBlock_Expediteur->addCtrl($oCtrlTxtRep);   
        
        $oCtrlCBNoReply = AlkHtmlFactory::getHtmlCheckbox($this->msg_noreply, "", "1", "0");
        $iIndexCB = $oCtrlCBNoReply->addCheckBox("0", _t("Ne pas répondre à ce message"), "1", "0");
        $oCtrlCBNoReply->addEventToCheckBoxByIndex($iIndexCB, "onclick", "onClickNoReply(this, '".str_replace('"', '', ALK_MAIL_NOREPLY)."')");
        $oBlock_Expediteur->addCtrl($oCtrlCBNoReply);
      }
  }
  
  /**
   * function affichant la liste des destinataires
   * @param : $bModele : permet d'adapter la liste des destinataires 
   */
  
  public function getBlockDestinataire($bModele=true){   
      
    // block destinataire
    $oQueryAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    $oBlock_destinataire = $this->addBlock("block_dest", _t("Sélection des destinataires"), "", "80", $this->iWidthSelect+45);       
    
    // ajoute le lien "Ajout des abonnés" dans le cas d'une notification
    $bAbonnesOnly = AlkRequest::getToken("bAbonnesOnly", AlkRequest::_REQUEST("bAbonnesOnly", 0));
    if ( $this->bNotification ) {
      $liste_id = AlkRequest::getToken("liste_id", AlkRequest::_REQUEST("liste_id", -1));
      if ( $liste_id != -1 ) {
        $tabListeIdAssoc = AlkRequest::_REQUEST("tabListeIdAssoc", array());
        $tabListeId = array_merge(array($liste_id), $tabListeIdAssoc);
        $oLinkAddAbonnes = AlkHtmlFactory::getHtmlButton("javascript:addAbonnes(".$liste_id.")", _t("Ajout des abonnés de l'information"), _t("Ajouter les abonnés de l'information"));
        $oBlock_destinataire->addCtrl(AlkHtmlFactory::getHtml($oLinkAddAbonnes->getHtml(), ">"));
      }
    }
    
    if ( !$bAbonnesOnly ) {
      $strToken = AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USERS_LIST.
                                             ( defined("ALK_B_LSDIF_SEARCHUSERBYSPACE") && ALK_B_LSDIF_SEARCHUSERBYSPACE==true
                                               ? "&cont_id_filtre=".$this->oAppli->cont_id
                                               : "" ).
                                             "&iAffAdmin=1&abonne_id_filtre=".( $this->bNotification ? "3" : "1" )."&dest=document.formMail.elements['mailListes[]']");
                                             
      $oLinkAddAnim = AlkHtmlFactory::getHtmlButton("javascript:addAbonneAnnu('".$strToken."')", _t("Sélection dans l'annuaire"), _t("Sélectionner des utilisateurs dans l'annuaire"));
      $oBlock_destinataire->addCtrl(AlkHtmlFactory::getHtml($oLinkAddAnim->getHtml(), ">"));

      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_USER, ALK_SHEET_NONE, "&dest=document.formMail.elements['mailListes[]']&list=1");
      $oLinkAddUserDest = AlkHtmlFactory::getHtmlButton("javascript:AddUserDest('".$strToken."',500)", _t("Ajout de destinataires"), _t("Ajouter des destinataires"));
      if($bModele == true){
        $oBlock_destinataire->addCtrl(AlkHtmlFactory::getHtml($oLinkAddUserDest->getHtml(), ">"));
      }
      $oCtrlSelectListe = AlkHtmlFactory::getHtmlSelect($this->mailListe, ">", 1, $this->iWidthSelect-10);

      $ValTxt = $oQueryAnnu->oQuery->getDsListes($this->user_id, $this->oAppli->cont_id, true, 0, -1, false, false, true, "0, 3, 4"); 
      $oCtrlSelectListe->setProperty("oValTxt", $ValTxt);
      $oCtrlSelectListe->setProperty("tabValTxtDefault", array("-1", _t("Sélectionnez une liste de diffusion")));
      $oCtrlSelectListe->addButtonIcon("BtAddListe", "javascript:AddListDest()", "ajouter", _t("Ajouter cette liste aux destinataires"));
      $oBlock_destinataire->addCtrl($oCtrlSelectListe, ALK_HTMLFORM_1L2C);    
    }
  
      // on récupère la liste des destinataires
    $dsDest = $this->oAppli->oQuery->getDsListDestForCombo($this->liste_id->value);
    
    $oCtrlSelectListes = AlkHtmlFactory::getHtmlSelect($this->mailListes, _t("Destinataires"), $this->iHeightSelect, $this->iWidthSelect-10);
    $oCtrlSelectListes->addValidator(ALK_IS_REQUIRED+ALK_VERIF_SELECT);
    $oCtrlSelectListes->setProperty("oValTxt", $dsDest);
    $oCtrlSelectListes->setProperty("strFieldValue", "A_ID");
    $oCtrlSelectListes->setProperty("strFieldText", "NOM");
    $oCtrlSelectListes->setProperty("tabValTxtLast", array("-1", ""));
     
    $oCtrlSelectListes->setProperty("bMultiple", true);
    $oCtrlSelectListes->addButtonIcon("oBtDel", "javascript:supprDest()", "supprimer", _t("Retirer le destinataire sélectionné de la liste"));
    $strTokenVoir = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_LIST, ALK_SHEET_NONE);
    $oCtrlSelectListes->addButtonIcon("oBtvoir", "javascript:AffDest('".$strTokenVoir."')", "afficher" ,_t("Voir la liste détaillée des destinataires"));
    $oBlock_destinataire->addCtrl($oCtrlSelectListes, ALK_HTMLFORM_1L2C);  

  }
  
  /**
   * Function permettant d'afficher le bloc message de la list diff
   * $bModele : booleen permettant d'adapter les ctrl du bloc notamment pour lancer les invitations à un espace
   */
  
  public function getBlockMessage($oCtrlH, $bModele=true){
    // block message
    $oBlock_message = $this->addBlock("block_message", _t("Message"), "", "70", 710);   

    $oQueryGEdit = AlkFactory::getQuery(ALK_ATYPE_ID_GEDIT);

    if ( $this->bNotification || $bModele==false) {
    
    } else {
      $oCtrlCC = AlkHtmlFactory::getHtmlRadio($this->msg_group, _t("Envoi"));
      $oCtrlCC->AddRadio("0", _t("Anonyme"));
      $oCtrlCC->AddRadio("1", _t("Personnalisé"));
      $oCtrlCC->setLabelAfter("<i><br/>"._t("L'envoi personnalisé permet le publipostage de l'identité du destinataire en ajoutant [#PRENOM_NOM#] dans votre message")."</i>");
      $oBlock_message->addCtrl($oCtrlCC, ALK_HTMLFORM_1L2C);
      
      $oCtrlCT = AlkHtmlFactory::getHtmlRadio($this->msg_type, _t("Type"));
      $oCtrlCT->AddRadio("0", _t("Courriel"));
      $oCtrlCT->AddRadio("2", _t("Lettre d'informations"));
      $oCtrlCT->addEventToRadio("0", "onclick", "onClickMailing()");
      $oCtrlCT->addEventToRadio("2", "onclick", "onClickMailing()");
      if( !is_null($oQueryGEdit) ) {
        $oCtrlCT->AddRadio("3", _t("Lettre d'informations éditoriales"));
        $oCtrlCT->addEventToRadio("3", "onclick", "onClickNewsletter()");
      } 
      $oBlock_message->addCtrl($oCtrlCT);
    }

    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->msg_sujet, _t("Sujet"), 1, 90, 255);
    $oCtrlTxt->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);

    // Liste des modèles
    if ( !$this->bNotification ) { 
      $oCtrlTemplate = AlkHtmlFactory::getHtmlSelect($this->msg_template, _t("Modèles"), 1, $this->iWidthSelect*1.5);
      $dsTmp = $this->oAppli->oQuery->getDsListeModeleMsg($this->oAppli->appli_id, $this->user_id);
      if( $dsTmp->getCountTotDr() ) {
        $oCtrlTemplate->setProperty("tabValTxtDefault", array("-1", _t("Sélectionnez un modèle")));
        $oCtrlTemplate->setProperty("oValTxt", $dsTmp);
        $oCtrlTemplate->setProperty("strFieldValue", "MSG_ID");
        $oCtrlTemplate->setProperty("strFieldText", "MSG_SUJET");
      } else {
        $oCtrlTemplate->setProperty("tabValTxtDefault", array("-1", _t("Aucun modèle n'est accessible.")));
      }
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=4");  
      $oCtrlTemplate->addEvent("onchange","onChangeTemplate('".$strToken."')");

      if($bModele==true)
        $oBlock_message->addCtrl($oCtrlTemplate);
    
    }

    $oCtrlLien = null;
    if( !is_null($oQueryGEdit) ) {
      $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $cont_id_filter  = $this->oAppli->cont_id;
      $appli_id_filter = $this->oAppli->appli_id;
      $oQueryGEdit->getIdContAppliByPage($this->page_id->value, $cont_id_filter, $appli_id_filter);
      
      $this->gedit_cont_id->value = $cont_id_filter;
      $oCtrlEspace = AlkHtmlFactory::getHtmlSelect($this->gedit_cont_id, _t("Espace"), 1, $this->iWidthSelect*1.5);
      $oCtrlEspace->setProperty("oValTxt", $oQueryEspace->getDsListSpaceByATypeIdForCombo($this->user_id, ALK_ATYPE_ID_GEDIT));
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=5");  
      $oCtrlEspace->addEvent("onchange","onChangeEspace('".$strToken."')");
      $oBlock_message->addCtrl($oCtrlEspace);

      $this->gedit_appli_id->value = $appli_id_filter;
      $oCtrlAppli = AlkHtmlFactory::getHtmlSelect($this->gedit_appli_id, _t("Application"), 1, $this->iWidthSelect*1.5);
      $oDsAppli = $oQueryEspace->getDsListAppliBySpaceByATypeIdForCombo($this->user_id, $cont_id_filter, ALK_ATYPE_ID_GEDIT);
      if( $oDsAppli->getCountTotDr() > 0 ) {
        $oCtrlAppli->setProperty("tabValTxtDefault", array("-1", _t("Sélectionnez une application")));
        $oCtrlAppli->setProperty("oValTxt", $oDsAppli);
      } else {
        $oCtrlAppli->setProperty("tabValTxtDefault", array("-1", _t("Aucune accessible dans cet espace")));
      }
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=6");  
      $oCtrlAppli->addEvent("onchange","onChangeAppli('".$strToken."')");
      $oBlock_message->addCtrl($oCtrlAppli);

      $tabLangue = array();
      foreach($this->tabLangue as $langueId => $tabLg) {
        $tabLangue[$langueId] = strtoupper($tabLg["rep"]);
      }
      
      $oCtrlPage = AlkHtmlFactory::getHtmlSelect($this->page_id, _t("Page"), 1, $this->iWidthSelect*1.5);
      $oDsPage = $oQueryGEdit->getArboAutorise($this->user_id, $appli_id_filter, true, -1, false, ALK_ATYPE_ID_GEDIT, 4, -1);
      if( $oDsPage->getCountTotDr() > 0 ) {
        $oCtrlPage->setProperty("tabValTxtDefault", array("-1", _t("Sélectionnez une page")));
        $oCtrlPage->setProperty("oValTxt", $oDsPage);
        $oCtrlPage->setProperty("strFieldValue", "PAGE_ID");
        $oCtrlPage->setProperty("strFieldText", "NOM".strtoupper($this->tabLangue[$this->langue_id->value]["bdd"]));
      } else {
        $oCtrlPage->setProperty("tabValTxtDefault", array("-1", _t("Aucune page n'est accessible")));
      }  
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE, "&iMode=7");
      $oCtrlPage->addEvent("onchange","onChangePage('".$strToken."', 'page_id')");
      $oBlock_message->addCtrl($oCtrlPage);
      
      $oCtrlLangue = AlkHtmlFactory::getHtmlSelect($this->langue_id, "", 1);
      $oCtrlLangue->setProperty("tabValTxt", $tabLangue);
      $oCtrlLangue->addEvent("onchange","onChangePage('".$strToken."', 'langue_id')");
      $oCtrlPage->addCtrl($oCtrlLangue);
      
      $oCtrlHtml = AlkHtmlFactory::getHtml('<span id="ctlLetterUpdate" class="txtWarning" style="display:none">'._t("Lettre mise à jour").'</span>');
      $oCtrlPage->addCtrl($oCtrlHtml);
      
      $strPageLink = "";
      $strHtmlLink = "";
      
      if( $this->msg_id->value != "-1" ) {
        $strPathPage = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF, false)."lettre_".$this->msg_id->value.".htm";
        $strPageLink = AlkFactory::getUploadUrl(ALK_ATYPE_ID_LSDIF, false)."lettre_".$this->msg_id->value.".htm";
        if( file_exists($strPathPage) && is_file($strPathPage) ) { 
          $strHtmlLink = '<div id="div_msg_lien"><a title="'._t('Voir la lettre').'" target="_blank" href="'.$strPageLink.'">'._t('Voir la lettre').' </a></div>';
        } 
        elseif( $this->page_id->value != "-1" && $this->page_id->value != "" && $this->langue_id->value != "" ) {
          $oAppliGedit = AlkFactory::getAppli(ALK_ATYPE_ID_GEDIT, $this->appli_id);
          
          $strPageLink = 
            ( defined("ALK_ROOT_URL_FRONTOFFICE") 
              ? ALK_ROOT_URL_FRONTOFFICE.ALK_ROOT_DIR
              : ALK_ALKANET_ROOT_URL ). 
            $oAppliGedit->oQuery->getPageUrl($this->page_id->value, "", false, $this->tabLangue[$this->langue_id->value]["bdd"])."?mode=newsletter";
          $strHtmlLink = '<div id="div_msg_lien"><a target="_blank" title="'._t('Voir la lettre').'" href="'.$strPageLink.'">'._t('Voir la lettre').' </a></div>';
        }
        else {
          $strHtmlLink = '<div id="div_msg_lien">'._t('Aucun contenu sélectionné').'</div>';
        }
      } else {
        $strHtmlLink = '<div id="div_msg_lien">'._t('Aucun contenu sélectionné').'</div>';
      }
      $strHtmlLink .= '<div id="div_msg_refresh"'.
        ( $strPageLink != "" 
          ? ''
          : ' style="display:none"').
        '><a title="'._t('Mettre à jour la lettre').'" href="javascript:onChangePage(\''.$strToken.'\', \'\')">'._t('Mettre à jour la lettre').'</a></div>';
      
      $oCtrlLien = AlkHtmlFactory::getHtml($strHtmlLink, _t('Message'));
      $oCtrlLien->setName("msg_lien");
      $oCtrlLien->setProperty("guid", "msg_lien");
    }
    $this->addOnload($this->msg_type->value != "3" ? "onClickMailing();" : "onDisableMailing();"); 
    $oCtrlMemo = AlkHtmlFactory::getHtmlText($this->msg_message, _t("Message"), $this->iHeightMemo, 86);
    
    // ajout de l'éditeur
    if( !is_null($oCtrlMemo) && 
      (defined("ALK_B_LSDIF_EDITOR_LONGDESC") && ALK_B_LSDIF_EDITOR_LONGDESC==true)
      /*&& $this->iTypeSheet != ALK_TYPESHEET_POPUP*/ && $this->msg_type->value != "3" ) {
      $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF, true).$this->oAppli->cont_id."/"; 
      if( !(@file_exists(ALK_ALKANET_ROOT_PATH.$strPathUpload) && @is_dir(ALK_ALKANET_ROOT_PATH.$strPathUpload)) ) {
        $bRes = @mkdir(ALK_ALKANET_ROOT_PATH.$strPathUpload, 0770);
        if( !$bRes ) {
          $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF, true);
        } 
      }
      $oCtrlMemo->setEditor(true);
      $oCtrlMemo->setParamEditor("openPopup", false);
      $oCtrlMemo->setParamEditor("msg_idfrom", $this->msg_idfrom->value);
      $oCtrlMemo->setParamEditor("tableName", "LSDIF_MSG");
      $oCtrlMemo->setParamEditor("fieldPk", "msg_idfrom");
      $oCtrlMemo->setParamEditor("userForm", false);
      $oCtrlMemo->setParamEditor("lg", ALK_LG_REP);
      $oCtrlMemo->setParamEditor("pathUpload", $strPathUpload);
      $oCtrlMemo->setParamEditor("tokenStart", "cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id);
      $oCtrlMemo->setParamEditor("styleCss", ( ALK_EDITEUR_CSS != "" ? ALK_EDITEUR_CSS : "editeur.css"));
      $oCtrlMemo->setParamEditor("bodyId", ( defined("ALK_EDITEUR_BODYID") ? ALK_EDITEUR_BODYID : "" ));
      $oCtrlMemo->setParamEditor("toolbarSet", "BasicLong");
    }

/*
Champs de publipostage disponible :     
[#titreappli#] : courriel expediteur
[#nom_prenom_dest#] : nom prénom du destinataire
[#date#] : date et heure courante
[#dest#] : civilite prenom nom du destinataire
[#login#] : identifiant de connexion du destinataire
[#url_site#] : url de l'Extranet";*/

    $oBlock_message->addCtrl($oCtrlTxt, ALK_HTMLFORM_1L2C);
    $oBlock_message->addCtrl($oCtrlMemo, ALK_HTMLFORM_1L2C);    
    $oBlock_message->addCtrl($oCtrlLien, ALK_HTMLFORM_1L2C);    
    $oBlock_message->addCtrl($oCtrlH);
  }
  
  
  
  
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/help/lsdif_01_01_message_form.htm"); 	
  }


}
?>