<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkHtmlPopupLsDifDestList
 * Classe permettant d'afficher une liste de destinataires'
 */
class AlkHtmlPopupLsDifDestList extends AlkHtmlForm
{
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "popupLsDifDestList"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");    
  } 
   
   /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Traitement du formulaire
   */
  public function doSql() { } 
   
 /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return "Liste des abonn&eacute;s s&eacute;lectionn&eacute;s";
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {

    // Récupération des paramètres de l'URL
    $appli_id = AlkRequest::getToken("appli_id", -1);
    $cont_id = AlkRequest::getToken("cont_id", -1);
    
    $strListeId = AlkRequest::_GET ("listesId", ""); 
    $page = AlkRequest::_GETint ("page", 1);
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);   
    
    // Paramètres de l'action du formulaire
    $strParam = "appli_id=".$appli_id."&cont_id=".$cont_id;

    // ------------------------------------------------------------
    // Traitement des thèmes
    // ------------------------------------------------------------
    $strListeMail = "";
    $strSql = "";
    $nbListeSelect = 0;
    $idAffListe = -1;
    $mail_listes = explode(",", $strListeId);
    $nbElts = count($mail_listes);
    $strListAgentId = "-1";
    $tabListAgent = array();
    
    for($i=0; $i < $nbElts; $i++) {
      $strVal = $mail_listes[$i];
      if( is_numeric( $strVal ) ) { // agent de l'annuaire
         $strListAgentId .= ",".$strVal;
      } elseif( substr($strVal, 0 , 2) == "L_" ) { // liste de diff
        $nbListeSelect++;
        $liste_id = substr($strVal, 2);
        if( $nbListeSelect == 1 )
          $idAffListe = $liste_id;
        else 
          $idAffListe = -1;
        $strSql .= ( $strSql != "" ? " union " : "" ).
          $oQueryAnnu->getDsAbonnesByListe($liste_id, false, 0, -1, true);
      } elseif( substr($strVal, 0 , 3) == "AA_" ) {  // liste d'abonnés
        preg_match('/^AA_\d+_(\d+)$/', $strVal, $matches);
        if ( array_key_exists(1, $matches) ) {
          $strListAgentId .= ",".$matches[1];
        }
      } else { // agent hors annuaire, ensemble d'adresse mail
        $tabListAgent[] = $strVal;
      }
    }
    $nbElt = 0;
    if( $strSql != "" || $strListAgentId != "-1" || !empty($tabListAgent)) {
      if( $strSql != "" || $strListAgentId != "-1" ) {
        $strSql .= ( $strListAgentId != "-1"
                     ? ( $strSql != "" ? " union " : "" ).
                       $oQueryAnnu->getStrDsListeAgentMailForLsDif($strListAgentId)
                     : "" ).
          " order by nom, prenom";
        
        $dsDest = $this->oAppli->oQuery->GetDs("select distinct u.* from (".$strSql.") u");
        $nbElt = $dsDest->getCountTotDr()+count($tabListAgent);  
      } else {
        $dsDest = null;
        $nbElt = count($tabListAgent);
      }
       
      $strTokenPagine = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_LIST, ALK_SHEET_NONE, "&listesId=".$strListeId);
      $oTabPage=AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $nbElt, false, ALK_ALKANET."?token".$strTokenPagine, 
                                        "Aucune liste.", false, "tabPagine", false);
      $oTabPage->SetColumns(array("left", "400"));
      $oTabPage->setProperty("strTableAlign", "center");
      $i = 0;
      $j = 0;
      while( $i < $nbElt ) {
        if( !is_null($dsDest) && $drDest = $dsDest->getRowIter() ) {
          $idMailTo  = $drDest->getValueName("AGENT_ID");
          $strMailTo = $drDest->getValueName("MAIL");
          $strNomTo  = trim($drDest->getValueName("PRENOM")." ".$drDest->getValueName("NOM"));
          $i++;
        } else {
          $idMailTo  = "";
          $strMailTo = $tabListAgent[$j];
          $strNomTo  = $tabListAgent[$j];
          $i++;
          $j++;
        }     
        $strHtml = "";
        if( $strMailTo != "" ) { 
          $strListeMail .= $strMailTo.";";
          $strHtml =" <a class='aTabLienPair1' href='mailto:".$strMailTo."' title=\"".$strMailTo."\">@</a> ";
        }        
        if( $idMailTo != "" ) { 
          $strHtml .= "<a class='aTabLienPair1' href=\"javascript:OpenPopupFiche('agent', ".$idMailTo.");\" title=\"Voir la fiche\">".$strNomTo."</a>";
        } else {
          $strHtml .= $strNomTo;
        }
                 
        $oTabPage->addRow($strHtml);
      }
    }

    $this->addPanel($oTabPage);   
    // infos sur l'auteur de la liste sélectionnée
    $strAuteur = "";
    if( $idAffListe != -1 ) {
    	$idAuteur =  $oQueryAnnu->getStrIdAuteurListeDif($idAffListe);
    	$dsAgent = $oQueryAnnu->GetStrDs_ficheAgentMail($idAuteur);
    	if( $drAgent = $dsAgent->getRowIter() )	{
        $idAgent = $drAgent->getValueName("AGENT_ID");
        $strAuteur = $drAgent->getValueName("PRENOM")." ".$drAgent->getValueName("NOM");
        $strMail = $drAgent->getValueName("MAIL");
    
        $strAuteur = "<a class='aTabLienEntete' href=\"javascript:OpenPopupFiche('agent', ".
          $idAgent.");\" title=\"Voir la fiche\">".$strAuteur."</a>";
        if( $strMail !="" )
          $strAuteur = "<a class=aTabLienEntete href=\"mailto:".$strMail.
            "\" title=\"".$strMail."\">@</a> ".$strAuteur;
      }
    }
    $bloc =$this->addBlock("bloc_aff","", "", 55);
    if( $strAuteur!="" ) {
      $strAuteur = "Auteur : ".$strAuteur;
      $oCtrlAuteur = AlkHtmlFactory::getHtml($strAuteur);
      $bloc->addCtrl($oCtrlAuteur);
    }
    $strNbAbonne = "Nombre d'abonn&eacute;s : ".$nbElt;
    $oCtrlNbAbonne = AlkHtmlFactory::getHtml($strNbAbonne);
    $bloc->addCtrl($oCtrlNbAbonne);    
    if( count($oTabPage) > 0 ) {
    	$this->addButtonPage("oBtEnv", "mailto:$strListeMail", "Envoyer", "Envoyer un mail à partir de votre messagerie"); 
    }
    $this->addButtonPage("oBtFerme", "javascript:closeWindow('');", "Fermer", "Fermer la fenêtre"); 
    
    $this->setTemplate("lsdif", "alkhtmlpopuplsdifdestlist.tpl");
  }
}
?>
