<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkHtmlPopupLsDifSujetForm
 * Classe permettant d'afficher le contenu  d'un sujet
 */
class AlkHtmlPopupLsDifSujetForm extends AlkHtmlForm
{
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "popupLsDifsujetForm"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");    
  } 
   
   /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Traitement du formulaire
   */
  public function doSql() { } 
   
 /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  { 
    return "Consultation du message";
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    // Récupération des paramètres de l'URL
    $msg_id = AlkRequest::getToken("msg_id", "-1");
    $tboite  = AlkRequest::getToken("tboite", "0");
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    // Collecte des infos
    $dsMsg = $this->oAppli->oQuery->GetDsFicheMessage($msg_id);
    if( !($drMsg = $dsMsg->getRowIter()) ) {
    	return;
    }

    $msg_idfrom   = $drMsg->getValueName("MSG_IDFROM");
    $msg_nomfrom  = $drMsg->getValueName("MSG_NOMFROM");
    $msg_mailfrom = $drMsg->getValueName("MSG_MAILFROM");
    $msg_idreply  = $drMsg->getValueName("MSG_IDREPLY");
    $msg_nomreply = $drMsg->getValueName("MSG_NONREPLY");
    $msg_mailreply= $drMsg->getValueName("MSG_MAILREPLY");
    $strSujet      = $drMsg->getValueName("MSG_SUJET");
    $strMsg        = $drMsg->getValueName("MSG_MESSAGE");
    $strFilePJ     = $drMsg->getValueName("MSG_PJ");
    $msg_date     = $drMsg->getValueName("DATE_ENR");
    $msg_datenv   = $drMsg->getValueName("DATE_ENV");
    $msg_group    = $drMsg->getValueName("MSG_GROUP");
    $msg_public   = $drMsg->getValueName("MSG_PUBLIC");
    
    $strHtml = "<table border='0' cellpadding='1' cellspacing='0' width='100%'>";
    
    $strData = ( $msg_public == "1" ? "public, " : "" ). 
      ($msg_group=="0" ? "anonyme, " : "personnalisé, " ).
      "enregistré le ".$msg_date.
      ( $msg_datenv != ""
        ? ", envoyé le ".$msg_datenv."<br/>"
        : "" );
    $strHtml .= $this->GetTabResHtml("Message : ", $strData);
    
    // expediteur
    $strData =  "<a style='text-decoration: none' href=\"mailto:".
      $msg_mailfrom."\" title=\"".$msg_mailfrom."\">@</a>&nbsp;".
      ( $msg_idfrom!="" && $msg_idfrom!="-1"
        ? "<a href=\"javascript:OpenPopupFiche('agent', ".$msg_idfrom.
          ");\" title=\"Voir la fiche\">".$msg_nomfrom."</a>"
        : "<span>".$msg_nomfrom."</span>");
    $strHtml .= $this->GetTabResHtml("Exp&eacute;diteur : ", $strData);

    // répondre à
    if( $msg_mailreply != "" ) {
      $strData =  "<a style='text-decoration: none' href=\"mailto:".
        $msg_mailreply."\" title=\"".$msg_mailreply."\">@</a>&nbsp;".
        ( $msg_idreply!="" && $msg_idreply!="-1"
          ? "<a href=\"javascript:OpenPopupFiche('agent', ".$msg_idreply.
            ");\" title=\"Voir la fiche\">".$msg_nomreply."</a>"
          : "<span>".$msg_nomreply."</span>");
      $strHtml .= $this->GetTabResHtml("Exp&eacute;diteur : ", $strData);
    }
        
    $tabColor = array(0 => "#fb3434", 1=> "#394c9b", 2=> "#489b05");
    
    $strDest = '<span style="color:'.$tabColor[0].'">Non envoyé</span> - '.
      '<span style="color:'.$tabColor[1].'">Envoyé</span> - '.
      '<span style="color:'.$tabColor[2].'">Envoyé et confirmé</span><br/><br/>';
    $dsDest = $this->oAppli->oQuery->getDsListDest($msg_id, true, ($tboite=="0" ? "3" : "-1"), ($tboite=="0" ? $user_id : "-1"));
    while( $drDest = $dsDest->getRowIter() ) {
      $strNom  = trim($drDest->getValueName("ABONNE_PRENOM")." ".$drDest->getValueName("ABONNE_NOM")); 
      $strMail   = $drDest->getValueName("ABONNE_MAIL");
      $dest_etat = $drDest->getValueName("DEST_ETAT");
    
      $strDest .= 
        ( $strNom != $strMail
          ? '<span style="color:'.$tabColor[$dest_etat].'">'.$strNom.'</span> <<a style="color:'.$tabColor[$dest_etat].'" href="mailto:'.$strMail.'">'.$strMail.'</a>>'
          : '<a style="color:'.$tabColor[$dest_etat].'" href="mailto:'.$strMail.'">'.$strMail.'</a>' ).
        '<br/>';
    }
    $strHtml .= $this->GetTabResHtml("Destinataires : ", "<div style='border: 1px solid #d8d8d8; overflow:auto; width:100%; height:80px;'>".$strDest."</div>");
    
    // pieces jointes
    $URL_Path_Upload_LSDIF= AlkFactory::getUploadUrl(ALK_ATYPE_ID_LSDIF);
    
    if( $strFilePJ != "" ) {
      $tabFileName = explode("|", $strFilePJ);
      $strData = "";
      for($i=0; $i<count($tabFileName); $i++)
        if( $tabFileName[$i] != "" )
          $strData .= ", <a target='_blank' href=\"".$URL_Path_Upload_LSDIF.$tabFileName[$i]."\">".$tabFileName[$i]."</a>";
      if( $strData != "" ) 
        $strData = substr($strData, 2);
      $strHtml .= $this->GetTabResHtml("Pièces jointes : ", $strData);
    }
    
    // message
    $strPathFileMsg = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."lsdif/lettre_".$msg_id.".htm";
    if( file_exists($strPathFileMsg) && is_file($strPathFileMsg) ) {
      $strFileMsg = "lettre_".$msg_id.".htm";
    } else {
      $hFile = fopen($strPathFileMsg, "w");
      if( $hFile ) {
        fwrite($hFile, html_entity_decode($strMsg));
        fclose($hFile); 
        $strFileMsg = "lettre_".$msg_id.".htm";
      } else {
        $strFileMsg = "../../scripts/alkanet/blank.htm";
      }
    }
    $strHtml .= $this->GetTabResHtml("", "<iframe style='border: 1px solid #d8d8d8; overflow:auto; width:100%; height:280px;' src='".
                                     ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."lsdif/".$strFileMsg."'></iframe>");        
    $strHtml .= "</table>";
    
    $oBlock = $this->addBlock("block1", $strSujet, "", 0, 650);
    $oResult = AlkHtmlFactory::getHtml($strHtml);
    $oBlock->addCtrl($oResult, ALK_HTMLFORM_1L1C);
  }

  /**
   *  Affiche une ligne du tableau affichant le message envoyé
   */
 private function GetTabResHtml($strLabel, $strData)
  {
    return "<tr>" .
      ( $strLabel=="" && $strData!=""
        ? "<td align='left' valign='top' colspan='2'>".$strData."</td>"
        : ( $strLabel!="" && $strData==""
            ? "<td align='left' valign='top' colspan='2'><span class='formLabel'>".$strLabel."&nbsp;</span></td>"
            : "<td width='80' align='right' valign='top'><span class='formLabel'>".$strLabel."&nbsp;</span></td>".
              "<td align='left' valign='top'>".$strData."</td>" )).
      "</tr>";
  }

}
?>
