<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkQueryLsDifAction
 * Ensemble des requetes actions liées à l'application liste de diffusion
 */
final class AlkQueryLsDifAction extends AlkQuery
{
  /**
   * Constructeur par défaut
   * @param oDb  Référence sur l'objet AlkDb de connexion
   */ 
  public function __construct(&$oDb)
  {
    parent::__construct($oDb);
  }

  /**
   * Destructeur par défaut
   */
  public function __destruct() { }
  
	/**
   * Enregistre dans le message envoyé : ajout ou modif selon la valeur de msg_id (-1=ajout, modif sinon)
   * @param msg_id       identifiant du message
   * @param appli_id     identifiant de l'appli mailing
   * @param msg_idfrom   identifiant de l'agent expéditeur
   * @param msg_idreply  identifiant de l'agent destinataire à répondre à
   * @param msg_sujet    sujet du message
   * @param msg_message  corqs du message
   * @param msg_public   =1 pour l'enregistrement d'un msg public, =0 sinon
   * @param msg_group    =1 groupé, =0 individuel
   * @param msg_type     =0 mailing, =1 lettre, =2 lettre éditoriale
   * @param page_id      =-1 si aucune page associée au message, >0 sinon
   * @param langue_id    identifiant de la langue de la page
   * @param tabFileName  tableau contenant la liste des fichiers joints
   * @return int
   */
	public function saveMsg($msg_id, $appli_id, $msg_idfrom, $msg_idreply, 
                          $msg_sujet, $msg_message, $msg_public, $msg_group, 
                          $msg_type, $page_id, $langue_id, $tabFileName)
  {
    $user_id = AlkFactory::getSProperty("user_id", -1);

    $strFilePJ = "";
    if( is_array($tabFileName) ) {
      $strFilePJ = implode("|", $tabFileName);
    }
    
    if( $msg_id == "-1" ) { 
      // memorise le message
      $msg_id = $this->dbConn->GetNextId("LSDIF_MSG", "MSG_ID", "SEQ_LSDIF_MSG");
      $strSql = "insert into LSDIF_MSG (MSG_ID, APPLI_ID, MSG_DATE, MSG_IDFROM, MSG_IDREPLY," .
        " MSG_SUJET, MSG_MESSAGE, MSG_PJ, MSG_PUBLIC, MSG_GROUP, MSG_ETAT, MSG_TYPE, AGENT_ID) values (".$msg_id.
        ", ".$appli_id.
        ", ".$this->dbConn->GetDateCur().
        ", ".$msg_idfrom.
        ", ".$msg_idreply.
        ", '".$this->dbConn->analyseSql($msg_sujet)."'".
        ", '".$this->dbConn->analyseSql($msg_message)."'".
        ", '".$this->dbConn->analyseSql($strFilePJ)."'".
        ", ".$msg_public.
        ", ".$msg_group.
        ", 0". // état ajouté
        ", ".$msg_type.
        ", ".$user_id.
        ")";
    } else {
      $strSql = "update LSDIF_MSG set" .
        "  MSG_IDFROM=".$msg_idfrom.
        ", MSG_IDREPLY=".$msg_idreply.
        ", MSG_DATE=".$this->dbConn->GetDateCur().
        ", MSG_SUJET='".$this->dbConn->analyseSql($msg_sujet)."'".
        ( $msg_type!=3 || $msg_type==3 && trim($msg_message) != ""
          ? ", MSG_MESSAGE='".$this->dbConn->analyseSql($msg_message)."'"
          : "" ).
        ", MSG_PJ='".$this->dbConn->analyseSql($strFilePJ)."'".
        ", MSG_PUBLIC=".$msg_public.
        ", MSG_GROUP=".$msg_group.
        ", MSG_TYPE=".$msg_type.
        ", MSG_ETAT=1". //etat modifié
        ", AGENT_ID=".$user_id.
        " where MSG_ID=".$msg_id;
    }
    $this->dbConn->ExecuteSql($strSql);
    
    $strSql = "delete from LSDIF_MSG_PAGE where MSG_ID=".$msg_id;
    $this->dbConn->ExecuteSql($strSql);
    
    if( $page_id != "-1" ) {
      $strSql = "insert into LSDIF_MSG_PAGE (MSG_ID, PAGE_ID, LANGUE_ID) values (".
        $msg_id.", ".$page_id.", ".$langue_id.")";
      $this->dbConn->ExecuteSql($strSql);
    }
    
    if( $msg_type == "3" && $msg_message != "" ) {
      $strPath = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF, false);
      $hf = @fopen($strPath."lettre_".$msg_id.".htm", "w");
      if( $hf ) {
        fwrite($hf, $msg_message);
        fclose($hf);
      } 
    }
    
    return $msg_id;
  }

  /**
   * Enregistre dans le message envoyé : ajout ou modif selon la valeur de msg_id (-1=ajout, modif sinon)
   * @param msg_id       identifiant du message
   * @param appli_id     identifiant de l'appli mailing
   * @param msg_sujet    sujet du message
   * @param msg_message  corqs du message
   * @param msg_public   =1 pour l'enregistrement d'un msg public, =0 sinon
   * @param msg_group    =1 groupé, =0 individuel
   * @param tabFileName  tableau contenant la liste des fichiers joints
   * @return int
   */
  public function saveTemplate($msg_id, $appli_id, $msg_sujet, $msg_message, $msg_public, $msg_group, $tabFileName)
  {
    $user_id = AlkFactory::getSProperty("user_id", -1);
   
    return $this->saveMsg($msg_id, $appli_id, $user_id, $user_id, 
                          $msg_sujet, $msg_message, $msg_public, $msg_group, 
                          4, -1, 1, $tabFileName);
  }

  /**
   * Enregistre la date de fin d'envoi du message
   * @param msg_id identifiant du message
   * @param bSend   =true si l'envoi est terminé, =false si planification
   */
  public function saveMsgSent($msg_id, $bSend=true)
  {
    $strSql = "update LSDIF_MSG set" .
      ( $bSend
        ? "  MSG_DATENV=".$this->dbConn->GetDateCur().
          ", MSG_ETAT=3"    // état envoyé
        : "  MSG_ETAT=2" ). // état en attente d'envoi
      " where MSG_ID=".$msg_id;
    $this->dbConn->ExecuteSql($strSql);
    
    // DEST_ETAT=0 non envoyé
    // DEST_ETAT=1 lorsque envoyé par l'appli
    // DEST_ETAT=2 validation de l'envoi de la part du serveur
    if( $bSend ) {
      $strSql = "update LSDIF_DEST set DEST_ETAT=1 where MSG_ID=".$msg_id;
      $this->dbConn->ExecuteSql($strSql);
    }
  }

  /**
   * Enregistre la liste des destinataires si iSaveMsg=1
   * Retourne le dataset contenant la liste des destinataires (limité à iMax)
   * 
   * @param msg_id              identifiant du message
   * @param liste_id            identifiant de la liste associée au message, mémorisant les listes et abonnés associés, passage en référence
   * @param cont_id             identifiant de l'espace courant
   * @param tabDest             tableau contenant la liste des destinataires
   * @param iSaveMsg            =1 par défaut pour enregistrer les destinataires, =0 sinon
   * @param iMax                nombre max de destinataires retournés dans le dataset, =200 par défaut   
   * @param tabAbonneIdInclude  tableau des identifiants des abonnés à conserver (exclus tous les autres), conserve tous les utilisateurs si vide
   * @return AlkDs
   */
  public function saveMsgDest($msg_id, &$liste_id, $cont_id, $tabDest, $iSaveMsg=1, $iMax=200, $tabAbonneIdInclude=array())
  {
    $queryAnnu       = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $queryAnnuAction = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    
    $strSql = "";
    $strSqlAb = "";
    $tabAgentId = array();
    $tabAbonneId = array();
    $tabSListeId = array();
    
    $nbElts = count($tabDest);
    for($i=0; $i < $nbElts; $i++) {
      $strVal = $tabDest[$i];
      if( is_numeric( $strVal ) && $strVal != "-1" ) { // abonné sélectionné
        if( empty($tabAbonneIdInclude) ||
            !empty($tabAbonneIdInclude) && in_array($strVal, $tabAbonneIdInclude) ) {
          $tabAbonneId[] = $strVal;
        }
      } 
      elseif( substr($strVal, 0 , 2) == "L_" && is_numeric(substr($strVal, 2)) ) { // liste de diff
        $sliste_id = substr($strVal, 2);
        $tabSListeId[] = $sliste_id; 
        $strSql .= ( $strSql != "" ? " union " : "" ).
          $queryAnnu->getDsAbonnesByListe($sliste_id, false, 0, -1, true, false, -1, $tabAbonneIdInclude);
      }/*
      elseif( substr($strVal, 0 , 2) == "A_" && is_numeric(substr($strVal, 2)) ) { // abonné
        $idAbo = substr($strVal, 2);
        if( empty($tabAbonneIdInclude) || 
            !empty($tabAbonneIdInclude) && in_array($idAbo, $tabAbonneIdInclude) ) {
          $tabAbonneId[] = $idAbo;
        }
      }*/
      elseif( substr($strVal, 0 , 3) == "AA_" ) { // abonnés avec agent_id fourni
        $tabAbAg = explode("_", substr($strVal, 3));
        if ( is_numeric($tabAbAg[0]) && is_numeric($tabAbAg[1]) ) {
          $idAbo = $tabAbAg[0];
          $idAg  = $tabAbAg[1];
          if( empty($tabAbonneIdInclude) || 
              !empty($tabAbonneIdInclude) && in_array($idAbo, $tabAbonneIdInclude) ||
              $tabAbAg[1] == ALK_USER_ID_INTERNET ) {
            $tabAbonneId[] = $idAbo;
          }
        }
      }
    }
         
    /*if( !empty($tabAgentId) ) {
      $tabAgentId = array_chunk($tabAgentId, 500);
      foreach($tabAgentId as $tabA) {
        $strListId = ( is_array($tabA)
                       ? implode(",", array_unique($tabA))
                       : $tabA );
        if( $strListId!="-1" && $strListId!="" ) {
          $strSqlAbByAg = $queryAnnu->getStrDsListeAgentMailForLsDif($strListId);
          $strSql .= ( $strSql != "" ? " union " : "" ).$strSqlAbByAg;
          $strSqlAb .= ( $strSqlAb != "" ? " union " : "" ).$strSqlAb;  
        }
      }
    }*/
    
    if( !empty($tabAbonneId) ) {
      $tabAbonneId = array_chunk($tabAbonneId, 500);
      foreach($tabAbonneId as $tabA) {
        $strListId = ( is_array($tabA)
                       ? implode(",", array_unique($tabA))
                       : $tabA );
        if( $strListId!="-1" && $strListId!="" ) {
          $strSqlAbTmp = $queryAnnu->getStrDsListeAgentMailForLsDif($strListId, false, false);
          $strSql .= ( $strSql != "" ? " union " : "" ).$strSqlAbTmp;
          $strSqlAb .= ( $strSqlAb != "" ? " union " : "" ).$strSqlAbTmp;  
        }
      }
    }
    
    if( $iSaveMsg == 1 ) {
      if( $liste_id == "-1" ) {
        // public à l'espace, de type abonnement
        $tabIntitule = array();
        $tabDesc = array();
        foreach($this->tabLangue as $key => $tabLg) {
          $tabIntitule[$key] = "Liste associée au message id=".$msg_id;
          $tabDesc[$key] = "";
        }
        $liste_id = $queryAnnuAction->addListe($tabIntitule, $tabDesc, 1, $user_id, $cont_id, -1, 2);
        
        $strSqlIns = "insert into LSDIF_MSG_LISTE (MSG_ID, LISTE_ID) values (".$msg_id.", ".$liste_id.")";
        $this->dbConn->executeSql($strSqlIns);
      }

      // destinataires du message avant envoi
      $strSqlClean = "delete from SIT_LISTE_SLISTE where LISTE_ID=".$liste_id;
      $this->dbConn->executeSql($strSqlClean);

      $strSqlClean = "delete from SIT_ABONNE_LISTE where LISTE_ID=".$liste_id;
      $this->dbConn->executeSql($strSqlClean);
      
      if( !empty($tabSListeId) ) {
        $strSqlIns = "insert into SIT_LISTE_SLISTE (LISTE_ID, SLISTE_ID) " .
          " select ".$liste_id.", LISTE_ID".
          " from SIT_LISTE".
          " where LISTE_ID in (".implode(",", $tabSListeId).")";
        $this->dbConn->executeSql($strSqlIns);
      }

      if( $strSqlAb != "" ) {
        $strSqlIns = "insert into SIT_ABONNE_LISTE (ABONNE_ID, LISTE_ID) " .
          " select distinct ab.ABONNE_ID, ".$liste_id.
          " from SIT_ABONNE ab".
          "   inner join (".$strSqlAb.") tmp on ab.ABONNE_ID=tmp.ABONNE_ID";
        $this->dbConn->executeSql($strSqlIns);
      }

  	  if( $strSql != "" ) {
        // destinataires après envoi
        $strSqlIns = "insert into LSDIF_DEST (ABONNE_ID, MSG_ID)".
          " select distinct a.ABONNE_ID, ".$msg_id.
          " from (".$strSql.") a".
          "   left join LSDIF_DEST d on (a.ABONNE_ID=d.ABONNE_ID and d.MSG_ID=".$msg_id.")".
          " where d.ABONNE_ID is null";
        $this->dbConn->executeSql($strSqlIns);
        
        // ajout des nouveaux destinataires
        $strSqlIns = "insert into LSDIF_DEST (ABONNE_ID, MSG_ID)".
          " select distinct a.ABONNE_ID, ".$msg_id.
          " from (".$strSql.") a".
          "   left join LSDIF_DEST d on (a.ABONNE_ID=d.ABONNE_ID and d.MSG_ID=".$msg_id.")".
          " where d.ABONNE_ID is null";
        $this->dbConn->executeSql($strSqlIns);
        
        // suppression des destinataires non reconduits
        $strSqlClean = "delete from LSDIF_DEST where MSG_ID=".$msg_id.
          " and ABONNE_ID not in (select a.ABONNE_ID from (".$strSql.") a)";
        $this->dbConn->executeSql($strSqlClean);
      }
    }
    
    if( $strSql != "" ) {
      $strSql .= " order by nom, prenom";
      return $this->dbConn->initDataset($strSql, 0, $iMax);
    }    
    else 
      return $this->dbConn->initDataset("select * from LSDIF_MSG_LISTE where 1=0");
  }

  /**
   * Suppression de la file d'attente, le msg_id
   * @param msg_id   identifiant du message à retirer de la file
   */
  public function delMsgFromQueue($msg_id)
  {
    $strPathQueue = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."queue/";
    $tabFiles = getTabFilesByDir($strPathQueue, array(), false, array(), true, array("_".$msg_id.".queue"));
    foreach($tabFiles as $strPathFileName) {
      if( !file_exists($strPathFileName.".lock") ) {
        delFile($strPathFileName);
        delFile($strPathFileName.".mail");
        delFile($strPathFileName.".mail.end");
      }
    }
  }

	/**
   * Supprime un message de la boite de message
   * @param msg_id         identifiant du message envoyé
   * @param liste_id       identifiant de la liste associée au message
   * @param strPathUpload  chemin physique complet vers le répertoire d'upload
   */
	public function delMsgBoiteEnv($msg_id, $liste_id, $strPathUpload)
  {
    $strSql = "delete from LSDIF_MSG_LISTE where MSG_ID=".$msg_id;
    $this->dbConn->ExecuteSql($strSql);

    $strSql = "delete from LSDIF_MSG_PAGE where MSG_ID=".$msg_id;
    $this->dbConn->ExecuteSql($strSql);

    // supprime les destinataires
    $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    $oAppliAnnu->delListe($liste_id);

    // supprime les destinataires
    $strSql = "delete from LSDIF_DEST where MSG_ID=".$msg_id;
    $this->dbConn->ExecuteSql($strSql);

    // suppression des pièces jointes
    $strSql = "select MSG_PJ from LSDIF_MSG where MSG_ID=".$msg_id;
    $dsMsg = $this->dbConn->initDataSet($strSql);
    if( $drMsg = $dsMsg->getRowIter() ){
      $strFilePJ = $drMsg->getValueName("MSG_PJ");
      $tabFilePJ = explode("|", $strFilePJ);
      for($i=0; $i<count($tabFilePJ); $i++) {
        if( $tabFilePJ[$i] != "" ) {
          $strPathFileName = $strPathUpload.$tabFilePJ[$i];
          delFile($strPathFileName);
        }
      }
    }

    delFile($strPathUpload."lettre_".$msg_id.".htm");

    $this->delMsgFromQueue($msg_id);

    // supprime le message
    $strSql = "delete from LSDIF_MSG where MSG_ID=".$msg_id;
    $this->dbConn->ExecuteSql($strSql);
  }

	/**
   * Supprime un message de la boite de message
   * @param benvdest_id
   */
	public function delMsgBoiteRecu($msg_id, $abonne_id)
  {
    // supprime juste le destinataire
    $strSql = "update LSDIF_DEST set DEST_VISIBLE=0 where MSG_ID=".$msg_id." and ABONNE_ID=".$abonne_id;
    $this->dbConn->ExecuteSql($strSql);
  }
  
  /**
   * Supprime les messages de l'application
   * @param appli_id  Identifiant de l'application
   */
  public function delAppli($appli_id)
  {
    $strWhere = "select MSG_ID from LSDIF_MSG where APPLI_ID=".$appli_id;
    
    $strSql = "delete from LSDIF_DEST where MSG_ID in (".$strWhere.")";
    $this->dbConn->ExecuteSql($strSql);
    
    $strSql = "delete from LSDIF_MSG_PAGE where MSG_ID in (".$strWhere.")";
    $this->dbConn->ExecuteSql($strSql);

    $strSql = "delete from LSDIF_MSG_LISTE where MSG_ID in (".$strWhere.")";
    $this->dbConn->ExecuteSql($strSql);

    // suppression des pièces jointes
    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF, false);
    $strSql = "select MSG_PJ from LSDIF_MSG where APPLI_ID=".$appli_id;
    $dsMsg = $this->dbConn->initDataSet($strSql);
    while( $drMsg = $dsMsg->getRowIter() ) {
      $msgId     = $drMsg->getValueName("MSG_ID");
      $strFilePJ = $drMsg->getValueName("MSG_PJ");
      $tabFilePJ = explode("|", $strFilePJ);
      for($i=0; $i<count($tabFilePJ); $i++) {
        if( $tabFilePJ[$i] != "" ) {
          $strPathFileName = $strPathUpload.$tabFilePJ[$i];
          delFile($strPathFileName);
        }
      }
      delFile($strPathUpload."lettre_".$msgId.".htm");
      $this->delMsgFromQueue($msgId);
    }
    
    $strSql = "delete from LSDIF_MSG where APPLI_ID=".$appli_id;
    $this->dbConn->ExecuteSql($strSql);
  }

  /**
   * Supprime une ou plusieurs listes
   *
   * @param liste_id  Identifiant d'une ou plusieurs listes séparées par une virgule
   */
  public function delListe($liste_id)
  {
    $strSql = "delete from LSDIF_LISTE_BLOC where LISTE_ID in (".$liste_id.")";
    $this->dbConn->ExecuteSql($strSql);

    $strWhere = "select MSG_ID from LSDIF_MSG_LISTE where LISTE_ID in (".$liste_id.")";

    $strSql = "delete from LSDIF_MSG_PAGE where MSG_ID in (".$strWhere.")";
    $this->dbConn->ExecuteSql($strSql);

    $strSql = "delete from LSDIF_DEST where MSG_ID in (".$strWhere.")";
    $this->dbConn->ExecuteSql($strSql);

    $strSql = "delete from LSDIF_MSG_LISTE where LISTE_ID in (".$liste_id.")";
    $this->dbConn->ExecuteSql($strSql);

    $strSql = "delete from LSDIF_MSG where MSG_ID in (".$strWhere.")";
    $this->dbConn->ExecuteSql($strSql);
  }

  /**
   * Méthode appelée avant suppression définitive d'un abonne
   * Attention, si un abonné est propriétaire d'une info, il ne faut pas la supprimer
   * Implémenter les actions effectuant le ménage interne à l'application
   * Retourne true si l'abonné reste supprimable, faux si il est propriétaire d'info
   * @param abonne_id  identifiant de l'abonné, peut contenir une liste d'identifiant
   * @return boolean
   */
  public function delAbonne($abonne_id)
  {
    $strSql = "delete from LSDIF_DEST where ABONNE_ID in (".$abonne_id.")";
    return $this->dbConn->ExecuteSql($strSql);
  }

  /**
   * Méthode appelée après suppression d'un abonnement
   * @param abonne_id  identifiant de l'abonné, peut contenir une liste d'identifiant
   * @param appli_id   identifiant de l'appli newsletter
   */
  public function delAbonnement($abonne_id, $appli_id, $liste_id)
  {
    $strSql = "delete from LSDIF_DEST".
      " where ABONNE_ID=".$abonne_id.
      "  and MSG_ID in (select MSG_ID from LSDIF_MSG where MSG_TYPE=2 and APPLI_ID=".$appli_id.")";
    $this->dbConn->ExecuteSql($strSql);
  }

  /**
   * Supprime les messages associés aux agents
   * @param appli_id        Identifiant de l'application
   * @param strListeAgentId liste d'id des agents dont leurs infos sont à supprimer
   */
  public function delBoiteReceptionAgent($appli_id, $strListeAgentId)
  {
    $strSql = "delete from LSDIF_DEST".
      " where ABONNE_ID in (select ABONNE_ID from SIT_ABONNE where AGENT_ID in (".$strListeAgentId."))".
      ( $appli_id != "-1"
        ? "  and MSG_ID in (select MSG_ID from LSDIF_MSG where APPLI_ID=".$appli_id.")"
        : "" );
    $this->dbConn->ExecuteSql($strSql);
  }

  /**
   * Modifie la propriété d'une information d'un utilisateur à un autre
   * @param agentOld_id  Identifiant de l'utilisateur remplacé
   * @param agentNew_id   Identifiant de l'utilisateur remplaçant
   */
  public function replaceUser($agentOld_id, $agentNew_id) { /** rien à faire */ }

  /*** Gestion des blocs */
  
  /**
   * Associe une catégorie appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param liste_id    Identifiant de la classification
   */
  public function assocCatToBloc($bloc_id, $liste_id) { }
   
  /**
   * Associe un ensemble de données appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param tabDataId   Tableau contenant les identifiants des données à associer
   */
  public function assocDataToBloc($bloc_id, $tabDataId)
  {
    $strSql = "delete from LSDIF_LISTE_BLOC where BLOC_ID=".$bloc_id;
    $this->dbConn->executeSql($strSql, false);
    foreach($tabDataId as $rank=>$data_id) {
      if( $data_id!="" && $data_id!="-1" ) {
        $strSql = "insert into LSDIF_LISTE_BLOC (LISTE_ID, BLOC_ID, LISTE_RANG)".
          " values (".$data_id.", ".$bloc_id.", ".($rank+1).")";
        // accepte l'erreur d'ajout si doublon.
        $this->dbConn->executeSql($strSql, false);
      }
    }
  }
  
  /**
   * Supprime une association entre une catégorie appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param liste_id    Identifiant de la catégorie
   */
  public function removeCatFromBloc($bloc_id, $liste_id) { }
  
  /**
   * Supprime une association entre une donnée appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param liste_id    Identifiant de la données à associer
   */
  public function removeDataFromBloc($bloc_id, $liste_id)
  {
    $strSql = "delete from LSDIF_LISTE_BLOC where BLOC_ID=".$bloc_id.
      ( $liste_id != "-1" ? " and LISTE_ID=".$liste_id : "" );
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * Met à jour le rang d'une donnée dans un bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la donnée
   * @param iRank       Rang actuel de la donnée
   * @param iDelta      Entier : 1 pour descendre d'un rang, -1 pour monter d'un rang
   */
  public function updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta)
  {
    $this->dbConn->switchRank("LSDIF_LISTE_BLOC", "LISTE_RANG", 
                              $iRank, $iDelta, "BLOC_ID=".$bloc_id, "LISTE_ID=".$data_id);
  }
  
  /**
   * Ajout d'un bloc de newsletter
   * @param bloc_id identifiant du bloc
   */
  public function addGEditBloc($bloc_id) 
  {
    $strSql = "insert into LSDIF_FORM_BLOC (BLOC_ID) values (".$bloc_id.")";
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * Suppression d'un bloc de documents
   * @param bloc_id identifiant du bloc
   */
  public function delGEditBloc($bloc_id) 
  {
    $strSql = "delete from LSDIF_FORM_BLOC where BLOC_ID in (".$bloc_id.")";
    $this->dbConn->executeSql($strSql);
    
    $strSql = "delete from LSDIF_LISTE_BLOC where BLOC_ID in (".$bloc_id.")";
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * Met à jour le marqueur d'abonnement à une information pour une relation information/liste
   * Tente de la créer si la relation n'existe pas (crée également un message associé)
   * @param table_name  nom de la table relationnelle entre une information et une liste d'abonnés
   * @param field_name  nom du champ clé primaire de l'information
   * @param data_id     clé primaire de l'information
   * @param liste_id    identifiant de la liste d'abonnés
   * @param msg_id      identifiant du message de notification
   * @param iAbonnement 0 = pas d'abonnement, 1 = abonnement
   * @return 0 = KO, 1 = OK
   */
  public function setInfoAbonnement($table_name="", $field_name="", $data_id=-1, $liste_id=-1, $msg_id=-1, $iAbonnement=0)
  {
    $oQueryLsDif = AlkFactory::getQuery(ALK_ATYPE_ID_LSDIF);
    
    $tabSql = array();
    
    $oDs = $oQueryLsDif->getInfoAbonnement($table_name, $field_name, $data_id);
    if ( $oDs->getCountTotDr() == 0 ) {
      $strSql = "insert into ".strtoupper($table_name)." (".strtoupper($field_name).", LISTE_ID, MSG_ID, ABONNEMENT) values (".$data_id.", ".$liste_id.", ".$msg_id.", ".$iAbonnement.")";
    } else {
      $strSql = "update ".strtoupper($table_name)." set ABONNEMENT=".$iAbonnement." where ".strtoupper($field_name)."=".$data_id." and LISTE_ID=".$liste_id;
    }
    return $this->dbConn->executeSql($strSql, false);
  }
}

?>