/**
 * fonction qui met à jour l'information d'autorisation d'abonnement ainsi que les abonnés de l'information
 * @param strToken    token de l'action
 */
function onChangeNotificationAbonnement(strToken)
{
  var iAbonnement = 0;
  
  var oCtrl = document.getElementById("notification_abonnement");
  if ( !oCtrl ) return;
  if ( oCtrl.checked == true ) {
    iAbonnement = 1;
  }
  
  oStrFieldParentValue = "";
  if ( iAbonnement == 0 ) {
    if ( !alkConfirm(_gt("Souhaitez-vous vraiment interdire l'abonnement à cette information ? (Tous les abonnés de l'information seront supprimés)")) ) {
      oCtrl.checked = !oCtrl.checked;
      return;
    }
  }
  
  var oAjax = new AlkAjax('notification_change_abonnement', 'NothingToDo', "GET", ALK_ALKANET_SQL+"?token="+strToken+"&iAbonnement="+iAbonnement, null, false);
  if ( oAjax.returnValue != "" ) {
    alert("Une erreur est survenue lors de la tentative "+( iAbonnement ? "d'activation" : "de désactivation" )+" de l'abonnement à cette information.");
    oCtrl.checked = !oCtrl.checked;
  }
  
  var oCtrlLink = document.getElementById("link_gerer_abonnes");
  if ( oCtrlLink ) {
    oCtrlLinkStyle = ( oCtrlLink.style ? oCtrlLink.style : oCtrlLink );
    if ( oCtrl.checked ) {
        oCtrlLinkStyle.display = "";
    } else {
    oCtrlLinkStyle.display = "none";
    }
  }
}

/**
 * Ouvre la popup permettant de notifier une action sur une information
 * @param strFunctionVerifCtrl  fonction javascript encodée à exécuter pour vérifier le formulaire
 * @param strTokenNotifier      token de l'action de notification
 * @param strFunctionJsAfter    fonction javascript encodée à executer après envoie de la notification
 * @param iAbonnement           0 : abonnement non autorisé (valeur en base)
 *                              1 : abonnement autorisé (valeur en base)
 * @param liste_id              identifiant de la liste d'abonnés à l'information
 * @param strInfo               chaine des informations de l'information sous la forme infoType__infoTitle__infoValue||infoType__infoTitle__infoValue
 * @param strEvent              chaine des dates de l'événement lié à l'information sous la forme infoType__eventInfoType__eventInfoValue||infoType__eventInfoType__eventInfoValue
 * @param bAbonnesOnly          booléen à true pour notifier uniquement les abonnés de l'information, false sinon
 * @param strChampCheck         nom de la case à cocher qui permet de spécifier si la donnée est publiée ou pas (data_validepub...)
 */
function Notifier(strFunctionVerifCtrl, strTokenNotifier, strFunctionJsAfter, iAbonnement, liste_id, strInfo, strEvent, bAbonnesOnly, strChampCheck)
{
  // vérifie les controles du formulaire si la fonction de vérification est fournie
  if ( strFunctionVerifCtrl != "" ) {
    var res = execEncodedStrFunctionJs(strFunctionVerifCtrl);
    if ( !res ) return false;
  }
  
  // enlève la liste de l'information si l'abonnement sur l'information est désactivé
  var oCtrlAbonnement = document.getElementById("notification_abonnement");
  if ( oCtrlAbonnement ) {  // case à cocher "Autoriser l'abonnement" existe
    if ( oCtrlAbonnement.checked == false ) { // case décochée
      liste_id = -1;
    }
  } else {  // case à cocher "Autoriser l'abonnement" n'existe pas
    if ( iAbonnement == 0 ) { // abonnement non autorisé
      liste_id = -1;
    }
  }
  
  // ne notifie pas si la notification se fait uniquement sur les abonnés de l'information et que l'abonnement est désactivé
  if ( bAbonnesOnly && liste_id == -1 ) {
    execEncodedStrFunctionJs(strFunctionJsAfter);
    return false;
  }
  
  // la notif se fait uniquement sur un document publié (ou en cours de pub)
  if (strChampCheck != ""){
    var oCheckPub = document.getElementById(strChampCheck);
    if (oCheckPub && oCheckPub.checked==false){
  	  execEncodedStrFunctionJs(strFunctionJsAfter);
      return false;
    }
  }
  // demande à l'utilisateur s'il souhaite notifier des utilsateurs
  if ( !alkConfirm(_gt("Souhaitez-vous notifier des utilisateurs avant d'effectuer cette action ?")) ) {
    execEncodedStrFunctionJs(strFunctionJsAfter);
    return false;
  }
  
  // construit les paramètres contenant les informations de l'information
  var strParamInfo = "";
  if ( strInfo != "" ) {
    var tabInfos = strInfo.split("||");
    for ( var i=0; i<tabInfos.length; i++ ) {
      var tabInfoValue = tabInfos[i].split("__");
      if ( tabInfoValue[0] == 0 ) {
       strParamInfo+= "&tabInfo["+encodeURIComponent(tabInfoValue[1])+"]="+encodeURIComponent(tabInfoValue[2]);
      }
      if ( tabInfoValue[0] == 1 ) {
        var oCtrl = document.getElementById(tabInfoValue[2]);
        if ( oCtrl ) {
          strParamInfo+= "&tabInfo["+encodeURIComponent(tabInfoValue[1])+"]="+encodeURIComponent(oCtrl.value);
        } else {
          strParamInfo+= "&tabInfo["+encodeURIComponent(tabInfoValue[1])+"]="+encodeURIComponent("Valeur non trouvée dans le formulaire pour le champ identifié \""+tabInfoValue[2]+"\"");
        }
      }
    }
  }
  
  // construit les paramètres contenant les dates de l'événement lié à l'information
  var strParamEvent = "";
  if ( strEvent != "" ) {
    var tabEvent = strEvent.split("||");
    for ( var i=0; i<tabEvent.length; i++ ) {
      var tabEventValue = tabEvent[i].split("__");
      if ( tabEventValue[0] == 0 ) {
       strParamEvent+= "&"+tabEventValue[1]+"="+encodeURIComponent(tabEventValue[2]);
      }
      if ( tabEventValue[0] == 1 ) {
        var oCtrl = document.getElementById(tabEventValue[2]);
        if ( oCtrl ) {
          strParamEvent+= "&"+tabEventValue[1]+"="+encodeURIComponent(oCtrl.value);
        }
      }
    }
  }
  
  OpenWindow(ALK_ALKANET+"?token="+strTokenNotifier+"&strFunctionJsAfter="+strFunctionJsAfter+"&liste_id="+liste_id+strParamInfo+strParamEvent, 760, 780, "popupNotifier");
  return false;
}

function execEncodedStrFunctionJs(strFunctionJs)
{
  strFunctionJs = decodeURIComponent(strFunctionJs);
  strFunctionJs = strFunctionJs.replace(/\+/g, " ");
  return eval(strFunctionJs);
}