<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="ISO-8859-1" indent="no" omit-xml-declaration="yes"  media-type="text/html"/>

<xsl:template match="/contenu">
  <xsl:apply-templates select="page"/>
</xsl:template>

<xsl:template match="page">

  <xsl:comment>
    la page php contenant le résultat html de cette page doit :
     - définir un formulaire acceptant l'upload
     - charger toutes les librairies js : lib_formXXX.js
  </xsl:comment>

  <div>
    <xsl:attribute name="class">geditPage</xsl:attribute>

  <xsl:if test="./blocs/bloc/@colonne=1">
  <table>
    <xsl:attribute name="valign">top</xsl:attribute>
    <xsl:attribute name="hspace">10</xsl:attribute>
    <xsl:attribute name="vspace">10</xsl:attribute>
    <xsl:attribute name="align">right</xsl:attribute>
    <xsl:attribute name="cellspacing">0</xsl:attribute>
    <xsl:attribute name="border">0</xsl:attribute>
    <xsl:attribute name="cellpadding">0</xsl:attribute>
    <xsl:attribute name="width">200</xsl:attribute>
    <xsl:attribute name="style">padding: 10px; border: none;	margin: 0px 0px 3px 10px;</xsl:attribute>
    <tr>
      <td>
    
    <xsl:for-each select="/contenu/page/blocs/bloc[@colonne=1]">
      
      <xsl:if test="./texte and @colonne=1">
        <div>
          <xsl:attribute name="class">geditBlocColumn</xsl:attribute>
            <xsl:apply-templates select="texte"/>
        </div>
      </xsl:if>

    </xsl:for-each>
  
    <xsl:for-each select="/contenu/page/blocs/bloc/contenu_bloc">
      
      <xsl:if test="./texte and ancestor::bloc/@colonne=1 and @nbbloc>0">
        <div>
          <xsl:attribute name="class">geditBlocColumn</xsl:attribute>
          <xsl:apply-templates select="texte"/>
        </div>
      </xsl:if>

      <xsl:if test="./actualite and ancestor::bloc/@colonne=1 and @nbbloc>0">
        <div>
          <xsl:attribute name="class">geditBlocColumn</xsl:attribute>
          <h3>
            <xsl:choose>
              <xsl:when test="/contenu/@lg = '_FR'">Actualités</xsl:when>
              <xsl:otherwise>News</xsl:otherwise>
            </xsl:choose>
          </h3>
          <ul>        
            <xsl:apply-templates select="child::*"/>
          </ul>
        </div>
      </xsl:if>
      <xsl:if test="./lien and ancestor::bloc/@colonne=1 and @nbbloc>0">
        <div>
          <xsl:attribute name="class">geditBlocColumn</xsl:attribute>
          <h3>
		        <xsl:choose>
		          <xsl:when test="/contenu/@lg = '_FR'">Liens utiles</xsl:when>
		          <xsl:otherwise>Useful Links</xsl:otherwise>
		        </xsl:choose>
          </h3>
          <ul>
          <xsl:apply-templates select="child::*"/>
          </ul>
        </div>
      </xsl:if>
      <xsl:if test="./doc and ancestor::bloc/@colonne=1 and @nbbloc>0">
        <div>
          <xsl:attribute name="class">geditBlocColumn</xsl:attribute>
          <h3>
            <xsl:choose>
              <xsl:when test="/contenu/@lg = '_FR'">Documents à télécharger</xsl:when>
              <xsl:otherwise>To download</xsl:otherwise>
            </xsl:choose>
          </h3>
          <xsl:apply-templates select="child::*"/>
        </div>
      </xsl:if>
      <xsl:if test="./glossaire and ancestor::bloc/@colonne=1 and @nbbloc>0">
        <div>
          <xsl:attribute name="class">geditBlocColumn</xsl:attribute>
          <h3>
	          <xsl:choose>
	            <xsl:when test="/contenu/@lg = '_FR'">Glossaire</xsl:when>
	            <xsl:otherwise>Glossary</xsl:otherwise>
	          </xsl:choose>
          </h3>
          <ul>
            <xsl:apply-templates select="child::*"/>
          </ul>
        </div>
      </xsl:if>
      <xsl:if test="./faqs and ancestor::bloc/@colonne=1 and @nbbloc>0">
        <div>
          <xsl:attribute name="class">geditBlocColumn</xsl:attribute>
          <h3>
            Faqs
          </h3>
          <ul>
            <xsl:apply-templates select="child::*"/>
          </ul>
        </div>
      </xsl:if>
    </xsl:for-each>
    
      </td>
    </tr>
  </table>
  </xsl:if>
  
  <xsl:if test="./titre != ''">
  <ul>
    <xsl:attribute name="class">geditPageTitle bold</xsl:attribute>
    <li> 
      <xsl:value-of select="titre"/>
    </li>
  </ul>
  </xsl:if>

  <xsl:apply-templates select="blocs"/>
  <iframe name='footerExecGEdit' style='display:none;'></iframe>
  </div>

</xsl:template>

<xsl:template match="blocs">
  <xsl:apply-templates select="bloc"/>
</xsl:template>

<xsl:template match="bloc">
  <xsl:if test="@colonne=0">
     <xsl:apply-templates select="child::*"/>
  </xsl:if>
</xsl:template>

<xsl:template match="texte">
  <xsl:apply-templates select="child::*"/>
</xsl:template>

<xsl:template match="contenu_bloc">
  <xsl:if test="ancestor::bloc/@colonne=0">
    <ul class="geditBloc">
    <xsl:apply-templates select="child::*"/>
    </ul>
  </xsl:if>
</xsl:template>

<xsl:template match="lien">
  <li>
    <xsl:attribute name="class">lien</xsl:attribute>
    <a>
      <xsl:attribute name="class">bold</xsl:attribute>
      <xsl:attribute name="href"><xsl:value-of select="url"/></xsl:attribute>
      <xsl:attribute name="target">_new</xsl:attribute>
      <xsl:attribute name="title"><xsl:value-of select="url"/></xsl:attribute>
      <xsl:value-of select="titre"/>
    </a>
	  <xsl:if test="./descl and descl != ''">  
	    <div>
	      <xsl:value-of select="descl"/>
	    </div>
	  </xsl:if>
	</li>  
</xsl:template>

<xsl:template match="glossaire">
  <li>
    <xsl:attribute name="class">glos</xsl:attribute>
  	<span>
      <xsl:attribute name="class">bold</xsl:attribute>
      <xsl:value-of select="titre"/>
    </span>
    <xsl:if test="./descl and descl != ''">  
	    <div>
	      <xsl:value-of select="descl"/>
	    </div>
	  </xsl:if>
	</li>  
</xsl:template>

<xsl:template match="faqs">
  <li>
    <xsl:attribute name="class">faqsq bold</xsl:attribute>
    <xsl:value-of select="desc"/>
	</li>  
  <xsl:if test="./descl and descl != ''">  
    <li>
      <xsl:attribute name="class">faqsr</xsl:attribute>
      <xsl:value-of select="descl"/>
    </li>  
	</xsl:if>
</xsl:template>

<xsl:template match="doc">
  <li>
    <xsl:attribute name="class">doc</xsl:attribute>
    <xsl:if test="./pj">
		  <xsl:apply-templates select="pj"/>
		</xsl:if>
    <img border='0' style='padding-right:4px;'>
      <xsl:attribute name="src"><xsl:value-of select="visuel"/></xsl:attribute>
    </img>
    <span>
      <xsl:attribute name="class">bold</xsl:attribute>
      <xsl:value-of select="titre"/>
    </span>
    <xsl:if test="./descl and descl != ''">  
	    <div style='margin-left:8px;'>
	      <xsl:value-of select="descl"/>
	    </div>
	  </xsl:if>
  </li>
</xsl:template>

<xsl:template match="actualite">
  
  <xsl:if test="ancestor::bloc/@colonne=1">
	  <li>
	    <xsl:attribute name="class">actu bold</xsl:attribute>
	    <xsl:value-of select="titre"/>
  	  <xsl:if test="desc != ''">  
        <div>
          <xsl:value-of select="desc"/>
        </div>
		  </xsl:if>
		</li>  
  </xsl:if>
  
  <xsl:if test="ancestor::bloc/@colonne=0">
    <ul>
      <xsl:attribute name="class">geditBlocActu</xsl:attribute>
      <xsl:if test="./datepub!=''"> <li class='date'>[<xsl:value-of select="datepdeb"/>]</li> </xsl:if>
      <li class='titre bold'><xsl:value-of select="titre"/></li>
      <xsl:if test="./datedeb and datedeb!=''">
		    <li class='date bold'>
		      <xsl:value-of select="datedeb"/>
		      <xsl:if test="./datefin and datefin!=''"> - <xsl:value-of select="datefin"/></xsl:if>
		    </li>
		  </xsl:if>
  	  <li class='desc'>
	      <div>
	        <xsl:if test="./visuel and visuel!=''">
	          <img>
	            <xsl:attribute name="src"><xsl:value-of select="visuel"/></xsl:attribute>
	            <xsl:attribute name="border">0</xsl:attribute>
	            <xsl:attribute name="style">float:left; padding:0px 4px 2px 0px</xsl:attribute>
	            <xsl:attribute name="width"><xsl:value-of select="visuel/@width"/></xsl:attribute>
	          </img>
	        </xsl:if>
          <xsl:if test="./desc and ./desc!=''"><p class='bold'><xsl:value-of select="desc"/></p></xsl:if>
          <xsl:if test="./descl and ./descl!=''"><p><xsl:value-of select="descl"/></p></xsl:if>
		      <xsl:if test="./pj or url!=''">
			      <div style='clear:left'>
			        <xsl:attribute name="class">savoirplus</xsl:attribute>
			        >> En savoir plus
			        <xsl:if test="./pj">
			          <xsl:apply-templates select="pj"/>
			        </xsl:if>
			        <xsl:if test="url!=''">
			          <a>
			            <xsl:attribute name="target">_blank</xsl:attribute>
			            <xsl:attribute name="title"><xsl:value-of select="url"/></xsl:attribute>
			            <xsl:attribute name="href"><xsl:value-of select="url"/></xsl:attribute>
			            <img src='/media/images/bullet_site.gif' border='0'/>
			          </a>
			        </xsl:if>
			      </div>
		      </xsl:if>	   
        </div>
      </li>
    </ul>
	</xsl:if>
</xsl:template>

<xsl:template match="contenu_bloc/form">
  <script type="text/javascript">
  var form_nbClickValidForm<xsl:value-of select="@id"/> = 0;
  function form_ValidForm<xsl:value-of select="@id"/>() {
    var f = document.formulaire<xsl:value-of select="@id"/>;
    if( !f ) return;
  	if( form_nbClickValidForm<xsl:value-of select="@id"/> == 0 ) {
  		var bRes = AlkVerifCtrl(f);
  		if( bRes ) {
  			bRes = window.confirm("Confirmez vous la validation du formulaire ?");
  			if( bRes ) {
  				form_nbClickValidForm<xsl:value-of select="@id"/>++;
  				f.target = "footerExec";
  				f.action = "alkanet_site_sql.php?token=<xsl:value-of select="@token"/>";
  				f.submit();
  			}
  		}
  	}
  }
  </script>
  <form>
    <xsl:attribute name="name">formulaire<xsl:value-of select="@id"/></xsl:attribute>
    <xsl:attribute name="method">post</xsl:attribute>
    <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
  <table summary='' border='0' cellpadding='0' cellspacing='0' align='center'>
    <tr>
      <td>
        <xsl:apply-templates select="texte"/>
        <div align="center" style='padding-top:16px;'>
	        <a>
	          <xsl:attribute name="href">javascript:form_ValidForm<xsl:value-of select="@id"/>()</xsl:attribute>
	          <img src="/media/images/ok.gif" border="0"/>
	        </a>
	      </div>
	    </td>
  	</tr>
	</table>
  </form>
</xsl:template>

<xsl:template match="pj">
  <div>
    <xsl:attribute name="class">menuopener</xsl:attribute>
    <xsl:attribute name="onmouseout">OpenClosePJMenu(this, 'pjs_<xsl:value-of select="@module"/>_<xsl:value-of select="@id"/>', 'out', '<xsl:value-of select="@align"/>', '<xsl:value-of select="@token"/>')</xsl:attribute>
    <xsl:attribute name="onmouseover">OpenClosePJMenu(this, 'pjs_<xsl:value-of select="@module"/>_<xsl:value-of select="@id"/>', 'over', '<xsl:value-of select="@align"/>', '<xsl:value-of select="@token"/>');</xsl:attribute>
    <img src='/media/images/icon_pieces_jointes.gif' width='16' height='16' style='vertical-align: bottom'> 
      <xsl:attribute name="title">
        <xsl:value-of select="@nbpj"/>
        <xsl:choose>
	        <xsl:when test="/contenu/@lg = '_FR'">fichier</xsl:when>
	        <xsl:otherwise>file</xsl:otherwise>
	      </xsl:choose>
        <xsl:if test="@nbpj &gt; 1">s</xsl:if>
      </xsl:attribute> 
    </img>
    <div style="position: relative; height: 0px; display: inline; left: -20px;">
	    <div>
	      <xsl:attribute name="id">pjs_<xsl:value-of select="@module"/>_<xsl:value-of select="@id"/></xsl:attribute>
	      <xsl:attribute name="class">menu</xsl:attribute>
	      <xsl:attribute name="style">display: none;</xsl:attribute>
	    </div>
	  </div>
  </div>
</xsl:template>

<xsl:template match="descl">
  <xsl:apply-templates select="child::*"/>
</xsl:template>
