<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanel.class.php");

/**
 * @package Alkanet_Class_Form
 * 
 * @class AlkHtmlAdapter
 * @brief Classe représentant un panneau d'affichage adpaté à des composants externes à Alkanet
 */
class AlkHtmlAdapter extends AlkHtmlPanel
{
  /** Application propriétaire du formulaire */
  protected $oAppli;

  /** référence sur l'objet externet associé */
  protected $oComponent;

  /** nom de la méthode permettant de récupérer le contenu html */
  protected $strFnHtml;

  /** tableau contenant les valeurs de paramètre de la fonction strFnHtml */
  protected $tabFnArgs;

  /** vrai si capture de la sortie standard, faux sinon (par défaut) */
  protected $bCaptureStdOutput;
  
  /**
   *  Constructeur par défaut
   * 
   * @param name  Identifiant et non du panel
   */
  public function __construct(AlkAppli &$oAppli, $name, $label="")
  {
    parent::__construct($name, $label);
    $this->oAppli         = $oAppli;
    $this->oComponent     = null;
    $this->strFnHtml      = "";
    $this->tabFnArgs      = array();
    $this->bCaptureStdOutput = false;
  }

  /**
   *  destructeur par défaut
   */
  public function __destruct() { }

  /**
   *  fixe l'état de capture
   * @param bCapture  true ou false
   */
  public function setCaptureStdOutput($bCapture)
  {
    $this->bCaptureStdOutput = $bCapture;
  }

  /**
   *  Associe le composant externe
   * @param oComponent  Référence sur l'objet du composant externe
   * @param strFnHtml   Nom de la fonction à appeler pour générer le contenu html
   * @param tabFnArgs   Tableau de paramètres de la fonction strFnHtml, =array() par défaut
   */
  public function setComponent($oComponent, $strFnHtml, $tabFnArgs=array())
  { 
    $this->oComponent = $oComponent;
    $this->strFnHtml  = $strFnHtml;
    $this->tabFnArgs  = $tabFnArgs;
  }

  /**
   *  méthode virtuelle pour initialiser le composant qui sera affiché
   */
  protected function setContents() { }

  /**
   *  Retourne le code Html du composant
   */
  public function getHtml()
  {
    $this->setContents();

    $strHtml = "";
    if( $this->bCaptureStdOutput ) {
      ob_start();
      call_user_func_array(array(&$this->oComponent, $this->strFnHtml), $this->tabFnArgs);
      $strHtml = ob_get_contents();
      ob_end_clean();

    } else {
      $strHtml = call_user_func_array(array(&$this->oComponent, $this->strFnHtml), $this->tabFnArgs);
      if( is_bool($strHtml) ) {
        $strHtml = "";
      }
    }
    
    return $strHtml;
  }
}

?>