/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

window.oParamCalendar = [];
window.bCalendar = [];

var texts = {
  en : {
    previous_month : "Previous month",
    next_month : "Next month",
    week_title : "Week ",
    week_title_abrev : "Week",
    _goto : "Go to ",
    _select : "Select date ",
    clear_title : "Clear date",
    clear_text : "Clear"
  },
  fr : {
    previous_month : "Mois précédent",
    next_month : "Mois suivant",
    week_title : "Semaine ",
    week_title_abrev : "Sem.",
    _goto : "Aller à ",
    _select : "Sélectionner le ",
    clear_title : "Vider le champ date",
    clear_text : "Aucune"
  }
}

function DefineCalendar(guid){
  var strVar = "oCalendar_"+guid;
  
  if ( typeof window.bCalendar[guid] == "undefined" )
    window.bCalendar[guid] = false;
    
  if ( typeof window.oParamCalendar[guid] == "undefined" ) 
    return window.bCalendar[guid];
  
  if ( window.bCalendar[guid] && eval("typeof "+strVar+" != 'undefined' && "+strVar+" != null") ) 
    return window.bCalendar[guid];
  
  eval("delete("+strVar+")");
  if ( eval("typeof "+strVar+" == 'undefined' || "+strVar+" == null") ) {
    eval(strVar+" = new Calendar('"+guid+"', window.oParamCalendar['"+guid+"'])");
  }
  window.bCalendar[guid] = true;
  return window.bCalendar[guid];
}
function OpenCalendar(guid){
  var strVar = "oCalendar_"+guid;
  if ( !DefineCalendar(guid) ) return;
  if (eval(strVar+".oDiv")){
    eval(strVar+".Open"+(window.oParamCalendar[guid]["closeOnChoose"] ? "Close" : "")+"Calendar((arguments.length>1 ? arguments[1] : true))");
  }
}
function HideCalendar(guid){
  var strVar = "oCalendar_"+guid;
  if ( !DefineCalendar(guid) ) return;
  if (eval(strVar+".oDiv")){
    eval(strVar+".HideCalendar(false)");
  }
}

var dayNames = new Array(_gt("Lundi"), _gt("Mardi"), _gt("Mercredi"), _gt("Jeudi"), _gt("Vendredi"), _gt("Samedi"), _gt("Dimanche"));
//var dayNames = new Array();
//dayNames["en"] = new Array("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday");
//dayNames["fr"] = new Array("Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi", "Dimanche");

var months = new Array(_gt("Janvier"), _gt("Février"), _gt("Mars"), _gt("Avril"), _gt("Mai"), _gt("Juin"), 
                       _gt("Juillet"), _gt("Août"), _gt("Septembre"), _gt("Octobre"), _gt("Novembre"), _gt("Décembre"));
//var months = new Array();
//months["en"] = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
//months["fr"] = new Array("Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre");

var iDayStyle = 1;

var xp=0;
var yp=0;  

var CURSOR_HAND = "hand";
// Taille de la fenetre
if (navigator.userAgent.indexOf("IE") >= 0){
/*  maxX = document.body.scrollLeft + document.body.clientWidth;
  maxY = document.body.scrollTop  + document.body.clientHeight ;*/
  CURSOR_HAND = "hand";
}
else{  
  // AVOIR pour le scroll
  CURSOR_HAND = "pointer";
/*  maxX = window.innerWidth;   
  maxY = window.innerHeight;  */
}  
if (navigator.userAgent.indexOf("IE") >= 0){   
  var calxpos = "event.offsetX";
  var calypos = "event.offsetY";
}else{
  var calxpos = "e.pageX";
  var calypos = "e.pageY";
}

var MODE_DAY = 1;
var MODE_WEEK = 2;
var MODE_MONTH = 3;

var nbYears = 10;


Calendar.prototype.constructor = Calendar;
function Calendar(inputName, date_min, date_max){
  this.oParam = null;
  if ( arguments.length==2 && typeof arguments[1]=="object" ){
    this.oParam = arguments[1];
    for (var prop in this.oParam){
      eval(prop+" = '"+this.oParam[prop]+"';");
      this[prop] = this.oParam[prop];
    }
  }
  
  this.iMode = MODE_DAY;
  this.inputName = inputName;
  this.oDiv = document.getElementById(this.inputName+"_allCalendarDiv");
  this.oDiv2 = document.getElementById(this.inputName+"_calendarDiv");
  this.oInput = document.getElementById(this.inputName);
  this.oHide = document.getElementById("hide_"+this.inputName);
  this.bOpen = false;
  
  this.select_day = "";
  this.select_month = "";
  this.select_year = "";

  this.dDate = new Date();
  this.MIN_YEAR = 1900;
  //this.MAX_YEAR = this.dDate.getFullYear()+2;
  this.MAX_YEAR = 2099;
  
  this.cur_year = this.dDate.getFullYear();
  this.cur_month = this.dDate.getMonth()+1;
  this.cur_day = this.dDate.getDate();
  
  this.lang = "fr";
  this.langSave = "fr";
  
  this.oDateMin = null;
  this.oDateMax = null;
  this.date_min = date_min;
  this.date_max = date_max;
  
  
  this.closeOnChoose = true;
  if (arguments.length>3){
    this.closeOnChoose = arguments[3];
  }
  this.image_path = "../../media/images/"; 

}

Calendar.prototype.initCalendar = function (bFocusInput){
  
  if (this.date_min=="")
    this.date_min = "01/01/"+this.MIN_YEAR;
  if (this.date_max=="")
    this.date_max = "31/12/"+this.MAX_YEAR;
    
  if (this.date_min!=""){
    var tabDate = this.date_min.replace("W", "").split("/");
    if (this.langSave=="fr"){
      this.oDateMin = new Date(tabDate[2], tabDate[1]-1, tabDate[0]);
    }
    else {
      this.oDateMin = new Date(tabDate[2], tabDate[0]-1, tabDate[1]);      
    }
  }
  if (this.date_max!=""){
    var tabDate = this.date_max.replace("W", "").split("/");
    if (this.langSave=="fr"){
      this.oDateMax = new Date(tabDate[2], tabDate[1]-1, tabDate[0]);
    }
    else {
      this.oDateMax = new Date(tabDate[2], tabDate[0]-1, tabDate[1]);      
    }
  }
  
  if ( this.oInput && this.oInput.disabled ) return;
  if (this.oInput) {
    this.oInput.defaultValue = this.oInput.value;
  }
  
  var dCurDate = new Date();
  
  if (this.oInput){
    if (this.lang!=this.langSave && this.oHide)
      var fDate = this.oHide.value;
    else
      var fDate = this.oInput.value;
    var tabDate = fDate.replace("W", "").split("/");
    for (var i=0; i<tabDate.length; i++){
      tabDate[i] = parseInt(tabDate[i].replace(/^0/, ''));
    }
    if (this.iMode==MODE_DAY){
      if (this.langSave=='fr' && fDate.match(new RegExp("[0-3][0-9]\/[0-1][0-9]\/[0-9]{4}"))){
        var day = tabDate[0];
        var month = tabDate[1]-1;
        var year = tabDate[2];
      }
      else if (this.langSave=='en' && fDate.match(new RegExp("[0-1][0-9]\/[0-3][0-9]\/[0-9]{4}"))){
        var day = tabDate[1];
        var month = tabDate[0]-1; 
        var year = tabDate[2];         
      }
      else if( fDate=="" ){
        var day = dCurDate.getDate();
        var month = dCurDate.getMonth();
        var year = dCurDate.getFullYear();
      }
      else return;
      dCurDate = new Date(year, month, day); 
      this.select_day = dCurDate.getDate();
    }
    else if (this.iMode==MODE_WEEK && fDate.match(new RegExp("W[0-5][0-9]\/[0-9]{4}")) ){
      var week = tabDate[0];
      var year = tabDate[1];
      dCurDate = this.getDateFromWeek(year, week);
      this.select_day = week;
    }
    else if (this.iMode==MODE_MONTH && fDate.match(new RegExp("[0-1][0-9]\/[0-9]{4}")) ){
      var month = tabDate[0]-1;
      var year = tabDate[1];
      dCurDate = new Date(year, month, 1);
      this.select_day = dCurDate.getDate();
    }
    
    if ( this.oInput.onfocus && bFocusInput ){
      this.oInput.onfocus();
    }
  }
  
  
  this.select_month = dCurDate.getMonth()+1;
  this.select_year = dCurDate.getFullYear();
  this.cur_day = this.select_day;
  this.cur_month = this.select_month;
  this.cur_year = this.select_year;
  
}

Calendar.prototype.CheckWeek = function(initWeek, cur_year, cur_month, cur_date){
  var week = initWeek;
  if (this.oDateMin){
    var oDateMin = this.oDateMin;
    if (cur_year>=oDateMin.getFullYear()){
	   var aDate = new Date(cur_year, cur_month-1, cur_date);
   	 if (aDate.getTime()<oDateMin.getTime()) 
   	   week = this.getWeek(oDateMin.getFullYear(), oDateMin.getMonth(), oDateMin.getDate());
    }
    else week = this.getWeek(oDateMin.getFullYear(), oDateMin.getMonth(), oDateMin.getDate());
 	}
  if (this.oDateMax){
    var oDateMax = this.oDateMax;
    if (cur_year<=oDateMax.getFullYear()){
	   var aDate = new Date(cur_year, cur_month-1, cur_date);
   	 if (aDate.getTime()>oDateMax.getTime()) {
   	   week = this.getWeek(oDateMax.getFullYear(), oDateMax.getMonth(), oDateMax.getDate());
   	 }
    }
    else week = this.getWeek(oDateMax.getFullYear(), oDateMax.getMonth(), oDateMax.getDate());
 	}
 	return week;
}

Calendar.prototype.CheckDate = function(cur_year, cur_month, cur_date){
  var date = new Date(cur_year, cur_month-1, cur_date);
  if (this.oDateMin){
    var oDateMin = this.oDateMin;
    if (cur_year>=oDateMin.getFullYear()){
	   var aDate = new Date(cur_year, cur_month-1, cur_date);
   	 if (aDate.getTime()<oDateMin.getTime()) 
   	   date = oDateMin;
    }
    else date = oDateMin;
 	}
  if (this.oDateMax){
    var oDateMax = this.oDateMax;
    if (cur_year<=oDateMax.getFullYear()){
	   var aDate = new Date(cur_year, cur_month-1, cur_date);
   	 if (aDate.getTime()>oDateMax.getTime()) {
   	   date = oDateMax;
   	 }
    }
    else date = oDateMax;
 	}
 	return date;
}

Calendar.prototype.fToggleColor = function (myElement, bOver) {
  if (!myElement) return;
  if (myElement.className.indexOf('invalid')!=-1) return;
  if (myElement.id.indexOf("calCell")!=-1 && myElement.className.indexOf('select')==-1) {
    myElement.className = (bOver ? myElement.className+' over' : myElement.className.replace(" over", ""));
  }
}

Calendar.prototype.fToggleColorWeek = function (myElement, bOver) {
  if (!myElement) return;
  if (myElement.className.indexOf('invalid')!=-1) return;
  if (myElement.className.indexOf('invalidweek')!=-1) return;
  if (this.iMode==MODE_WEEK){
    if (myElement.id.indexOf("_weekCell_")!=-1 && myElement.className.indexOf('select')==-1)
      myElement.className = (bOver ? myElement.className+' over' : myElement.className.replace(" over", ""));
  }
}

Calendar.prototype.fToggleColorMonth = function (myElement, bOver) {
  if (!myElement) return;

  if (myElement.className.indexOf('invalid')!=-1) return;
  if (this.iMode==MODE_MONTH){
    if (myElement.id.indexOf("_monthCell_")!=-1 && myElement.className.indexOf('select')==-1) 
      myElement.className = (bOver ? myElement.className+' over' : myElement.className.replace(" over", ""));
  }
}

Calendar.prototype.clearDate = function (){
    
  if (this.oInput!=null) {
    this.oInput.value = (this.defaultValue ? this.defaultValue : '');
    if (this.oInput.onchange){
      if (arguments.length==1 || arguments[1]){
        this.oInput.onchange();
      }
    }
  }     
  if (this.oHide!=null) {
    this.oHide.value = (this.defaultValue ? this.defaultValue : '');
  }
  
  if (this.closeOnChoose) this.HideCalendar();
}

Calendar.prototype.fSetSelectedDay = function (myElement){
  if (!myElement) return;
  
  if (myElement.id.indexOf(this.inputName+"_calCell")!=-1) {
    if (myElement.className.indexOf('invalid')!=-1) return;
    if (this.dateSelected){
      var element = document.getElementById(this.inputName+"_calCell_"+this.dateSelected);
      if (element) element.className = element.className.replace(" select", "");
      if (element) element.className = element.className.replace(" over", "");
    }         
    
    myElement.className = myElement.className+' select';
    
    var date = myElement.id.substring((this.inputName+"_calCell_").length);
    this.dateSelected = date;
    if (!isNaN(parseInt(date))) {    
      var day = parseInt(date);
      var before_day = (day<10 ? "0" : "");
      var before_month = (this.cur_month<10 ? "0" : "");      
      if (this.oInput!=null) {
        if (this.lang=="fr")
          this.oInput.value = before_day+day+"/"+before_month+this.cur_month+"/"+this.cur_year;
        else
          this.oInput.value = before_month+this.cur_month+"/"+before_day+day+"/"+this.cur_year;
        if (this.oInput.onchange){
          if (arguments.length==1 || arguments[1]){
            this.oInput.onchange();
          }
        }
      }     
      if (this.oHide!=null) {
        if (this.langSave=="fr")
          this.oHide.value = before_day+day+"/"+before_month+this.cur_month+"/"+this.cur_year;
        else
          this.oHide.value = before_month+this.cur_month+"/"+before_day+day+"/"+this.cur_year;
      }
      
      if (this.closeOnChoose) this.HideCalendar();
    }
    
  }
}

Calendar.prototype.fSetSelectedWeek = function (myElement){
  if (!myElement) return;
  
  if (myElement.id.indexOf(this.inputName+"_weekCell")!=-1) {
    if (myElement.className.indexOf('invalid')!=-1) return;
    if (myElement.className.indexOf('invalidweek')!=-1) return;
    if (this.weekSelected){
      var element = document.getElementById(this.inputName+"_weekCell_"+this.dateSelected);
      if (element) element.className = element.className.replace(" select", "");
      if (element) element.className = element.className.replace(" over", "");
    }         
    
    myElement.className = myElement.className+' select';
    
    var week = myElement.id.substring((this.inputName+"_weekCell_").length);
    this.weekSelected = week;
    if (!isNaN(parseInt(week))) {    
      week = parseInt(week);  
      if (this.oInput!=null) {
/*        var weekEnd = this.getWeek(this.cur_year, 11, 31);
        if (week==weekEnd && new Date(this.cur_year, 11, 31).getDay()!=0){
          this.cur_year++;
          week = this.getWeek(this.cur_year, 0, 1);  
        }*/
        if (week>=52 && this.cur_month==1) {
          this.cur_year--; 
          week = this.getWeek(this.cur_year, 11, 31);
        }
        var before_week = (week<10 ? "0" : "");  
        this.oInput.value = "W"+before_week+week+"/"+this.cur_year;
        if (this.oInput.onchange){
          if (arguments.length==1 || arguments[1]){
            this.oInput.onchange();
          }
        }
      }
      if (this.oHide!=null) {
        this.oHide.value = "W"+before_week+week+"/"+this.cur_year;
      }
      
      if (this.closeOnChoose) this.HideCalendar();
    }
    
  }
}

Calendar.prototype.fSetSelectedMonth = function (myElement){
  if (!myElement) return;
  
  if (myElement.id.indexOf(this.inputName+"_monthCell")!=-1) {
    if (myElement.className.indexOf('invalid')!=-1) return;
    if (myElement.className.indexOf('invalidmonth')!=-1) return;
    if (this.monthSelected){
      var element = document.getElementById(this.inputName+"_monthCell_"+this.dateSelected);
      if (element) element.className = element.className.replace(" select", "");
      if (element) element.className = element.className.replace(" over", "");
    }         
    
    myElement.className = myElement.className+' select';
    
    var month = myElement.id.substring((this.inputName+"_monthCell_").length);
    this.monthSelected = month;
    if (!isNaN(parseInt(month))) {    
      month = parseInt(month);
      var before_month = (month<10 ? "0" : "");    
      if (this.oInput!=null) {
        this.oInput.value = before_month+month+"/"+this.cur_year;
        if (this.oInput.onchange){
          if (arguments.length==1 || arguments[1]){
            this.oInput.onchange();
          }
        }
      }  
      if (this.oHide!=null) {
        this.oHide.value = before_month+month+"/"+this.cur_year;
      }  
      
      if (this.closeOnChoose) this.HideCalendar();
    }
    
  }
}
Calendar.prototype.fGetDaysInMonth = function (iMonth, iYear) {
  var dPrevDate = new Date(iYear, iMonth, 0);
  return dPrevDate.getDate();
}

Calendar.prototype.fGetFirstDayInMonth = function (iMonth, iYear) {
  var dCalDate = new Date(iYear, iMonth-1, 1);
  return dCalDate.getDay();
}

Calendar.prototype.getDayNames = function (iStyle){
  var strHtml = "";
  strHtml += "<tr>";
  strHtml += "<td align='center' width='14%' class='weektitle'>" + _gt("Sem.") /*(this.langSave=="en" ? "Week" : "Sem.")*/ + "</td>";
  
  for (var i=0; i<dayNames.length; i++){
    var day = dayNames[i];
    switch (iStyle){
      case 0 : day = day.substring(0, 2); break;
      case 1 : day = day.substring(0, 3); break;
    }
    strHtml += 
      "<td align='center' width='14%' class='daytitle'>" + day + "</td>";
  }
  strHtml += "</tr>";
  
  return strHtml;
}
Calendar.prototype.isBissextile =  function (iYear){
  return ( (iYear%400==0) || ((iYear%4==0) && (iYear%100!=0)));
}

Calendar.prototype.getWeekStart =  function (iYear){
  var start = new Date(iYear, 0, 1);
  var day = start.getDay();
  if (day>0 && day<5){
    return 1;
  }
  
  var nbYear = 1;
  if (this.getWeekStart(iYear-1)!=1){
    nbYear++;
  }
  if (nbYear==1)
    return 53;
  else
    return 52;
}

Calendar.prototype.getWeek = function (iYear, iMonth, iDate){
	return getWeek(iYear, iMonth, iDate);
}

function y2k(number) { return (number < 1000) ? number + 1900 : number; }

function getWeek(year,month,day) {
    var when = new Date(year,month,day);
    var newYear = new Date(year,0,1);
    var modDay = newYear.getDay();
    if (modDay == 0) modDay=6; else modDay--;

    var daynum = ((Date.UTC(y2k(year),when.getMonth(),when.getDate(),0,0,0) -
                 Date.UTC(y2k(year),0,1,0,0,0)) /1000/60/60/24) + 1;

    if (modDay < 4 ) {
        var weeknum = Math.floor((daynum+modDay-1)/7)+1;
    }
    else {
        var weeknum = Math.floor((daynum+modDay-1)/7);
        if (weeknum == 0) {
            year--;
            var prevNewYear = new Date(year,0,1);
            var prevmodDay = prevNewYear.getDay();
            if (prevmodDay == 0) prevmodDay = 6; else prevmodDay--;
            if (prevmodDay < 4) weeknum = 53; else weeknum = 52;
        }
    }

    return + weeknum;
}

/**
* Returns the week number for this date. dowOffset is the day of week the week
* "starts" on for your locale - it can be from 0 to 6. If dowOffset is 1 (Monday),
* the week returned is the ISO 8601 week number.
* @param int dowOffset
* @return int
*/
Date.prototype.getWeek = function (dowOffset) {
/*getWeek() was developed by Nick Baicoianu at MeanFreePath: http://www.meanfreepath.com */

  dowOffset = typeof(dowOffset) == 'int' ? dowOffset : 0; //default dowOffset to zero
  var newYear = new Date(this.getFullYear(),0,1);
  var day = newYear.getDay() - dowOffset; //the day of week the year begins on
  day = (day >= 0 ? day : day + 7);
  var daynum = Math.floor((this.getTime() - newYear.getTime() -
    (this.getTimezoneOffset()-newYear.getTimezoneOffset())*60000)/86400000) + 1;
  var weeknum;
  weeknum = Math.floor((daynum+day-1)/7) + 1;
  
  //if the year starts before the middle of a week
  if(day < 4) {
    weeknum = Math.floor((daynum+day-1)/7) + 1;
    if(weeknum > 52) {
      nYear = new Date(this.getFullYear() + 1,0,1);
      nday = nYear.getDay() - dowOffset;
      nday = nday >= 0 ? nday : nday + 7;
      /*if the next year starts before the middle of
      the week, it is week #1 of that year*/
      weeknum = nday < 4 ? 1 : 53;
    }
  }
  else {
    weeknum = Math.floor((daynum+day)/7);
  }
  return weeknum;
};

Calendar.prototype.getDateFromWeek= function(iYear, iWeek){
  var nbJours = iWeek * 7;
  var start = new Date(iYear-1, 11, 31);
  var time = start.getTime() + (nbJours) * 24 * 60 * 60 * 1000;
  var date = new Date();  date.setTime(time);
  /*if ( dateMonday.getMonth() == date.getMonth() )
    return dateMonday;*/
  return date;
}

Calendar.prototype.getCalendar = function (iYear, iMonth){  
  var strHtml = "";
  
  //Navigation supérieur
  var dateMinus = this.CheckDate(this.cur_year, this.cur_month, 1);
  var datePlus = this.CheckDate(this.cur_year, parseInt(this.cur_month)+1, 1);
	var validMonthMinus = (dateMinus.getTime()>this.oDateMin.getTime());
	var validMonthPlus = (datePlus.getTime()<this.oDateMax.getTime());

  strHtml += "<table width='220' cellspacing='0' cellpadding='4' class='popcal'>";  
  strHtml += "<tr>";
	strHtml += "<td valign='top' align='left' width='98%'>";
	strHtml += "<table border='0' cellspacing='0' cellpadding='3' width='100%' class='poptitle'>";
	strHtml += "	<tr>";
	strHtml += "		<td align='left'>" +
	    ( validMonthMinus
  	    ? "<a title='"+_gt("Mois précédent")+"' href='javascript:oCalendar_"+this.inputName+".decreaseMonth();'>"+
  	      "<img src='"+this.image_path+"cal_prev.gif' width='16' height='16' alt='"+_gt("Mois précédent")+"' border='0' /></a>" 
  	    : "") +
	    "</td>";
	strHtml += "	<td width='99%' align='center'><div id='"+this.inputName+"_months'>"+months[this.cur_month-1]+" "+this.cur_year+"</div></th>";
	strHtml += "		<td align='right'>" +
	    ( validMonthPlus
  	    ? "<a title='"+_gt("Mois suivant")+"' href='javascript:oCalendar_"+this.inputName+".increaseMonth();'>"+
  	      "<img src='"+this.image_path+"cal_next.gif' width='16' height='16' alt='"+_gt("Mois suivant")+"' border='0' /></a>" 
  	    : "") +
	    "</td>";
	strHtml += "	</tr>";
	strHtml += "</table>";
  strHtml += "<div id='"+this.inputName+"_calendar'>";
  
  // Calendrier
  
	//Jours et semaines
  strHtml += "<table border='0' cellspacing='1' cellpadding='2' width='100%' class='popcalext'>";
  strHtml += this.getDayNames(iDayStyle);
  var iDayOfFirst = this.fGetFirstDayInMonth(iMonth, iYear);
  if (iDayOfFirst==0) iDayOfFirst = 7;
  var iDaysInMonth = this.fGetDaysInMonth(iMonth, iYear);
  strHtml += "<tr>";
  var week = 1;
  var strCssWk = "week";
  if (this.iMode!=MODE_WEEK)
    strCssWk = "invalidweek";
    
  if (iDayOfFirst!=1){
    week = this.getWeek(iYear, iMonth-1, 1);
    var oDate = this.CheckDate(this.cur_year, iMonth, 1);
	  var validWeek = this.getWeek(oDate.getFullYear(), oDate.getMonth(), oDate.getDate());
	  bInvalidWeek = false;
    var strInvalid = "";
	  if ( bInvalidWeek = !(validWeek==week && oDate.getFullYear()==iYear) ) {
      strInvalid = " invalid";
      this.select_day = validWeek;
      this.select_year = oDate.getFullYear();
	  }
    var strCssWeek = strCssWk + strInvalid;
    if ( this.iMode==MODE_WEEK && week==this.select_day  && iYear==this.select_year){
      strCssWeek += " select";
     	this.weekSelected = week;
    }
  	strHtml += "	<td class='"+strCssWeek+"' id='"+this.inputName+"_weekCell_"+week+"'" +
        	        " onMouseOver='oCalendar_"+this.inputName+".fToggleColorWeek(this, true)'" +
      	          " onMouseOut='oCalendar_"+this.inputName+".fToggleColorWeek(this, false)'" +
      	          " onclick='oCalendar_"+this.inputName+".fSetSelectedWeek(this)'" +
      	          ">";
    strHtml += week;
    strHtml += "	</td>";
  }
  
  for (var i=1; i<iDayOfFirst; i++){
		strHtml += "	<td class='empty'>";
		strHtml += "	</td>";
  }
  
  var dayOfWeek = iDayOfFirst;
  for (var date=1; date<=iDaysInMonth; date++){
    
    if (dayOfWeek==1){
  	  strHtml += "</tr><tr>";       
  	  week = this.getWeek(iYear, iMonth-1, date);
  	  var oDate = this.CheckDate(this.cur_year, iMonth, date);
  	  var validWeek = this.getWeek(oDate.getFullYear(), oDate.getMonth(), oDate.getDate());
  	  bInvalidWeek = false;
      var strInvalid = "";
  	  if ( bInvalidWeek = !(validWeek==week && oDate.getFullYear()==iYear) ) {
        strInvalid = " invalid";
        this.select_day = validWeek;
        this.select_year = oDate.getFullYear();
  	  }
      var strCssWeek = strCssWk + strInvalid;
      if ( this.iMode==MODE_WEEK && week==this.select_day && iYear==this.select_year ){
        strCssWeek += " select";
     	  this.weekSelected = week;
      }
    	strHtml += "	<td class='"+strCssWeek+"' id='"+this.inputName+"_weekCell_"+week+"'" +
    	        " onMouseOver='oCalendar_"+this.inputName+".fToggleColorWeek(this, true)'" +
  	          " onMouseOut='oCalendar_"+this.inputName+".fToggleColorWeek(this, false)'" +
      	      " onclick='oCalendar_"+this.inputName+".fSetSelectedWeek(this)'" +
  	          ">";
      strHtml += week
      strHtml += "	</td>";
      
    }
    
    strClass = "day";  	  
  	if (dayOfWeek>5){
  	  strClass = "weekend";
  	  if (dayOfWeek==7)
  	    dayOfWeek = 0;
  	}
    
    if (!isNaN(date)) {
   	   
   	 if (date == this.dDate.getDate() && iMonth==this.dDate.getMonth()+1 && iYear==this.dDate.getFullYear()){
   	   strClass += " today";
   	   this.dateSelected = date;
   	 }
   	
   	 var bInvalid = false;
	   var aDate = new Date(iYear, iMonth-1, date);
   	 if (this.oDateMin){
   	   if (aDate<this.oDateMin){
   	     strClass += " invalid";
   	     bInvalid = true;
   	   }
   	 }
   	 if (this.oDateMax){
   	   if (aDate>this.oDateMax && !bInvalid){
   	     strClass += " invalid";
   	     bInvalid = true;
   	   }
   	 }
   	 
   	 if (this.iMode==MODE_DAY && !bInvalid){
     	 if (date == this.select_day && iMonth==this.select_month && iYear==this.select_year){
     	   strClass += " select";
     	   this.dateSelected = date;
     	 }
   	 }
   	 
   	 if (this.iMode!=MODE_DAY)
   	  strClass = "invalid";
     strHtml += "	<td id='"+this.inputName+"_calCell_"+date+"' class='"+strClass+"' style='cursor:"+CURSOR_HAND+"' ";
     strHtml += " onMouseOver='oCalendar_"+this.inputName+".fToggleColor(this, true)'" +
    	          " onMouseOut='oCalendar_"+this.inputName+".fToggleColor(this, false)'" +
    	          " onclick='oCalendar_"+this.inputName+".fSetSelectedDay(this)'>";
     strHtml += "	"+ date;
     strHtml += "	</td>";	
	
      dayOfWeek++;
    } 
  }
  for (var i=dayOfWeek; i>1 && i<=7; i++){
		strHtml += "	<td class='empty'>";
		strHtml += "	</td>";
  }
	
  strHtml += "</tr>";
  strHtml += "</table>";
    
	//Barre des mois
  strHtml += "<table border='0' cellspacing='0' cellpadding='0' width='100%' class='popcalfoot'>";
	strHtml += "	<tr><td colspan='3'>";
  strHtml += "<table border='0' cellspacing='1' cellpadding='2' width='100%' class='popcalext'>";
	strHtml += "	<tr>";
	
	for (var i=0; i<months.length; i++){
	  var strCssMonth = "month";
	  
	  var bInvalidMonth = false;
	  var date = this.CheckDate(this.cur_year, i+1, 1);
	  if ( bInvalidMonth = !(date.getMonth()==i && date.getFullYear()==this.cur_year) ) 
	     strCssMonth += " invalid";
	  
	  if (this.iMode==MODE_MONTH){
	    if ((i+1)==this.select_month && this.cur_year==this.select_year){
	      strCssMonth += " select";
	      this.monthSelected = i+1;
	    }
	  }
	  else if (!bInvalidMonth) {
	    strCssMonth += " invalidmonth";
	  }
	  strHtml += "	<td title='"+months[i]+"' width='8%'  class='"+strCssMonth+"'" +
	      " id='"+this.inputName+"_monthCell_"+(i+1)+"'" +
	      " onmouseover='oCalendar_"+this.inputName+".fToggleColorMonth(this, true)'" +
	      " onmouseout='oCalendar_"+this.inputName+".fToggleColorMonth(this, false)'" +
	      ( !bInvalidMonth 
	        ? " onclick='"+( this.iMode==MODE_MONTH 
	                         ? "oCalendar_"+this.inputName+".fSetSelectedMonth(this)" 
	                         : "oCalendar_"+this.inputName+".changeMonth(\""+(i+1)+"\");")+"'" 
	        : "") +
	      ">" + months[i].charAt(0) + "</td>";
	}
	strHtml += "	</tr>";
	strHtml += "</table>";
	strHtml += "</td></tr>";
	strHtml += "	<tr><td colspan='3' height='4'></td></tr>";
	strHtml += "	<tr>";
	
	//Navigation inférieure
	strHtml += "	<td class='tdlienmoisL'>" +
	    (this.cur_year-1>(this.oDateMin.getFullYear()-1)
	     ? "<a href='javascript:oCalendar_"+this.inputName+".changeYear("+(this.cur_year-1)+");'  class='lienmois'>"+(this.cur_year-1)+"</a>" 
	     :  this.cur_year-1)+  
	      "</td>";
	strHtml += "	<td class='tdlienmoisC'>" +
	    "<a href='javascript:oCalendar_"+this.inputName+".clearDate();' class='lienmois'>"+_gt("Aucune")+"</a>" 
	         "</td>";
	strHtml += "	<td class='tdlienmoisR'>" +
	    (this.cur_year+1<=this.oDateMax.getFullYear()
	     ? "<a href='javascript:oCalendar_"+this.inputName+".changeYear("+(this.cur_year+1)+");'  class='lienmois'>"+(this.cur_year+1)+"</a>" 
	     : this.cur_year+1)+  
	         "</td>";
	strHtml += "	</tr>";
	strHtml += "</table>";
	
	//Fin
  strHtml += "</div>";
  strHtml += "</td></tr>";
  strHtml += "</table>";
  return strHtml;
}

Calendar.prototype.decreaseMonth = function (){
  var old_month = this.cur_month;
  this.cur_month = (this.cur_month-1)%12;
  if (old_month==1) {
  	 this.cur_month = 12;
   	 this.cur_year = this.cur_year - 1;
  }
  document.getElementById(this.inputName+"_months").innerHTML = months[this.cur_month-1]+" "+this.cur_year;
  this.changeCalendar();
}

Calendar.prototype.increaseMonth = function (){
  var old_month = this.cur_month;
  this.cur_month = (this.cur_month+1)%12;
  if (old_month==11) {
  	 this.cur_month = 12;
  }
  if (old_month==12) {
   	 this.cur_year = this.cur_year + 1;
  }
  document.getElementById(this.inputName+"_months").innerHTML = months[this.cur_month-1]+" "+this.cur_year;
  this.changeCalendar();
}

Calendar.prototype.changeDay = function (iDay){
  var id = this.inputName+"_calCell_"+iDay;
  this.fSetSelectedDay( document.getElementById(id), false );
}

Calendar.prototype.changeMonth = function (iMonth){
  this.cur_month = iMonth;
  document.getElementById(this.inputName+"_months").innerHTML = months[this.cur_month-1]+" "+this.cur_year;
  this.changeCalendar();
}

Calendar.prototype.changeYear = function (iYear){
  this.cur_year = iYear;
  this.cur_month = 1;
  document.getElementById(this.inputName+"_months").innerHTML = months[this.cur_month-1]+" "+this.cur_year;
  this.changeCalendar();
}

Calendar.prototype.changeCalendar = function (){
  this.dateSelected = 0;
  this.oDiv2.innerHTML = this.getCalendar(this.cur_year, this.cur_month);
}

Calendar.prototype.getCloseButton = function (){
  var strHtml = "<a href='javascript:oCalendar_"+this.inputName+".HideCalendar()'>";
  strHtml += "<img src='../../../media/admin/images/bt_close.gif' width='15' height='15' border=0>";
  strHtml += "</a>";
  return strHtml;
}

Calendar.prototype.OpenCloseCalendar = function (){
  if (this.bOpen) this.HideCalendar();
  else this.OpenCalendar();
}

Calendar.prototype.SetMode = function (iMode){
  this.iMode = iMode;
  if (this.bOpen)
    this.OpenCalendar();
}
Calendar.prototype.OpenCalendar = function (bFocusInput){
  if ( this.oInput && this.oInput.disabled ) return;
  this.initCalendar(bFocusInput);
  if ( this.bOpen ) return;
  var strHtml = this.getCalendar(this.cur_year, this.cur_month, this.cur_day);
  
  this.oDiv2.innerHTML = strHtml; 
  if (oToday = document.getElementById(this.inputName+'calCell'+this.cur_day)){
    oToday.oldClassName = oToday.className;
  }
  var calskn = this.oDiv.style;
 /* if (!(xp==0 && yp==0)){
    calskn.top  = yp+20;
    calskn.left = xp+10;   
  }*/
  calskn.display = "block";

  this.bOpen = true;
}

Calendar.prototype.HideCalendar = function (){
  var calskn = this.oDiv.style;
  calskn.display = "none";
  if (this.oInput){
    this.oInput.defaultValue = this.oInput.value;
    
    if ( this.oInput.onblur && arguments.length==0 ){
      this.oInput.onblur();
    }
  }
  this.bOpen = false;
}




function FocusTexte(Obj) {
  // A l'entrée dans le champ 
  // Si la valeur égale la valeur par défaut => on efface
  if (Obj.value == Obj.defaultValue && !isDateValidJJMMAAAA(Obj.value) )
    Obj.value = '';
}
function BlurTexte(Obj) { 
  // A la sortie du champ
  // Si la valeur est vide => on remet la valeur par défaut
  if (Obj.value == '')
    Obj.value = Obj.defaultValue;
}

$(function()
{ 
	initCalendar();
});

function initCalendar()
{
  for ( var guid in window.oParamCalendar){
		$('#' + guid ).datepicker($.datepicker.regional[_gt("fr")]);
    $('#' + guid ).datepicker( "option", "dateFormat", 'dd/mm/yy' );
    $('#' + guid ).datepicker( "option", "changeMonth", true );
    $('#' + guid ).datepicker( "option", "changeYear", true ); 
	}
}

