<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlFile
 * 
 * Classe d'affichage d'un composant de saisie texte.
 *        génère : <input type=file>
 *                 ou une ligne proposant le fichier en téléchargement 
 *                 avec case à cocher pour le supprimer
 *                 Nom de la case à cocher : 
 */
class AlkHtmlFile extends AlkHtmlCtrl
{
  /** = vrai par défaut pour afficher la case à cocher de suppression en mode 1 */
  protected $bDel;

  /** adresse du fichier à télécharger en mode 1 */
  protected $urlFile;

  /** nombre de colonnes, =0 par défaut 
   * iWidth est calculé à partir de column si <>0 
   */
  protected $column;

  /** longueur max, =0 par défaut */
  protected $maxlength;

  /** largeur en pixels, = vide par défaut 
   * column est calculé à partir de width si <>vide 
   */
  protected $width;

  /** Fenêtre cible sur ouverture du fichier existant */
  protected $target;

  /** =true pour affichage simultané du mode lecture et modif, false sinon (par défaut) */
  protected $bDualMode;

  /** nom du checkbox : par défaut = del_[name] si bDualMode=false, =[name] sinon */
  protected $cbName;

  /**
   *  Constructeur par défaut 
   * @param oForm     référence sur l'objet formulaire
   * @param iMode     Mode du controle de saisie : =0 modif, =1 lecture
   * @param name      Nom du controle de saisie
   * @param value     Valeur par défaut du controle de saisie
   * @param label     Etiquette texte associée au controle de saisie
   * @param column    Taille en caractère de la zone de saisie (sans prendre en compte la taille du bouton)
   * @param maxlength Longueur max du nom de fichier
   */
  public function __construct($oForm, $iMode, $name, $value="", $label="", $column=0, $maxlength=0)
  {
    parent::__construct($oForm, $iMode, $name, $value, $label);
    $this->bDel = ($iMode==0);
    $this->urlFile = "";
    $this->column = $column;
    $this->maxlength = $maxlength;
    $this->width = "";
    $this->target = "_blank";
    $this->bDualMode = false;
    $this->cbName = "del_".$this->name;
  }
  
  /**
   * Génère puis retourne le code html associé au controle de saisie
   * @param iMode =1 pour afficher le lien vers le fichier existant
   *              =2 pour afficher le ctrl de sélection du fichier
   */
  private function _getHtml($iMode)
  {
    // contruit le controle
    $strHtml = "";
    
    if( $iMode == "1" ) {
      // mode lecture, propose de lire le fichier, de cocher une case pour le supprimer
      if( $this->value != "" ) {
        $strHtml .= '<a class="'.$this->cssLink.'"'.
          ' target="'.$this->target.'"'.
          ' href="'.$this->urlFile.'">'.$this->value.'</a>';
        if( $this->bDel == true ) {
          $strHtml .= '&nbsp;&nbsp;<input type="checkbox" id="'.$this->cbName.'" name="'.$this->cbName.'" value="1"'.
            $this->GetHtmlEvent().'/>' .
            '<input type="hidden" id="old_'.$this->getGUID().'" name="old_'.$this->name.'" value="'.$this->value.'"/>'.
            '<span class="'.$this->cssText.'">&nbsp;'._t("Effacer").'</span>';
        }
      } else {
        $strHtml .= '<span id="msg_'.$this->name.'" class="'.$this->cssText.'">('._t("pas de fichier disponible").')</span>';
      }
      $strHtml .= '<br/>';
    } else {
      // mode modif
      $iDeltaColumn = ( strpos($_SERVER["HTTP_USER_AGENT"], "Linux") === false ? 0 : -10 );

      $bIE = true;
      if( ALK_NAVFAM != ALK_NAVFAM_IEXPLORER ) {
        $strClass = "";
        $bIE = false;
      }

      $iDelta = -20;
      if( !$bIE && $this->column>0 ) {
        $this->column -= 2;
        $iDelta = -8;
      }
      $iDelta += $iDeltaColumn*8;

      if( $this->width=="" ) { 
        $this->width = $this->column*8+$iDelta;
      } else {
        $iDelta = -20;
        $this->column = ceil(($this->width- $iDelta)/8)+( $bIE ? 0 : -5 );
      }
      
      $strClass = ( $this->cssFormCtrl != ""
                    ? ' class="'.$this->cssFormCtrl.'"'
                    : '' );
      
      if( $this->width!="" ) $strClass .= ' style="width: '.$this->width.'px;"';
      
      // input type=file
      $strHtml = '<input type="file" id="'.$this->guid.'" name="'.$this->name.'"'.
        ' value="'.$this->value.'" defaultValue="'.$this->urlFile.'" '.
        $strClass.
        ( $this->column!="0" ? ' size="'.($this->column+$iDeltaColumn).'"' : '' ).
        $this->GetHtmlEvent().
        '/>';
    }
    return $strHtml;
  }
  
  /**
   *  Modifie le mode d'affichage du controle
   * @param bMode   true pour affichage simultané du mode lecture et modif, false sinon
   */
  public function setDualMode($bMode)
  {
    $this->bDualMode = $bMode;
  }

  /**
   *  Modifie l'url du fichier actuellement sélectionné (affichage en mode 1)
   * @param strUrlBase   url de base
   * @param strFileName  nom du fichier
   */
  public function setFileUrl($strUrlBase, $strFileName)
  {
    $this->urlFile = ( $strFileName=="" ? "" : $strUrlBase.$strFileName );
  }
  
  /**
   *  indique si le controle necessite un formulaire de type upload 
   * @return boolean  
   */
  public function isUpload()
  {
    return !$this->isHidden(); 
  } 

  /**
   *  Pour retourner le code html du ctrl de saisie seul
   *        Méthode appelée par GetHtml qui se chargera d'ajouter le code JS
   *        les textes before et after, les drapeaux, le bouton d'aide
   */
  protected function getCtrlHtml($key=0, $tabLg=array()) 
  {
    // contruit le controle
    $strHtml = "";

    // vérifie la valeur de cbName si cbName possède toujours un nom par défaut
    // sinon on laisse la valeur personnalisée
    if( $this->cbName == $this->name ) {
      $this->cbName = ( $this->bDualMode == true ? $this->name : "del_".$this->name );
    } 

    if( $this->bDualMode == false || ($this->bDualMode==true && $this->iMode=="1") ) {
      $strHtml = $this->_getHtml($this->iMode);
    } else {
      // this->bDualMode==true && this->iMode==2
      $strHtml = $this->_getHtml("1").$this->_getHtml("2");
    }
    return $strHtml;
  }

}

?>