<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlblock.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkintlist.int.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlList
 * 
 * Classe affichant une liste paginée
 */
class AlkHtmlList extends AlkHtmlBlock implements AlkIntList
{
  /** Nombre d'appels à _getHtmlSelectResults */
  private static $iNbSelect = 0;
  
  /** Nombre d'élément au total (hors pagination) */
  protected $iNbElt;
  
  /** numéro de page actuel (=1 par défaut) */
  protected $iNumPage;

  /** nombre éléments par page (=20 par défaut) */
  protected $iNbEltParPage;

  /** vrai si résultat paginé, faux sinon (true par défaut) */
  protected $bPagine;

  /** vrai si affichage de la pagination avant la liste, faux sinon par défaut */
  protected $bAffPagineBefore;

  /** tableau contenant l'alignement et la largeur de chaque colonne */
  protected $tabAlign;

  /** nombre de colonnes */
  protected $iNbCol;

  /** tableau contenant les titres de chaque colonne */
  protected $tabTitle;

  /** tableau contenant les droits de chaque colonne */
  protected $tabRight;

  /** tableau contenant les infos de chaque ligne */
  protected $tabData;

  /** url de pagination */
  protected $strUrlPagine;

  /** vrai= tabData contient toutes les données, faux = tabData ne contient que les données de la page (faux par défaut) */
  protected $bAllData;

  /** Message affiché pour le cas où pas de résultat */
  protected $strMsgNoResult;

  /** Message affiché pour le cas où pas de colonne affichée (pour cause de droit) */
  protected $strMsgNoColumn;

  /** Vrai si le compteur des résultats ("indiceMin - indiceMax / iNbElt") est affiché */
  protected $bAffCompteur;

  /** Nombre réel de ligne de résultats hors rowspan */
  protected $iNbRealElt;

  /** Vrai si le combo de choix du nombre de résultats par page est affiché */
  protected $bSelectNbElts;

 /** Tableau du combo de choix du nombre de résultats */
  protected $tabValSelect;

  /** css du tableau */
  protected $cssList;
  
  /** style par defaut pour les td impair */
  protected $cssDefault;
  
  /** deuxieme style css pour les td */ 
  protected $cssGroup;
  
  /** active (true) ou non (false par défaut) l'apparence de block pour ce ctrl */
  protected $bBlock;

  /** Formulaire propriétaire de la liste */
  protected $oForm;

  /** Hauteur autour du message de no results (30px en haut et en bas par défaut) */
  protected $iHeightNoRes;
  
  /** chaine texte contenant le mot tout */
  protected $strAll;
  
  protected $mode;
  
  protected $id;
 
  /**
   *  Constructeur par défaut
   * 
   * @param oForm          Formulaire propriétaire de la liste (null accepté)
   * @param iNbElt         Nombre d'élément au total (hors pagination)
   * @param iNumPage       Numéro de page actuel (=1 par défaut)
   * @param iNbEltParPage  Nombre éléments par page (=20 par défaut)
   * @param bPagine        Vrai si résultat paginé, faux sinon (true par défaut)
   * @param strUrlPagine   url de pagination
   * @param strMsgNoResult message affiché lorsqu'une info n'est affichée
   * @param bAllData       vrai= tabData contient toutes les données, faux = tabData ne contient que les données de la page (faux par défaut)
   * @param strName        nom du controle : tabPagine par défaut
   * @param bSelectNbElts  true pour afficher le composant de selection de pagination
   * @param tabValSelect   Tableau contenant les paginations possibles
   */
  public function __construct($oForm, $iNbElt=0, $iNumPage=1, $iNbEltParPage=ALK_ITEMS_PER_PAGE, $bPagine=true, $strUrlPagine="", 
                              $strMsgNoResult="", $bAllData=false, $strName="tabPagine", $bSelectNbElts=true, $tabValSelect=array())
  {
    parent::__construct($oForm, $strName);

    $this->iNbElt           = $iNbElt;
    $this->iNumPage         = $iNumPage;
    $this->iNbEltParPage    = $this->oldEltsParPage = $iNbEltParPage;
    $this->bPagine          = $bPagine;
    $this->strUrlPagine     = $strUrlPagine;
    $this->bAllData         = $bAllData;
    $this->strMsgNoResult   = $strMsgNoResult;
    $this->iHeightNoRes     = 30;
    $this->strMsgNoColumn   = "";
    $this->iNbCol           = 0;
    $this->tabAlign         = array();
    $this->tabTitle         = array();
    $this->tabRight         = array();
    $this->tabData          = array();
    $this->bAffCompteur     = false; 
    $this->iNbRealElt       = -1;
    $this->bSelectNbElts    = $bSelectNbElts;
    $this->bAffPagineBefore = false;
    $this->bBlock           = false;
    $this->strAll           = _t("Tout");
    $this->tabValSelect     = ( empty($tabValSelect) 
                                ? array($iNbElt => $this->strAll,
                                        "10" => "10",
                                        "20" => "20",
                                        "30" => "30",
                                        "50" => "50",
                                        "100" => "100",
                                        "200" => "200",
                                        "500" => "500")
                                : $tabValSelect );
    $this->cssList       = "tabList";
    $this->cssDefault    = "impair";
    $this->cssGroup      = "group";
    $this->id            = $this->getGUID().($this->bBlock ? '_list' : '');
    $this->setDefaultCss("alkhtmllist.css");
  }

  /**
   *  Active les propriétés d'affichage d'un block formulaire pour cet objet
   * 
   * @param strTitle     Titre du block, vide par défaut
   * @param strDesc      Commentaire du block, vide par défaut
   * @param iWidthLabel  Largeur en pixel de la colonne label
   * @param iWidthCtrl   Largeur en pixel de la colonne ctrl
   * @param bMaintitle   false par défaut, true pour signifier un bloc principal
   * @param iSheet       Identifiant de l'onglet contenant ce bloc, =0 par défaut
   */
  public function enableBlock($strTitle="", $strDesc="", $iWidthLabel="180", $iWidthCtrl="390", $bMaintitle=false, $iSheet=0)
  {
    $this->bBlock = true;
    $this->title  = $strTitle;
    $this->labelDesc = $strDesc;
    $this->iSheet = $iSheet;
    $this->iWidthLabel = $iWidthLabel;
    $this->iWidthCtrl = $iWidthCtrl;
    $this->bMainTitle = $bMaintitle;
  }

  /**
   *  Regarde si la donnée est un objet de type htmlctrl et l'ajoute à la liste des controles si c'est le cas
   * 
   * @param oData  Donnée à controler 
   */
  private function checkData($oData)
  {
    if ( is_object($oData) && is_subclass_of($oData, self::ALK_CLASS_HTMLCTRL) ){
      $this->addCtrl($oData, ALK_HTMLFORM_NONE);
    }
  }
  
  /**
   *  Définit l'alignement et la largeur de chaque colonne
   *        Un paramètre est du type array(align, width) 
   *        Le nombre de paramètre n'est pas limité. 
   *        Ce nombre est la borne sup à ne pas dépasser lors des appels des autres méthodes
   */
  public function setColumns()
  {
    $this->setColumnsByArray(func_get_args());
  }

  /**
   *  Définit l'alignement et la largeur de chaque colonne
   *        Un paramètre est du type array(align, width) 
   *        Le nombre de paramètre n'est pas limité. 
   *        Ce nombre est la borne sup à ne pas dépasser lors des appels des autres méthodes
   *
   * @param tabParam Paramètres du tableau : align et width 
   */
  public function setColumnsByArray($tabParam)
  {
    $this->iNbCol = count($tabParam);
    $this->tabAlign = $tabParam;
  }

  /**
   *  Affecte les titres aux colonnes.
   *        Possibilité de colspan sur les colonnes.
   *        Un paramètre est du type array(title, colspan) ou array(title, colspan, rowspan) ou title equivalent à array(title, 1, 1)
   */
  public function addTitleRow()
  {
    $this->addTitleRowByArray(func_get_args());
  }

  /**
   *  Affecte les titres aux colonnes.
   *        Possibilité de colspan sur les colonnes.
   *        Un paramètre est du type array(title, colspan) ou array(title, colspan, rowspan) ou title equivalent à array(title, 1, 1)
   *
   * @param tabParam Tableau contenant les titres de chaque colonne
   */
  public function addTitleRowByArray($tabParam)
  {
    if( count($tabParam) > $this->iNbCol ) 
      return;

    $tabTitle = array();
    for($i=0; $i<count($tabParam); $i++) {
      $oElt = $tabParam[$i];
      if( is_array($oElt) ){
        for($p=1; $p<3; $p++){//remplissage du colspan(indice 1) et du rowspan(indice 2) à la valeur 1 si non définit 
          if( !array_key_exists($p, $oElt) )
            $oElt[$p] = 1;
        }
        $tabTitle[] = $oElt;
        $this->checkData($oElt[0]);
      }
      else {
        $tabTitle[] = array($oElt, 1, 1);
        $this->checkData($oElt);
      }
    }
    $this->tabTitle[count($this->tabTitle)] = $tabTitle;
  }
   
  /**
   *  Affecte les droits aux colonnes (pas de colspan)
   *        Valeur de right : 0=aucun, 1=visible
   */
  public function addRightRow()
  {
    $this->addRightRowByArray(func_get_args());
  }

  /**
   *  Affecte les droits aux colonnes (pas de colspan)
   *        Valeur de right : 0=aucun, 1=visible
   * @param tabRightRow tableau contenant les droits des colonnes 
   */
  public function addRightRowByArray($tabRightRow)
  {
    if( count($tabRightRow) != $this->iNbCol ) 
      return;

    for($i=0; $i<count($tabRightRow); $i++) {
      $oElt = $tabRightRow[$i];
      if( is_numeric($oElt) && $oElt==1 )
        $this->tabRight[] = 1;
      else
        $this->tabRight[] = 0;
    }
  }
  /**
   *  Ajoute une ligne au tableau. 
   *        Chaque paramètre correspondant à une colonne. 
   *        Un paramètre est du type array(htmldata, colspan, rowspan) ou htmldata equivalent à array(htmldata, 1, 1)
   *        Le nombre de paramètre n'est pas limité
   */
  public function addRow()
  {
    $this->addRowByArray(func_get_args());
  }

  /**
   *  Ajoute une ligne au tableau. 
   *        Chaque paramètre correspondant à une colonne. 
   *        Un paramètre est du type array(htmldata, colspan, rowspan) ou htmldata equivalent à array(htmldata, 1, 1)
   *        Le nombre de paramètre n'est pas limité
   *
   * @param tabRow Tableau contenant les données d'une ligne
   */
  public function addRowByArray($tabRow)
  {    
    if( count($tabRow) > $this->iNbCol ) 
      return;
    
    $iRow = count($this->tabData);
    for($i=0; $i<count($tabRow); $i++) {
      $oElt = $tabRow[$i];
      if( is_array($oElt) && count($oElt)>=3 ){
        $this->tabData[$iRow][$i] = $oElt;
        
        $this->checkData($oElt[0]);
      }
      else {
        $this->tabData[$iRow][$i] = array($oElt, 1, 1);
        $this->checkData($oElt);
      }
    }
  }
  

  /**
   *  Retourne l'entete du tableau de la page courante
   */
  protected function _getHtmlHeader()
  {
    $strHtml = '';
    
    $strDim  = "";
    $iDimPx = $iDimPc = 0;
    $nbCol = 0;
    for($i=0; $i< $this->iNbCol; $i++) {
      if( count($this->tabRight) == 0 || 
          count($this->tabRight) > 0 && $this->tabRight[$i] > 0 
      ){    
        $bPercent = mb_ereg("%", $this->tabAlign[$i][1]);
        if ( $bPercent )
          $iDimPc += mb_ereg_replace("%", "", $this->tabAlign[$i][1]);
        else
          $iDimPx += $this->tabAlign[$i][1];
        $strDim .= '<col style="width:'.$this->tabAlign[$i][1].($bPercent ? '' : 'px').'"/>';
        $nbCol++;
      }
    }
    $strWidth = "";
    if ( $iDimPc >= 100)
      $strWidth = 'width:100%;';
    else if ( $iDimPx==0 )
      $strWidth = 'width:'.$iDimPc.'%;';
    else if ( $iDimPc==0 )
      $strWidth = 'width:'.$iDimPx.'px;';
      
    $strHtml.= '<table summary=""' .
      ' class="'.$this->cssList.'"'.
      ' style="'.$strWidth.$this->cssStyle.'"'.
      ( $this->strTableAlign!="" 
        ? ' align="'.$this->strTableAlign.'"' 
        : '' ) .
      ' id="'.$this->id.'">'.
      ( $this->title!=""
        ? '<caption>'.$this->title.'</caption>'
        : '' ).
      ( $strDim != ""
        ? '<colgroup>'.$strDim.'</colgroup>'
        : '' );

    if( $nbCol == 0 ) {
      $this->iNbCol = 0;
      $strHtml = "";
      return $strHtml;
    }
    
    $strHtmlHeader = "";
    if( $this->labelDesc != "" ) {
      $strHtmlHeader .= '<tr><td colspan="'.$nbCol.'" class="desc">'.$this->labelDesc.'</td></tr>';
    }
    
    if( $this->bAffPagineBefore ) {
      $strHtmlHeader .= $this->_getHtmlPagination(false);
    }
    
    for($j=0; $j< count($this->tabTitle); $j++) {
      $iRealCol = 0;
      $strHtmlHeader .= '<tr>';
      for($i=0; $i< count($this->tabTitle[$j]); $i++) {
        if( count($this->tabRight) == 0 || 
            count($this->tabRight) > 0 && $this->tabRight[$iRealCol] > 0 ) {
          $strTitle = "";
          
          $contents = $this->tabTitle[$j][$i][0];
          if ( is_string($contents) ){
            $strTitle = $contents;
          }
          else if ( is_object($contents) && $contents->isTypeOf(self::ALK_CLASS_HTMLPANEL) ){
            $strTitle = (!$contents->isTypeOf(self::ALK_CLASS_HTMLBUTTON) ? $contents->getLabel()." " : "").
                        $contents->getHtml();
          }
          
          if ( $this->bAffCompteur && $i==0 && $j==0 && $this->iNbRealElt!=-1 ){
            $indiceMin = ($this->iNumPage-1) * $this->iNbEltParPage+1;
            $indiceMax = $this->iNbRealElt+$indiceMin-1; 
            
            $strTitle = '<div style="float:left">'.$strTitle.'</div>';
            
            $strTitle .= '<span style="float:right">'.
              ( !$this->bPagine && $this->bAllData 
                ? _nf("%s élément", "%s éléments", $this->iNbElt)
                : ( $this->iNbElt==0 
                    ? "0" 
                    : $indiceMin." - ".$indiceMax 
                  ). " / ".$this->iNbElt 
              ). '</span>';
               
          } 
          $cssStyle = "";
          $cssClass = "";
          if(isset($this->tabTitle[$j][$i][3])) {
            $style = $this->tabTitle[$j][$i][3];
            $forceClassCss = true;
            if(is_string($style)) {
              if( substr($style, 0, 7) == "style='" ) {
                $style = str_replace("'", '"', $style);
              }
              if( substr($style, 0, 7) == 'style="' ) {
                $cssStyle = ' '.$style.' ';
              } else {
                $cssClass = $style;
              }
            }
          } 
          
          $strHtmlHeader .= '<th'.
            ' align="center"'.
            $cssStyle.
            ( $cssClass!="" 
              ? ' class="'.$cssClass.'"'
              : '' ).
            ( $this->tabTitle[$j][$i][1] > 1 
              ? ' colspan="'.$this->tabTitle[$j][$i][1].'"' 
              : '' ).
            ( $this->tabTitle[$j][$i][2] > 1 
              ? ' rowspan="'.$this->tabTitle[$j][$i][2].'"' 
              : '' ).
            '>'.$strTitle.'</th>';
        }
        $iRealCol += $this->tabTitle[$j][$i][1];
      }
      $strHtmlHeader .= '</tr>';
    }
    
    $strHtml .= ( $strHtmlHeader!=''
                  ? '<thead>'.$strHtmlHeader.'</thead>'
                  : '' );
    return $strHtml;
  }

  /**
   *  Retourne le contenu de la page courante du tableau
   */
  protected function _getHtmlBody()
  {
    $strHtml = "";

    if( isset($_GET["print"]) && $_GET["print"] == "1" ) {
      $this->bPagine = false;
    }

    if( $this->bPagine == false ) {
      $this->iNbEltParPage = max($this->iNbElt, 1);
      $this->iNumPage = 1;      
    }

    $iFirst = 0;
    $iLast = min(count($this->tabData)-1, $this->iNbEltParPage-1);

    if( $this->bAllData == true && $this->bPagine == true ) {
      $iFirst = ($this->iNumPage-1)*$this->iNbEltParPage;
      $iLast = min($this->iNbElt-1, $iFirst+$this->iNbEltParPage-1);
    }
    
    if ( !is_null($this->oTemplate) ){
      $this->oTemplate->assign("iFirst", $iFirst);
      $this->oTemplate->assign("iLast", $iLast);
      $this->oTemplate->assign("tabData", $this->tabData);
      $this->oTemplate->assign("tabAlign", $this->tabAlign);
      $this->oTemplate->assign("tabRight", $this->tabRight);

      return $this->oTemplate->fetch($this->strTemplateFile);
    } 
    
    for($iRow=$iFirst; $iRow<=$iLast; $iRow++) {
      $strHtml .= '<tr id="tr'.$this->name.$iRow.'">';
      $iRealCol = 0;      
      for($iCol=0; $iCol<count($this->tabData[$iRow]); $iCol++) {
        if( count($this->tabRight) == 0 || 
            count($this->tabRight) > 0 && $this->tabRight[$iRealCol] > 0 
        ){
          $contents = $this->tabData[$iRow][$iCol][0];
          $strContents = '&nbsp;';
         
          if ( is_object($contents) && is_subclass_of($contents, self::ALK_CLASS_HTMLPANEL) ){
            $strContents = $contents->getHtml();
          } else {
            $strContents = $contents;
          }

          $cssClass = $this->cssDefault;
          $cssStyle = "";
          $forceClassCss = false;
          if(isset($this->tabData[$iRow][$iCol][3]) && $this->tabData[$iRow][$iCol][3]!=="") {
            $style = $this->tabData[$iRow][$iCol][3];
            $forceClassCss = true;
            if( is_bool($style) ) {
              $cssClass = ( $style ? $this->cssDefault : $this->cssGroup );
            } else if(is_string($style)) {
              // inverse les quotes et doubles quotes
              if( substr($style, 0, 7) == "style='" ) {
                $style = str_replace("'", '"', $style);
              }
              if( substr($style, 0, 7) == 'style="' ) {
                $forceClassCss = false;
                $cssStyle = ' '.$style.' ';
              } else {
                $cssClass = $style;
              }
            }
          } 
          $strHtml .= '<td id="td'.$this->name.$iRow.'_'.$iCol.'"'.
            $cssStyle.
            ( (($iRow % 2) == 0 && !$forceClassCss) 
              ? '' 
              : ' class="'.$cssClass.'"' ).
            ( $this->tabData[$iRow][$iCol][1] > 1 
              ? ' colspan="'.$this->tabData[$iRow][$iCol][1].'"' 
              : '' ).
            ( $this->tabData[$iRow][$iCol][2] > 1 
              ? ' rowspan="'.$this->tabData[$iRow][$iCol][2].'"' 
              : '' ).
            ( isset($this->tabData[$iRow][$iCol][4]) && $this->tabData[$iRow][$iCol][4]!="" 
              ? ' title="'.addslashes($this->tabData[$iRow][$iCol][4]).'"' 
              : '' ).
            ' align="'.$this->tabAlign[$iRealCol][0].'"'. 
            ' valign="top"'.
            ( isset($this->tabData[$iRow][$iCol][5]) 
              ? ' '.$this->tabData[$iRow][$iCol][5] 
              : '' ).
            '>'.$strContents.'</td>';
        }
        $iRealCol += $this->tabData[$iRow][$iCol][1];
      }

      $strHtml .= '</tr>';
    }

    if( $strHtml != "" ) {
      $strHtml = '<tbody>'.$strHtml.'</tbody>';
    }
    
    return $strHtml;
  }

  /**
   *  Retourne la fin de la page courante
   */
  protected function _getHtmlFooter()
  {
    return ( $this->iNbCol == 0 ? '' : '</table>' );
  }

  /**
   *  Retourne les liens de pagination
   */
	protected function _getHtmlPagination($bClose=true)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbuttonicon.class.php");
    
    $anchor = preg_replace("!^[^#]+!", "", $this->strUrlPagine);
    $strUrlPagine = str_replace($anchor, "", $this->strUrlPagine);

    $strHtml = '';
    $strFooter    = ( $bClose ? '<tfoot>' : '' );
    $strFooterEnd = ( $bClose ? '</tfoot>' : '' );

    $bUrlJs = ( mb_strtolower(mb_substr($strUrlPagine, 0, 11)) == "javascript:" ? true : false );
	
    $noPageSuiv = $this->iNumPage + 1;
    $noPagePrec = $this->iNumPage - 1;
    $nbTotalPages = $this->getNbTotalPages();
    
    $noPageDebut = max($this->iNumPage-5, 1);
    $noPageFin   = min($this->iNumPage+5, $nbTotalPages);
    
    // affiche la pagination si resultat sur plusieurs pages
    if( $nbTotalPages>1 && $this->iNumPage<=$nbTotalPages && $this->iNumPage>0 ) {
      $strHtml .= $strFooter.
        '<tr class="pagination"><td colspan="'.$this->iNbCol.'">'.
        '<table cellpadding="0" border="0" cellspacing="0" width="100%"><tr><td class="left">';
      
      if( $nbTotalPages>1 ) {
        $strHtml .= 'Pages&nbsp;:&nbsp;';
      }
      if( $noPagePrec > 0 ) {
        $strBtUrl = $strUrlPagine;
        $strBtUrl = ( $bUrlJs == true
                      ? str_replace("page", $noPagePrec, $strBtUrl)
                      : $strUrlPagine."&page=".$noPagePrec.$anchor);
        $oBtPrec = new AlkHtmlButtonIcon($strBtUrl, _t("Precedent"), _t("Page Précédente"));
        $strHtml .= $oBtPrec->getHtml().'&nbsp;&nbsp;&nbsp;';
      }
      
      if( $nbTotalPages>1 ) {
        for($i=$noPageDebut; $i<=$noPageFin; $i++)
          if( $this->iNumPage == $i ) {
            $strHtml .= " ".$i;
          } else {
            $strBtUrl = $strUrlPagine;
            $strBtUrl = ( $bUrlJs == true
                          ? str_replace("page", $i, $strBtUrl)
                          : $strUrlPagine."&page=".$i.$anchor);
            $strHtml .= ' <a href="'.$strBtUrl.'">'.$i.'</a>';
          }
      }
      
      if( $noPageSuiv <= $nbTotalPages ) {
        $strBtUrl = $strUrlPagine;
        $strBtUrl = ( $bUrlJs == true
                      ? str_replace("page", $noPageSuiv, $strBtUrl)
                      : $strUrlPagine."&page=".$noPageSuiv.$anchor);
        $oBtSuiv = new AlkHtmlButtonIcon($strBtUrl, _t("Suivant"), _t("Page Suivante"));
        $strHtml .= '&nbsp;&nbsp;&nbsp;';
        $strHtml .= $oBtSuiv->getHtml();
      }
      $strHtml .= '</td>'.
        '<td class="right">'.
        ( $this->bPagine && $this->bSelectNbElts 
          ? $this->_getHtmlSelectResults() 
          : '&nbsp;' ).
        '</td></tr></table></td>'.
        '</tr>' .
        $strFooterEnd;
      
    } elseif( $this->bSelectNbElts ) {
      $strHtml .= $strFooter.
        '<tr class="pagination">' .
        '<td class="right" colspan="'.$this->iNbCol.'">'.
        $this->_getHtmlSelectResults().
        '</td></tr>'.
        $strFooterEnd;
    } 
    return $strHtml; 
  }
  
  /**
   *  Retourne le code html du combo de sélection du nombre de résultats par page
   */
  protected function  _getHtmlSelectResults()
  {
    if ( !$this->bPagine )
      return "";
    $this->checkForm();
    $guid = $this->getGUID()."_itemsPerPage_".(self::$iNbSelect++);
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlselect.class.php");

    $nbSelect = ( $this->iNbEltParPage == $this->iNbElt 
                  ? ( !array_key_exists($this->iNbEltParPage, $this->tabValSelect)
                      ? 0 /* pas de pagination */
                      : $this->iNbEltParPage )
                  : $this->iNbEltParPage );

    $oSelect = new AlkHtmlSelect($this->oForm, 0, $guid, $nbSelect, _t("Nb Lignes"));
    $oSelect->setProperty("tabValTxt", $this->tabValSelect);
    $oSelect->addEvent("onchange", "SetPagine_".$this->getGUID()."(this.value)");
    
    $bUrlJs = ( mb_strtolower(mb_substr($this->strUrlPagine, 0, 11)) == "javascript:" ? true : false );
  
    $anchor = preg_replace("!^[^#]+!", "", $this->strUrlPagine);
    $strUrlPagine = str_replace($anchor, "", $this->strUrlPagine);
    
    $strCodeJs = 
      "function SetPagine_".$this->getGUID()."(nbResults) {".
      ( $bUrlJs 
        ? str_replace("javascript:", "", str_replace("page", "1, '&nbItemsPerPage='+nbResults+'".$anchor."'", $strUrlPagine)) 
        : "  window.location = "."'". $strUrlPagine."&nbItemsPerPage='+nbResults+'".$anchor."';" ).      
      "}";
    $this->AddJs($strCodeJs);

    return '<label for="'.$guid.'" class="formLabel">'.$oSelect->getLabel().'</label>'.$oSelect->getHtml();
  }
  
  /**
   *  retourne le nombre total de pages
   * @return int
   */
  protected function getNbTotalPages()
  { 
    if( !$this->bPagine || 
        $this->bPagine && ( $this->iNbEltParPage==0 || 
                            $this->iNbEltParPage>0 && $this->bSelectNbElts && !array_key_exists($this->iNbEltParPage, $this->tabValSelect)) ) {
      $this->iNbEltParPage = ( $this->bPagine && $this->iNbEltParPage>0 ? ALK_ITEMS_PER_PAGE : $this->iNbElt );
    }
    
    $nbTotalPages = floor($this->iNbElt / $this->iNbEltParPage) + ($this->iNbElt % $this->iNbEltParPage==0 ? 0 : 1);
    
    return $nbTotalPages; 
  }

  /**
   * Fixe le nombre d'éléments au total
   * Met à jour le tableau du nb d'éléments par page si l'élément tout en fait parti
   * @param iNbElt  Nombre élément au total 
   */
  public function setNbTotItems($iNbElt)
  { 
    if( $this->bSelectNbElts ) {
      $tabTmp = array();
      if( in_array($this->strAll, $this->tabValSelect) ) {
        $tabTmp["".$iNbElt] =  $this->strAll;
      }
      foreach($this->tabValSelect as $iNb => $strValue) {
        if(  $strValue != $this->strAll ) {
          $tabTmp["".$iNb] = $strValue;
        }
      }
      $this->tabValSelect = $tabTmp;
    }
    $this->iNbElt = $iNbElt;
  }

  /**
   *  Cherche le formulaire dans lequel cette liste est inclus ou le construit sinon
   * 
   * @return AlkHtmlForm
   */
  private function checkForm()
  {
    if (!is_null($this->oForm)) return true;
    
    if ( $this->isInHtmlForm() ){
      $oForm = $this->getParent();
      while ( !is_null($oForm) && !is_subclass_of($oForm, self::ALK_CLASS_HTMLFORM) ){
        $oForm = $oForm->getParent();
      }
      $this->oForm = $oForm;
      return true;
    }
    return false;
  }
  
  /**
   *  Fonction à redéfinir dans les classes dérivées pour définir le contenu de la liste
   */
  protected function setContents() { }
  
  /**
   *  Retourne le contenu html du tableau paginé 
   */
  public function getHtml()
  {
    $this->addDefaultCss();
    $this->setContents();

    $strHtml = "";
    $strHeader = $this->_getHtmlHeader();
    if( $this->iNbCol == 0 ) {
      $strHtml = '<div id="none_'.$this->getGUID().'"' .
        ' class="'.$this->cssText.'"'.
        ' align="center"' .
        ' style="margin-top:30px; margin-bottom:30px">'.
        ( $this->strMsgNoColumn == "" 
          ? _t("Vous n'avez pas les droits nécessaires pour consulter cette liste.") 
          : $this->strMsgNoColumn ).
        '</div>';
    } else {
      if( $this->iNbElt <= 0 ) {
        $strHtml = 
          $strHeader.
          $this->_getHtmlFooter().
            '<div id="none_'.$this->getGUID().'"'.
            ' class="'.$this->cssText.'"' .
            ' align="center"' .
            ' style="margin-top:'.$this->iHeightNoRes.'px; margin-bottom:'.$this->iHeightNoRes.'px">'.
            ( $this->strMsgNoResult == "" 
               ? _t("Aucun élément dans la liste.") 
               : $this->strMsgNoResult 
            ).
            '</div>'.
          ( !$this->bBlock 
            ? parent::getHtml() 
            : '' );
      } else {
        $strHtml = 
          $strHeader.
          $this->_getHtmlBody().
          $this->_getHtmlPagination().
          $this->_getHtmlFooter().
          ( !$this->bBlock 
            ? parent::getHtml() 
            : '');
      }
    }
    return $strHtml;
  }
  
}
?>