<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanel.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlsheet.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlPage
 * 
 * Classe représentant la page html affichée
 */
abstract class AlkHtmlPage extends AlkHtmlPanel
{
  /** référence sur l'espace en cours */
  protected $oSpace;

  /** référence sur l'appli en cours */
  protected $oAppli;

  /** Encodage de la page*/
  protected $strEncoding;

  /** tableau contenant l'ensemble des paramètres link de l'entete header */
  protected $tabMeta;

  /** tableau contenant l'ensemble des paramètres link de l'entete header */
  protected $tabLink;
  
  /** DocTypeHeader du header et balise <html> */
  protected $strDocTypeHeader;

  /**
   *  Constructeur par défaut
   * @param oSpace Référence 
   * @param oAppli Référence 
   */
  public function __construct(&$oSpace, &$oAppli)
  {
    parent::__construct("");

    $this->oSpace =& $oSpace;
    $this->oAppli =& $oAppli;
    
    $this->tabMeta = array("name"=>array());
    $this->tabLink = array();
    $this->strDocTypeHeader = "";
    
    $this->title = "Alkanet";
    $this->strEncoding = "utf-8";
    $this->addOnload("HideLoadMsg()");
    
    $cont_id  = ( !is_null($this->oSpace) ? $this->oSpace->cont_id : "-1" );
    $appli_id = ( !is_null($this->oAppli) ? $this->oAppli->appli_id : "-1" );
    $this->addVarJs("ALK_CONT_ID", "'".$cont_id."'");
    $this->addVarJs("ALK_APPLI_ID", "'".$appli_id."'");
    $this->addVarJs("ALK_APPLI_TOKEN", "'".AlkRequest::getEncodeParam("&cont_id=".$cont_id."&appli_id=".$appli_id)."'");
    
    $strParamUser   = "iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER."&iSSheet=".ALK_SHEET_NONE."&cont_id=".$cont_id."&appli_id=0";
    $strParamServ   = "iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_SERVICE."&iSSheet=".ALK_SHEET_NONE."&cont_id=".$cont_id."&appli_id=0";
    $strParamAbonne = "iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_ABONNE."&iSSheet=".ALK_SHEET_NONE."&cont_id=".$cont_id."&appli_id=".$appli_id;
    $this->addVarJs("ALK_TOKEN_POPUPUSERINFO", "'".AlkRequest::getEncodeParam($strParamUser)."'");
    $this->addVarJs("ALK_TOKEN_POPUPSERVINFO", "'".AlkRequest::getEncodeParam($strParamServ)."'");
    $this->addVarJs("ALK_TOKEN_POPUPABONNEINFO", "'".AlkRequest::getEncodeParam($strParamAbonne)."'");
  }

  /**
   *  Fixe l'encodage de la page
   */
  public function setEncoding($strEncoding)
  {
    $this->strEncoding = $strEncoding;
  }

  /**
   *  Ajoute un paramètre meta à l'entete http
   * @param strParam Nom du paramètre
   * @param strValue valeur du paramètre
   * @param strAttribute Type d'attribut affecté parmi : name, http-equiv, scheme
   */
  public function addMeta($strParam, $strValue, $strAttribute="name")
  {
    $this->tabMeta[$strAttribute][$strParam] = $strValue;
  }

  /**
   * Ajoute un paramètre link à l'entete http
   * @param strRel    Nom du paramètre =shortcut icon,  =alternate
   * @param strHRef   valeur du paramètre
   * @param strType   type du paramètre, =vide par défaut, =application/rss+xml
   * @param strTitle  titre du paramètre, =vide par défaut
   *
   */
  public function addLink($strRel, $strHRef, $strType="", $strTitle="")
  {
    $this->tabLink[] = array("rel" => $strRel, "href" =>$strHRef, "type" => $strType, "title" => $strTitle);
  }

  /**
   *  Retourne le code html de l'entete html
   * @return string
   */
  protected function getHtmlHeader()
  {
    $strHtml = 
      ( ALK_NAV==ALK_NAV_IE6 
        ? "" 
        : ( (defined(ALK_NAVHTML) && defined(ALK_NAVHTML5) && ALK_NAVHTML == ALK_NAVHTML5 ) || $this->strDocTypeHeader != '' ? '' : '<?xml version="1.0" encoding="'.$this->strEncoding.'"?>' ) ).
      ($this->strDocTypeHeader != '' ? $this->strDocTypeHeader : 
        ( defined(ALK_NAVHTML) && defined(ALK_NAVHTML5) && ALK_NAVHTML == ALK_NAVHTML5  ? 
          '<!DOCTYPE html>'.'<html lang="fr">' : 
          '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'.
          '<html xmlns="http://www.w3.org/1999/xhtml">'
        )
      ).
      '<head>'.
      '<title>'.$this->title.'</title>'.
      '<meta http-equiv="content-type" content="text/html; charset='.$this->strEncoding.'" />';
    
    foreach($this->tabMeta as $strAttribute => $tabMetaAttr ) {
      foreach($tabMetaAttr as $strPram => $strValue ) {
        $strHtml .= '<meta '.$strAttribute.'="'.$strPram.'" content="'.$strValue.'" />';
      }
    }

    foreach($this->tabLink as $tabValue ) {
      $strHtml .= '<link rel="'.$tabValue["rel"].'" href="'.$tabValue["href"].'"'.
        ( $tabValue["type"] != "" 
          ? ' type="'.$tabValue["type"].'"'
          : '' ).
        ( $tabValue["title"] != "" 
          ? ' title="'.$tabValue["title"].'"'
          : '' ).
        '/>';
    }

    $strHtml .= $this->getHtmlCss();
    $strHtml .= $this->getHtmlJs();

    $strHtml .= '</head>';

    $strHtml .= '<body '.
      ( $this->cssFormCtrl != ""
        ? ' class="'.$this->cssFormCtrl.'"'
        : '' ).
      $this->getHtmlEvent().'>';

    return $strHtml;
  }

  /**
   *  Retourne le code html de la fin de page html
   * @return string
   */
  abstract protected function initBody();

  /**
   *  Retourne le code html de la fin de page html
   * @return string
   */
  protected function getHtmlFooter()
  {
    return '</body></html>';
  }

  /**
   *  Retourne le code html de la page
   * @return string
   */
  public function getHtml()
  {
    // nécessité d'appeler le body avant le header pour capter 
    // tous les besoins en css et js du corps html
    $this->initBody();

    return parent::getHtml();
  }

  /**
   *  Ajoute et créé les onglets d'une application avec sélection de l'onglet en cours
   * @param bUseSSheet    faux par défaut, true pour utiliser des iSSheet pour identifier de manière unique des onglets de même iSheet
   */
  protected function setPageSheets($bUseSSheet=false, $strNamePanel="contents")
  {
    $tabSheets = $this->oAppli->getProperty("tabSheets");
    $iTypeSheetSelect = -1;
    $iSheetSelect = -1;
    $iSSheetSelect = -1;
    $this->oAppli->getCurrentSheet($iTypeSheetSelect, $iSheetSelect, $iSSheetSelect);

    $oPanel = new AlkHtmlPanel($strNamePanel, "");
    $this->addPanel($oPanel);
    
    // ajout des types onglets accessibles
    foreach($tabSheets as $iTypeSheet => $tabSheet) {
      $iTypeSheet = mb_substr($iTypeSheet, 1);
      if( !empty($tabSheet) ) {
        $oPanel->oSheetsManager->addTypeSheet($iTypeSheet, $tabSheet["text"], $tabSheet["url"]);
      }
    }
    
    // pour le type onglet sélectionné, ajoute les ongles accessibles
    $oSheet = $oPanel;
    if( array_key_exists("_".$iTypeSheetSelect, $tabSheets) ) {
      
      $oSelectedSheet = null;
      foreach($tabSheets["_".$iTypeSheetSelect] as $iKey => $tabSheet) {
        if( is_numeric($iKey) ) {
          $idSheet    = $tabSheet["idSheet"];
          $idSSheet   = $tabSheet["idSSheet"];
          $strTitle   = $tabSheet["text"];
          $strUrl     = $tabSheet["url"];
          $bVisible   = $tabSheet["visible"];
          $guid       = ( array_key_exists("guid", $tabSheet) && $tabSheet["guid"]!=""
                          ? $tabSheet["guid"]
                          : ( $bUseSSheet ? $idSheet.$idSSheet : $idSheet ) );
          $bSelected  = $tabSheet["selected"];
          if( $bVisible ) {
            if( (!$bUseSSheet && $idSheet == $iSheetSelect) ||
                ($bUseSSheet && $idSheet == $iSheetSelect && ($idSSheet=="" || $idSSheet==$iSSheetSelect)) ) {
              $oSheet = $oPanel->addSheet($guid, $strTitle, $strUrl, $iTypeSheetSelect);
              if ( $bSelected ){
                $oSelectedSheet = $oSheet;
                $oPanel->oSheetsManager->setSelectedSheet($oSheet, $iTypeSheetSelect);
              } 
            } else {
              $oPanel->addSheet($guid, $strTitle, $strUrl, $iTypeSheetSelect);
            }
          }
        }
      }
    
      //$oPanel->oSheetsManager->setSelectedSheetByID($iTypeSheetSelect, $iSheetSelect, $iSSheetSelect);
      if ( is_null($oSelectedSheet) )
        $oPanel->oSheetsManager->setSelectedSheet($oSheet, $iTypeSheetSelect);
    }

    return (is_null($oPanel->oSheetsManager->getSelectedSheet()) ? $oSheet : $oPanel->oSheetsManager->getSelectedSheet());
  }
}

?>