<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Projet Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpage.class.php"); 

/**
 * classe modèle qui sera chargée par défaut pour chaque extranet
 */
class AlkHtmlPageAlkanet extends AlkHtmlPage
{
 /**
 * @brief constructeur par défaut
 *
 */
  public function __construct(&$oSpace, &$oAppli)
  {
    parent::__construct($oSpace, $oAppli);

    $this->setTitle(ALK_APP_TITLE);
    $this->setEncoding(ALK_HTML_ENCODING);
    $this->addMeta("language", "FR");
    $this->addMeta("ROBOTS", "NOINDEX, NOFOLLOW");
    $this->addMeta("http-equiv", 'X-UA-Compatible" content="IE=9');
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery-1.6.4.min.js", "", true);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery-ui-1.8.16.custom.min.js", "", true);
    $this->addScriptCss("../".ALK_ROOT_LIB."jquery/jquery-ui-1.8.16.custom.css");
    if ( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF.ALK_ROOT_LIB."jquery/jquery-ui-1.8.16.custom.css") ) {
      $this->addScriptCss("../".ALK_ROOT_CONF.ALK_ROOT_LIB."jquery/jquery-ui-1.8.16.custom.css");
    }
    
    if ( file_exists(ALK_ALKANET_ROOT_PATH."/".ALK_ROOT_LIB."jquery/DataTables-1.9.4/media/js/jquery.dataTables.alk.js") ) {
      $this->addScriptJs(ALK_ALKANET_ROOT_URL."/".ALK_ROOT_LIB."jquery/DataTables-1.9.4/media/js/jquery.dataTables.alk.js");
    }
    if ( file_exists(ALK_ALKANET_ROOT_PATH."/".ALK_ROOT_LIB."jquery/DataTables-1.9.4/media/css/jquery.dataTables.alk.css") ) {
      $this->addScriptCss("../".ALK_ROOT_LIB."jquery/DataTables-1.9.4/media/css/jquery.dataTables.alk.css");
    }
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_js.php", "", true);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_js.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_js_jquery.js"); 
    if( defined("ALK_LG_JSON") ) {
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.ui.datepicker-".ALK_LG_LOCALE.".js");
      $this->addScriptJs(ALK_LG_JSON);
    } else {
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.ui.datepicker-fr_FR.js");
    }
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_jsaddon.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_ajax.js");
   
    $strInterfaceType = $oSpace->getAppliProperty("CONT_TYPE");
    if( !defined("ALK_INTERFACE_TYPE") ) {
      define("ALK_INTERFACE_TYPE", mb_strtolower($strInterfaceType));
    }
    
    // charge css par défaut liée au template de page
    $strFileCssLinked = "alkanet".strtolower(ALK_INTERFACE_TYPE).".css";
    $this->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/".$strFileCssLinked);
    
    // puis chargement de la css spécifique (se trouvant dans le répertoire styles) qui surcharge celle par défaut si elle existe
    $strFileCss = $oSpace->getAppliProperty("CONT_CSS");
    if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.$strFileCss) && is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.$strFileCss) ) {
      $this->addScriptCss($strFileCss);
    }

    // Traitements css spécifiques 
    // tente de charger d'abord la spécifique puis celle par défaut si elles existent
    if( ALK_NAVCSS != ALK_NAVCSS_FF ) {
      $strFileCssOther = "alkanet".strtolower(ALK_INTERFACE_TYPE)."_".str_replace("CSS_", "", ALK_NAVCSS).".css";
      if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.$strFileCssOther) && 
          is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.$strFileCssOther) ) {
        $this->addScriptCss($strFileCssOther);
      } 
      elseif( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/styles/".$strFileCssOther) && 
              is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/styles/".$strFileCssOther) ) {
        $this->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/".$strFileCssOther);
      }
    }
    
    // css print
    // tente de charger d'abord la spécifique puis celle par défaut si elles existent
    $strCssPrint = "alkanet".strtolower(ALK_INTERFACE_TYPE)."_print.css";
    if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.$strCssPrint) && 
        is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.$strCssPrint) ) {
      $this->addScriptCss($strCssPrint, "print");
    } 
    elseif( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/styles/".$strCssPrint) && 
            is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/styles/".$strCssPrint) ) {
      $this->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/".$strCssPrint, "print");
    }

    $this->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/alkimgpic.css");
    $this->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/alkimgpicto.css");
    $this->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/alkimgicon.css");
    
    $iTypeSheet = AlkRequest::getToken("iTypeSheet", ALK_TYPESHEET_CONSULT);
    $strPopup = ( $iTypeSheet == ALK_TYPESHEET_POPUP ? "_popup" : "" );
    
    // Traitements sur les chargements des templates    
    $this->oTemplate =& AlkFactory::getTemplate();
    // utilisation du template par défaut
    $this->strTemplateFile = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/templates/alkhtmlpage".ALK_INTERFACE_TYPE.$strPopup.".tpl";
    $strNewTemplateFile = ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."alkhtmlpage".ALK_INTERFACE_TYPE.$strPopup.".tpl";
    if( file_exists($strNewTemplateFile) && is_file($strNewTemplateFile)) {
      // utilisation du template spécifique
      $this->strTemplateFile = $strNewTemplateFile;
    }
    
    $GLOBALS["oHtmlPage"]=$this;
  }
  
  /**
   * @brief Retourne le code html du parcours de la page courante depuis la racine alkanet
   * @return string
   */
  protected function getHtmlRoute()
  {
    $tabNavAppli = array();
    $cont_id    = AlkRequest::getToken("cont_id",  "-1");
    $appli_id   = AlkRequest::getToken("appli_id", "-1");
    $iTypeSheet = AlkRequest::getToken("iTypeSheet", ALK_TYPESHEET_CONSULT);
    $iSheet     = AlkRequest::getToken("iSheet", ALK_SHEET_NONE);

    // ajoute le nom de l'application sélectionnée
    $strLib = "";
    $strUrl = "";
    switch( $appli_id ) {
    default:
      switch( $appli_id ) {
      case -2: 
        $strLib = _t("Mon espace"); 
        break;
      case -1:
        if( $iTypeSheet== ALK_TYPESHEET_CONSULT ) { 
          if( $iSheet == ALK_SHEET_RECHERCHE ) {
            $strLib = _t("Effectuer une recherche");
          } else {
            $strLib = _t("Plan de l'espace");
          }
        }
        break;
      case 0: 
        $strLib = _t("Annuaire"); 
        break;
      default:
        if( !is_null($this->oAppli) ) {
          $strLib = $this->oAppli->getAppliProperty("APPLI_INTITULE");
          $strUrl = ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id);
        }
        break;
      }
      break;
    }
    if( $strLib != "" ) {
      $tabNavAppli[] = array("titre" => $strLib, "url" => $strUrl);
    }

    // ajoute du mode sur l'application (sauf consultation)
    $strLib = "";
    switch( $iTypeSheet ) {
    case ALK_TYPESHEET_ADMIN:     $strLib = _t("Administration"); break;
    case ALK_TYPESHEET_PROPRIETE: $strLib = _t("Propriétés"); break;
    }
    
    if ( !is_null($this->oAppli) ){
      $strAppli = $this->oAppli->getHtmlRoute();
      if ( $strAppli!="" )
        $strLib .= ($strLib!="" ? " : " : "").$strAppli;
    }
    if( $strLib != "" ) {
      $tabNavAppli[] = array("titre" => $strLib, "url" => "");
    }

    $tabNavs = $this->oSpace->getTabNav($tabNavAppli);
    
    $strNav = "";
    $strGlu = " ";
    foreach($tabNavs as $tabNav) {
      $bSpace = ( array_key_exists("type", $tabNav) && $tabNav["target"]=="espace" );
      $strTarget = ( array_key_exists("target", $tabNav)==true && $tabNav["target"]!="" ? "target=\"".$tabNav["target"]."\"" : "");
      $strNav .= "<li>".$strGlu.
        ( $tabNav["url"] != ""
          ? "<a ".$strTarget." ".($bSpace ? "class='bold'" : "" )." title='' href='".$tabNav["url"]."'>".$tabNav["titre"]."</a>"
          : $tabNav["titre"] ).
        "</li>";
      $strGlu = "&gt; ";
    }
    
    if( $strNav != "" ) {
      $strNav = "<ul>".$strNav."</ul>";
    }

    return $strNav;
  }
  
  /**
   * @brief Retourne le code html du contenu de la page
   * @return string
   */
  protected function initBody()
  {
    $iTypeSheet = ALK_TYPESHEET_CONSULT;
    $iSheet     = ALK_SHEET_NONE;
    $iSSheet    = ALK_SHEET_NONE;
    $this->oAppli->getCurrentSheet($iTypeSheet, $iSheet, $iSSheet);

    $cont_id    = AlkRequest::getToken("cont_id",    "-1");
    $appli_id   = AlkRequest::getToken("appli_id",   "-1");
    $typeappli_id = AlkRequest::getToken("typeappli_id","-1");

    $bPopup = ( $iTypeSheet == ALK_TYPESHEET_POPUP );

    if( !is_null($this->oAppli) ) {
      $this->oAppli->setTabSheets();
      $oSheetSelect = $this->setPageSheets();
      if( !is_null($oSheetSelect) ) {
        $oAppliPanel = $this->oAppli->getPanel();
        if ( is_null($oAppliPanel) ) return;
        $oSheetSelect->addPanel($oAppliPanel);
        if( $bPopup ) {
          $this->oTemplate->assign("mainTitle", $oAppliPanel->getTitle());
          if( defined("ALK_B_ATYPE_EDITEUR") && ($typeappli_id == ALK_B_ATYPE_EDITEUR) ) {
            $this->oTemplate->assign("stylePopupContents", "margin:0px; padding:0px; width:100%;");
          }
          $oAppliPanel->setTitle("");
          $oAppliPanel->setLabel("");
        }
      }
    }

    $this->oAppli->getCurrentSheet($iTypeSheet, $iSheet, $iSSheet);

    if( $bPopup ) {
      $tokenClose = AlkRequest::getToken("tokenClose",   "");
      $popupCanClose = AlkRequest::getToken("popupCanClose",   "1");
      $popupAddTitle = AlkRequest::getToken("popupAddTitle",   "1");
      $this->oTemplate->assign("tokenClose", $tokenClose);  
      $this->oTemplate->assign("popupCanClose", $popupCanClose);  
      $this->oTemplate->assign("popupAddTitle", $popupAddTitle);  
    }

    $tabAppliSubMenu = array();
    $tabAppliMenus = $this->oSpace->getTabMenuAppli($tabAppliSubMenu);
    $tabAppliMenu = $tabAppliMenus["appli"];
    $tabSpaceMenus = $this->oSpace->getTabMenuSpace(7);
    $tabSpaceMenuChild = $tabSpaceMenus["child"];    
    $tabSpaceMenuBrother = $tabSpaceMenus["brother"];
    $tabSpaceMenuOther = $tabSpaceMenus["other"];
    
    $this->oTemplate->assign_by_ref("oSpace", $this->oSpace);
    $this->oTemplate->assign_by_ref("oAppli", $this->oAppli);
    $this->oTemplate->assign_by_ref("tabAppli", $tabAppliMenu);  
    $this->oTemplate->assign_by_ref("tabSpaceChild", $tabSpaceMenuChild);
    $this->oTemplate->assign_by_ref("tabSpaceBrother", $tabSpaceMenuBrother);
    $this->oTemplate->assign_by_ref("tabSpaceOther", $tabSpaceMenuOther);
    
    $urlConfSpace = ( AlkFactory::isSpaceAnim() ? ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_FICHE) : "");
    $this->oTemplate->assign("urlConfSpace", $urlConfSpace);

    if(defined("ALK_APPLI_ID_JMAPLINK") ){
      $this->oTemplate->assign("urlPoi","");
      foreach($tabAppliMenus["appli"] as $id => $tabInfoAppli){
    	if($tabInfoAppli["atypeid"]==ALK_ATYPE_ID_GEOLOC && $tabInfoAppli["rightid"]>=2){
    		$this->oTemplate->assign("urlPoi", ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$tabInfoAppli["id"]."&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_GEOLOC));
    	}
      }
    }
    
    $this->oTemplate->assign("urlAnnu", ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0"));
    $this->oTemplate->assign("urlPlan", ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_ARBORESCENCE));
    $this->oTemplate->assign("urSearch", ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_RECHERCHE));
    $this->oTemplate->assign("urlContact", "javascript:OpenContactAdmin('".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_CONTACT)."')");
    $this->oTemplate->assign("urlPerf", "javascript:OpenPerf('".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_FORM)."')");
    $this->oTemplate->assign("urlAide", "javascript:OpenHelp('".$this->oAppli->getToken($iTypeSheet, $iSheet, $iSSheet)."')");
    $this->oTemplate->assign("dateCur", date("d/m/Y"));
    $this->oTemplate->assign("cont_intitule", $this->oSpace->getAppliProperty("CONT_INTITULE"));
    $this->oTemplate->assign("appli_intitule", $this->oAppli->getAppliProperty("APPLI_INTITULE"));
    $this->oTemplate->assign("userName", AlkFactory::getSProperty("user_name"));
    $this->oTemplate->assign("userMail", AlkFactory::getSProperty("user_mail"));
    $this->oTemplate->assign("userLogin", AlkFactory::getSProperty("user_login"));
    $this->oTemplate->assign("urlFicheUser", "javascript:OpenPopupFiche('agent', '".AlkFactory::getSProperty("user_id")."')");
    $this->oTemplate->assign("alkAlkanetRootUrl",ALK_ALKANET_ROOT_URL);
    $this->oTemplate->assign("strTokenCache",AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1"));
    $this->oTemplate->assign('alkRootTemplate', ALK_ROOT_TEMPLATE);

    $cont_logo = $this->oSpace->getAppliProperty("CONT_LOGO");
    $cont_logo = ( $cont_logo != "" ? $this->oSpace->getUrlUpload().$cont_logo : "" );
    $this->oTemplate->assign("urlBandeauVignette1", $cont_logo);

    $cont_logo = $this->oSpace->getAppliProperty("CONT_LOGO2");
    $cont_logo = ( $cont_logo != "" ? $this->oSpace->getUrlUpload().$cont_logo : "" );
    $this->oTemplate->assign("urlBandeauVignette2", $cont_logo);
    
    $cont_bandeau = $this->oSpace->getAppliProperty("CONT_BANDEAU");
    $cont_bandeau = ( $cont_bandeau !="" 
                      ? $this->oSpace->getUrlUpload().$cont_bandeau
                      : "" );
    $this->oTemplate->assign("urlBandeau", $cont_bandeau);

    $this->oTemplate->assign("parcours", $this->getHtmlRoute());
  }

  /**
   * Retourne l'aide de la page en cours de consultation
   */
  public function getHelp()
  {
    $strHtmlHelp = "";
    if( !is_null($this->oAppli) ) {
      $iTypeSheet = ALK_TYPESHEET_CONSULT;
      $iSheet     = ALK_SHEET_NONE;
      $iSSheet    = ALK_SHEET_NONE;
      $this->oAppli->getCurrentSheet($iTypeSheet, $iSheet, $iSSheet);
      $oPanel = $this->oAppli->getPanel();
      if( !is_null($oPanel) ) {
        $strHtmlHelp = $oPanel->getHelp();
      } else {
        $strHtmlHelp = _t("Aucune aide disponible pour cette page.");
      }
    } else {
      $strHtmlHelp = _t("Aucune aide disponible pour cette page.");
    }
    return $strHtmlHelp;
  }
}
?>