<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

// Call AlkHtmlPanelTest::main() if this source file is executed directly.
if (!defined("PHPUnit2_MAIN_METHOD")) {
    define("PHPUnit2_MAIN_METHOD", "AlkHtmlPanelTest::main");
}

require_once "PHPUnit2/Framework/TestCase.php";
require_once "PHPUnit2/Framework/TestSuite.php";
require_once "../../libconf/app_conf.php";
require_once "../../lib/app_conf_alkanet.php";
require_once "../../lib/app_conf_alkanet.php";
require_once "../../classes/form/test_objet.class.php";
require_once "../../classes/form/alkhtml.class.php";

// You may remove the following line when all tests have been implemented.
require_once "PHPUnit2/Framework/IncompleteTestError.php";

require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanel.class.php";

/**
 * Test class for AlkHtmlPanel.
 * Generated by PHPUnit2_Util_Skeleton on 2007-10-04 at 11:54:23.
 *
 * @package Alkanet_Class_Form_Test
 */
class AlkHtmlPanelTest extends PHPUnit2_Framework_TestCase {

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit2/TextUI/TestRunner.php";

        $suite  = new PHPUnit2_Framework_TestSuite("AlkHtmlPanelTest");
        $result = PHPUnit2_TextUI_TestRunner::run($suite);
    }
    
    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {      
      AlkHtmlPanel::$tabPanelIds = array();      
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

    /**
     * test du constructeur
     */
    public function test__construct() {	
    	$name = "test";
      $cas1 = "echec du test du constructeur";     
      try {
        $obj_panel= new AlkHtmlPanel_bis ($name, $title="");
        $this->asserttrue(true);
      } 
      catch(Exception $e) { $this->asserttrue(false, $cas1." - ".$e->getMessage());       
      }  
    }
    
      /**
       * @test le desctruct
       */
    public function test__destruct() 
    {    
    }

    /**
    * @test la fonction HasSomeType
    * fonction protected
    **/
 
    public function testHasSameType() 
    {        	
      // création d'un objet de type de classe différent du panel courant
      $oObject = new TestObjet();
      $this->assertfalse(AlkHtmlPanel_bis::hasSameType($oObject), ": Error testHasSameType() : le test devrait retourner false car l'objet est d'un type de classe differente de la hiérarchie panel'");    
      // création d'un objet de type classe appartenant à la hiérarchie panel
      $name="test2";
      $oObject2 = new AlkHtmlPanel_bis($name, $title="");
      $this->asserttrue(AlkHtmlPanel_bis::hasSameType($oObject2), ": Error testHasSameType() : le test devrait retourner true car l'objet est de  la hiérarchie panel'"); 
    }
    /**
      * @test la fonction CanAddPanel
      * fonction protected
    **/
    public function testCanAddPanel()
    {
      // création d'un objet de type de classe différent du panel courant
      $name="test3";
      $oObject = new TestObjet();
      $objet_test = new AlkHtmlPanel_bis($name, $title=""); 
    	$this->asserttrue($objet_test->CanAddPanel($oObject), ": Error testCanAddPanel() : le test devrait retourner true car l'objet n'est pas de type de classe differente de la hiérarchie panel'"); 
      // création d'un objet de type classe appartenant à la hiérarchie panel
      $name="test4";
      $objet_test = new AlkHtmlPanel_bis($name, $title="");
      $this->asserttrue($objet_test->CanAddPanel($objet_test), ": testCanAddPanel() : le test devrait retourner true car l'objet n'est pas du même type que  la hiérarchie panel'");    
      // création d'un objet appartenant à la hiérarchie panel de type formulaire
      $objet_form = new AlkHtml($strHtml="", $label="");
      $this->assertfalse($objet_test->CanAddPanel($objet_form), ": testCanAddPanel() : le test devrait retourner false car l'objet est du même type que la hiérarchie panel detype formulaire'");    
    }


    /**
      * @test la fonction SetParent
      * fonction protected
    **/
    public function testSetParent(){
   
      $oPanel1 = new AlkHtmlPanel_bis("panel1", "Panel 1");
      $oPanel2 = new AlkHtmlPanel_bis("panel2", "Panel 2");
      $oPanel3 = new AlkHtmlPanel_bis("panel3", "Panel 3");  
      $oPanel3->setParent($oPanel1);//le parent de oPanel3 est oPanel1 
      $tmp = $oPanel3->getParent();
      $this->assertsame($oPanel3->getParent(), $oPanel1, "les deux objets devraient avoir une même reference - o1=".$oPanel1->__toString()." o3.o1=".$tmp->__toString());
      $this->asserttrue($oPanel3->setParent($oPanel1), "l'affectation de l'objet en paramètre comme parent devrait retourner vrai");
  //changement de parent le parent de oPanel3 est oPanel2   
      $oPanel3->setParent($oPanel2);
      $this->assertNotsame($oPanel3->getParent(), $oPanel1, "les deux objets ne devraient plus avoir une même reference");
      $this->assertsame($oPanel2, $oPanel3->getParent(), "les deux objets devraient avoir une même reference");
      //if($oPanel2->SetParent($oPanel3));//cas d'une boucle'materialisé par faux   
  //création d'une boucle'
      $oPanel3->setParent($oPanel2);
      $oPanel1->setParent($oPanel3);
      $this->assertfalse($oPanel2->setParent($oPanel3), "le test devrait retourner false car il existe une boucle de type le contenu contient son contenant");
      if($oPanel2->setParent($oPanel3)==true){$this->asserttrue(false, "le test devrait retourner false car il existe une boucle de type le contenu contient son contenant");
      }      
    }   

    /**
     * @todo Implement testIsParentOf().
     */ 
    public function testIsParentOf(){
    	
      $oPanelA = new AlkHtmlPanel_bis("panel1", "Panel 1");
      $oPanelB = new AlkHtmlPanel_bis("panel2", "Panel 2");
      $oPanelC = new AlkHtmlPanel_bis("panel3", "Panel 3");    
    	$oPanelC->setParent($oPanelB);
      $oPanelA->setParent($oPanelC);
      if($oPanelB->setParent($oPanelC)==true){
        $this->asserttrue(false, "le test devrait retourner false car il existe une boucle de type le contenu contient son contenant");
      }
    }  
 
    public function testCheckName(){
      //AlkHtmlPanel::$tabPanelIds=array();
      //cas réponse true
      $iError = "";
      $name = "test15";
      $identifiant = 12;
      $obj_test = new AlkHtmlPanel_bis("", $title="");   
      //AlkHtmlPanel::$tabPanelIds[1] = 1;  AlkHtmlPanel::$tabPanelIds[2] = 2;  
      $this->asserttrue($obj_test->checkName($identifiant, $name, $iError), "Le test devrait renvoyer true car l'identifiant n'existe pas dans le tableau tabPanelIds'");        
      /*
      try {     	
      $name = "test1gf5"; 
      $identifiant = 46;
      $obj_test = new AlkHtmlPanel_bis($name, $title="");       
      $obj_test->checkName($identifiant, $name, $iError);   
      $this->asserttrue(false, "Le test n'a pas trouvé l'identifiant alros qu'il auriat dû le détecter et renvoyer false'");
      }
      catch(Exception $e) {	
      $this->asserttrue(true, "Le test devrait renvoyer false car l'identifiant existe déjà dans le tableau tabPanelIds'");    
      //$this->assertfalse($obj_test->checkName($identifiant, $name, $iError), "Le test devrait renvoyer false car l'identifiant existe déjà dans le tableau tabPanelIds'");   
      } 
    */
    }
    
    public function testsetObjData(){
    	$oData = "test";
      $obj_test = new AlkHtmlPanel_bis("", $title=""); 
    	$this->asserttrue ($obj_test->setObjData($oData), "le test devrait rendre vrai");
    }
 
    /**
     * @todo Implement testAddVarJs().
     */
    public function testAddVarJs() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }
    /**
     * @todo Implement testAddJs().
     */
    public function testAddJs() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testAddScriptJs().
     */
    public function testAddScriptJs() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testAddCss().
     */
    public function testAddCss() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }
    
    /**
     * @todo Implement testAddScriptCss().
     */
    public function testAddScriptCss() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testSetTemplate().
     */
    public function testSetTemplate() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testAddEvent().
     */
    public function testAddEvent() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testGetHtml().
     */
    public function testGetHtml() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testAddPanel().
     */
    public function testAddPanel() {
       
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
       
    }

    /**
     * @todo Implement testRemovePanel().
     */
    public function testRemovePanel() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testAddSheet().
     */
    public function testAddSheet() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testSetInializationProperties().
     */
    public function testSetInializationProperties() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testSetName().
     */
    public function testSetName() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testGetName().
     */
    public function testGetName() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testGetGUID().
     */
    public function testGetGUID() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testSetTitle().
     */
    public function testSetTitle() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testGetTitle().
     */
    public function testGetTitle() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testSetInitMode().
     */
    public function testSetInitMode() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testGetInitMode().
     */
    public function testGetInitMode() {
    }

    /**
     * @todo Implement testGetObjData().
     */
    public function testGetObjData() {
    }

    /**
     * @todo Implement testSetDataFields().
     */
    public function testSetDataFields() {
        // Remove the following line when you implement this test.
        throw new PHPUnit2_Framework_IncompleteTestError;
    }

    /**
     * @todo Implement testGetDataFields().
     */
    public function testGetDataFields() {
    }
}

// Call AlkHtmlPanelTest::main() if this source file is executed directly.
if (PHPUnit2_MAIN_METHOD == "AlkHtmlPanelTest::main") {
    AlkHtmlPanelTest::main();
}
?>
