<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlRadio
 * 
 * classe d'affichage d'un composant groupe de radio
 *        génère : <input type=radio>
 */
class AlkHtmlRadio extends AlkHtmlCtrl
{
  /** liste des boutons radios */
  protected $tabRadios;

  /** Séparateur bouton radio */
  protected $separator;
  
  /** vrai si label à droite du bouton radio */
  protected $bLabelRight;

  /**
   *  Constructeur par défaut
   * @param oForm      référence sur l'objet formulaire
   * @param iMode      Mode du controle de saisie : =0 modif, =1 lecture
   * @param name       Nom du controle de saisie
   * @param value      Valeur du groupe de boutons radio
   * @param label      Etiquette texte associée au groupe
   */
  public function __construct($oForm, $iMode, $name, $value=0, $label="")
  {
    parent::__construct($oForm, $iMode, $name, $value, $label);
    $this->tabRadios = array();
    $this->separator = "&nbsp;&nbsp;";
    $this->bLabelRight = true;
    $this->cssFormCtrl  = "formCtrlRCB";
  }

  /**
   *  Modifie le séparateur entre les boutons radios
   * @param strTxt  nouveau séparateur utilisé
   */
  public function setSeparator($strTxt)
  {
    $this->separator = $strTxt;
  }

  /**
   *  Ajoute un bouton radio au groupe
   * 
   * @param strValue  Valeur du radio bouton
   * @param strLabel  Etiquette texte associé au bouton radio
   */
  public function addRadio($strValue, $strLabel)
  {
    $this->tabRadios[] = array("value" => $strValue, 
                               "label" => $strLabel,
                               "event" => array());
  }

  /**
   *  Ajoute un evenement sur un bouton radio
   * 
   * @param strValue      Valeur du radio bouton
   * @param strEvent      Nom de l'événement
   * @param strFunctionJS Nom de la fonction javascript appelée (pas nécessaire d'ajouter 'javascript:')
   */
  public function addEventToRadio($strValue, $strEvent, $strFunctionJS)
  {
    // recherche l'indice de la valeur
    $iPos = -1;
    while( ++$iPos < count($this->tabRadios) ) {
      if( $this->tabRadios[$iPos]["value"] == $strValue )
        break;
    }

    if( $iPos == -1 || $iPos>=count($this->tabRadios) ) 
      return;

    if( array_key_exists($strEvent, $this->tabRadios[$iPos]["event"]) ) {
      $this->tabRadios[$iPos]["event"][$strEvent] .= $strFunctionJS;
    } else {
      $this->tabRadios[$iPos]["event"][$strEvent] = $strFunctionJS;
    }
  }
  
  /**
   *  Genere puis retourne tous les evenements liés au controle html
   *
   * @return Retourne les événements concaténés dans une chaine pour être inclus dans
   *         dans un tag html de type controle de saisie
   */
  protected function getHtmlEventRadio($iPos)
  {
    $strHtml = "";
    foreach($this->tabRadios[$iPos]["event"] as $strEvent => $strFunctionJs)
      $strHtml .= ' '.$strEvent.'="javascript:'.$strFunctionJs.'"';
    return $strHtml;
  }

  /**
   *  Génère puis retourne le code html associé au controle de saisie
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    $strClassCss = ( $this->cssFormCtrl
                     ? ' class="'.$this->cssFormCtrl.'"'
                     : '' );
    
    // contruit le controle
    $strHtml = "";
    if( $this->iMode == "1" ) {
      // mode lecture
      // recherche puis affiche le label sélectionné
      $iPos = -1;
      while( ++$iPos < count($this->tabRadios) ) {
        if( $this->tabRadios[$iPos]["value"] == $this->value ) break;
      }

      if( $iPos != -1 && $iPos<count($this->tabRadios) )
        $strHtml = '<span '.$strClassCss.'>'.$this->tabRadios[$iPos]["label"].'</span>';

    } else {

      // mode modif
      // input type=radio
      for($i=0; $i<count($this->tabRadios); $i++) {
        if( $this->bLabelRight == false )
          $strHtml .= '<label for="'.$this->guid.'_'.$i.'">'.$this->tabRadios[$i]["label"].' </label>';

        $strHtml .= '<input type="radio"'.
          ' name="'.$this->name.'"'.
          ' id="'.$this->guid.'_'.$i.'"'.
          ' value="'.$this->tabRadios[$i]["value"].'"'.
          $strClassCss.
          ( $this->value == $this->tabRadios[$i]["value"] 
            ? ' checked="checked"' 
            : '' ).
          ( $this->bDisabled 
            ? ' disabled="disabled"' 
            : '' ) .
          $this->GetHtmlEventRadio($i).
          '/>';

        if( $this->bLabelRight == true )
          $strHtml .= '<label for="'.$this->guid.'_'.$i.'"> '.$this->tabRadios[$i]["label"].'</label>';

        $strHtml .= $this->separator;
      }
    }
    
    return $strHtml;
  }
}

?>