<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanel.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlSheet
 * 
 * Classe affichant un onglet d'un panel d'onglets 
 * Gère le contenu sous forme de layer visible ou invisible
 */
class AlkHtmlSheet extends AlkHtmlPanel 
{
  /** boolean : l'onglet est sélectionné */
  private $isSelected;
  
  /** Formulaire conteneur de l'onglet */
  private $oForm;

  /** url correspondant à l'onglet */
  private $strUrl;

  /** définition d'un style spécifique à l'onglet */
  public $cssSpecific;
  
 /** tooltip de l'onglet */
  protected $tooltip;
  /**
   * Constructeur par défaut
   * @param oParent    référence sur le panel parent
   * @param name       identifiant du panel d'onglets
   * @param title      titre de l'onglet
   * @param oUrl       lien url pour ouvrir l'onglet, chaine vide par défaut pour sélectionner l'onglet en javascript
   *                   tableau associatif pour construire le token vers alkanet.php. le tableau doit comporter bPopup=true pour 
   *                   appeler alkanet_popup.php
   */
  public function __construct($oParent, $name, $title, $oUrl="", $tooltip="") 
  {
    if( is_numeric($name) ) {
      $name = $oParent->getGUID()."_sheet".$name;
    }
    parent::__construct($name, "");
    $this->title = $title;
    $this->tooltip = ($tooltip=="" ? $title : $tooltip);
    $this->oParent = $oParent;
    $this->isSelected = false;
    $this->oForm      = null;
    $this->consUrl($oUrl);
    $this->cssSpecific = "";
    
    if( $this->oParent->isTypeOf(self::ALK_CLASS_HTMLFORM) ){
      $this->oForm = $this->oParent;
    }
    elseif( !is_null($oParent) && property_exists($oParent, "oForm") ) {
      $this->oForm = $this->oParent->oForm;
    }
  }
  
  /**
   *  Construit l'url à partir de l'élément de base brute : chaine, tableau ?
   */
  private function consUrl($oUrl)
  {
    if( is_array($oUrl) ) {
      $strUrl = ALK_ALKANET."?";
      $strParams = "";
      foreach($oUrl as $strName => $strValue ) {
        $strParams = ($strParams!="" ? "&" : "").$strName."=".$strValue;
      }
      $this->strUrl = $strUrl."token=".AlkRequest::getEncodeParam($strParams);
    } 
    else if( is_string($oUrl) ) {
      $this->strUrl = trim($oUrl);
    }
    else {
      $this->strUrl = "";
    }
  }

  /**
   *  Sélectionne cet onglet dans le manager d'onglet
   */
  public function selectSheet()
  {
    $this->oParent->oSheetsManager->setSelectedSheet(null);
    $this->isSelected = true;
    $this->oParent->oSheetsManager->setSelectedSheet($this);
  }
  
  /**
   *  Désélectionne cet onglet dans le manager d'onglet
   */
  public function unselectSheet()
  {
    $this->oParent->oSheetsManager->setSelectedSheet(null);
    $this->isSelected = false;
  }
  
  /**
   *  Evalue l'ajout d'un objet de la hiérarchie panel au tableau de panels courant
   * 
   * @param  oPanel   Objet de type panel que l'on souhaite ajouter au tableau des panels
   * @return boolean
   */
  protected function canAddPanel($oPanel)
  {
    if ( $oPanel->isTypeOf(self::ALK_CLASS_HTMLCTRL) )
      return false;
    if ( $oPanel->isTypeOf(self::ALK_CLASS_HTMLLIST) )
      return true;
    if ( $oPanel->isTypeOf(self::ALK_CLASS_HTMLBLOCK) )
      return true;
    if ( $oPanel->isTypeOf(self::ALK_CLASS_HTMLFORM) )
      return is_null($this->oForm);
    return !$oPanel->isTypeOf(self::ALK_CLASS_HTMLPAGE);    
  } 
  
  /**
   *  Construit un bloc, l'ajoute au formulaire puis retourne une référence sur l'objet créé
   *
   * @param idBlock     identifiant du bloc
   * @param strTitle    titre du bloc (= chaine vide par défaut, dans ce cas, le cadre titre n'est pas affiché)
   * @param strDesc     description du bloc (= chaine vide par défaut)     
   * @param iWidthLabel largeur en px de la colonne label (=180 par défaut)
   * @param iWidthCtrl  largeur en px de la colonne ctrl  (=390 par défaut)
   * @param bMaintitle  vrai si titre principal, faux si titre de bloc classique (par défaut)
   * @param oForm       référence sur le formulaire, null par défaut. Nécessaire lorsque les onglets sont un sous-élément du formulaire
   * @return Retourne une référence sur le bloc créé
   */
  public function &addBlock($idBlock, $strTitle="", $strDesc="", $iWidthLabel="180", $iWidthCtrl="390", $bMaintitle=false, $oForm=null)
  {
    if( is_null($this->oForm) && !is_null($oForm) ) {
      $this->oForm = $oForm;
    }

    if ( !is_null($this->oForm) ){
      $oBlock = $this->oForm->createBlock($idBlock, $strTitle, $strDesc, $iWidthLabel, $iWidthCtrl, $bMaintitle);
      if ( $this->addPanel($oBlock) )
        return $oBlock;
    }
    return self::$oNull;
  }
  
  /**
   *  Retourne le formulaire parent si il s'agit d'un onglet de formulaire à onglet
   *        ou retourne null sinon
   * 
   * @return AlkHtmlForm ou null
   */
  private function getFormParent()
  {
    if ( $this->oParent->isInHtmlForm() ){
      $oParent = $this->oParent;
      while ( !is_null($oParent) && !$oParent->isTypeOf(self::ALK_CLASS_HTMLFORM) ){
        $oParent = $oParent->getParent();
      }
      return $oParent;
    }
    return self::$oNull;
  }

  /**
   *  Retourne l'url de l'onglet
   * @return string
   */
  public function getUrl()
  {
    return $this->strUrl;
  }

  /**
   *  Retourne le code html l'entête du formulaire
   *
   * @return Retourne un string
   */
  protected function getHtmlHeader()
  {
    $strHtml = '<div id="contents_'.$this->guid.'" '.
      $this->getHtmlEvent().
      ' align="center" '.
      ( $this->cssSpecific != "" 
        ? ' style="'.$this->cssSpecific.'"' 
        : '' ).
      '>';
    return $strHtml;
  }

  /**
   *  Ne pas pas le titre d'un onglet.
   *        Le titre est présent sur l'objet de type htmlForm
   *  Retourne un string
   */
  public function getLabel()
  {
    return "";
  }
  
  /**
   * Définit le formulaire de l'onglet (pour utilisation de addBlock)
   * @param oForm   Formulaire contenant l'onglet
   */
  public function setOForm($oForm)
  {
    $this->oForm = $oForm;
  }

  /**
   * Le titre est présent sur l'objet de type htmlForm
   *  Retourne un string
   */
  public function getTooltip()
  {
    return $this->tooltip;
  }
}

?>