<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");
define("ALK_SYMBOLCOLOR_NOIMG", ALK_ALKANET_ROOT_URL."media/images/transp.gif");
define("ALK_SYMBOLCOLOR_NOCOLOR", "transparent");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlSymbolColor
 * 
 * Classe d'affichage d'un composant de sélection de couleurs et de trame
 */
class AlkHtmlSymbolColor extends AlkHtmlCtrl
{  
  protected static $bDefaultDeclare = false;
  
  /** Image par défaut de fond du symbole */
  protected $strNoImage;
  
  /** Couleur par défaut de fond du symbole */
  protected $strNoColor;
  
  /** Couleur de fond du symbole */
  protected $strColor;
  
  /** Couleur de bordure du symbole */
  protected $strBorderColor;
  
  /** Image de fond du symbole */
  protected $strImage;
  
  /** Action sur clic */
  protected $strActionJs;
  
  /** Taille du symbole */
  protected $iSize;
  
  /** Marge autour de l'image */
  protected $iMargin;

  /**
   * Constructeur par défaut
   * @param name           Nom ou identifiant du control
   * @param value          Valeur du control
   * @param label          Label associé au control
   * @param strColor       Couleur de fond du symbole
   * @param strBorderColor Couleur de bordure du symbole
   * @param strImage       Image de fond du symbole
   * @param strActionJs    Action sur clic 
   * @param iSize          Taille du symbole
   */
  public function __construct($oForm, $name, $value, $label="", $strColor="", $strBorderColor="", $strImage="", $strActionJs="", $iSize="20") 
  {
    parent::__construct($oForm, 0, $name, $value, $label);
    $this->strColor          = $strColor;
    $this->strBorderColor    = $strBorderColor;
    $this->strImage          = $strImage;
    $this->strActionJs       = $strActionJs;
    $this->iSize             = $iSize;

    $this->strNoImage = ALK_SYMBOLCOLOR_NOIMG;
    $this->strNoColor = ALK_SYMBOLCOLOR_NOCOLOR;
    
    $this->iMargin = 2;
  }

  /**
   * Génère puis retourne le code html associé au controle de saisie
   * @return string
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    if ( !self::$bDefaultDeclare ){
      $this->addVarJs("g_sc_noimg",   "'".ALK_SYMBOLCOLOR_NOIMG."'");
      $this->addVarJs("g_sc_nocolor", "'".ALK_SYMBOLCOLOR_NOCOLOR."'");
      self::$bDefaultDeclare = true;
    }

    if ( $this->strNoImage!=ALK_SYMBOLCOLOR_NOIMG )
      $this->addVarJs("g_sc_noimg_".$this->guid,   "'".$this->strNoImage."'");
    if ( $this->strNoColor!=ALK_SYMBOLCOLOR_NOCOLOR )
      $this->addVarJs("g_sc_nocolor_".$this->guid, "'".$this->strNoColor."'");
      
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlsymbolcolor.js");
    
    $this->strColor       = ($this->strColor==""       ? $this->strNoColor : $this->strColor);
    $this->strBorderColor = ($this->strBorderColor=="" ? $this->strNoColor : $this->strBorderColor);
    $this->strImage       = ($this->strImage==""       ? $this->strNoImage : $this->strImage);
    
    if ( $this->strActionJs!="" ){
      $tabParams = array();
      if ( preg_match("!\(([^)]*)\)!", $this->strActionJs, $tabParams) ){
        $strMatch = $tabParams[1];
        $strMatch = preg_replace("!(\[|\]|\-|\+|\*|\.)!", "\\\\$1", $strMatch);
        $this->strActionJs = preg_replace("!\(".$strMatch."\)!ui", "(".$tabParams[1].($tabParams[1]=="" ? "" : ", ")."'".$this->guid."', '".$this->name."')", $this->strActionJs);
      }
      else {
        $this->strActionJs .= "('".$this->guid."', '".$this->name."')";
      }
    }
    
    $strHtml = "";
    $strHtml .= "<table id='table_".$this->guid."' border='0' cellpadding='0' cellspacing='0' width='".$this->iSize."' ".($this->strActionJs!="" ? "class='hand'" : "")." style='float:left;'>";
    $strHtml .= "<tr><td width='".$this->iSize."' height='".$this->iSize."'" .
        " style='" .
          ($this->strColor!="transparent" ? "background-color:".$this->strColor.";" : "") .
          ($this->strBorderColor!="transparent" ? "border:1px solid ".$this->strBorderColor.";" : "") .
          "padding:0px;margin:0px;'" .
        " id='td_".$this->guid."' onclick=\"".$this->strActionJs."\">";
    $strHtml .= "<img id=\"img_".$this->guid."\" name=\"img_".$this->guid."\" src=\"".$this->strImage."\"" .
        " width='".$this->iSize."' height='".$this->iSize."' border='0' style='margin:".$this->iMargin."px'/>";
    
    $strHtml .= "<input type='hidden' name='".$this->name."' id='".$this->guid."' value='".$this->value."'/>";
    $strHtml .= "<input type='hidden' name='bgcolor_".$this->name."' id='bgcolor_".$this->guid."' value='".$this->strColor."' onchange=\"SetColorLink(this, '".$this->guid."')\"/>";
    $strHtml .= "<input type='hidden' name='bordercolor_".$this->name."' id='bordercolor_".$this->guid."' value='".$this->strBorderColor."' onchange=\"SetBorderColorLink(this, '".$this->guid."')\"/>";
    $strHtml .= "<input type='hidden' name='image_".$this->name."' id='image_".$this->guid."' value='".$this->strImage."' onchange=\"SetImageLink(this, '".$this->guid."')\"/>";
    
    $strHtml .= "</td></tr>";
    $strHtml .= "</table>&nbsp;";
    return $strHtml;
  }
}
?>