<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkinthtmlcomponent.int.php");

define("ALK_ACTIONTAG_GETSELECTOR",   "1");
define("ALK_ACTIONTAG_GETSELECTABLE", "2");
define("ALK_ACTIONTAG_ADDTAG",        "3");
define("ALK_ACTIONTAG_RELOADLIST",    "4");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlTag extends AlkHtmlCtrl implements AlkIntHtmlComponent
 * classe d'affichage d'un composant complexe de sélection et d'édition de valeurs dans la table SIT_TAG ou [thésaurus]
 * Controle de formulaire ouvrant une popup où il devient alors formulaire de sélection
 * Ajouté à des formulaires comme tous les controles Alk par AlkHtmlFactory::get(New)HtmlTag.
 * Retourné comme panel d'une page par le module Espace aux coordonnées (ALK_TYPESHEET_POPUP, ALK_SHEET_LABELS)
 */
class AlkHtmlTag extends AlkHtmlCtrl implements AlkIntHtmlComponent
{  
  /** séparateur de valeurs utilisé */
  protected $separator;
  
  /** active la sélection de valeurs de thésaurus si true */
  protected $bModeThesaurus;
  
  /** Lien vers un requeteur SQL */
  protected $oQuery;
  
  /** Paramètres de définition du controle */
  protected $tabParams;
  
  /** Action demandée sur le getHtml */
  protected $iActionTag;
  
  /** référence vers le formulaire conteneur */
  protected $oForm;
  
  /** nom du formulaire conteneur */
  protected $formName;
  
  /** référence vers le block conteneur */
  protected $oBlock;

  /** Mode du controle de saisie : =1 en lecture, =0 en modification */
  protected $iMode; 

  /** Valeur du controle de saisie par défaut */
  protected $value;

  /** Sauvegarde du label mis à "" par alkhtmlpagealk */
  protected $labelSave;

  /** Valeurs encodées (rawurlencode(utf8_decode(html_entity_decode)))*/
  protected $encodeValues;
  
  /**
   *  Constructeur par défaut
   *
   * @param oForm        Formulaire contenant ce champ
   * @param iMode        Mode du controle de saisie : =1 lecture, =0 ou =2 case à cocher + bouton ajouter
   * @param name         Nom du controle de saisie
   * @param label        Etiquette texte associée au controle de saisie
   * @param column       Nombre de colonnes. =0 par défaut
   * @param separator    Séparateur de valeurs utilisé
   */
  public function __construct($oForm, $iMode, $name, $value, $label, $tabParams, $separator="||", $bModeThesaurus=false) 
  {
    parent::__construct((is_object($oForm) ? $oForm : null), $iMode, $name, $value, $label);
    $this->formName = "";
    if (!is_null($this->oForm)){
      $this->formName = $this->oForm->getName();
    }
    else if ( is_string($oForm) ){
      $this->formName = $oForm;
    }
    $this->labelSave = $label;
    
    $this->bModeThesaurus = $bModeThesaurus;
    $this->separator = $separator;
    $this->setParameters($tabParams);
    
    $this->iActionTag = AlkRequest::getToken("iActionTag", AlkRequest::_REQUESTint("iActionTag", "-1"));
    
    $this->oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
  }
  
  /**
   * Défini le tableau des paramètres de définition du controle qui seront envoyés en token sous json_encode
   * @param tabParams   Nouvelles valeurs des paramètres
   */
  public function setParameters($tabParams)
  {
    $this->tabParams = $tabParams;
    $this->checkParameters();
  }
  
  /**
   * Ajoute un paramètre au tableau des paramètres de définition du controle qui seront envoyés en token sous json_encode
   * @param tabParams   Nouvelles valeurs des paramètres
   */
  public function addParameter($param_name, $param_value)
  {
    $this->tabParams[$param_name] = $param_value;
    $this->checkParameters();
  }
  
  /**
   * Controle que les paramètres par défaut ("table_name", "pk_field", "pk_id") sont fournis dans le tableau des paramètres de définition du controle
   * trigger_error en cas d'échec
   */
  protected function checkParameters()
  {
    $mandatory = array("table_name", "pk_field", "pk_id");
    $diff = array_diff($mandatory, array_keys($this->tabParams));
    if ( !empty($diff) ){
      trigger_error(__CLASS__."[".__LINE__."] : Les clés \"".implode(", ", $diff)."\" sont obligatoires dans le tableau des paramètres", E_USER_ERROR);
    } else {
      foreach ($mandatory as $key){
        if ( $this->tabParams[$key]==="" ){
          trigger_error(__CLASS__."[".__LINE__."] : La valeur de la clé ".$key." ne peut être vide", E_USER_ERROR);
        }
      }
    }
  }
  
  /**
   * Retourne le token d'accès à ce controle sous tous ses modes d'éxécution (encode les paramètres de définition)
   */
  protected function getStrToken()
  {
    $this->decodeValues();
    $this->addParameter("_INIT_", array(
      "iMode" => $this->iMode,
      "name" => $this->name,
      "value" => $this->getEncodedValues(),
      "label" => $this->labelSave,
      "formName" => $this->formName,
      "separator" => $this->separator,
      "bMultiLanguage" => $this->getBMultiLanguage()
    ));
    return AlkRequest::getEncodeParam("cont_id=".AlkFactory::getSProperty("cont_id", "-1").
                  "&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_LABELS.
                  "&params=".json_encode($this->tabParams));
  }
  
  /**
   * Encode les valeurs (rawurlencode(utf8_decode(html_entity_decode))) pour permettre leur transmission en javascript et url
   * @return les valeurs encodées
   */
  protected function getEncodedValues()
  {
    $res = $this->value;
    if ( is_array($this->value) ){
      foreach($this->value as $key=>$value){
        $res[$key] = str_replace(rawurlencode($this->separator), $this->separator, rawurlencode(utf8_decode(html_entity_decode($value))));
      }
    } else {
      $res = str_replace(rawurlencode($this->separator), $this->separator, rawurlencode(utf8_decode(html_entity_decode($this->value))));
    }
    return $res;
  } 
  
  /**
   * Decode l'attribut value (utf8_encode(rawurldecode)) pour permettre leur utilisation normale en php
   * Affecte l'attribut value
   */
  protected function decodeValues()
  {
    $res = $this->value;
    if ( is_array($this->value) ){
      foreach($this->value as $key=>$value){
        $res[$key] = rawurldecode($value);
        if ( $res[$key] != $value ){
          $res[$key] = utf8_encode($res[$key]);
        }
      }
    } else {
      $res = rawurldecode($this->value);
      if ( $res != $this->value ){
        $res = utf8_encode($res);
      }
    }
    $this->value = $res;
  } 
  
  /**
   *  Retourne le code html du ctrl ou exécute les instructions SQL ou ajax selon $this->iActionTag
   *
   * @return Retourne une chaîne vide
   */
  public function getHtml()
  {
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmltag.js");
    $this->addScriptCss("../".ALK_ROOT_CLASSE."form/alkhtmltag.css");
    switch($this->iActionTag){
      case ALK_ACTIONTAG_GETSELECTOR :
        $lg_id = AlkRequest::_REQUESTint("lg_id", ALK_LG);
        $this->value[$lg_id] = AlkRequest::_REQUEST("field_value", $this->value[$lg_id]);
        return $this->getHtmlSelector($lg_id);
        
      case ALK_ACTIONTAG_GETSELECTABLE :
        $lg_id = AlkRequest::_GETint("lg_id", ALK_LG);
        $this->value[$lg_id] = utf8_encode(AlkRequest::_REQUEST("field_value", $this->value[$lg_id]));
        $filters = $_POST;
        $oCtrl = $this->getHtmlTagListValues(true, $lg_id, $filters);
        echo $oCtrl->getHtml();
        exit();
        
      case ALK_ACTIONTAG_ADDTAG :
        $lg_id = AlkRequest::_GETint("lg_id", ALK_LG);
        $this->value[$lg_id] = utf8_encode(AlkRequest::_REQUEST("field_value", $this->value[$lg_id]));
        $filters = $_POST;
        $new_value = utf8_encode(rawurldecode(AlkRequest::_REQUEST("new_value", "")));
        $this->oQuery->addTag($lg_id, $new_value);
        $oCtrl = $this->getHtmlTagListValues(true, $lg_id, $filters);
        echo $oCtrl->getHtml();
        exit();
        
      case ALK_ACTIONTAG_RELOADLIST :
        $lg_id = AlkRequest::_GETint("lg_id", ALK_LG);
        $this->value[$lg_id] = utf8_encode(rawurldecode(AlkRequest::_REQUEST("field_value", $this->value[$lg_id])));
        writeJsonEncode($this->getListValues($lg_id, true));
        exit();
        
      default : 
        return parent::getHtml();
    }
  }
  
  /**
   *  Génère puis retourne le code html associé au controle de saisie
   *
   * @return Retourne un string dans le cas 1 langue
   *         Retourne un tableau dans le cas n langues
   */
  public function getCtrlHtml($key=0, $tabLg=array())
  {
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmltag.js");
    $this->addScriptCss("../".ALK_ROOT_CLASSE."form/alkhtmltag.css");
    if( $this->bMultiLanguage == false && !is_array($this->value)) {
      foreach($this->tabLangue as $lg_id => $tabLg) {
        $this->value = array($lg_id=>$this->value);
        break;
      }
      $this->tabParams["_INIT_"]["value"] = $this->value;
    }
    $strHtml = "";
    $bMultiLingue = $this->getBMultiLanguage();
    
    //modele html initialisé en variable globale par l'appel au chargement initModeleHtml : invisible
    $strGlue = "";
    foreach($this->tabLangue as $lg_id => $tabLg) {
      $suffixe = ($bMultiLingue ? $this->tabLangue[$lg_id]["bdd"] : "");
      
      $strHtml .= "<div style='clear:both;'>";      
      $strHtml .= $strGlue;
      
      $strHtml .= "<div id='list_".$this->guid.$suffixe."'>";      
      $strHtml .= $this->getListValues($lg_id);
      $strHtml .= "</div>";
      
      $strHtml .= "</div>";
      $strGlue = "<br/>";
    }
    
    return $strHtml;
  }
  
  /*
   * Affiche la liste des valeurs de la langue demandée sélectionnées en mode lecture et le bouton de recherche si le controle est éditable
   * @param lg_id         Langue demandée
   * @param bAjax(false)  Demande du résultat pour format Ajax(Json) si true
   * @return bAjax=false : strHtml ou bAjax=true : array(id, html)
   */
  public function getListValues($lg_id, $bAjax=false)
  {
    $strToken = $this->getStrToken();
    
    $bMultiLingue = $this->getBMultiLanguage();
    $tabLg = $this->tabLangue[$lg_id];
    $suffixe = ($bMultiLingue ? $tabLg["bdd"] : "");
    
    $encoded_values = $this->getEncodedValues();
    $strHtml = "<input type='hidden' id='".$this->guid.$suffixe."' name='".$this->name.$suffixe."' value=\"".$encoded_values[$lg_id]."\"/>";
    
    $strGlue = ", "/*"<img src=\"".$this->urlBaseFlag."bullet_actu.gif\" alt=\"\" valign='bottom'/>&nbsp;".*/;
    $strHtml .= substr(str_replace($this->separator, $strGlue, $this->value[$lg_id]), strlen($strGlue), -strlen($strGlue));
    
    if ( $this->iMode!="1" ){// bouton rechercher en mode édition
      $strHtml .= "<div>";
      $strLabelBt = _t("Ajouter");
      if ( $bMultiLingue && count($this->tabLangue)>1 ){
        $strHtml .= "<img class=\"alkimgicon alkimgicondrapeau".$tabLg["rep"]."\" src=\"".$this->urlBaseFlag."transp.gif\"".
              " alt=\"".$tabLg["rep"]."\" title=\"".$tabLg["rep"]."\" align='top'/>&nbsp;";
      }
      $oAdd = AlkHtmlFactory::getHtmlButtonForm("javascript:selectTags('".$strToken."', '".$lg_id."')", $strLabelBt, _t("Sélectionner les valeurs"));
      $strHtml .= $oAdd->getHtml();
      $strHtml .= "</div>";
    }

    if ($bAjax){
      return array("id"=>$this->guid.$suffixe, "html" => $strHtml);
    }
    return $strHtml;
  }
  
  /**
   * Retourne le code HTML de la popup de sélection de valeur pour une langue d'entrée donnée
   * Affiche les critères de recherche et les listes de valeurs
   * @param lg_id   Langue demandée
   * @return strHtml
   */
  public function getHtmlSelector($lg_id)
  {
    $strToken = $this->getStrToken();
    
    $from_table = AlkRequest::_REQUEST("from_table", "SIT_TAG");
    $filters = array("from_table"=>$from_table, "field_value"=>$this->value[$lg_id]);
    
    $oHide = AlkHtmlFactory::getNewHtmlHidden($this->oForm, "field_value", $this->value[$lg_id]);
    $oHide->addHidden("lg_id", $lg_id);
    
    $oType = AlkHtmlFactory::getNewHtmlSelect($this->oForm, "0", "from_table", $from_table, "");
    $tabTypes = array("SIT_TAG" => _t("Mots-clés"));
    if ( $this->bModeThesaurus ){
      $tabTypes = array_merge($tabTypes, array("1" => _t("Thésaurus")));
    }
    $oType->setProperty("tabValTxt", $tabTypes);
    $oType->addEvent("onchange", "changeSelector('".$this->formName."', '".$strToken."', ".$lg_id.")");
    
    $tabCtrlFilter = array();
    if ($from_table!="SIT_TAG"){
      // sélecteurs de thésaurus
    }
    
    $searchAction = "searchValue('".$this->formName."', '".$strToken."', ".$lg_id.")";
    $oSearch = AlkHtmlFactory::getNewHtmlText($this->oForm, "0", "intitule", "", "");
    $oSearch->addEvent("onkeyup", $searchAction);
    $varCtrl = AlkHtmlFactory::getHtmlButtonIcon("javascript:".$searchAction, "Rechercher", _t("Rechercher"));
    $oSearch->addCtrl($varCtrl);
      
    $oSelectable = $this->getHtmlTagListValues(true, $lg_id, $filters);
    $oSelected = $this->getHtmlTagListValues(false, $lg_id, $filters);
    
    $oValider = AlkHtmlFactory::getHtmlButtonPage("javascript:ValidSelectTag('".$strToken."', ".$lg_id.")", _t("Valider"), _t("Valider la sélection"));
    $oAnnuler = AlkHtmlFactory::getHtmlButtonPage("javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
    
    $strHtml = "<div class='alkhtmltag'>".
                  "<div style='margin:2px;' class='searcher'>".
                  "<form name='".$this->formName."' method='POST'>".
                    $oHide->getHtml().
                    $oType->getHtml()."&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp;".
                    "<div id='filters_cat' style='float:left;'>";
    foreach ($tabCtrlFilter as $oCtrl){
      $strHtml .= $oCtrl->getHtml()."&nbsp;&nbsp;&nbsp;&nbsp;";
    }
    $strHtml .=     "</div>".
                    $oSearch->getHtml().
                  "</form>".
                  "</div>".
                  "<table width='100%' align='center' cellspacing='6'><tr>".
                    "<td id='list_values_selectable' class='part'>".$oSelectable->getHtml()."</td>".
                    "<td id='list_values_selected' class='part'>".$oSelected->getHtml()."</td>".
                  "</tr></table>".
                  "<table width='100%' align='center' cellspacing='12' style='clear:both'><tr>".
                    "<td align='right'>".$oValider->getHtml()."</td>".
                    "<td align='left'>".$oAnnuler->getHtml()."</td>".
                  "</tr></table>".
                "</div>";
    return $strHtml;
  }
  
  /**
   * Retourne le code HTML des listes des valeurs sélectionnables ou sélectionnées pour une langue donnée et des critères donnés
   * @param bSelectable       si true : liste des valeurs sélectionnables (+éditeur de nouveau), si false : liste des valeurs sélectionnées 
   * @param lg_id             Langue demandée
   * @param filters(array())  Liste des filtres à appliquer à la recherche des valeurs
   * @return strHtml
   */
  public function getHtmlTagListValues($bSelectable, $lg_id, $filters=array())
  {
    $strToken = $this->getStrToken();
    
    $dsValues = $this->oQuery->getDsTagList($bSelectable, $this->name, $lg_id, $this->tabParams, $this->separator, $filters);
    $strHtml = "";
    if ( $bSelectable ){
      $oNewValue = AlkHtmlFactory::getNewHtmlText($this->oForm, "0", "new_value", "", "");
      $varCtrl2 = AlkHtmlFactory::getHtmlButtonIcon("javascript:newTag('".$this->formName."', '".$strToken."', ".$lg_id.", '".$this->separator."')", 
                                                            "Valider", _t("Ajouter cette valeur"));
      $oNewValue->addCtrl($varCtrl2);
      $strHtml .= "<div class='editor".($dsValues->getCountDr()>13 ? " scroll" : "")."'>".$oNewValue->getHtml()."</div>";
      
    } else {
      // ligne modele pour les ajouts
      $strHtml .= "<div class='oneline modele' id='selected[\$\$]'>";
      $strHtml .= "<div style='float:left;' id='selected_intitule[\$\$]'></div>";
      $strActionDel = "javascript:delTag('\$\$', '".$this->separator."');";
      $oDel = AlkHtmlFactory::getHtmlButtonIcon($strActionDel, "Supprimer", _t("Retirer de la sélection"));
      $strHtml .= "<div class='action' id=\"del[\$\$]\">".$oDel->getHtml()."</div>";
      $strHtml .= "</div>";
    }
    
    $prefixe_id =  ($bSelectable ? "selectable" : "selected");
    $encoded_values = $this->getEncodedValues();
    $tabValues = explode($this->separator, $encoded_values[$lg_id]);
    $strHtml .= "<div class='overflow".($dsValues->getCountDr()>13 ? " scroll" : "")."' id='list_".$prefixe_id."'>";
    while ( $drValues = $dsValues->getRowIter() ){
      $class = ($dsValues->getCurrentIndex()%2==0 ? "impair" : "pair");
      $tag_intitule = html_entity_decode($drValues->getValueName("TAG_INTITULE"));
      
      $tag_intitule_escape = rawurlencode(utf8_decode($tag_intitule));
      
      $tag_used = in_array($tag_intitule_escape, $tabValues);
      $strHtml .= "<div class='oneline ".$class."' id='".$prefixe_id."[".$tag_intitule_escape."]'>";
      $strHtml .= "<div style='float:left;' id='".$prefixe_id."_intitule[".$tag_intitule_escape."]'>".$tag_intitule."</div>";
      if ( $bSelectable ){
        $strActionAdd = "javascript:addTag('".$tag_intitule_escape."', '".$this->separator."');";
        $oAdd = AlkHtmlFactory::getHtmlButtonIcon($strActionAdd, "Ajouter", _f("Ajouter à la sélection : %s", $tag_intitule));
        $strHtml .= "<div class='action' id=\"add[".$tag_intitule_escape."]\" style='".($tag_used ? "display:none;" : "")."'>".$oAdd->getHtml()."</div>";
      
      } 
      else {
        $strActionDel = "javascript:delTag('".$tag_intitule_escape."', '".$this->separator."');";
        $oDel = AlkHtmlFactory::getHtmlButtonIcon($strActionDel, "Supprimer", _t("Retirer de la sélection"));
        $strHtml .= "<div class='action' id=\"del[".$tag_intitule_escape."]\">".$oDel->getHtml()."</div>";
      }
      $strHtml .= "</div>";
    }
    $strHtml .= "</div>";
    
    return AlkHtmlFactory::getHtml($strHtml);
  }
  
  /**
   * Retourne le titre de la popup de sélection
   */
  public function getTitle()
  {
    $lg_id = AlkRequest::_GETint("lg_id", ALK_LG);
    $tLg = $this->tabLangue[$lg_id];
    return ($this->getBMultiLanguage() && count($this->tabLangue)>1
            ? "<img class=\"alkimgicon alkimgicondrapeau".$tLg["rep"]."\" src=\"".$this->urlBaseFlag."transp.gif\"".
              " alt=\"".$tLg["rep"]."\" title=\"".$tLg["rep"]."\" align='bottom'/> " 
            : "").
            _f("Sélection des %s", $this->label);
  }
}
?>