<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlText
 * 
 * classe d'affichage d'un composant de saisie texte.
 *        génère : <input type=text>
 *                 <input type=password>
 *                 <textarea></textarea>
 *        classe multilingue : passer un tableau sur param value
 *                             renseigner les attributs tabLangue et urlBaseFlag
 */
class AlkHtmlText extends AlkHtmlCtrl
{
  /** = vrai si champ mot de passe, faux par défaut */
  protected $bPassword;
  
  /** nombre de lignes, = 1 par défaut */
  protected $row;

  /** nombre de colonnes, = 0 par défaut */
  protected $colomn;
  
  /** longueur max, = 0 par défaut */
  protected $maxLength;

  /** largeur en pixels, = vide par défaut */
  protected $width;

  /** hauteur en pixels, = vide par défaut */
  protected $height;

  /** vrai si memo représenté par fckeditor, =faux par défaut */
  public $bEditor;

  /** paramètres de fckeditor spécifiques */
  protected $tabParamEditor;

  /** paramètres de l'objet Config de fckeditor (les clés doivent être des clés du tableau Config de FCK)*/
  protected $tabParamFCKConfig;

  /** Indique si on affiche (true=affiche, false=n'affiche pas, default=false) le décompteur du nombre de caractères saisis dans le textarea dans le cas où celui-ci est limité en nombre de car max. */
  protected $bMemoCountLength;
  
  /** 
   * =0 pour recopier automatiquement la valeur de la langue par défaut sur les autres vides
   * =1 pour recopier automatiquement la valeur de la langue par défaut suffixé par le code de la langue sur les autres vides
   * =2 pour ne rien faire
   */
  protected $iMultiLanguageMode;

  /** 
   * false par défaut pour ne montrer que la langue par défaut 
   * true pour afficher toutes langues par défaut
   * */
  protected $bShowButtonMultiLanguage;


  /**
   *  Constructeur par défaut
   * @param oForm    référence sur l'objet formulaire
   * @param iMode     Mode du controle de saisie : =0 modif, =1 lecture
   * @param name      Nom du controle de saisie
   * @param value     Valeur par défaut du controle de saisie
   * @param label     Etiquette texte associée au controle de saisie
   * @param row       Nombre de ligne (=1 : <input type=text>, >1 : <textarea>). =1 par défaut
   * @param column    Nombre de colonnes. =0 par défaut
   * @param maxlength Longueur max du texte saisi. =0 par défaut
   */
  public function __construct($oForm, $iMode, $name, $value="", $label="", $row=1, $column=0, $maxlength=0 )
  {
    parent::__construct($oForm, $iMode, $name, $value, $label);
    
    $this->bReadOnly = false;
    $this->bPassword = false;
    $this->row = $row;
    $this->column = $column;
    $this->maxLength = $maxlength;
    $this->width = "";
    $this->height = "";
    $this->bEditor = false;
    $this->bShowMultiLanguage = true;
    $this->bShowButtonMultiLanguage = true;
    $this->strQuot = "&#34;";
    $this->tabParamEditor = array("pathUpload"  => "",
                                  "styleCss"    => "editeur.css",
                                  "styleXml"    => "fckstyles.xml",
                                  "bodyId"      => ( defined("ALK_EDITEUR_BODYID") ? ALK_EDITEUR_BODYID : "" ),
                                  "bodyClass"   => ( defined("ALK_EDITEUR_BODYCSS") ? ALK_EDITEUR_BODYCSS : "" ),
                                  "templateXml" => "fcktemplates.xml",
                                  "cktemplate"  => "cktemplate.js",
                                  "ckstyle"     => "ckstyle.js",
                                  "lg"          => "fr",
                                  "openPopup"   => false,
                                  "tableName"   => "",
                                  "data_id"     => "-1",
                                  "useForm"     => false,
                                  "fieldPk"     => "",
                                  "tokenStart"  => "",
                                  "basicMenuBar"=> "1",
                                  "toolbarSet"  => "Basic");
    $this->tabParamFCKConfig = array("AutoDetectLanguage"   => "false",
                                     "ToolbarStartExpanded" => "false");

    $this->bMemoCountLength = false;
    $this->bMultiLanguage = ( is_array($value) ? true : false ); 
    $this->iMultiLanguageMode = 0;
  }

  /**
   *  Génère puis retourne le code html associé au controle de saisie
   *
   * @return Retourne un string dans le cas 1 langue
   *         Retourne un tableau dans le cas n langues
   */
  protected function getCtrlHtml($key="0", $tabLg=array(), $bSee=true)
  {
    // contruit le controle
    
    $strClassCss = ( $this->cssFormCtrl!=""
                     ? ' class="'.$this->cssFormCtrl.'"'
                     : '' );
    
    $strHtml = "";
    $strHtmlSee ="";
    $strHtmlCtrl = "";
    $strHtmlContent = "";
    if( $this->iMode == "1" ) {
      // mode lecture
      if( $this->bMultiLanguage == false ) {
        $strHtml = '<span class="'.$strClassCss.'">'.$this->value.'</span>';
      } else {
          $strImgDrap = "";
          if( $this->nbLangue >= 1 && $this->bShowMultiLanguage == true)
            $strImgDrap = '<img'.
              ' class="alkimgicon alkimgicondrapeau'.$tabLg["rep"].'"'.
              ' src="'.$this->urlBaseFlag.'transp.gif"'.
              ' alt="'.$tabLg["rep"].'"'.
              ' title="'.$tabLg["rep"].'"'.
              ' align="top"/>';
          $strHtml .= '<div '.$strClassCss.'>'.$strImgDrap.$this->value[$key].'</div>';        
      }
    } else {
      if( $this->bMultiLanguage == false ) {
        $strHtml .= $this->_getHtmlUpdateMode();
      } else {
        $strImgDrap = "";
        $strGUID = $this->guid.$tabLg["bdd"];
        if($this->bShowMultiLanguage==true ) {
          if ( $this->nbLangue > 1){
            if ($this->bEditor==true ){
              $strHtmlContent.= 
                '<a id="link_'.$strGUID.'"' .
                ' href="javascript:void(1)"' .
                ' class="lang"' .
                ' title="'._f("Editer le contenu %s", $tabLg["rep"]).'"'.
                ' onclick="javascript:LoadEditor(\'div_'.$strGUID.'\',0)">'.
                '<img alt="'._f("Editer le contenu %s", $tabLg["rep"]).'"' .
                ' class="alkimgicon alkimgicondrapeau'.$tabLg["rep"].'"'.
                ' src="'.$this->urlBaseFlag.'transp.gif"'.
                ' border="0"' .
                ' alt="'.$tabLg["rep"].'"' .
                ' align="top"/></a>';
            } else {
              $strHtmlSee = ( $key==0 && $this->bShowButtonMultiLanguage
                              ? '<a title="'._t("Afficher toutes les langues").'"' .
                                ' onclick="LangShowHideLayer(\'0_'.$this->name.'\')">'.
                                '<img border="0"' .
                                ' alt="'._t("Afficher toutes les langues").'"' .
                                ' class="SeeButton alkimgicon alkimgiconlocale"' .
                                ' src="'.$this->urlBaseImg.'transp.gif"'. 
                                '></a>'
                              : ''); 
            }
          }                          
          $this->addScriptJs($this->tabConstJs["HELP"]);
          $strHtmlCtrl.= $this->_getHtmlUpdateMode($key).$strHtmlSee.
            ( $this->bShowMultiLanguage==false && $key >0 || count($this->tabLangue)<=1
              ? ''
              : '' /*'<br>'*/);            
        }
        $strHtmlContent .= ( $this->nbLangue > 1 && $this->nbLangue==($key+1)
                             ? '<a title="'._t("Dupliquer le contenu de référence").'"' .
                               ' onclick="CopyField(\'div_'.$this->name.'\',0)">'.
                               '<img border="0" ' .
                               ' alt="'._t("Dupliquer le contenu de référence") .'"' .
                               ' class="CopyButton  alkimgicon alkimgiconcopy"' .
                               ' src="'.$this->urlBaseImg.'transp.gif"' .
                               '></a>'
                            : "");
        
        $strHtml .= ( $this->bEditor==true 
                      ? $strHtmlContent.'@@@'
                      : ''
                    ).$strHtmlCtrl;
      }
    }
    return $strHtml;
  }

  /**
   *  Génère puis retourne le code html du ctrl texte dans la langue spécifiée.
   *        si multilingue :
   *          - génère 1 hidden supplémentaires : ancienne valeur
   *          - si showMultilingue=false,
   *              - retourne la valeur française en text,
   *              - retourne les valeurs étrangères en hidden
   *
   * @param $iLangue  Identifiant de la langue
   * @return Retourne un string
   */
  protected function _getHtmlUpdateMode($iLangue=0)
  {
    $strHtml = "";
    $strReadOnly = "";
    $strDisabled = "";
    $strJs   = "";
    $strGlue ="";
    if( $this->bReadOnly == true ) $strReadOnly = ' readonly="true" ';
    if( $this->bDisabled == true ) $strDisabled = ' disabled="true" ';

    $strName = $this->name;
    $strGUID = $this->guid;
    
    if( $this->bMultiLanguage == true ) {
      $strName = $this->name.$this->tabLangue[$iLangue]["bdd"];
      $strGUID = $this->guid.$this->tabLangue[$iLangue]["bdd"];
      $strValue =  ( !$this->bEditor ? htmlspecialchars_decode($this->value[$iLangue], ENT_NOQUOTES) : $this->value[$iLangue] );
      $strHtml .= ( $this->row==1 
                   ? '<input type="hidden" id="a'.$strGUID.'" name="a'.$strName.'" value="'.$strValue.'"/>'
                   : '<input type="hidden" id="a'.$strGUID.'" name="a'.$strName.'" value="'.AlkRequest::getEncodeParam($strValue).'"/>');
      
      if( $this->bShowMultiLanguage == false && $iLangue>1 ) {
        $strHtml .= ( $this->row==1
                      ? '<input type="hidden" id="'.$strGUID.'" name="'.$strName.'" value="'.$strValue.'"/>'
                      : '<input type="hidden" id="'.$strGUID.'" name="'.$strName.'" value="'.AlkRequest::getEncodeParam($strValue).'"/>');
        return $strHtml;
      }
    } else {
      $strValue = ( !$this->bEditor ? htmlspecialchars_decode($this->value, ENT_NOQUOTES) : $this->value); 
    }

    $iDeltaFlag = 0;
    if( $this->nbLangue >= 1 &&  $this->bMultiLanguage==true && $iLangue>=0 ) {
      if( $this->nbLangue > 1 )
        $iDeltaFlag = -40; // padding-left 20px intérieur pour le drapeau + 20px extérieur droit pour afficher le picto "afficher toutes les lg"
      if ($iLangue == 0){
        if( $this->iMultiLanguageMode < 2 ) {
          $strJs .= ' onKeyUp="javascript:DuplicateFieldContent(\''.$this->name.'\','.$iLangue.', '.$this->iMultiLanguageMode.')"';
        }
      }
      else {
        if( $this->iMultiLanguageMode < 2 ) {
          $strCurrentValue =  ( !$this->bEditor ? htmlspecialchars_decode($this->value[0], ENT_NOQUOTES) : $this->value[0]);
          $strJs .= ' onfocus="javascript:FocusTexteField(this)" onblur="javascript:fillField(\''.$this->name.'\','.$iLangue.',0, '.$this->iMultiLanguageMode.')"';
          $strGlue = ( $strCurrentValue == $strValue ? " idem" : "");
        }
      }
    }

    $iDelta = 0;
    if( $this->column>30 ) $iDelta = -24;
    if( $this->width=="" ) $this->width = ($this->column + ($this->row=="1" ? 0 : 2))*8+$iDelta+$iDeltaFlag;

    $strClass = ' class="'.
      $this->cssFormCtrl.
      ( $this->bMultiLanguage == true && $this->nbLangue > 1
        ? ' multilg '.strtolower($this->tabLangue[$iLangue]["rep"]).$strGlue
        : '').
      '"';
    $bIE = true;
    if( self::$strNavigator == "Netscape4" ) {
      $strClass = "";
      $bIE = false;
    }
    if( $bIE && ($this->width!="" || $this->height!="") ) {
      $strClass .= ' style="';
      if( $this->width!="" ) $strClass .= 'width: '.$this->width.'px;';
      if( $this->height!="" ) $strClass .= 'height: '.$this->height.'px;';
      $strClass .= '"';
    }

    if( $this->row == 1 ) {
      // input type=text
      $strHtml .= '<input'.
        ' type="'.($this->bPassword==true ? "password" : "text").'"'.
        ' id="'.$strGUID.'"'.
        ' name="'.$strName.'"'.
        ' value="'.$strValue.'"'.
        $strReadOnly.
        $strDisabled.
        $strJs.
        $strClass.
        ( $this->column!="0" 
          ? ' size="'.$this->column.'"' 
          : '').
        ( $this->maxLength!="0" 
          ? ' maxlength="'.$this->maxLength.'"' 
          : '').
        $this->getHtmlEvent().
        '/>';
    } else {
      // textarea
      if( $this->bEditor==true ) {
        if( array_key_exists("openPopup", $this->tabParamEditor) && $this->tabParamEditor["openPopup"]==true ) {
          
          $strParam = $this->tabParamEditor["tokenStart"].
            "&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_FORM."&iSSheet=".ALK_SHEET_NONE.
            "&applitype_id=".ALK_ATYPE_ID_EDITEUR.
            "&idEnt=".$this->tabParamEditor["data_id"].
            "&table=".$this->tabParamEditor["tableName"].
            "&champsHtml=".$strName.
            "&champJScript=".
            "&champsId=".$this->tabParamEditor["fieldPk"].
            "&bForm=".$this->tabParamEditor["useForm"].
            "&bReload=1".
            "&bBasicMenuBar=".$this->tabParamEditor["basicMenuBar"].
            "&repUpload=".$this->tabParamEditor["pathUpload"];
          $strToken = AlkRequest::getEncodeParam($strParam);
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmltext.js");

          $strValContents = mb_ereg_replace("<[bB][rR]>", "sautdeligne", $strValue);
          $strValContents = mb_ereg_replace("<[^>]*>", "", $strValContents);
          $strValContents = mb_substr($strValContents, 0, 300);
          $strValContents = mb_ereg_replace("sautdeligne", "<br/>", $strValContents);
          if( $strValContents != "" ) {
            $strValContents .= "...";
          }
          if( $strValContents == "" ) {
            $strValContents = "Ouvrir l'éditeur";
          }

          $strHtml .= '<a' .
            ' title="'._f("Modifier le contenu %s", ( $iLangue>0 ? $this->tabLangue[$iLangue]["rep"]: "" )).'"'.
            ' href="javascript:openFCKeditor(\''.$strToken.'\')">'.
            $strValContents.
            '</a>';
        } else {
          $iHeight = ( $this->row!="" ? 40+$this->row*16 : 104 );
          $iWidth = $this->width;
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/ckeditor.js");
          $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmltext.js");
          $this->addVarJs("ALK_B_EDITEUR_CKEDITOR", "true"); 
          
          $strHtml.='<div style="display:none;"' .
            ' id="div_'.$strGUID.'"'.
            ' class="cke_editable"' .
            ' width="'.$iWidth.'px"' .
            ' height="'.$iHeight.'">'.
            ( $strValue!= "" 
              ? $strValue 
              : "").
            '</div>';
          
          $strHtml .= '<input type="hidden"'.
            ' name="'.$strName.'"'.
            ' id="'.$strGUID.'"'.
            ' value=""'.
            '/>';
                             
         if( $iLangue == 0 && $this->bMultiLanguage && $this->nbLangue > 1 ) {   
           $strHtml.='<div style="display:block;overflow:auto;padding:5px;margin-top:5px; width:272px;"'.
             ' id="current_div_'.$strGUID.'"' .
             ' height="'.$iHeight.'">'.strip_tags($strValue).'</div>';            
           }
         $strHtml .= $this->_getCKEditorJS("div_".$strGUID);
        }
      } else {
        if( $this->bMemoCountLength && count($this->tabValidator)>0 && $this->tabValidator["type"]=="memo" && $this->tabValidator["max"]!="" ){
          $this->addEvent("onfocus",    "validLongueurTextArea(this, ".$this->tabValidator["max"].", '".$this->guid."')");
          $this->addEvent("onblur",     "validLongueurTextArea(this, ".$this->tabValidator["max"].", '".$this->guid."')");
          $this->addEvent("onkeypress", "validLongueurTextArea(this, ".$this->tabValidator["max"].", '".$this->guid."')");
          $this->addEvent("onkeyup",    "validLongueurTextArea(this, ".$this->tabValidator["max"].", '".$this->guid."')");
        }
        
        $strHtml .= '<textarea'.
          ' name="'.$strName.'"'.
          ' id="'.$strGUID.'"'.
          $strDisabled.
          $strReadOnly.
          $strJs.
          $strClass.
          ( $this->column!="0" 
            ? ' cols="'.$this->column.'"' 
            : '').
          ( $this->row!= "" 
            ? ' rows="'.$this->row.'"' 
            : '').
          $this->getHtmlEvent().
          '>'.
          $strValue.
          '</textarea>';
      }
    }

    return $strHtml;
  }

  /**
   *  Retourne le code javascript utile pour ouvrir un éditeur mémo
   *        de type fckeditor avec une barre outils minimale
   *
   * @param  strName  Nom du controle
   * @return Retourne un string
   */
  protected function _getCKEditorJS($strName)
  {
    $this->tabParamEditor["bodyId"];
    $iHeight = ( $this->row!="" ? 40+$this->row*16 : 104 );
    $iWidth = $this->width;
    if( !defined("ALK_CSS_DIR") ) define("ALK_CSS_DIR",  "");
    
    $strHtml = 
      "<script type=\"text/javascript\">".
      " var sBasePath = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/';".
      ( defined("ALK_B_EDITEUR_PDW_FILEBROWSER") && ALK_B_EDITEUR_PDW_FILEBROWSER==true 
        ? "CKEDITOR.config.filebrowserBrowseUrl = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/pdw_file_browser/index.php?editor=ckeditor&ServerPath=".ALK_VIRTUAL_DIR.$this->tabParamEditor["pathUpload"]."&UrlRoot=".ALK_ROOT_URL."';"
        : "CKEDITOR.config.filebrowserBrowseUrl = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/filemanager2/index.html?ServerPath=".ALK_VIRTUAL_DIR.$this->tabParamEditor["pathUpload"]."&UrlRoot=".ALK_ROOT_URL."';"
      ).
      "CKEDITOR.config.toolbar = '".$this->tabParamEditor["toolbarSet"]."';".
      "CKEDITOR.config.width = ".$iWidth.";".
      "CKEDITOR.config.height = ".$iHeight.";";
      //"CKEDITOR.config.bodyId = '".$this->tabParamEditor["bodyId"]."';".
      //"CKEDITOR.config.bodyClass = '".$this->tabParamEditor["bodyClass"]."';";
    
     if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_".AlkFactory::getSProperty("cont_id", "-1").".css")){
      $strHtml .= "CKEDITOR.config.contentsCss = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur_".AlkFactory::getSProperty("cont_id", "-1").".css';";
    } elseif( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur.css") ){
      $strHtml .= "CKEDITOR.config.contentsCss = '". ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/editeur.css';";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur_".AlkFactory::getSProperty("cont_id", "-1").".css")){
      $strHtml .= "CKEDITOR.config.contentsCss = '". ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur_".AlkFactory::getSProperty("cont_id", "-1").".css';";
    } elseif( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur.css") ){
      $strHtml .= "CKEDITOR.config.contentsCss = '". ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur.css';";
    } else {
      $strHtml .= "CKEDITOR.config.contentsCss = '". ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/templates/editeur.css';";
    }
     
    /*if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur_".AlkFactory::getSProperty("cont_id", "-1").".css")){
      $strHtml .= "CKEDITOR.config.contentsCss = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur_".AlkFactory::getSProperty("cont_id", "-1").".css';";
    } else {
      $strHtml .= "CKEDITOR.config.contentsCss = '".( ALK_EDITEUR_CSS!= "" ? ALK_EDITEUR_CSS : ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."editeur.css")."';" ;
    } */
    
    if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $strHtml .= "CKEDITOR.config.templates_files = ['". ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js'];";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/cktemplate.js")){
      $strHtml .= "CKEDITOR.config.templates_files = ['". ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/cktemplate.js'];";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $strHtml .= "CKEDITOR.config.templates_files = ['". ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js'];";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."cktemplate.js")){
      $strHtml .= "CKEDITOR.config.templates_files = ['". ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."cktemplate.js'];";
    }else {
      $strHtml .= "CKEDITOR.config.templates_files = ['". ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/cktemplate.js'];";
    }
     
    if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js';";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle.js")){
      $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckstyle.js';";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js';";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckstyle.js")){
      $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckstyle.js';";
    }else {
      $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/ckstyle.js';";
    }
       
    /*if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $strHtml .= "CKEDITOR.config.templates_files = ['".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."cktemplate_".AlkFactory::getSProperty("cont_id", "-1").".js'];";
    } elseif (file_exists(ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.$this->tabParamEditor["cktemplate"])){
      $strHtml .= "CKEDITOR.config.templates_files = ['".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.$this->tabParamEditor["cktemplate"]."'];";
    }else {
      $strHtml .= "CKEDITOR.config.templates_files = ['".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/".$this->tabParamEditor["cktemplate"]."'];";
    }*/
    
    /*if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckstyle_".AlkFactory::getSProperty("cont_id", "-1").".js';";
    } elseif (file_exists(ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.$this->tabParamEditor["ckstyle"])){
       $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.$this->tabParamEditor["ckstyle"]."';";
    }else {
       $strHtml .= "CKEDITOR.config.stylesSet = 'styleperso:".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/".$this->tabParamEditor["ckstyle"]."';";
    }*/
    $strHtml.="CKEDITOR.basePath = sBasePath;";
    
    if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js")){
     $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js';";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig.js")){
      $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE.ALK_CSS_DIR."/ckconfig.js';" ;
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js")){
     $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js';";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig.js")){
      $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig.js';" ;
    } else {
      $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/ckconfig.js';" ;
    }
     
    /*if(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js")){
      $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig_".AlkFactory::getSProperty("cont_id", "-1").".js';";
    } elseif(file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."ckconfig.js")){
      $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_STYLE."ckconfig.js';";
    } else {
      $strHtml .= "CKEDITOR.config.customConfig = '".ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/lib/ckconfig.js';";
    }*/
    if ( !$this->bMultiLanguage || ($this->bMultiLanguage && $this->nbLangue  == 1)){
      $strHtml .= "CKEDITOR.replace('".$strName."');";
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_ckeditor.js");
    }
    $strHtml .= "</script>";

    return $strHtml;
  }

  /**
   *  Met à jour un paramètre de l'éditeur
   *
   * @param strParamName  Nom du paramètre
   * @param strParamValue Valeur du paramètre
   * @param bFCKConfig    (default false) Indique s'il s'agit d'un paramètre de l'objet Config du FCK (true) ou d'un paramètre spécifique (false) 
   */
  public function setParamEditor($strParamName, $strParamValue, $bFCKConfig=false)
  {
    /* vérification de l'existance d'une css personnalisée pour l'espace courant */
    if ($strParamName=="styleCss"){
      $strUrlCssCont = ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."editeur_".AlkFactory::getSProperty("cont_id", "-1").".css";
      if (file_exists($strUrlCssCont)){
        $strParamValue = $strUrlCssCont;
      }      
    }
    
    if ( $bFCKConfig ) {
      $this->tabParamFCKConfig[$strParamName] = $strParamValue;
    }
    else if( array_key_exists($strParamName, $this->tabParamEditor) ) {
      $this->tabParamEditor[$strParamName] = $strParamValue;
    } 
  }
  
  /**
   *  Passe le controle en mode éditeur
   */
  public function setEditor($bEditor)
  {
    $this->bEditor = $bEditor;
  }

  /**
   *  Modifie la valeur de bPassword
   * @param bEnable booleen
   */
    public function setBPassword($bEnable)
    {
      $this->bPassword = $bEnable;
    }
  
  /**
   * Modifie la valeur de bMemoCountLength
   * @param bEnable booleen
   */
  public function setBMemoCountLength($bMemoCountLength)
  {
    $this->bMemoCountLength = $bMemoCountLength;
  }
 
  /**
   * Fixe le mode de saisie multilingue
   * @param iMultiLanguageMode =0, 1 ou 2
   */
  public function setMultiLanguageMode($iMultiLanguageMode)
  {
    $iMultiLanguageMode = ( is_numeric($iMultiLanguageMode) ? floor($iMultiLanguageMode) : 0);
    if( $iMultiLanguageMode<0 || $iMultiLanguageMode>2 ) $iMultiLanguageMode = 0; 
    $this->iMultiLanguageMode = $iMultiLanguageMode;
  }
 
  /**
   * Retourne le label du controle
   */
  public function getLabel()
  {
    $strLabel = parent::getLabel();
    if( $this->bMemoCountLength && $this->iMode==0 && 
        count($this->tabValidator)>0 && 
        $this->tabValidator["type"]=="memo" && 
        $this->tabValidator["max"]!="" ) {
      // Ces messages sont modifiés en javascript par la fonction validLongueurTextArea du fichier lib/lib_formtxt.js
      $nbCar = $this->tabValidator["max"]-mb_strlen($this->value);
      $class = "";
      $strMsg = _f("%s car. restant", $nbCar);
      if ( $nbCar<0 ){
        $class = ' class="txtWarning"';
        $strMsg = _f("%s car. excédant", abs($nbCar));
      }
      $strLabel .= '<br/><span id="counter_'.$this->guid.'"'.$class.'>('.$strMsg.')</span>';
    }
    return $strLabel;
  }   
}
?>