<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Htdig
Module fournissant les classes pour le moteur d'indexation Htdig.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

class AlkMnogoSearch extends AlkObject
{
  /** tableau des résultats*/
  public    $matches = NULL;
  /** nombre total de résultat */
  public    $total   = NULL;
  /** tableau des informations du résultats concernées par la mise en évidence du mote recherché */
  public    $hilites = array('title', 'text');
  /** caractère ou code html correspondant au début de la mise en évidence du mote recherché */
  public    $hlbeg   = '<strong>';
  /** caractère ou code html correspondant à la fin de la mise en évidence du mote recherché */
  public    $hlend   = '</strong>';

  /** agent mnogosearch */
  protected $agent   = NULL;
  /** identifiant du résultat mnogosearch */
  protected $res     = NULL;
  
  /** Protocoloe de connexion a la base de donnees */
  protected $strProtocole;
  /** Adresse IP du serveur de base de donnees */
  protected $strHost;    
  /** Identifiant de l'utilisateur */
  protected $strLogin;
  /** Nom de la base de donnees */
  protected $strDb;
  /** Mot de passe */
  protected $strPwd;
  /** Alias */
  protected $strAlias;
  /** numéro de port */
  protected $strPort;
  /** mode de stockage des infos mnogosearch dans la base de données par défaut blob */
  protected $strMode;

  /**
   * Constructeur par défaut
   */
  public function __construct($strLogin,  $strHost,  $strPwd,  $strDb,  $strAlias,  $strPort, $strMode="blob",  $strProtocole="mysql") 
  {
    $this->strLogin = $strLogin;
    $this->strHost = $strHost;
    $this->strPwd = $strPwd;
    $this->strDb = $strDb;
    $this->strAlias = $strAlias;
    $this->strPort = $strPort;
    $this->strMode = $strMode;
    
    $this->strProtocole =  $strProtocole;
    
    $this->res = false;
    
    $this->agent = udm_alloc_agent($this->strProtocole."://".$this->strLogin.":".$this->strPwd."@".$this->strHost.($this->strPort!="" ? ":".$this->strPort : "")."/".$this->strDb."/?dbmode=".$this->strMode);
     
    $this->set(UDM_PARAM_SEARCH_MODE, UDM_MODE_ALL);
    //$this->set(UDM_PARAM_CHARSET, 'iso-8859-1');
    $this->set(UDM_PARAM_CHARSET, 'utf-8');
    $this->set(UDM_PARAM_BROWSER_CHARSET, 'utf-8');
    $this->set(UDM_PARAM_WORD_MATCH, UDM_MATCH_SUBSTR);    
    udm_set_agent_param_ex($this->agent, 'DateFormat','%d/%m/%Y - %H:%M'); 
    
    /*if ((! udm_load_ispell_data($this->agent, UDM_ISPELL_TYPE_AFFIX, 'fr', '/opt/ispell/fr.aff', 1))) {
	    printf("Erreur #%d: '%s'\n", udm_errno($this->agent), udm_error($this->agent));
	    exit;
		}
		$this->set(UDM_PARAM_ISPELL_PREFIXES, UDM_PREFIXES_ENABLED);*/
	  
  }

  /**
   * Destructeur  
   */
  public function __destruct() 
  {
    if( $this->res ) 
      udm_free_res($this->res);
    
    if( $this->agent ) 
    	udm_free_agent($this->agent);
    }

  /**
   * Personnalise la mise en valeur du mot recherché dans le résultat
   * @param t expression trouvée à mettre en valeur
   * @return string
   */
  private function hiLite($t) 
  {
    if( $t == '' )
        return '';
    $t = str_replace("\2", $this->hlbeg, $t);
    $t = str_replace("\3", $this->hlend, $t);
    return $t;
  }

  /**
   * Fixe la valeur d'un paramètre mnogosearch
   * Retourne true si ok, false sinon
   * @param k  paramètre
   * @param v  valeur
   * @return boolean
   */
  public function set($k, $v) 
  {
    return udm_set_agent_param($this->agent, $k, $v);
  }
  
  /**
   * Fixe la valeur d'un paramètre mnogosearch
   * Retourne true si ok, false sinon
   * @param k  paramètre
   * @param v  valeur
   * @return boolean
   */
  public function set_agent_param_ex($k, $v) 
  {
    return udm_set_agent_param_ex($this->agent, $k, $v);
  }
  
  /**
   * Ajoute une limite de recherche
   * Retourne true si ok, false sinon
   * @param k   paramètre de la limitation de la recherche, valeurs possibles: UDM_LIMIT_URL  UDM_LIMIT_TAG UDM_LIMIT_LANG UDM_LIMIT_CAT UDM_LIMIT_DATE
   * @param v   valeur du paramètre
   * @return bool
   */
  public function add_search_limit($k, $v) 
  {
    return udm_add_search_limit($this->agent, $k, $v);
  }

  /**
   * Efface les restrictions sur url
   * @return true
   */
  public function clear_search_limits() 
  {
    return udm_clear_search_limits($this->agent);
  }
  
  /**
   * Retourne la valeur d'un paramètre lié au résultat d'une recherche
   * Retourne faux si aucun résultat
   * @param v  nom du paramètre
   * @return string ou boolean
   */
  public function getResParam($v) 
  {
    if ( $this->res )
      return udm_get_res_param ($this->res,$v);
    
    return false;
  }

  /**
   * Lance la recherche 
   * Retourne le nombre d'éléments présents dans la page si > 0 
   * Retourne faux si aucun résultat
   * @param q    expressions recherchées
   * @param p    numéro de page souhaitée, commence à 0 pour la première page, =0 par défaut
   * @param rows nombre de résultats par page, =10 par défaut
   * @return int ou boolean
   */
  public function find($q, $page=0, $rows=10) 
  {
    if ($page < 0 || $rows <= 0) {
      $page = 0;
      $rows = 10;
    }

    $this->set(UDM_PARAM_PAGE_SIZE, $rows);
    $this->set(UDM_PARAM_PAGE_NUM, $page);
    $this->res = udm_find($this->agent, $q);
    if( !$this->res ) {
      return false;
    } 
    $this->total = udm_get_res_param($this->res, UDM_PARAM_FOUND);
    
    $found = udm_get_res_param($this->res, UDM_PARAM_NUM_ROWS);
    
    if( $found ) {
      $b = udm_get_res_param($this->res, UDM_PARAM_FIRST_DOC);
      $e = udm_get_res_param($this->res, UDM_PARAM_LAST_DOC);
      $rows = $e - $b + 1;

      $fields = array('urlid', 'url', 'content', 'title', 'keywords', 'desc',
                      'text', 'size', 'rating', 'modified', 'order', 'crc', 'category',
                      'lang', 'charset', 'siteid', 'pop_rank', 'originid');

      for($i=0; $i<$rows; $i++){
        for($j=0; $j<count($fields); $j++) {
            $this->matches[$i][$fields[$j]] = udm_get_res_field($this->res, $i, $j+1);
        }
        foreach($this->hilites as $hilite) {
            $this->matches[$i][$hilite] = $this->hiLite($this->matches[$i][$hilite]);
        }
      }
      
      return $rows;
    }

    return false;
  }
}

?>