<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Pattern
Module fournissant les classes de base Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");

/**
 * @package Alkanet_Class_Pattern
 * 
 * @class AlkDr
 * @brief Classe abstraite représentant un dataRow
 */
abstract class AlkDr extends AlkObject implements ArrayAccess
{
	/** Objet contenant les données du datarow */
	protected $oRow;
	
  /** Nombre de champs dans le datarow courant */
	protected $iCountField;
	
	/** Référence vers le dataSet associé */
	protected $dsParent;
	
  /**
   *  Constructeur par défaut
   * @param oRow     Objet contenant l'enregistrement provenant du dataset
   * @param dsParent Référence vers le dataset associé
   */
	public function __construct(&$dsParent)
  {
    parent::__construct();

    $this->dsParent =& $dsParent;		
	}

  /**
   *  Destructeur par défaut
   */
  public function destruct()
  {
  	unset($this->oRow);
  }

  /**
   *   Retourne la valeur du champs passé en paramètre
   *         Retourne une chaine vide si le champ n'existe pas
   *
   * @param strField          nom du champs
   * @param strDefaultValue   Valeur par défaut si le champ n'est pas trouvé dans oRow
   * @param bToUpper  vrai=force strField en majuscule (par défaut), faux=ne modifie pas strField
   * @return Retourne une chaine
   */
  public function getValueName($strField, $strDefaultValue="", $bToUpper=true)
  {
    $strRes = $strDefaultValue;
    $strEncoding = $this->dsParent->getEncoding();
    if( is_array($this->oRow) && array_key_exists($strField, $this->oRow) ) {
      $strRes = ( $strEncoding != ALK_HTML_ENCODING
                  ? mb_convert_encoding($this->oRow[$strField], ALK_HTML_ENCODING, $strEncoding)
                  : $this->oRow[$strField] );
    }
    return $strRes;
  }

  /**
   *  Retourne la valeur du champs identifiant par son numéro d'ordre dans la requete
   *
   * @param iNumField numéro du champs (indicé à 0 à n-1)
   * @return Retourne une chaine : valeur du champs
   */
  public function getValueNum($iNumField, $strDefaultValue="")
  {
    return $this->getValueName($this->dsParent->getFieldName($iNumField), $strDefaultValue);
  }
  
  /**
   *  Retourne dans un tableau la liste des champs
   *
   * @return Retoune un array
   */
  public function getFields()
  {
    return $this->dsParent->getFields();
  }

  /**
   *  Réinitialise l'objet
   */
  public function close( )
  {
    $this->oRow = array();
    $this->iCountField = 0;
  }

  /**
   *  Retourne le dataRow dans un tableau associatif avec comme clé, 
   *        les noms de colonne en majuscule
   * @return array
   */
  public function getDataRow()
  {
    $tabRes = array();
    $strEncoding = $this->dsParent->getEncoding();
    foreach($this->oRow as $strKey => $oValue) {
      $tabRes[strtoupper($strKey)] = ( $strEncoding != ALK_HTML_ENCODING
                                       ? mb_convert_encoding($oValue, ALK_HTML_ENCODING, $strEncoding)
                                       : $oValue );
    }
    return $tabRes;
  }

  /**
   *   Retourne la valeur du champs passé en paramètre en appliquant la conversion d'encodage vers toEncoding
   *         Retourne une chaine vide si le champ n'existe pas
   *
   * @param strField          nom du champs
   * @param toEncoding        Encodage de sortie du résultat
   * @param strDefaultValue   Valeur par défaut si le champ n'est pas trouvé dans oRow
   * @param bToUpper          vrai=force strField en majuscule (par défaut), faux=ne modifie pas strField
   * @return Retourne une chaine
   */
  public function getValueNameEncoded($strField, $toEncoding=ALK_EXPORT_ENCODING, $strDefaultValue="", $bToUpper=true)
  {
    return mb_convert_encoding($this->getValueName($strField, $strDefaultValue, $bToUpper), $toEncoding, ALK_HTML_ENCODING);
  }
  
  /**
   * Retourne le datarow au format json
   * 
   * @param strDrName  Le nom du DR, = vide par défaut
   * @return string
   */
  public function getJson($strDrName="")
  {
    $tabRes = array();
    $strEncoding = $this->dsParent->getEncoding();
    foreach($this->oRow as $strKey => $oValue) {
      if( !is_numeric($strKey) ) {
        $tabRes[strtolower($strKey)] = ( $strEncoding != ALK_HTML_ENCODING
                                         ? mb_convert_encoding($oValue, ALK_HTML_ENCODING, $strEncoding)
                                         : $oValue );
      }
    }
    return ( $strDrName == ""
             ? json_encode( $tabRes )
             : "{".$strDrName.":".json_encode( $tabRes )."}" );
  }
  
  /**
   * obsolete
   *  Retourne le DR résultant en JSON
   * 
   * @param strDrName  Le nom du DR
   * @return string
   */
  public function getJsonFromDr($strDrName="")
  {
    return $this->getJson($strDrName);
  }
  
  /**
   * @see ArrayAccess::offsetExists()
   * 
   * @param mixed $offset
   * @return boolean true if offset exists, false otherwise
   */
  public function offsetExists($offset)
  {
    return is_array($this->oRow) && array_key_exists($offset, $this->oRow);
  }
  
  /**
   * @see ArrayAccess::offsetGet()
   * 
   * @param mixed $offset
   * @return mixed the value at the specified offset
   */
  public function offsetGet($offset)
  {
    return $this->getValueName($offset);
  }
  
  /**
   * @see ArrayAccess::offsetSet()
   * 
   * @param mixed $offset
   * @param mixed $value
   */
  public function offsetSet($offset, $value)
  {
    trigger_error(__CLASS__." - fonction ".__FUNCTION__." non autorisée.", E_USER_ERROR);
  }
  
  /**
   * @see ArrayAccess::offsetUnset()
   * 
   * @param unknown_type $offset
   */
  public function offsetUnset($offset)
  {
    trigger_error(__CLASS__." - fonction ".__FUNCTION__." non autorisée.", E_USER_ERROR);
  }
  
}

?>