/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * Surcharge les fonctions du lib_js.js pour afficher les Popups en mode Jquery Dialog
 * 
 */

/**
 * Ferme la dernière popup ouverte
 * @param strUrlToken  url de réaffichage de l'opener. 
 *                     si la chaine ne contient pas .php, le paramètre est considéré comme un token
 *                     sur l'url alkanet.php
 *                     si la chaine = reload, un reload est effectué sur l'opener
 */
function removePopup(strUrlToken)
{ 
  var bClose = false;
  
  if ( window!=top ){
    bClose = top.removePopup(strUrlToken);
    return bClose;
  }
  var iLevel = top.iLevelAlkPopup;
  if ( top.jQuery("#alkIFrameNiv"+iLevel.toString()).length > 0 ) {
    top.jQuery("#alkIFrameNiv"+iLevel.toString()).data("strUrlToken", strUrlToken);
    top.jQuery("#alkIFrameNiv"+iLevel.toString()).dialog('close'); // la popup n'est pas détruite mais uniquement masquée => exécution de l'événement "close"
    bClose = true;
  }
  
  return bClose;
}

/**
 * @brief Ferme toute les popup ouvertes
 */
function removeAllPopup()
{
  var bClose = false;
  
  for(iLevel=1; iLevel<=top.iLevelAlkPopup; iLevel++) {
    if ( top.jQuery("#alkIFrameNiv"+iLevel.toString()).length > 0 ) {
      top.jQuery('#'+"alkIFrameNiv"+iLevel.toString()).dialog('close');
      bClose = true;
    }
  }
  
  // réinitialise le numéro de la dernière page ouverte
  top.iLevelAlkPopup = 0;   
     
  return bClose;
}

/**
 * @brief fonction appelée à la fermeture d'une popup
 * @param strUrlToken  url de réaffichage de l'opener. 
 *                     si la chaine ne contient pas .php, le paramètre est considéré comme un token
 *                     sur l'url alkanet.php
 *                     si la chaine = reload, un reload est effectué sur l'opener
 */
function popupClosed(strUrlToken)
{
  if ( window!=top ){
    top.popupClosed();
    return;
  }
  
  // décrémente le numéro de la dernière page ouverte
  top.iLevelAlkPopup = top.iLevelAlkPopup - 1;
  
  // réaffichage de l'opener
  if( typeof(strUrlToken)!="undefined" && strUrlToken != "" ) {
    var iLevelOpener = top.iLevelAlkPopup;
    var oOpenerIFrame = top.window;
    if( iLevelOpener >= 1 ) {
      oOpenerIFrame = top.document.getElementById("alkIFrameNiv"+iLevelOpener.toString());
    }

    // le paramètre &r=1 est présent pour éviter l'utilisation du cache navigateur
    if( strUrlToken == "reload" ) {
      if( oOpenerIFrame==top.window ) {
        oOpenerIFrame.location.reload();
      } else {
        oOpenerIFrame.contentWindow.location.reload();
      }
    } else {
      var strUrl = ( strUrlToken.indexOf(".php")>-1 
                     ? strUrlToken+(strUrlToken.substr(-4)==".php" ? "?" : "&")+"r=1"
                     : ( isToken(strUrlToken)
                         ? ALK_ALKANET+"?token="+strUrlToken+"&r=1"
                         : strUrlToken ));
      if( oOpenerIFrame==top.window ) {
        oOpenerIFrame.location = strUrl;
      } else {
        oOpenerIFrame.src = strUrl;
      }
    }
  }
}

/**
 * @brief Simule l'ouverture d'une fenêtre popup dans un layer et iframe combinés
 * @param strUrl  url de iframe
 * @param iHeight hauteur de l'iframe
 * @param iWidth  largeur de l'iframe
 * @param strName Nom de l'iFrame
 * @return Une référence sur l'iframe ouverte
 */
function OpenWindow(strUrl, iHeight, iWidth, strName, oOpener)
{
  if ( window!=top ){
    return top.OpenWindow(strUrl, iHeight, iWidth, strName, window);
  }
  if( top.iLevelAlkPopup > 4 ) {
    alert("Conception à revoir. Trop de popup.");
    return null;
  }
  
  var oWind = top;
  top.iLevelAlkPopup = top.iLevelAlkPopup + 1;
  var iFrameId = "alkIFrameNiv"+top.iLevelAlkPopup.toString();
  var iFrameName = ( !strName ? iFrameId : strName );
  oOpener = oOpener || window;//GetWindowByNiv(top.iLevelAlkPopup-1);
  AddWindOpener(iFrameName, oOpener);
  
  var width = parseInt(iWidth)+20;
  var height = parseInt(iHeight)+20;
  
  /* si la popup existe => set URL et ouverture */
  if ( top.jQuery('#'+iFrameId).length > 0 ) {
    top.jQuery('#'+iFrameId)[0].contentWindow.name = iFrameName;  // renommage du name du contentWindow nécessaire pour que les submits vers la popup fonctionnent
    top.jQuery('#'+iFrameId)
      .dialog("option", "width", width)
      .dialog("option", "minWidth", width)
      .dialog("option", "height", height)
      .dialog("option", "title", "")
      .dialog("option", "position", { my: "center top", at: "center top+10", of: window })
      .attr('name', iFrameName)
      .attr('src', strUrl)
      .removeClass('full')
      .dialog('open');
  }
  /* si la popup n'existe pas => création */
  else {
    top.jQuery('<iframe id="'+iFrameId+'" name="'+iFrameName+'" src="' + strUrl + '" frameborder="0"/>').dialog({
      width: width,
      minWidth: width,
      height: height,
      position: { my: "center top", at: "center top+10", of: window},
      modal: true,
      stack: true,
      zIndex : 20000,
      overlay : {
        overflow:"hidden"
      },
      open : function(event, ui){
        var onload = function(){
          this.strTokenClose = "";
          try {
            var tthis = top.jQuery(this);
            var oDivTitle = oDivbClose = null;
            if ( this.contentDocument ) { // DOM
              var oDivTitle = this.contentDocument.getElementById("alkPopupTitle");
              var oDivbClose = this.contentDocument.getElementById("alkPopupBtClose");
            } else if ( typeof this.contentWindow != "undefined" && typeof this.contentWindow.document != "undefined" ) { // IE win
              var oDivTitle = this.contentWindow.document.getElementById("alkPopupTitle");
              var oDivbClose = this.contentWindow.document.getElementById("alkPopupBtClose");
            }
            var strDivTitle = ( oDivTitle ? oDivTitle.innerHTML : "" );
            this.strTokenClose = ( oDivbClose ? oDivbClose.innerHTML : "" );
            tthis.dialog("option", "title", strDivTitle);
          } catch(ex){}
        };
        
        if( typeof(this.onreadystatechange) == "undefined" ) {
          this.onload = onload;
        } else {
          this.onreadystatechange = onload;
        }
      },
      close: function(event, ui){   // appelé sur le clic de X ou à l'appel de dialog('close')
        if( typeof(this.onreadystatechange) == "undefined" ) {
          this.onload = null;
        } else {
          this.onreadystatechange = null;
        }
        this.src = "";  // réinitialise l'URL à vide pour éviter qu'à la prochaine ouverture de la popup apparaissent l'ancien contenu
        top.popupClosed(typeof top.jQuery(this).data("strUrlToken") != "undefined" && top.jQuery(this).data("strUrlToken") != "" ? top.jQuery(this).data("strUrlToken") : this.strTokenClose);
        top.jQuery(this).data("strUrlToken", ""); // réinitialise le token de retour pour la prochaine ouverture
      }
  	});
  }
  
  var dialog = top.jQuery('#'+iFrameId).dialog();
  dialog.parent().height('auto');
  dialog.parent().css({'position' : 'fixed'});
  var titlebar = dialog.parents('.ui-dialog').find('.ui-dialog-titlebar');
  top.jQuery('<a href="#" class="ui-dialog-titlebar-close ui-dialog-titlebar-expend ui-corner-all" role="button"><span class="ui-icon ui-icon-arrow-4-diag">Fullsize</span></a>')
    .appendTo(titlebar)
    .click(function() {
      
      var wWidth = top.jQuery(window).width();
      var dWidth = wWidth * 0.95;
      var wHeight = top.jQuery(window).height();
      var dHeight = wHeight * 0.90;
      var dHeight2 = wHeight * 0.90;
      
      if(!dialog.hasClass('full')){
        dialog.addClass('full');
        top.jQuery(this).attr( 'currHeight', dialog.parent().height());
        top.jQuery(this).attr( 'currHeight2', dialog.height());
        top.jQuery(this).attr( 'currWidth', dialog.parent().width());
        dialog.dialog( "option", "draggable", false );
        dialog.dialog( "option", "resizable", false );
      }else{
        dialog.removeClass('full');
        dWidth = top.jQuery(this).attr('currWidth')+'px';
        dHeight = top.jQuery(this).attr('currHeight')+'px';
        dHeight2 = top.jQuery(this).attr('currHeight2')+'px';
        dialog.dialog( "option", "draggable", true );
        dialog.dialog( "option", "resizable", true );
      }
      dialog.parent().height(dHeight);
      dialog.height(dHeight2);
      dialog.parent().height('auto');
      dialog.parent().width(dWidth);
      dialog.dialog( "option", "position", { my: "center", at: "center", of: window } );
      dialog.parent().css({'position' : 'fixed'});
    }
  ).hover(
    function() {
       top.jQuery(this).addClass('ui-state-hover');
    },
    function() {
       top.jQuery(this).removeClass('ui-state-hover');
    }).css('right', '2em');
    
    top.jQuery(window).resize(function() {
      var button = dialog.parents('.ui-dialog').find('.ui-dialog-titlebar').find('.ui-dialog-titlebar-expend');
      if(dialog.hasClass('full')){
        var wWidth = top.jQuery(window).width();
        var dWidth = wWidth * 0.95;
        var wHeight = top.jQuery(window).height();
        var dHeight = wHeight * 0.90;
        
        dialog.parent().height(dHeight);
        dialog.height(dHeight);
        dialog.parent().height('auto');
        dialog.parent().width(dWidth);
        dialog.dialog( "option", "position", { my: "center", at: "center", of: window } );
        dialog.parent().css({'position' : 'fixed'});
      }
    });
  
  return top.jQuery('#'+iFrameId)[0].contentWindow;   
}


