function loadRss(channelName, idDivRss, rssTitle, bDetail, bDate)
{
  var iArg = 5;
  var urlEdit="";
  var urlDelete="";
  if (arguments.length>iArg) urlEdit = arguments[iArg++];
  if (arguments.length>iArg) urlDelete = arguments[iArg++];
  
  var divRss = document.getElementById(idDivRss);
  var oCtrlEdit = document.getElementById('idFieldSetEdit');
  var oCtrlLegendEdit = document.getElementById('idLegendEdit');

  // try to read the requested feed in channel
  if(window.getChannelRss) {
    var channel = getChannelRss(channelName);
  } else {
    // function getChannelRss does not exists
    // which means that the rss feed is not readable
    var channel = null;
  }
  
  var strInnerHTML = "<div class=\"rss-content\">";
  
  //strInnerHTML = getHtmlRss(channelName);
  //divRss.innerHTML = strInnerHTML;
  //return;
  
  if( channel ) {
    strTitle = "<div class='rss-title'>"+
      ( channel.logo.url!="" 
        ? "<a href=\""+channel.logo.link+"\" title=\""+channel.logo.title+"\"><img src=\""+channel.logo.url+"\"/></a>" 
        : "<img src=\""+ALK_ALKANET_ROOT_URL+"media/images/icon_doc_rss.gif\"/>")+
      channel.title + 
      ( urlEdit !="" ? urlEdit :"" ) + 
      ( urlDelete !="" ? urlDelete :"" ) +
     "</div>";
    strInnerHTML += strTitle;
  
    if( channel.items.length>0 ) {
      for (var i=0; i<channel.items.length; i++) {
        var strDesc = new String(channel.items[i].description);
        var strDescShort = 
                           ( channel.items[i].link != "" && channel.items[i].link != "#" 
                             ? "<a target=\"_blank\" href=\""+channel.items[i].link+"\">"+channel.items[i].title+"</a>"
                             : channel.items[i].title );
        var strDescLong = strDesc.replace(/<img[^\/]*\/>/, '');
        
        var strHtmlPj = "";
        var strHtmlImg = "";
        var nbPj = 0;
        if( channel.items[i].enclosures.length>0 ) {
          
          for (var j=0; j<channel.items[i].enclosures.length; j++) {
            if( strHtmlImg == "" && channel.items[i].enclosures[j].isImg ) {
              strHtmlImg = "<img src=\""+channel.items[i].enclosures[j].link+"\" border=\"0\" align=\"left\"/>";
            } else {
              nbPj++;
              strHtmlPj += ( strHtmlPj!="" ? ", " : "" ) + 
                "<a class=\"rss-item-pj\" target=\"_blank\" href=\""+channel.items[i].enclosures[j].link+"\">"+
                channel.items[i].enclosures[j].title+"</a>";
            }
          }
        }
        if( strHtmlPj != "" ) {
          strHtmlPj = "<div class=\"rss-item-pj\">"+
            _ngtf("Pi&egrave;ce jointe :", "Pi&egrave;ces jointes :", nbPj) + " "+strHtmlPj +
            "</div>";
        }
        strInnerHTML += "<div class=\"rss-item\">"+
          ( bDetail 
            ? "<div class=\"rss-item-img\">"+strHtmlImg+"</div>" 
            : "") +
          "<div class=\"rss-item-title\">&raquo;&nbsp;"+strDescShort+
          ( bDate 
            ? "&nbsp;&nbsp;<span class=\"rss-item-date\">"+channel.items[i].pubDate+"</span>" 
            : "")+
          "</div>"+
          ( bDetail 
            ? "<div class=\"rss-item-detail\">"+strDescLong+strHtmlPj+"</div>" 
            : "") +
          "</div>"+
          "<div class=\"rss-footer\"></div>";
      }
    } else {
     var msg = ( rssTitle!=""
                 ? _gtf("%s : aucun flux RSS disponible.", rssTitle)
                 : _gt("Aucun flux RSS disponible.") );
     strInnerHTML += "<span class='rss-msg'>"+msg+"</span>";
    } // fin if( channel.items.length>0 )
  
  } else {
    var msg = ( rssTitle!="" 
                ? _gtf("%s : ce flux rss ne semble pas valide ou est actuellement indisponible.", rssTitle)
                : _gt("Le flux rss ne semble pas valide ou est actuellement indisponible.") );
    strInnerHTML += "<span class='rss-msg'>"+msg+"</span>";
  } // fin if( channel )
  
  strInnerHTML += "</div>";
  // affectuer le contenu au div RSS
  divRss.innerHTML = strInnerHTML;
}
