<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


/** 
 * @file lib_session_cli.php
 * @package Alkanet_Library
 * @brief Charge les fichiers de définition de constantes en mode client
 */

// pas de session disponible en mode client

ini_set("display_errors", "on");
error_reporting(E_ALL);

/** Chargement des fichiers de config */
require_once("../../libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/lib_locales.php");
require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."app_conf_sig.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");

// Initialise la prise en change de la langue et de la locale courante
initAlkLocale();

/**
 * @brief Controle de sécurité
 */

/** $tabFileSession est déclaré dans app_conf_alkanet.php */

/** 
 * Pour s'assurer qu'on est en PHP_CLI, on vérifie l'existance des paramètres argc/argv normalement toujours et uniquement disponible dans ce mode
 */
ini_set('register_argc_argv', 0);
if( PHP_SAPI != "cli" ) {
  echo "Erreur : il faut appeler lib_session.php.";
  exit();
}

$PHP_SELF = $_SERVER["PHP_SELF"];
$strPageCur = substr($PHP_SELF, 1); // enleve le premier caractère = /

$bUserInternetExists = !( !defined("ALK_B_USER_INTERNET_EXISTS") || 
                          defined("ALK_B_USER_INTERNET_EXISTS") && !ALK_B_USER_INTERNET_EXISTS );

/** Chargement des classes de bases */
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");
require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkmailing.class.php";
if( strpos($strPageCur, "/alkanet_sql.php")===false ) {
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlfactory.class.php");
} 
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");

/**
 * Chargement des paramètres dans les tableaux $_REQUEST et $_GET
 */
if (isset($argc)){
  for($i=1; $i<$argc; $i++) {
    $matches = array();
    preg_match_all("!([^=]*)\s*=\s*\"?(.*)\"?!", $argv[$i], $matches);
    if(array_key_exists(0, $matches[1]) && strlen(trim($matches[1][0]))>0) {
      $key    = trim($matches[1][0]);
      $value  = str_replace("\"", "", trim($matches[2][0]));
      
      $_GET[$key]     = $value;
      $_REQUEST[$key] = $value;
    }
  }
}
/** Chargement ensuite du lib_global et du app_conf_sgbd : 
 *   - chargement des constantes générales + espace + annu + celles de l'appli utilisée 
 */
AlkRequest::readToken();

AlkFactory::setSProperty("user_id",    AlkRequest::getToken("user_id", ALK_USER_ID_INTERNET));
AlkFactory::setSProperty("profil_id",  AlkRequest::getToken("profil_id", "-1"));
AlkFactory::setSProperty("service_id", AlkRequest::getToken("service_id", "-1"));
AlkFactory::setSProperty("dept_id",    AlkRequest::getToken("dept_id", "-1"));
AlkFactory::setSProperty("service_name",  AlkRequest::getToken("service_name", ""));
AlkFactory::setSProperty("service_sigle", AlkRequest::getToken("service_sigle", ""));
AlkFactory::setSProperty("user_priv",  AlkRequest::getToken("user_priv", ALK_PRIV_SPACE_ADMIN));
AlkFactory::setSProperty("user_right", AlkRequest::getToken("user_right", ALK_APPLI_RIGHT_ADMIN));
AlkFactory::setSProperty("user_login", AlkRequest::getToken("user_login", ""));
AlkFactory::setSProperty("user_pwd",   AlkRequest::getToken("user_pwd", ""));
AlkFactory::setSProperty("user_name",  AlkRequest::getToken("user_name", ""));
AlkFactory::setSProperty("user_mail",  AlkRequest::getToken("user_mail", ""));
AlkFactory::setSProperty("user_home",  AlkRequest::getToken("user_home", ""));
AlkFactory::setSProperty("perf_id",    AlkRequest::getToken("perf_id", ""));

AlkFactory::setSProperty("bInternet",  false );
                                        
?>