<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Projet Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH."libconf/alkhtmlpagealk.class.php");


/**
 * @Class AlkHtmlPageDownload
 * @package Alkanet_Appli
 * @brief Classe permettant le téléchargement ou l'ouverture d'une ou plusieurs pièces jointes
 */
class AlkHtmlPageDownload extends AlkHtmlPageAlk
{
  /** Mode de chargement de pj : default, media, download_all, open_all */  
  protected $iMode;
  
  protected $cont_id;
  protected $tableName;
  protected $data_id;
  protected $pj_id;
  protected $user_id;
  
  protected $oDs;
  
  /**
   * @brief constructeur
   */
  public function __construct(&$oSpace, &$oAppli)
  {
    parent::__construct($oSpace, $oAppli);
  }

  /**
   * @brief Retourne le code html de la fin de page html
   * @return string
   */
  protected function initBody()
  {
    $this->iMode = AlkRequest::getToken("iMode", ALK_DOWNLOAD_MODE_DEFAULT);
    $this->cont_id = AlkRequest::getToken("cont_id", -1);
    $this->data_id = AlkRequest::getToken("data_id", -1);
    $this->tableName = AlkRequest::getToken("tableName", "");
    $this->pj_id = AlkRequest::getToken("pj_id", -1);
    $this->user_id = AlkFactory::getSProperty("user_id", -1);
    
    if ( !(  $this->data_id!="-1" && ($this->iMode>ALK_DOWNLOAD_MODE_MEDIA || $this->pj_id!="-1") && $this->user_id!="-1") ) 
      return false;
    
    if ( $this->iMode<=ALK_DOWNLOAD_MODE_MEDIA ){
      $this->oDs = $this->oAppli->oQuery->getDsPjForDownload($this->tableName, $this->user_id, $this->pj_id);
    }
    else {
      $this->oDs = $this->oAppli->oQuery->getDsListePJ($this->tableName, $this->data_id);
    }
    
    return true;
  }
  
  /**
   * @brief Retourne le code html de cette page
   * @return string html
   */
  public function getHtml()
  {
    if ( !$this->initBody() ) return "";

    $strHtml = "";
    
    $strDirCont = "";
    if ( file_exists(AlkFactory::getUploadPath($this->oAppli->atype_id).$this->cont_id) && is_dir(AlkFactory::getUploadPath($this->oAppli->atype_id).$this->cont_id) ){
      $strDirCont = $this->cont_id."/";
    }
    // Traitement d'un fichier 
    if ( $this->iMode<=ALK_DOWNLOAD_MODE_MEDIA ){
      $droit_id = 0;
      $strFileName = "";
      $strFileNameAff = "";
      
      // vérifie les droits sur le document
      if( $oDr = $this->oDs->getRowIter() ) {
        $droit_id = $oDr->getValueName("DROIT_ID");
        $strFileName = $oDr->getValueName("FILENAME");
        $strFileNameAff = $oDr->getValueName("FILENAME_AFF");
      }
      
      if( $droit_id == 0 ) {
        $this->addJs(" alert(\"Vous n'avez pas le droit de télécharger ce fichier.\");".
          " removePopup();");
        return parent::getHtml();
      }
        
      $strPathFileName = AlkFactory::getUploadPath($this->oAppli->atype_id).$strDirCont.$strFileName;
      $strUrlFileName = AlkFactory::getUploadUrl($this->oAppli->atype_id).$strDirCont.$strFileName;
      $bOk = false;
      
      $oRes = null;
      // Téléchargement d'un fichier non média
      if ( $this->iMode==ALK_DOWNLOAD_MODE_DEFAULT ){
        if( file_exists($strPathFileName) && is_file($strPathFileName) ) {
          // lecture du fichier
          AffHeaderFileDownload($strPathFileName, $strFileNameAff);
          $oRes = readfile($strPathFileName);
        }
      }
      
      // Téléchargement d'un fichier média
      else { 
        if (isFileMultimedia($strPathFileName)){
          $oRes = null;
          $this->oTemplate->assign("mainTitle", "Lecture d'un fichier multimédia");
          $this->oTemplate->assign("contents", getHtmlRunMedia($oRes, $strUrlFileName));
          $this->oTemplate->assign("tokenClose", "reload");  
          $this->oTemplate->assign("popupCanClose", 1);  
          $this->oTemplate->assign("popupAddTitle", 1);  
          
          $strHtml .= parent::getHtmlHeader();
          $strHtml .= $this->oTemplate->fetch($this->strTemplateFile);
          $strHtml .= parent::getHtmlFooter();
          
        }
      }
      
      $bOk = (is_bool($oRes) ? false : true);
      if( $bOk == true ) {
        $this->oAppli->oQueryAction->LogDownloadPj($this->pj_id, $this->user_id);
        return $strHtml; 
      }  
      $this->addJs(" alert(\"Impossible de lire le fichier ou celui-ci n'existe pas.\");".
        " removePopup();");
      return parent::getHtml();
    }
    // Traitement de toutes les pj d'une donnée
    else {
      $strFileNameZip = "allpj_".$this->data_id.".zip";
      $strFileName = $this->user_id."_".$strFileNameZip;
      $strPathFileZip = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.ALK_UPLOAD_CACHE.$strFileName;
      require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alkzip.class.php");
      $oZip = new AlkZipFile($strPathFileZip);
      $nbFile = 0;
      while ( $oDr = $this->oDs->getRowIter() ){
        $strFileName = $oDr->getValueName("FILENAME");
        $strFileNameAff = $oDr->getValueName("FILENAME_AFF");
        $pj_id = $oDr->getValueName("ID");
        $strPathFileName = AlkFactory::getUploadPath($this->oAppli->atype_id).$strDirCont.$strFileName;
        if ( file_exists($strPathFileName) ){
          $this->oAppli->oQueryAction->LogDownloadPj($pj_id, $this->user_id);
          $oZip->addFile($strPathFileName, $strFileNameAff);
          $nbFile++;
        }
      }
      
      if ( $nbFile==0 ){
        echo getBodyOnLoadExec("alert(\"Impossible de lire les fichiers ou ceux-ci n'existent pas.\");");
      }
      else {
        $oZip->close();
        AffHeaderFileDownload($strPathFileZip, $strFileNameZip);
        readfile($strPathFileZip);
        exit();
      }
    }
  }
}
?>