
OpenLayers.Control.Click = OpenLayers.Class(OpenLayers.Control, {                
    defaultHandlerOptions: {
        'single': true,
        'double': false,
        'pixelTolerance': 0,
        'stopSingle': false,
        'stopDouble': false
    },
    initialize: function(options) {
        this.handlerOptions = OpenLayers.Util.extend(
            {}, this.defaultHandlerOptions
        );
        OpenLayers.Control.prototype.initialize.apply(
            this, arguments
        ); 
        this.handler = new OpenLayers.Handler.Click(
            this, {
                'click': this.trigger
            }, this.handlerOptions
        );
    }, 
    trigger: function(e) {
        var lonlat = map.getLonLatFromPixel(e.xy);
        var strParam = "?iMode=1&coord_x="+lonlat.lon+"&coord_y="+lonlat.lat;
        var oAjax = new AlkAjax('getGeomCommune', 'fnDisplayClick', ALK_FORM_METHOD_GET, 
                                '/libconf/lib/lib_carte.php'+strParam, null);
    }
});

var boxControl = new OpenLayers.Control();
OpenLayers.Util.extend(boxControl, {
    draw: function () {
        this.box = new OpenLayers.Handler.RegularPolygon( boxControl,
            {"done": this.trigger},
            {keyMask: OpenLayers.Handler.MOD_SHIFT,sides:4, irregular:true, persist:true});
        this.box.activate();
    },
    trigger: function (bounds) {
    	 var strParam = "?iMode=2&box="+bounds.toString();
    	 var oAjax = new AlkAjax('getGeomCommune', 'fnDisplayClick', ALK_FORM_METHOD_GET, 
                 '/libconf/lib/lib_carte.php'+strParam, null);
    }
});

var map, layer,controls, layerClick;
//var selectFeature;

/**
 * Affiche la ville correspondant au clic
 * @param data
 */
function fnDisplayClick(data){
	result = eval("("+data+")");
	if(document.getElementById("search_commune_id")!=null){
	  layerClick.removeAllFeatures();	
	}
	for (var i=0; i<result.data_com.length; i++){
	    if(document.getElementById("search_commune_id")!=null){
		  document.getElementById("search_commune_id").value = result.data_com[i][1];
	    }
	    wkt = new OpenLayers.Format.WKT();
		var feature = wkt.read(result.data_com[i][2]);
		feature.fid = result.data_com[i][0];
		if(layerClick.getFeatureByFid(feature.fid)!=null){
		  layerClick.removeFeatures([layerClick.getFeatureByFid(feature.fid)]);
		  jQuery('#com_id_0').sortOptions().find('option').each(function(){
	        if ($(this).attr('value') == feature.fid ) $(this).remove();  
	      });
		}else{
		  layerClick.addFeatures([feature]);
		  if(document.getElementById('com_id_0')!=null){
			  var tabRes = result.data_com;
	    	  var oCtrlP = oDivP = document.getElementById("com_id_0");   
	    	  updateComboFromTabAlkAjax(oCtrlP, tabRes, false, false, true);
	    	  //à quoi ça sert ?
	    	  jQuery('#com_id_0').sortOptions().find('option').each(function(){
	    		if ( jQuery('#com_id_0 option[value="'+$(this).attr('value')+'"]').length > 1 ) $(this).remove();  
	    	  });
	    	  compteurComm();
	    	  selectAllComm();
		  }
		}
		
	}
	
}

function init(mapSearch){
	var options = {
		  projection: "EPSG:2154",
		 // layers: [new OpenLayers.Layer.OSM("Simple OSM Map")],
          layers : [new OpenLayers.Layer.WMS( "FdP",config_wms, {layers: config_layer_wms, version: '1.3.0', srs:'EPSG:2154'} )],
//		  center: new OpenLayers.LonLat(468911, 6679263), 
          center: new OpenLayers.LonLat(449743, 6890804), 
		  zoom: 3,
		  numZoomLevels:9,
//		  maxExtent: new OpenLayers.Bounds(242855,6454275,585079,6787393),
		  maxExtent: new OpenLayers.Bounds(-166444, 6357596, 1233881, 7137865),
	    //restrictedExtent: new OpenLayers.Bounds(-1.80, 48.00, 1.40, 50.00).transform('EPSG:4326', 'EPSG:3857'),
		  units: "m"
	  };
	 map = new OpenLayers.Map("map", options);
	 var click = new OpenLayers.Control.Click({
	        'single': true,
	        'pixelTolerance': 0
	    });
     map.addControl(click);
     click.activate();
     if(mapSearch==0)
	   map.addControl(boxControl);
	 //boxControl.activate();
/*	 selectFeature = new OpenLayers.Control.SelectFeature(layerClick, {
		    hover: false 
		    ,clickout: true
		    ,multiple : true, hover: false
		    ,toggleKey : "ctrlKey" // ctrl key removes from selection
		    ,multipleKey : "shiftKey" // shift key adds to selection
		    ,box: false
		  });
*/
     var layer_style = OpenLayers.Util.extend({}, OpenLayers.Feature.Vector.style['default']);
     layer_style.fillOpacity = 0.2;
     layer_style.strokeColor= '#ff0000';
     layer_style.fillColor= '#ff0000';
     layer_style.graphicOpacity = 1;
     
     layerClick =  new OpenLayers.Layer.Vector("Communes", {
         style: layer_style
     });
     map.addLayer(layerClick);
     
     if(typeof(initFeature)!="undefined"){
       wkt = new OpenLayers.Format.WKT();
       var feature = wkt.read(initFeature);
       feature.fid = -1;
       layerClick.addFeatures([feature]);
     }

}