<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


///<comment>
///<summary>
/// Ajoute un nombre number d'interval interval à une date date
///</summary>
///<params name="interval">
// 	yyyy	année
// 	q			Trimestre
// 	m			Mois
// 	y			jour de l'année
// 	d			jour
// 	w			jour de la semaine
// 	ww    Semaine de l'année
// 	h			Heure
// 	n			Minute
// 	s			seconde
///</params>
///<params name="number" option>
/// Nombre d'interval à ajouter à la date
///</params>
///<params name="date" option>
/// Date de référence
///</params>
///<returns>
/// une date de type timestamp
///</returns>
///</comment>


function DateAdd ($interval,  $number, $date) {

	$date_time_array  = getdate($date);
	
	$hours =  $date_time_array["hours"];
	$minutes =  $date_time_array["minutes"];
	$seconds =  $date_time_array["seconds"];
	$month =  $date_time_array["mon"];
	$day =  $date_time_array["mday"];
	$year =  $date_time_array["year"];
	
	switch ($interval)
	{
	  case "yyyy":
	    $year +=$number;
	    break;        
	  case "q":
			$year +=($number*3);
			break;        
	  case "m":
			$month +=$number;
			break;        
	  case "y":
	  case "d":
	  case "w":
			$day+=$number;
			break;        
	  case "ww":
			$day+=($number*7);
			break;        
	  case "h":
			$hours+=$number;
			break;        
	  case "n":
			$minutes+=$number;
			break;        
	  case "s":
			$seconds+=$number;
			break;        
	}
	
	$timestamp =  mktime($hours ,$minutes, $seconds,$month ,$day, $year);
	return $timestamp;
}

///<comment>
///<summary>
/// Convertit un jour ou un mois en français
///</summary>
///<params name="bMode"">
//  0     jour
//  1     mois
///</params>
///<params name="iValue">
/// Valeur à traduire
///</params>
///<returns>
/// la valeur traduite
///</returns>
///</comment>
function ConvertDateToFrench($bMode, $iValue)
{
   $tabJour = array ( 1=>"Lundi",
                      2=>"Mardi",
                      3=>"Mercredi",
                      4=>"Jeudi",
                      5=>"Vendredi",
                      6=>"Samedi",
                      7=>"Dimanche");
                      
   $tabMois = array ( 1=>"janvier",
                      2=>"f&eacute;vrier",
                      3=>"mars",
                      4=>"avril",
                      5=>"mai",
                      6=>"juin",
                      7=>"juillet",
                      8=>"aout",
                      9=>"septembre",
                      10=>"octobre",
                      11=>"novembre",
                      12=>"d&eacute;cembre");

   if ( $bMode==1 )
   {
    if ($iValue>0 && $iValue<13)
      return ($tabMois[$iValue]);
   }
   else
   {
    if ($iValue>0 && $iValue<8)
      return($tabJour[$iValue]);
   }
                      
}
?>