<?php 
/**
 * Script de génération automatique de l'aide SIT en LaTeX/PDF
 */
error_reporting(E_ALL);
include_once("lib/lib_session.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkxml.class.php");

$doGenerate = isset($_POST["doGenerate"]) ? $_POST["doGenerate"] : 0;

/** CONFIG */
$admin_dir  = dirname(__FILE__)."/";
$tex_dir    = $admin_dir."tex/";
$tmp_dir    = $tex_dir."tmp/";
$styles_dir = $admin_dir.ALK_ROOT_STYLE;
$script_dir = dirname($admin_dir)."/";
$sit_dir    = dirname($script_dir)."/";
$scripts_dir_name = ALK_ROOT_MODULE;
$start_dir_name   = "alkanet";
$tab_unparsed     = array();
$html_file_ext    = ".htm"; 
$img_file_ext     = ".PNG";

$fileHelpCss = "../../../styles/help.css";
$pathHelpCss = $sit_dir.ALK_ROOT_STYLE."help.css";

$tabChar = array("à", "â", "ç", "è", "é", "ê", "ë", "î", "ï", "ô", "€", "ù", "\"", "&", "<", ">", "'", " ");
$tabISO  = array("&#224;", "&#226;", "&#231;", "&#233;", "&#234;", "&#235;", "&#238;", "&#239;", "&#244;", "&#128;", "&#249;", "&#34;", "&#139;", "&#155;", "&#180;", "&#160;");
$tabHTML = array("&agrave;", "&acirc;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&icirc;", "&iuml;", "&ocirc;", "&euro;", "&ugrave;", "&quote;", "&amp;", "&lt;", "&gt;", "&acute;", "&nbsp;");
/** CONFIG */

$enable_pdf_img = false;
$enable_all_png = false;
$enable_8bit_png = false;

$sel_all_default = ""; // 'checked' ou ''

// store errors or any output
$errors = array();

if($doGenerate) {

$enable_all_png = isset($_POST['all_png']) ? $_POST['all_png'] : $enable_8bit_png;
$enable_8bit_png = isset($_POST['depth_png']) ? $_POST['depth_png'] : $enable_8bit_png;
  
// load modules paths
//$modules = readModules($script_dir);

// load modules paths from POST data
foreach($_POST as $key=>$value) {
  if(preg_match("!^cb_.*$!", $key)) {
    $modules[str_replace("cb_", "", $key)] = $value;
  }
}
if(empty($modules)) die("nothing to do.");

// parse all modules
foreach($modules as $name=>$path) {
  
  $help_dir = $path."help/";
  $dh = @opendir($help_dir);
  if($dh !== false) {
  
    while(($file = @readdir($dh)) !== false) {
      $filepath = $help_dir.$file;
      if($file=="." || $file==".." || strtoupper($file)=="CVS" || strtoupper($file)=="VIDE") continue;

      // ------ IMAGE PROCESSING -------
      if($enable_8bit_png) {
        // convert all images (PNG) to 8bit 256 colors PNG images
        if($enable_all_png || strpos(strtolower($file), strtolower($img_file_ext))!==false) {
          $no_ext = preg_replace("!^(.*)\.[a-zA-Z]{3,4}$!", "\\1", $file);
          exec("cd $help_dir; convert $file -colors 256 -depth 8 $no_ext$img_file_ext");
          $errors[] = "INFO : $help_dir - $file converted to 8bit 256 colors $no_ext$img_file_ext";
        }
      }
      if($enable_pdf_img) {
        // convert all images (PNG) to PDF files
        if(strpos(strtolower($file), strtolower($img_file_ext))!==false) {
          $no_ext = preg_replace("!^(.*)\.[a-zA-Z]{3,4}$!", "\\1", $file);
          exec("cd $help_dir; convert -antialias $file $no_ext.pdf");
          $errors[] = "INFO : $help_dir - $file converted to $no_ext.pdf";
        }
      }
      // ------ IMAGE PROCESSING -------
      
      // skip non html files
      if(strpos($file, $html_file_ext)===false) continue;

      // ok, try to clean this HTML file
      $ret = cleanHtml($filepath);
      
    }
  
    closedir($dh);
  } else {
    $errors[] = "INFO : Can't open $script_dir - skipped !";
  }
  
}

// get the pdf output for download
echo "<p>Done !</p>";

// last but not least, display output info & errors
echo "<p>";
foreach($errors as $line) {
  echo $line."<br>";
}
echo "</p>";

} else {

  // load modules paths
  $modules = readModules($script_dir);
  
  ?>
  <html>
  <head><title>Nettoyage des fichiers HTML de la documentation SIT</title>
  <link rel='stylesheet' href='styles/sit.css' type='text/css'/>
  <script type='text/javascript'>
    <!--
    function selAll(oCheck) {
      var f = document.forms[0];
      for(var i=0; i<f.elements.length; i++) {
        if(f.elements[i].name.match(/^cb_.*$/)) {
          f.elements[i].checked = oCheck.checked;
        }
      }
    }
    -->
  </script>
  </head>
  <body style='padding:10px;'>
    <form name="formGenerate" action="<?php echo $_SERVER["PHP_SELF"]?>" method="POST" target="generate">
      <h3>Script de nettoyage des fichiers HTML de la documentation SIT</h3>
      <p>Warning : (tous) les fichiers sources de l'aide HTML (de votre devperso) seront modifiés.<br>
      Il faudra penser à les commiter dans le CVS <b>après vérification</b>.</p>
      <p>Traitement des images :<br>
      <table>
      <tr><td valign='middle'>
      <input type='checkbox' class='formCtrl' name='all_png' value='1' onclick='document.forms[0].depth_png.checked=(this.checked ? true : document.forms[0].depth_png.checked)'/>
      <span class='formLabel'>forcer la convertion des images non PNG au format PNG</span>
      </td></tr>
      <tr><td valign='middle'>
      <input type='checkbox' class='formCtrl' name='depth_png' value='1'/>
      <span class='formLabel'>forcer la convertion des images PNG au format PNG 8bit 256 couleurs</span>
      </td></tr>
      </table></p>
      <p>Sélection des modules disponibles : </p>
      <table style="border:1px solid black; background:lightgrey;" width="600px">
        <tr height="0"><th>Nettoyer <input type='checkbox' <?php echo $sel_all_default; ?> name='sel_all' onclick='javascript:selAll(this);'/></th><th>Nom</th><th>Chemin</th></tr>
        <?php
        foreach($modules as $name=>$path) {
          echo "<tr><td align='center'>";
          echo "<input type='checkbox' $sel_all_default name='cb_$name' value='$path'/>";
          echo "</td><td>$name</td><td>$path</td></tr>";
        }
        ?>
      </table>
      <br>
      <input type="hidden" name="doGenerate" value="1"/>
      <input type="submit" name="submit" value="Start"/>
    </form>
    <h4>Résultat</h4>
    <iframe name="generate" width="100%" height="300px"></iframe>
  </body>
  </html>
  <?php

}


// -------------------------------------------
// FUNCTIONS
// -------------------------------------------

/**
 * Read all modules available in the script directory
 * @param $script_dir the script directory
 * @return array of readable modules {module_name => module_path, ...}
 */
function readModules($script_dir) {
  global $errors;
  global $tab_unparsed;
  
  $modules = array();
  $dh = @opendir($script_dir);
  if($dh !== false) {
  
    while(($file = @readdir($dh)) !== false) {
      if($file=="." || $file==".." || strtoupper($file)=="CVS" || strtoupper($file)=="VIDE") continue;
      if(in_array(strtolower($file), $tab_unparsed)) continue;
      
      // TEST only atlas
      //if(strtolower($file)!="atlas") continue;
    
      $modules[$file] = $script_dir.$file."/";
    }
    ksort($modules);
    
    closedir($dh);
  } else {
    $errors[] = "INFO : Can't open $script_dir - skipped !";
  }
  
  // return the array of readable modules 
  return $modules;
}

/**
 * Clean an HTML file with Tidy then save it
 * @param $filePath path to the html file to be cleaned
 * @return boolean - true for a successful transformation, false otherwise
 */
function cleanHtml($filePath) {
  global $errors;
  global $fileHelpCss, $pathHelpCss;
  global $tabChar, $tabHTML, $tabISO;
  
  $bool = true;
  
  // clean html with tidy
  $config = array(
             'indent'         => true,
             'output-xhtml'   => true, 
             'drop-font-tags' => true,
             'alt-text'       => 'img',
             'char-encoding'  => 'utf8',
             'tidy-mark'      => true,
             'doctype'        => 'transitional'); // omit
  
  $tidy = new tidy();
  $tidy->parseFile($filePath, $config, 'utf8');
  $bool = $tidy->cleanRepair();
  
  if($bool) {
    $strXml = $tidy->value;
    
    // clean header table
    $strXml = preg_replace("/<table[^>]*>/", "<table id='tableheader' class='header'>", $strXml, 1);
    
    // try adding css help stylesheet if available
    if(file_exists($pathHelpCss)) {
      // if help css is not already present, add it
      if(!preg_match("/<link[^>]*href[^>]*".basename($pathHelpCss)."[^>]*\/?>/", $strXml)) {
        $strXml = preg_replace("/<\/head>/", "<link rel='stylesheet' type='text/css' href='".$fileHelpCss."'/>\n</head>", $strXml);
      }
    }
    
    // replace ISO or HTML entities with normal characters
    $strXml = ereg_replace($tabISO, $tabChar, $strXml);
    $strXml = ereg_replace($tabHTML, $tabChar, $strXml);
    
    // overwrite file with the cleaned HTML
    file_put_contents($filePath, $strXml);
    $errors[] =  "INFO : processing $filePath - Ok !";
  } else {
    $errors[] =  "ERROR : [Tidy] unable to clean/repair $filePath - file not modified !";
  }
  
  return $bool;
}

?>