<?php
 
/**
 * @brief Retourne dans un tableau, la liste des fichiers scripts sql du projet Alkanet
 *
 * @param strPathName Chemin physique pointant vers le répertoire scripts
 * @return Retourne un array
 */
function getTabFileScriptSql($strPathName, $ind_moduleAlkanet)
{
  if( $ind_moduleAlkanet != ""  ) {
    $tabModule = explode(".", $ind_moduleAlkanet);
    $moduleAlkanet = $tabModule[1];
  } else {
    $moduleAlkanet = "";    
  }
  if( $strPathName[mb_strlen($strPathName)-1] != '/' )
    $strPathName .= '/';

  if( !file_exists($strPathName) )
    return $strPathName." n'existe pas.";

  $tabFileSql = array();

  $handle = opendir($strPathName);
  while( $strFile = readdir($handle) ) {
    if( $strFile=='.' || $strFile=='..' )
      continue;
    if(  is_dir($strPathName.$strFile) ) {
      $strSubPathName = $strPathName.$strFile."/_admin/";
      $lgFile = mb_strlen($strFile);
      if( file_exists($strSubPathName) && is_dir($strSubPathName) ) {
        $subHandle = opendir($strSubPathName);
        while( $strFileSql = readdir($subHandle) ) {
          if( mb_strlen($strFileSql)>4+$lgFile && 
              preg_match("!\d+_".$strFile."!u", $strFileSql) ) {
            $tabFile = explode("_", $strFileSql);
            $iNumFile = 99;
            if( count($tabFile) > 1 )
              $iNumFile = $tabFile[0]*1;
            $histo = ( preg_match("!histo!u", $tabFile[count($tabFile)-1]));
            $tabFileSql[count($tabFileSql)] = array("ind" => $iNumFile, "module" => $strFile, "histo"=>$histo, "file" => $strSubPathName.$strFileSql);
          }
        }
        closedir($subHandle);
      }
    }
  }
  closedir($handle);

  $tabIndex = array();
  foreach($tabFileSql as $key => $row) {
    $tabIndex[$key]  = $row["ind"];
  }
  array_multisort($tabIndex, SORT_ASC, SORT_NUMERIC, $tabFileSql);
  return $tabFileSql;
}

/**
 * @brief Retourne un tableau de requêtes lues dans une chaine texte
 *        Les commentaires commencent par --
 *        Les requêtes se termine par un point-virgule suivi d'un retour chariot
 *        
 * @param strSql Chaine texte contenant un ensemble de requêtes SQL
 * @return Retourne un array
 */
function splitContentsFileSql($strSql, $typeSgbd)
{
  if ( !defined("ALK_B_NO_CAST_SQL") ) define("ALK_B_NO_CAST_SQL", true);
  $dbConn = AlkFactory::getDbConn($typeSgbd);
  $sql               = trim($strSql);
  $char              = '';
  $last_char         = '';
  $ret               = array();
  $string_start      = '';
  $in_string         = FALSE;
  $escaped_backslash = FALSE;
  $delimiter         = ";";

  $tabRes = array();
  $sql = preg_replace("!\\\\;!u", "~", $sql); 
  $sql = preg_replace("!--.+!u", "", $sql);
  $sql = preg_replace("![\n\t\r]!u", " ", $sql);
  $sql = preg_replace("!/\*.+\*/!u", "", $sql);

  $sql = preg_replace("!;\s*(\[/[^]]+])!u", "$1;", $sql); 
  $tabSql = preg_split("!;[^[]!u", $sql);
  return $tabSql; 
/*
  foreach ($tabSql as $sql){
    $sql = trim($sql);
    
    $strReplacePostgre = $strReplaceMySql = $strReplaceOracle = "";
    if ( $typeSgbd==ALK_SGBD_POSTGRES ){
      $strReplacePostgre = "$1";
    }
    if ( $typeSgbd==ALK_SGBD_ORACLE ){
      $strReplaceOracle = "$1";
    }
    if ( $typeSgbd==ALK_SGBD_MYSQL ){
      $strReplaceMySql = "$1";
    }
    $sql = preg_replace("!\[MYSQL\]([^[]+)\[/MYSQL\]!u", $strReplaceMySql, $sql); 
    $sql = preg_replace("!\[POSTGRE\]([^[]+)\[/POSTGRE\]!u", $strReplacePostgre, $sql); 
    $sql = preg_replace("!\[ORACLE\]([^[]+)\[/ORACLE\]!u", $strReplaceOracle, $sql); 
    
    $sql = preg_replace("!\[PHP\]([^[]+)\[/PHP\]!u", "\"$1\"", $sql); 
    $sql = preg_replace("!\\\\!u", "\\", $sql);
    $sql = preg_replace("!~!u", ";", $sql);
    $sql = "return \"".$sql."\";";
    $sql = eval($sql);

    $sql = preg_replace("!\[/?(PHP|MYSQL|POSTGRE|ORACLE)\]!u", "", $sql); 
    if ( $sql=="" ) continue;
    $tabRes[] = $sql; 
  }
  return $tabRes;*/
}

/**
 * @brief transforme le code sql dans la norme respectée par le type sgbd sélectionné
 *
 * @param tabSql    tableau contenant l'ensemble des requêtes à analyser
 * @param typeSgbd  type sgbd sélectionné
 */
function EncodeSql($tabSql, $typeSgbd, $updtSequence="0")
{
  global $raa_num;

  $tabConvertion = array("(\W)(INT NOT NULL AUTO_INCREMENT)(\W)"       
                                             => array(ALK_SGBD_ORACLE => "$1$2$3",  ALK_SGBD_MYSQL => "$1$2$3",       (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "$1$2$3",       ALK_SGBD_POSTGRES => "$1serial not null$3"),
                         "(\W)INT(\W)"       => array(ALK_SGBD_ORACLE => "$1number$2",  ALK_SGBD_MYSQL => "$1int$2",       (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "$1int$2",       ALK_SGBD_POSTGRES => "$1integer$2"),
                         "(\W)TEXT(\W)"      => array(ALK_SGBD_ORACLE => "$1clob$2",    ALK_SGBD_MYSQL => "$1text$2",      (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "$1text$2",      ALK_SGBD_POSTGRES => "$1text$2"),
                         "(\W)VARCHAR\("     => array(ALK_SGBD_ORACLE => "$1varchar2(", ALK_SGBD_MYSQL => "$1varchar(",    (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "$1varchar(",    ALK_SGBD_POSTGRES => "$1varchar("),
                         "(\W)FLOAT\("       => array(ALK_SGBD_ORACLE => "$1float(", ALK_SGBD_MYSQL => "$1float(",    (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "$1float(",    ALK_SGBD_POSTGRES => "$1numeric("),
                         "SYSDATE\(\)"       => array(ALK_SGBD_ORACLE => "sysdate",     ALK_SGBD_MYSQL => "sysdate()",     (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "sysdate()",     ALK_SGBD_POSTGRES => "now()"),
                         "(\W)DATETIME(\W)"  => array(ALK_SGBD_ORACLE => "$1date$2",    ALK_SGBD_MYSQL => "$1datetime$2",  (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "$1datetime$2",  ALK_SGBD_POSTGRES => "$1timestamp$2"),
                         "(\W)type=innoDB"   => array(ALK_SGBD_ORACLE => " ",           ALK_SGBD_MYSQL => "$1type=innoDB", (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "$1type=innoDB", ALK_SGBD_POSTGRES => "$1"),
                         "\\\\'"             => array(ALK_SGBD_ORACLE => "''",          ALK_SGBD_MYSQL => "\\'",           (defined("ALK_SGBD_MYSQL5") ? ALK_SGBD_MYSQL5 : "mysql5") => "\\'",           ALK_SGBD_POSTGRES => "\\'")
                         );
  $table_pk = "";
  $primary_key = "";
  
  $tabRes = array();
  $tabDropTable = array();
  $tabDropSequence = array();

  for($i=0; $i<count($tabSql); $i++) {
    $tabSql[$i] = trim($tabSql[$i]);

    // remplacement RAA
    if( $raa_num != "" ) {
      $tabSql[$i] = mb_ereg_replace("_XX_", "_".$raa_num."_", $tabSql[$i]);
      $tabSql[$i] = mb_ereg_replace("RAAXX", "RAA".$raa_num, $tabSql[$i]);
    }

    reset($tabConvertion);
    while( list($strType, $tabAsso) = each($tabConvertion) ) {
      $tabSql[$i] = preg_replace("!".$strType."!usi", $tabAsso[$typeSgbd], $tabSql[$i]);
    }
    $tabParts = array();
    $strPattern = "!PRIMARY\s+KEY.*\(\s*(\w+)[^\)]*\)!ui";
    $iRes = preg_match($strPattern, $tabSql[$i], $tabParts);
    if ( $iRes > 0 ){
      $primary_key = $tabParts[1];
    }
    
    $strPattern = "!create\s+table\s+(\w+)!ui";
    $iRes = preg_match($strPattern, $tabSql[$i], $tabParts);
    if ( $iRes > 0 ){
      $table_pk = $tabParts[1];
      $tabDropTable[] = $table_pk;
    }
    
    // traitement de la sequence pour mysql 4
    if( mb_substr(mb_strtolower($tabSql[$i]), 0, 15) == "create sequence" ) {
      $strPattern = '!^create sequence([ ]+)([0-9A-Z_]+)([ ]+)start with([ ]+)(\d+)([ ]+)increment by([ ]+)(\d)$!u';
      $iRes = preg_match($strPattern, $tabSql[$i], $tabParts);
      if( $iRes > 0 && count($tabParts)>2 )
        $tabDropSequence[] = $tabParts[2];
      if( $iRes > 0 && $typeSgbd == ALK_SGBD_MYSQL ) {
        // repere les requêtes de type 
        //  create sequence [NOM_SEQUENCE] start with [nombre début] increment by [incrément]

        $tabRes[count($tabRes)] = "create table if not exists SEQUENCE (ID int NOT NULL default 1, constraint PK_SEQUENCE PRIMARY KEY ( ID ))";
        $tabRes[count($tabRes)] = "alter table SEQUENCE add ".$tabParts[2]." int default ".$tabParts[5];
        $tabRes[count($tabRes)] = "insert into SEQUENCE (ID) values (1) ON DUPLICATE KEY UPDATE ID=1";
        if ( $typeSgbd==ALK_SGBD_MYSQL && $updtSequence=="1" && $primary_key!="" && $table_pk!="" ){
          $tabRes[count($tabRes)] = "update SEQUENCE set ".$tabParts[2]." = IFNULL( (select max(".$primary_key.")+10 from ".$table_pk."), ".$tabParts[2]." )";
          $primary_key = "";
        }
      } else {       
        $tabRes[count($tabRes)] = $tabSql[$i];
      }
    } else {
      if ( $typeSgbd==ALK_SGBD_POSTGRES ){
        if ( mb_strpos(mb_strtolower($tabSql[$i]), "create index")!==false ){
          $tabRes[count($tabRes)] = preg_replace("! (asc|desc)(\)|,)!usi", "$2", $tabSql[$i]);
        }
        else 
          $tabRes[count($tabRes)] = $tabSql[$i];
      } 
      else 
        $tabRes[count($tabRes)] = $tabSql[$i];
    }
  }
  
  $tabDropTable = array_reverse($tabDropTable);
  return array($tabRes, $tabDropTable, $tabDropSequence);
}

/**
 * @brief Filtre et retourne le tableau de requete pour ne retenir que celles en insert into SIT_CONSTANTE
 *
 * @param tabSql  Tableau de requete
 * @returne Retourne un array 
 */
function FiltreConstPHP($tabSql)
{
  $tabRes = array();
  for($i=0; $i<count($tabSql); $i++) {
    if( mb_strtolower(mb_substr($tabSql[$i], 0, 25)) == "insert into sit_constante") 
      $tabRes[count($tabRes)] = $tabSql[$i];
  }
  return $tabRes;
}


/**
 * @brief Filtre et retourne le tableau de requete pour ne retenir que celles en insert into SIT_CONSTANTE
 *
 * @param tabSql  Tableau de requete
 * @returne Retourne un array 
 */
function FiltreSequence($tabSql)
{
  $tabRes = array();
  for($i=0; $i<count($tabSql); $i++) {
    if( preg_match("!SEQUENCE!u", $tabSql[$i])) 
      $tabRes[count($tabRes)] = $tabSql[$i];
  }
  return $tabRes;
}

/**
 * @brief Retourne le code html du controle affiché pour saisir la valeur d'une constante
 *
 * @return Retourne un string
 */
function getHtmlCtrlValAdmin($iNum, $const_id, $atype_id, $const_valeur, $const_type, $const_lock)
{
  $strId = "id_".$iNum;
  $strName = "val_".$const_id."_".$atype_id."_".$const_type;

  $strHtml = "<input type='hidden' name='".$strId."' value='".$strName."'>";
  if( $const_lock == "1" ) {
    $strHtml .= "<input type='hidden' name='".$strName."' value=\"".$const_valeur."\">&nbsp;";
    return $strHtml;
  }

  switch( $const_type ) {
  case "1": // int
    $strHtml .= "<input type='text' class='formCtrl' name='".$strName."' value=\"".$const_valeur."\" size='20' maxlength='20'>";
    break;

  case "2": // date
    $strHtml .= "<input type='text' class='formCtrl' name='".$strName."' value=\"".$const_valeur."\" size='20' maxlength='10'>";
    break;

  case "0": // string
  case "3": // bool
  case "4": // expression PHP
    $strHtml .= "<input type='text' class='formCtrl' name='".$strName."' value=\"".$const_valeur."\" size='20' maxlength='255'>";    
    break;    
  }
  return $strHtml;
}
function _DelFile($strPathFile)
{
  if( file_exists($strPathFile) && is_file($strPathFile) ) {
    $bDel = unlink($strPathFile);
    echo "df<".( $bDel == true ? "+" : "-" )." ".$strPathFile."<br>\n";
  } else {
    echo "df<= ".$strPathFile."<br>\n";
  }
}
function CreateDirectory($strDir)
{
  if( !file_exists($strDir) ) {
    $bDir = mkdir($strDir);
    echo "cd>".( $bDir == true ? "+" : "-" )." ".$strDir."<br>\n";
  } else {
    echo "cd>= ".$strDir."<br>\n";
  }
}
function RemoveDirectory($strDir)
{
  if( file_exists($strDir) && is_dir($strDir) ) {
    $bDir = rmdir($strDir);
    echo "dd<".( $bDir == true ? "+" : "-" )." ".$strDir."<br>\n";
  } else {
    echo "dd<= ".$strDir."<br>\n";
  }
}
function CopyMoveDirectory($strDirSrc, $strDirDest, $iDateMin, $iDateMax, $strType="Appli", $bMove=false)
{
   $handle = opendir($strDirSrc."/");
  while( $strFile = readdir($handle) ) {
    if( $strFile=='.' || $strFile=='..' )
      continue;
    elseif( is_dir($strDirSrc."/".$strFile) ) {
      if( $strFile != "CVS" )
        CopyMoveDirectory($strDirSrc."/".$strFile, $strDirDest."/".$strFile, $iDateMin, $iDateMax, $strType, $bMove);
    } elseif( $strFile[0]!='.' && $strFile[0]!='#' && $strFile[mb_strlen($strFile)-1]!='~' )  {
      $iSize = fileSize($strDirSrc."/".$strFile);
      $iDate = filemtime($strDirSrc."/".$strFile);
      if( $iDateMin<=$iDate && $iDate<=$iDateMax ) {
        if( !(file_exists($strDirDest) && is_dir($strDirDest)) ) {
          CreateDirectory($strDirDest);
        }
        if( !(file_exists($strDirDest."/".$strFile) && fileSize($strDirDest."/".$strFile)==$iSize) ) {
          $bCopy = copy($strDirSrc."/".$strFile, $strDirDest."/".$strFile);
          echo "cpf>".( $bCopy == true ? "+" : "-" )." ".$strFile." (".$iSize." o)<br>\n";
          if( $bCopy == true && $bMove == true ) {
            _DelFile($strDirSrc."/".$strFile);
          }
        } else {
          echo "cpf>= ".$strFile." (".$iSize." o)<br>\n";
          if( $bMove == true )
            _DelFile($strDirSrc."/".$strFile);
        }
        
        // traitement du fichier
        switch( $strType ) {
        case "Appli":    SetTemplateFileAppli($strDirDest."/".$strFile); break;
        case "DataForm": SetTemplateFileDataForm($strDirDest."/".$strFile); break;
        }
      }
    }
  }
  if( $bMove == true )
    RemoveDirectory($strDirSrc);
  closedir($handle); 
}

function SetTemplateFileAppli($strFileTemplate)
{
  global  $atype_id, $appli_nom, $appli_abrev_fichier, $appli_abrev_classe,
    $appli_dir, $appli_constante, $appli_ordre;

  
  // génére les fichiers en remplacant :
  //  - XXX par $appli_abrev_fichier
  //  toutes les combinaisons étant réalisées
  
  if( !(mb_strpos($strFileTemplate, "XXX")===false) ) {
    // renommage du fichier en remplacant XXX par $appli_abrev_fichier
    $strFileTemplateNew = mb_ereg_replace("XXX", $appli_abrev_fichier, $strFileTemplate);
    $strFileTemplateNew = mb_ereg_replace("ZZZ", $appli_ordre, $strFileTemplateNew);
    $bRes = rename($strFileTemplate, $strFileTemplateNew);
    echo "Création du fichier : ".$strFileTemplateNew.", res = ".($bRes ? "ok" : "<font color='red'>ko</font>")."<br>";
    SetTemplateIntoFileAppli($strFileTemplateNew);
    echo "Exécution du template sur ".$strFileTemplateNew." : ok<br>";
  } 
  else {
    // le nom du fichier n'est pas modifié
    $strFileTemplateNew = $strFileTemplate;
    SetTemplateIntoFileAppli($strFileTemplateNew);
  }
  echo "<br>";
}

function SetTemplateIntoFileAppli($strFile, $strSGBD="")
{
  // applique les templates à l'interieur du fichier
  global  $atype_id, $appli_nom, $appli_abrev_fichier, $appli_abrev_classe,
    $appli_dir, $appli_constante, $appli_ordre;

  $strContents = file_get_contents($strFile);
  
  $strContents = mb_ereg_replace("\{\\$"."appli_nom\}",           $appli_nom,           $strContents);
  $strContents = mb_ereg_replace("\{\\$"."appli_abrev_fichier\}", $appli_abrev_fichier, $strContents);
  $strContents = mb_ereg_replace("\{\\$"."appli_abrev_classe\}",  $appli_abrev_classe,  $strContents);
  $strContents = mb_ereg_replace("\{\\$"."appli_dir\}",           $appli_dir,           $strContents);
  $strContents = mb_ereg_replace("\{\\$"."appli_constante\}",     $appli_constante,     $strContents);
  $strContents = mb_ereg_replace("\{\\$"."atype_id\}",            $atype_id,            $strContents);
  echo $strContents."<br><br>";
  if( $strSGBD != "" ) {
    $strContents = mb_ereg_replace("\{\\$"."sgbd_classe\}", $strSGBD, $strContents);
  }
  
  $hf = @fopen($strFile, "w");
  if( $hf ) {
    fwrite($hf, $strContents);
    fclose($hf);
  }
}

function SetTemplateFileDataForm($strFileTemplate)
{
  global  $form_abrev_fichier, $form_abrev_classe, $appli_dir, $form_req, $form_query, $form_queryparam;
  
  $strFileTemplateNew = mb_ereg_replace("XXX", $form_abrev_fichier, $strFileTemplate);
  $bRes = rename($strFileTemplate, $strFileTemplateNew);
  echo "Création du fichier : ".$strFileTemplateNew.", res = ".($bRes ? "ok" : "<font color='red'>ko</font>")."<br>";
  
  SetTemplateIntoFileDataForm($strFileTemplateNew);
}

function SetTemplateIntoFileDataForm($strFile)
{
  // applique les templates à l'interieur du fichier
  global $dbConn, $form_abrev_fichier, $form_abrev_classe, $appli_dir, $form_req, $form_query, $form_queryparam;

  $tabType = array("text" => "", "int" => "is_numeric", "array" => "is_array", "bool" => "is_bool", "checkbox" => "");

  $strContents = file_get_contents($strFile);

  $strContents = mb_ereg_replace("{\$form_abrev_fichier}",  $form_abrev_fichier, $strContents);
  $strContents = mb_ereg_replace("{\$form_abrev_classe}",   $form_abrev_classe,  $strContents);
  $strContents = mb_ereg_replace("{\$appli_dir}",           $appli_dir,          $strContents);
  $strContents = mb_ereg_replace("{\$form_query}",          $form_query,         $strContents);
  $strContents = mb_ereg_replace("{\$form_queryparam}",     $form_queryparam,    $strContents);

  $form_req = mb_ereg_replace("\n", "", $form_req);
  $tabField = explode(",", $form_req);

  // déclaration des attributs de la classe
  $strTmp = "  /** @brief Déclaration des attributs */\n";
  $strTmp2 = "";
  $strTmp3 = "";
  $strTmp4 = "";
  for($i=0; $i < count($tabField); $i++) {
    $tabProp = explode("|", $tabField[$i]);
    if( count($tabProp) != 13 ) continue;
    $strName = mb_strtolower(trim($tabProp[0]));
    $bMutilingue = ( trim($tabProp[10]) == "0" ? "false" : "true" );
    if( $bMutilingue == "true" ) {
      $strVal = mb_strtolower(trim($tabProp[1]));
      $strValTmp = "";
      for($j=1; $j<count($GLOBALS["_LG_tab_langue"]); $j++) {
        $strValTmp .= ($strValTmp!="" ? "," : "")."\"".$strVal."\"";
      }
      $strValue = "array(".$strVal.")";
    } else {
      $strValue = "\"".mb_strtolower(trim($tabProp[1]))."\"";
    }
    $strCtrl      = "\"".trim($tabProp[2])."\"";
    $strType      = "\"".trim($tabProp[3])."\"";
    $bRequire     = ( trim($tabProp[4]) == "0" ? "false" : "true" );
    $oMin         = "\"".trim($tabProp[5])."\"";
    $oMax         = "\"".trim($tabProp[6])."\"";
    $strMsgErr    = "\"".trim($tabProp[7])."\"";
    $strExcept    = "\"".trim($tabProp[8])."\"";
    $bStrict      = ( trim($tabProp[9]) == "0" ? "false" : "true" );
    $strFuncVerif = "\"".trim($tabProp[11])."\"";
    $typeSql      = trim($tabProp[12]);

    $strTmp .= "  var \$".$strName.";\n";
    $strTmp2 .= "    \$this->".$strName." = new AlkDataFormAttrib(\"".$strName."\", ".$strValue.", ".
      $strCtrl.", ".$strType.", ".$bRequire.", ".$oMin.", ".$oMax.", ".$strMsgErr.", ".$strExcept.", ".
      $bStrict.", ".$bMutilingue.", ".$strFuncVerif.", ".$typeSql.");\n";
    $strTmp3 .= "      \$this->".$strName."->GetData(\$oDrData);\n";
    $strTmp4 .= "    \$this->".$strName."->GetRequest(\$reqMethod);\n";
  }

  $strContents = mb_ereg_replace("{\$formVar}", $strTmp, $strContents);
  $strContents = mb_ereg_replace("{\$formConstructor}", $strTmp2, $strContents);
  $strContents = mb_ereg_replace("{\$formDataRow}", $strTmp3, $strContents);
  $strContents = mb_ereg_replace("{\$formRequest} ", $strTmp4, $strContents);

  $hf = @fopen($strFile, "w");
  if( $hf ) {
    fwrite($hf, $strContents);
    fclose($hf);
  }

  echo "<div class='divContenuTexte' style='padding:10px'><b>Faire un copier/coller à partir de la source de cette page.</b></div>".
    "<div class='divContenuTexte' style='border:1px solid black; margin-top:10; padding:10px'>".CreateForm()."</div>";
}

function CreateForm()
{
  global $dbConn, $form_abrev_fichier, $form_abrev_classe, $appli_dir, $form_req, $form_query, $form_queryparam;

  $strPhp = "\n\n".
    "  /**\n".
    "   * @brief Retourne le code Html du formulaire ".$form_abrev_classe."\n".
    "   *\n".
    "   * @param \n".
    "   * @return Retourne un string\n".
    "   */\n".
    "  function GetHtmlForm".$form_abrev_classe."(\$iMode)\n".
    "  {\n".
    "    \$iWidthTxt = 38;\n".
    "    \$iWidthMemo = 36;\n".
    "    \$iHeightMemo = 5;\n".
    "    \$iWidthSelect= 295;\n".
    "\n".
    "    \$strParam = \"cont_id=\".\$this->oSpace->cont_id.\"&cont_appli_id=\".\$this->appli_id;\n".
    "\n".
    "    \$iModeForm = ( \$iMode == \"1\" ? ALK_FORM_MODE_ADD : ALK_FORM_MODE_UPDATE);\n".
    "    \$strAction = \"XXXXXXX_sql.php?\".\$strParam;\n".
    "    \$bUpload = false;\n".
    "    \$oForm = new HtmlForm(\$iModeForm, \"form".$form_abrev_classe."\", \$strAction, ALK_FORM_METHOD_POST, \$bUpload);\n".
    "    /* possibilité d'associer un template pour afficher les blocs */\n".
    "    /* \$oForm->SetTemplate(\"repertoire_appli\", \"Nom_du_template.tpl\"); */\n".
    "    \n".
    "    include_once(\"classes/alkdataform_".$form_abrev_fichier.".class.php\");\n".
    "    \$oDataForm = new AlkDataForm".$form_abrev_classe."(\$this, \$oForm);\n".
    "    if( \$iModeForm == ALK_FORM_MODE_UPDATE ) {\n".
    "      \$oDataForm->GetData(".$form_queryparam.");\n".
    "    }\n".
    "    \n".
    "    \$strTitre = ( \$iModeForm == ALK_FORM_MODE_ADD ? \"Cr&eacute;ation d'une nouvelle fiche\" : \"Modification de la fiche\" );\n".
    "    \$oBlock =& \$oForm->AddBlock(\"block_0\", \$strTitre, \"\", \"100\", \"300\", true);\n".
    "    \n";

  $form_req = mb_ereg_replace("\n", "", $form_req);
  $tabField = explode(",", $form_req);
  for($i=0; $i < count($tabField); $i++) {
    $tabProp = explode("|", $tabField[$i]);
    if( count($tabProp) != 13 ) continue;
    $strName = mb_strtolower(trim($tabProp[0]));
    $bMutilingue = ( trim($tabProp[10]) == "0" ? "false" : "true" );
    $strCtrl  = trim($tabProp[2]);
    $strType  = trim($tabProp[3]);

    $strParam = ", ALK_HTMLFORM_1L2C";
    $strLine2 = "";
    switch( mb_strtolower($strCtrl) ) {
    case "html":
    case "htmlcheckbox":
    case "htmlcheckboxgroup":
    case "htmlradiogroup":
    case "htmldate":
    case "htmldatetime":
      $strParam .= ", \"Label ".$i."\"";
      break;
    case "htmltext":
    case "htmlfile":
      if( $strType == "text" || $strType == "file" ) {
        $strParam .= ", \"Label ".$i."\", 1, \$iWidthTxt";
      } elseif( $strType == "memo" ) {
        $strParam .= ", \"Label ".$i."\", \$iHeightMemo, \$iWidthMemo";
      } else {
        $strParam .= ", \"Label ".$i."\"";
      }
      if( mb_strtolower($strCtrl) == "htmlfile" )
        $strLine2 = "    if( \$oDataForm->".$strName."->value != \"\" ) {\n".
          "      \$oCtrl->urlFile = ALK_ALKANET_ROOT_URL.ALK_PATH_UPLOAD_".mb_strtoupper($appli_dir).".\$oDataForm->".$strName."->value;\n".
          "    }\n";
      break;
    case "htmlselect":
    case "htmlselectdepend":
      $strParam .= ", \"Label ".$i."\", 1, \$iWidthSelect";
      $strLine2 = "    \$oCtrl->oValTxt = null; /* placer la source de données de type dataSet, ou de type tableau avec l'attribut tabValTxt */\n";
      break;
    case "htmlupload":
      $strParam .= ", \"Label ".$i."\", ALK_ALKANET_ROOT_PATH.ALK_PATH_UPLOAD_".mb_strtoupper($appli_dir).
        ", ALK_ALKANET_ROOT_URL.ALK_PATH_UPLOAD_".mb_strtoupper($appli_dir).", ALK_URL_SI_IMAGES, 1";
      break;
    case "htmlcolor":
      $strParam .= ", \"Label ".$i."\", \"/*height*/\", \"/*width*/\", \"true\"";
      break;
    case "htmlhidden":
      $strParam = "";
      break;
    }

    $strPhp .= "    \$oCtrl =& \$oBlock->AddHtmlCtrl(\$oDataForm->".$strName.$strParam.");\n".
      $strLine2.
      "\n";
  }

  $strPhp .= "    \$oForm->AddLink(\"bt_0\", \"javascript:Valider()\", \"Valider\", \"valid_gen.gif\", \"valid_gen_rol.gif\");\n";
  $strPhp .= "    \$oForm->AddLink(\"bt_1\", \"javascript:Annuler()\", \"Annuler\", \"annul_gen.gif\", \"annul_gen_rol.gif\");\n";
  $strPhp .= "\n";
  $strPhp .= "    \$oForm->AddVarJs(\"g_strParam\", \"'\".\$strParam.\"'\");\n";
  $strPhp .= "    \$oForm->AddScriptJs(\"lib/lib_XXX.js\");\n";
  $strPhp .= "\n";
  $strPhp .= "    return \$oForm->getHtml();\n".
    "  }\n\n\n";

  return $strPhp;
}

?>