<?php
include_once("../../lib/lib_session.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");

$suffixPatch = "sql.patch.php";
$xmlFileVersion = ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."version.xml";
$xmlFileVersionInit = ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."version_init.xml";
$dbConn = AlkFactory::getDbConn();
// force l'encodage pour uniformiser l'encodage de toutes les requêtes
$dbConn->setEncoding("UTF8");
$mapLevel = array("scripts" => 3, "classes" => 1, "lib" => 2, "services" => 4, "default" => 3);

/* Variables et Tableaux de type "include" => les fichiers *.sql.patch.php doivent les déclarer */
/* --- */
$tabTable     = array();
$tabDropTable = array();
$tabView      = array();
$tabDropView  = array();
$tabSeq       = array();
$tabDropSeq   = array();
$tabPk        = array();
$tabDropPk    = array();
$tabIdx       = array();
$tabDropIdx   = array();
$tabFk        = array();
$tabDropFk    = array();
$tabUq        = array();
$tabDropUq    = array();
$tabIns       = array();
$tabAlterTable= array();
/* --- */

$tabVersion   = array();			// Contiendra les requêtes de mise à jour de SIT_VERSION
$tabInc		  = array();			// Contiendra toutes les références aux tableaux de type "include"
$tabPatch	  = array();			// tabPatch[module][version][query]

echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">". 
  "<html><head>".
  "<meta http-equiv=\"content-type\" content=\"text/html; charset=".ALK_HTML_ENCODING."\" />".
  "<link rel='stylesheet' href='styles/sit.css' type='text/css'/>";
echo "<style type='text/css'><!-- ";
echo "body { padding: 10px; }";
echo "table { border-collapse:collapse; border:1px solid grey; padding:4px; } ";
echo "tr { border: 1px solid lightgrey; padding: 4px; } ";
echo "td { border: 1px solid lightgrey; padding: 8px; } ";
echo "th { border: 1px solid grey; padding: 8px; background-color: lightgrey; } ";
echo "--></style>";
echo "</head><body>";

  
/* Mise à jour module par module suivant version.xml */
	
// Initialisation de tabInc à partir des références des tableaux de type "include"
$tabInc['getTabSqlDropConstraintForeignKey'] = &$tabDropFk;
$tabInc['getTabSqlDropPrimary'] = &$tabDropPk;
$tabInc['getTabSqlDropConstraintUnique'] = &$tabDropUq;
$tabInc['getTabSqlDropIndex'] = &$tabDropIdx;
$tabInc['getTabSqlDropTable'] = &$tabDropTable;
$tabInc['getTabSqlDropView'] = &$tabDropView;
$tabInc['getTabSqlCreateTable'] = &$tabTable;
$tabInc['getTabSqlAlterTable'] = &$tabAlterTable;
$tabInc['getTabSqlAddPrimary'] = &$tabPk;
$tabInc['getTabSqlCreateView'] = &$tabView;
$tabInc['getTabSqlDropSequence'] = &$tabDropSeq;
$tabInc['getTabSqlCreateSequence'] = &$tabSeq;
$tabInc['getTabSqlCreateIndex'] = &$tabIdx;
$tabInc['getTabSqlAddConstraintForeignKey'] = &$tabFk;
$tabInc['getTabSqlAddConstraintUnique'] = &$tabUq;
$tabInc['_none_ins'] = &$tabIns;
	
$errors = array();
if( file_exists($xmlFileVersion) && is_file($xmlFileVersion) ) {
  // rien à faire
} elseif( file_exists($xmlFileVersionInit) && is_file($xmlFileVersionInit) ) {
  // recopie version_init.xml -> version.xml
  copy($xmlFileVersionInit, $xmlFileVersion);
} else {
  echo "<div class='divContenuTexte'><b>".
    "Impossible de lire le fichier libconf/version.xml ou libconf/version_init.xml<br>".
    "Cliquer sur <a class='aContenuLien' href='sgbd_init_version_xml.php'>Initialisation du fichier libconf/version_init.xml</a>";
  exit(); 
}

$simplexmlUpdate = simplexml_load_file($xmlFileVersion);
$updates = $simplexmlUpdate->xpath('/updates/update');
$update = lastUpdate($updates);
$attributesUpdate = $update->attributes();
$newLivraison = (int)$attributesUpdate['livraison'];
$newLivraison++;

$tabModule = array();
foreach($update as $module) {
	$attributesModules = $module->attributes();
  if( !isset($attributesModules['name']) ) continue;
	$dir = $attributesModules['name']."";
	$tabFiles = getTabFilesByDir(ALK_ALKANET_ROOT_PATH.$dir, array($suffixPatch), true, array(), true);
	if (count($tabFiles) == 1) {
		$module->addAttribute("filePath", reset($tabFiles));
		$module->addAttribute("fileName", key($tabFiles));
	}
	array_push($tabModule, $module);
}

$dom = new DomDocument();
$dom->preserveWhiteSpace = false;
$dom->load($xmlFileVersion);
$dom->formatOutput = true;

$update = $dom->createElement("update");
$update->setAttribute("livraison", $newLivraison);
$update->setAttribute("date", date('j/m/Y'));
$update->setAttribute("name", "pct");

// tri des modules puis parcours	
sortTabModule($tabModule);
foreach($tabModule as $module) {
	$attributesModules = $module->attributes();
	$moduleName     = $attributesModules['name']."";
	$moduleVersion  = $attributesModules['version']."";
	$moduleFilepath = $attributesModules['filePath']."";
	$moduleFileName = $attributesModules['fileName']."";
  $cvs_repository = $attributesModules['cvs_repository']."";
  $cvs_module     = $attributesModules['cvs_module']."";
  $cvs_branch     = $attributesModules['cvs_branch']."";
	
	if( !is_null($moduleFilepath) && strcmp($moduleFilepath, "") != 0 && 
      !is_null($moduleFileName) && strcmp($moduleFileName, "") != 0 ) {
		resetTabInc($tabInc);	// Restaure à l'état initial le tableau de type "include"
		include_once($moduleFilepath);	// Initialisation des Variables et Tableaux de type "include"
    
		addModuleToTabPatch($tabPatch, $tabInc, $moduleName, $moduleVersion, "last"); //Ajoute à tabPatch les infos utiles
		end($tabPatch[$moduleName]);

		$newVersion = key($tabPatch[$moduleName]);
		if (is_null($newVersion) || strcmp($newVersion, "") == 0 ) {
			$newVersion = $moduleVersion;
    } else {
			$arrayMod = explode("/", $moduleName);
			if (count($arrayMod) == 1 || count($arrayMod) == 2) {
				if (array_key_exists($arrayMod[0], $mapLevel))
					$dirModule = $arrayMod[0];
				else
					$dirModule = "default";
					
				if (count($arrayMod) == 1)
					$niceModuleName = $arrayMod[0];
				else
					$niceModuleName = $arrayMod[1];
					
				array_push($tabVersion, "insert into SIT_VERSION (VERS_NAME, VERS_VERSION, VERS_DATE, VERS_LEVEL) values (".
                  "'".$niceModuleName."', '".$newVersion."', ".$dbConn-> getDateCur().", '".$mapLevel[$dirModule]."')");
			}
			else
				array_push($errors, 'Attention : Module "'.$moduleName.'". invalide.');
		}
		$module = $dom->createElement("module");
		$module->setAttribute("name", $moduleName);
		$module->setAttribute("version", $newVersion);
    $module->setAttribute("cvs_repository", $cvs_repository);
    $module->setAttribute("cvs_module", $cvs_module);
    $module->setAttribute("cvs_branch", $cvs_branch);
		$update->appendChild($module);
	}
	else {
		array_push($errors, 'Attention : Patch non trouvé pour le module "'.$moduleName.'".');
  }
}
if (count($errors) == 0) {
	QuickDirtyDebug($tabPatch);
  
	$tabCreate = genereTabCreateFromTabPatch($tabPatch, $tabVersion, $dbConn);

  // Mise à jour du fichier XML version
  $root = $dom->documentElement;
  $root->insertBefore($update, $root->getElementsByTagName("update")->item(0));
  $dom->save($xmlFileVersion);
	
  // Enregistrement du patch
  $strFileName = "patch_update_alkanet_".ALK_BDD_TYPE."_v".$newLivraison.".sql";
  writeTabInFile($tabCreate, ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$strFileName, "w", ";\n", ALK_SGBD_ENCODING);
}
else if (count($errors) > 0) {
	$strFileName = "";
  foreach ($errors as $error)
		echo '<p>'.$error.'</p>';
}
else {
	$strFileName = "";
  echo '<p>Erreur interne</p>';
}

echo "<br><b>En gras, les modules mis à jour depuis la dernière livraison.<br>".
  "Au préalable, il est nécessaire de marquer tous les modules.<br>".
  "Avant de marquer un module, il faut mettre à jour le fichier _admin/xxx_module.sql.patch.php<br>".
  "<ul>".
  "<li>Ajouter une ligne \$strNum=\"[version du prochain marquage]\";</li>".
  "<li>Puis ajouter les éventuelles mises à jour SGBD liées au module.</li>".
  "<li>Si aucune mise à jour SGBD, ajouter la ligne \$tabIns[\$strNum][] = \"\"; pour mettre à jour le fichier libconf/version.xml</li>".
  "</ul>".
  "</b>".
  ( $strFileName != ""
    ? "<div class='divContenuTexte'><br>Script update Alkanet pour ".ALK_BDD_TYPE." disponible :
      <ul>
        <li><a class='aContenuLien' href='".ALK_ALKANET_ROOT_URL."/upload/".$strFileName."'>".ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD.$strFileName."</a></li> 
        <li>".ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$strFileName."</li>
      </ul>"
    : "" ).
  "<br></body></html>";


/* OPERATIONS UTILITAIRES */


/**
 * Exécute les requêtes définies à partir du tableau $tabPatch  
 * 
 * @param	array	$tabPatch	un tableau de "patchs"
 * @param	array	$tabPatch	un tableau de commentaires
 * @param	DB	$dbConn	un connecteur de base
 * @return	array	le tableau contenant les requêtes SQL appliquées 
 */
function genereTabCreateFromTabPatch($tabPatch, $tabSITVersion, $dbConn)
{
	$tabCreate = array();
	
	// Pour chaque module
	foreach ($tabPatch as $module => $tabModule) {
		// Pour chaque version
		foreach ($tabModule as $version => $tabVersion) {
			//Pour chaque type de requête
			foreach ($tabVersion as $method => $tabType) {
				if (checkTabType($tabType)) {
					if (!eregi("^_none_", $method)) {
            $tabTmp = $dbConn->$method($tabType);
						$tabCreate = array_merge($tabCreate, $tabTmp);
          } else {
            $tabTmp = array_filter($tabType, "isQuery");
						$tabCreate = array_merge($tabCreate, $tabTmp);
          }
				}
			}
		}
	}
	
  $tabCreate = array_merge($tabCreate, $tabSITVersion);
  
  return $tabCreate;
}

/**
 * Ajoute à tabPatch une entrée module correspondant au module donné
 * à partir des tableaux de type "include" qui au préalable
 * seront filtrer grâce aux versions données
 * 
 * @param	array	$tabPatch un tableau
 * @param	array $tabInc une référence sur le tableau contenant
 * les tableaux de type "include"
 * @param	String	$module le nom du module
 * @param	String	$currentVersion la version courante du module
 * @param	String	$updateVersion la version du module à mettre jour 
 */
function addModuleToTabPatch(&$tabPatch, &$tabInc, $module, $currentVersion, $updateVersion)
{
	$tabPatch[$module] = array();
	spliceTabInc($tabInc, $currentVersion, $updateVersion);
	fillTabPatchMod($tabPatch[$module], $tabInc);
}

/**
 * Vide les tableaux de type "include"
 * 
 * @param	array $tabInc une référence sur le tableau contenant
 * les tableaux de type "include"
 */
function resetTabInc(&$tabInc)
{
	foreach($tabInc as $key => &$value)
		array_splice($value, 0);
}

/**
 * Enlève des tableaux de type "include"
 * toutes les entrées non comprises entre 
 * $currentVersion et $updateVersion
 * 
 * $firstVersion n'est pas inclu (strict)
 * $lastVersion est inclu (large)
 * 
 * @param	array $tabInc une référence sur le tableau contenant
 * les tableaux de type "include"
 * @param	String	$firstVersion un numéro de version de type X.X.X
 * @param	String	$lastVersion un numéro de version de type X.X.X
 */
function spliceTabInc(&$tabInc, $firstVersion, $lastVersion)
{
	foreach($tabInc as $key => &$value)
		spliceTabVersion($value, $firstVersion, $lastVersion);
}

/**
 * Copie dans $tab les tableaux de type "include"
 * 
 * @param	array $tabPatch un tableau 	
 * @param	array $tabInc une référence sur le tableau contenant
 * les tableaux de type "include"	
 */
function fillTabPatchMod(&$tabPatchMod, $tabInc)
{
	foreach($tabInc as $method => $tab) {
		foreach($tab as $version => $tabQueries)
			$tabPatchMod[$version][$method] = $tabQueries;
	}
	sortTabVersion($tabPatchMod);
}

/**
 * Enlève de $tabVersion les entrées antérieure à $firstVersion (exclus)
 * et les entrées postérieure à $lastVersion (inclus)
 * @param	array	$tabVersion un tableau de version
 * @param	String	$firstVersion un numéro de version
 * @param	String	$lastVersion un numéro de version
 * @return	&array	une référence au tableau
 */
function spliceTabVersion(&$tabVersion, $firstVersion, $lastVersion)
{
	sortTabVersion($tabVersion);
	
	
	$iFirstVersion = convertVersionNumberToInt($firstVersion);
	$firstoffset = 0;
	foreach($tabVersion as $key => $value) {
		if (convertVersionNumberToInt($key) > $iFirstVersion)
			break;
		else
			$firstoffset++;
	}
	array_splice($tabVersion, 0, $firstoffset);
	
	
	if (strcmp($lastVersion, "last") != 0) {
		$iLastVersion = convertVersionNumberToInt($lastVersion);
		$lastOffset = 0;
		foreach($tabVersion as $key => $value) {
			if (convertVersionNumberToInt($key) > $iLastVersion)
				break;
			else
				$lastOffset++;
		}
		array_splice($tabVersion, $lastOffset);
	}
	
	return $tabVersion;
}

/**
 * Retourne la dernière mise à jour effectuée
 * en fonction de la livraison
 * 
 * @param	array $tabUpdate tableau d'update
 * 
 */
function lastUpdate(&$tabUpdate)
{
	sortTabUpdate($tabUpdate);
	return end($tabUpdate);
}

/**
 * Trie un tableau dont les clés sont des numéros de versions
 * @param	array	$tabVersion un tableau de version
 * @return	true si le tableau est trié false sinon
 */
function sortTabVersion(&$tabVersion)
{
	return uksort($tabVersion, "cmpVersion");
}


/**
 * Trie un tableau dont les valeurs sont des "updates"
 * @param	array	$tabUpdate un tableau d'Updates
 * @return	true si le tableau est trié false sinon
 */
function sortTabUpdate(&$tabUpdate)
{
	return uasort($tabUpdate, "cmpUpdate");
}

/**
 * Trie un tableau dont les valeurs sont des "updates"
 * @param	array	$tabUpdate un tableau d'Updates
 * @return	true si le tableau est trié false sinon
 */
function sortTabModule(&$tabModule)
{
	return uasort($tabModule, "cmpModule");
}


/**
 * Compare deux versions données
 * @param	String $version1
 * @param	String $version2
 * @return	int le résultat de la comparaison, -1, 0 ou 1
 */
function cmpVersion($version1, $version2)
{
	$a = convertVersionNumberToInt($version1);
	$b = convertVersionNumberToInt($version2);
	
  if ($a == $b)
   	return 0;
       	
  return ($a < $b) ? -1 : 1;
}

/**
 * Compare deux "update" données
 * @param	String $update1
 * @param	String $update2
 * @return	int le résultat de la comparaison, -1, 0 ou 1
 */
function cmpUpdate($update1, $update2)
{
	$livraison1 = $update1->attributes();
	$livraison2 = $update2->attributes();
	
	
	$livraison1 = (int)$livraison1['livraison'];
	$livraison2 = (int)$livraison2['livraison'];
	
	if ($livraison1 == $livraison2)
  	return 0;
       	
  return ($livraison1 < $livraison2) ? -1 : 1;
}

/**
 * Compare deux "modules" données
 * @param	String $module1
 * @param	String $module2
 * @return	int le résultat de la comparaison, -1, 0 ou 1
 */
function cmpModule($module1, $module2)
{
	$name1 = $module1->attributes();
	$name2 = $module2->attributes();
	
  return strcmp($name1['fileName']."", $name2['fileName']."");
}

/**
 * Fonction qui filtre les requêtes vide
 */
function isQuery($strTmp)
{
  return ( $strTmp != "" );
}

/**
 * @param	array $tabType un tableau contenant des requêtes
 * @return	true si $tabType est valide faux sinon
 */
function checkTabType($tabType)
{
	if( !is_array($tabType) )
		return false;
	if( count($tabType) < 1 )
		return false;
    
	/*if( count($tabType) == 1 ) {
    $field = reset($tabType);
		if( is_array($field) && empty($field) )
			return false;
		if( is_null($field) )
			return false;
		if( is_string($field) && strcmp($field , "") )
			return false;
    echo $field." ";
	}*/
	return true;
}


function QuickDirtyDebug($tabPatch)
{
	// Pour chaque module
	foreach ($tabPatch as $module => $tabModule) {
    
		echo "<div class='divContenuTexte'>".
      ( count($tabModule)>0 ? "<b>" : "" ).
      $module.
      ( count($tabModule)>0 ? "</b>" : "" ).
      " : ";
		// Pour chaque version
		foreach ($tabModule as $version => $tabVersion) {
			echo $version." ";
			// Pour chaque type de requête
			/*foreach ($tabVersion as $method => $tabType) {
				echo '<h3>'.$method.'</h3>';
				echo '<h3>'.$tabType.'</h3>';
			}*/
		}
    echo "</div>";
	}
}

?>
