<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="utf-8" indent="yes"/>

  <!-- format output with newline delimiter -->
  <xsl:variable name="CR">
    <xsl:if test="count(ancestor::td)=0">
    <!-- please keep the following indentation as is ! -->
    <xsl:text>
</xsl:text>
    </xsl:if>
  </xsl:variable>

  <xsl:template match="body/table[1]">
    <!-- don't process the header table -->
  </xsl:template>

  <xsl:template match="head/title">
    <!-- don't process the header table -->
  </xsl:template>
  
  <xsl:template match="style[@type='text/css']">
    <!-- don't process the embeded css -->
  </xsl:template>
  
  <xsl:template match="span">
    <xsl:apply-templates/>
  </xsl:template>

  <!-- p - paragraph -->
  <xsl:template match="p | div">
    <!-- don't display empty paragraphs -->
    <xsl:variable name="ret"><xsl:apply-templates/></xsl:variable>
    <xsl:if test="string-length(normalize-space($ret)) > 0">

      <xsl:call-template name="centering">
        <xsl:with-param name="this" select="."/>
        <xsl:with-param name="opt" select="string('begin')"/>
      </xsl:call-template>

      <xsl:text>\par{\noindent </xsl:text>
      <xsl:value-of select="$ret"/>
      <xsl:text>}\medskip</xsl:text>
      <xsl:value-of select="$CR"/>

      <xsl:call-template name="centering">
        <xsl:with-param name="this" select="."/>
        <xsl:with-param name="opt" select="string('end')"/>
      </xsl:call-template>

    </xsl:if>
  </xsl:template>

  <!--  -->
  <xsl:template name="centering">
    <xsl:param name="this"/>
    <xsl:param name="opt"/>
    
    <xsl:choose>
      <xsl:when test="count(ancestor::td)>0">
      </xsl:when>
      <xsl:when test="$this/@align and $this/@align!='justify'">
        <xsl:text>\</xsl:text><xsl:value-of select="$opt"/><xsl:text>{</xsl:text>
        <xsl:choose>
          <xsl:when test="$this/@align='center'">
            <xsl:text>center</xsl:text>
          </xsl:when>
          <xsl:when test="$this/@align='left'">
            <xsl:text>flushleft</xsl:text>
          </xsl:when>
          <xsl:when test="$this/@align='right'">
            <xsl:text>flushright</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>flushleft</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>}</xsl:text>
        <xsl:value-of select="$CR"/>
      </xsl:when>
      <xsl:when test="$this/@style and normalize-space($this/@style)!='text-align: justify'">
        <xsl:text>\</xsl:text><xsl:value-of select="$opt"/><xsl:text>{</xsl:text>
        <xsl:choose>
          <xsl:when test="normalize-space($this/@style)='text-align: center'">
            <xsl:text>center</xsl:text>
          </xsl:when>
          <xsl:when test="normalize-space($this/@style)='text-align: left'">
            <xsl:text>flushleft</xsl:text>
          </xsl:when>
          <xsl:when test="normalize-space($this/@style)='text-align: right'">
            <xsl:text>flushright</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>flushleft</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>}</xsl:text>
        <xsl:value-of select="$CR"/>
      </xsl:when>
    </xsl:choose>
        
    
  </xsl:template>

  <!-- ul - unordered list -->
  <xsl:template match="ul">
    <xsl:text>\begin{itemize}</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{itemize}</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>
  
  <!-- ol - unordered list -->
  <xsl:template match="ol">
    <xsl:text>\begin{enumerate}</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{enumerate}</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>

  <!-- li - list item -->
  <xsl:template match="li">
    <xsl:text>\item </xsl:text>
    <xsl:apply-templates/>
    <xsl:value-of select="$CR"/>
  </xsl:template>

  <!-- table - table -->
  <xsl:template match="table">
    <xsl:text>\begin{center}</xsl:text>
    <xsl:value-of select="$CR"/>
    <xsl:text>\begin{tabular}{</xsl:text>
    <xsl:for-each select="tr[1]/*">
        <xsl:text>| p{</xsl:text><xsl:value-of select="number(72 div count(../../tr[1]/*))"/><xsl:text>ex} </xsl:text>
      </xsl:for-each>
    <xsl:text>|}</xsl:text>
    <xsl:value-of select="$CR"/>
    <xsl:text>\hline</xsl:text>
    <xsl:value-of select="$CR"/>
    <xsl:apply-templates/>
    <xsl:text>\end{tabular}</xsl:text>
    <xsl:value-of select="$CR"/>
    <xsl:text>\end{center}</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>

  <!-- tr - table row -->
  <xsl:template match="tr">
    <xsl:apply-templates/>
    <xsl:text> \\ \hline</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>
  
  <!-- td - table cell -->
  <xsl:template match="td">
    <xsl:apply-templates/>
    <xsl:if test="position() &lt; last()-1">
      <xsl:text> &amp; </xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- b - bold face -->
  <xsl:template match="b">
    <xsl:text>\textbf{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>

  <!-- i - italic -->
  <xsl:template match="i">
    <xsl:text>\textit{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>
  
  <!-- u - underline -->
  <xsl:template match="u">
    <xsl:text>\underline{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>

  <!-- a - link -->
  <xsl:template match="a">
    <xsl:choose>
      <xsl:when test="starts-with(@href,'http://')">
        <xsl:text>\href{</xsl:text><xsl:value-of select="@href"/><xsl:text>}</xsl:text>
        <xsl:text>{</xsl:text><xsl:apply-templates/><xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- hr - line -->
  <xsl:template match="hr">
    <!-- don't process hr entities -->
    <!--
    <xsl:text>\vspace{0.2cm}</xsl:text><xsl:value-of select="$CR"/>
    <xsl:text>\hline</xsl:text><xsl:value-of select="$CR"/>
    <xsl:text>\vspace{0.2cm}</xsl:text><xsl:value-of select="$CR"/>
    -->
  </xsl:template>
  
  <!-- br - newline -->
  <xsl:template match="br">
    <!-- <xsl:text>\newline</xsl:text><xsl:value-of select="$CR"/> -->
  </xsl:template>

  <!-- img - images -->
  <xsl:template match="img">
    <xsl:value-of select="$CR"/>
    <xsl:if test="@width and @height">
       <xsl:text>\includegraphics[keepaspectratio=true, width=\maxwidth</xsl:text>
       <!-- 
       <xsl:text> ,width=</xsl:text><xsl:value-of select="@width"/><xsl:text>pt</xsl:text>
       <xsl:text> ,height=</xsl:text><xsl:value-of select="@height"/><xsl:text>pt</xsl:text>
       -->
       <!--
       <xsl:if test="@width > 500">
         <xsl:text>width=\linewidth</xsl:text>
       </xsl:if>
       -->
       <xsl:text>]{</xsl:text>
    </xsl:if>
    <xsl:if test="not(@width and @height)">
      <xsl:text>\includegraphics[keepaspectratio=true, width=\maxwidth]{</xsl:text>
    </xsl:if>
    <xsl:value-of select="@src"/>
    <xsl:text>}</xsl:text>
    <xsl:value-of select="$CR"/>
  </xsl:template>

  <!-- img - images 
  <xsl:template match="img">
    <xsl:value-of select="$CR"/>
    <xsl:text>\begin{figure}[h]</xsl:text><xsl:value-of select="$CR"/>
    <xsl:text>\caption{</xsl:text>
      <xsl:value-of select="@name"/>
    <xsl:text>}</xsl:text><xsl:value-of select="$CR"/>
    <xsl:text>\centering</xsl:text><xsl:value-of select="$CR"/>
    <xsl:if test="@width and @height">
       <xsl:text>\includegraphics[keepaspectratio=true, </xsl:text>
       <xsl:text>width=</xsl:text><xsl:value-of select="@width"/>
       <xsl:text> ,height=</xsl:text><xsl:value-of select="@height"/>
       <xsl:text>]{</xsl:text>
    </xsl:if>
    <xsl:if test="not(@width and @height)">
      <xsl:text>\includegraphics{</xsl:text>
    </xsl:if>
    <xsl:value-of select="@src"/>
    <xsl:text>}</xsl:text>
    <xsl:value-of select="$CR"/>
    <xsl:text>\end{figure}</xsl:text><xsl:value-of select="$CR"/>
  </xsl:template>
  -->

  <!-- text - escape latex special entities -->
  <xsl:template match="text()">
    <!-- the following need escaping: # $ % & ~ _ ^ \ { } -->
    <xsl:if test="string-length(normalize-space(.))>0">
    
  <xsl:call-template name="esc">
    <xsl:with-param name="c" select='"#"'/>
    <xsl:with-param name="s">
      <xsl:call-template name="esc">
  <xsl:with-param name="c" select='"$"'/>
  <xsl:with-param name="s">
    <xsl:call-template name="esc">
      <xsl:with-param name="c" select='"%"'/>
      <xsl:with-param name="s">
        <xsl:call-template name="esc">
    <xsl:with-param name="c" select='"et_com"'/>
    <xsl:with-param name="s">
      <xsl:call-template name="esc">
        <xsl:with-param name="c" select='"~"'/>
        <xsl:with-param name="s">
          <xsl:call-template name="esc">
      <xsl:with-param name="c" select='"_"'/>
      <xsl:with-param name="s">
        <xsl:call-template name="esc">
          <xsl:with-param name="c" select='"^"'/>
          <xsl:with-param name="s">
            <xsl:call-template name="esc">
        <xsl:with-param name="c" select='"{"'/>
        <xsl:with-param name="s">
          <xsl:call-template name="esc">
            <xsl:with-param name="c" select='"}"'/>
            <xsl:with-param name="s">
              <xsl:call-template name="esc">
          <xsl:with-param name="c" select='"\"'/>
          <xsl:with-param name="s" select='.'/>
              </xsl:call-template>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:with-param>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
  
  </xsl:if>
</xsl:template>

<!-- escape template -->
<xsl:template name="esc">
  <xsl:param name="s"/>
  <xsl:param name="c"/>

  <xsl:choose>
    <xsl:when test='contains($s, $c)'>
      <xsl:value-of select='substring-before($s, $c)'/>
      <xsl:text>\</xsl:text>

      <xsl:choose>
  <xsl:when test='$c = "\"'>
    <xsl:text>textbackslash </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select='$c'/>
  </xsl:otherwise>
      </xsl:choose>

      <xsl:call-template name="esc">
  <xsl:with-param name='c' select='$c'/>
  <xsl:with-param name='s' select='substring-after($s, $c)'/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select='$s'/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


</xsl:stylesheet>