#!/usr/bin/php-cgi
<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module CGI fournissant les pages adressables Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

set_time_limit(0);

//require_once("../../../lib/lib_session.php");	// ce chargement semble empêcher les appels Ajax en parallèles 
require_once("../../../libconf/app_conf.php");
require_once(ALK_ALKANET_ROOT_PATH."classes/pattern/alkrequest.class.php");

/* Récupération des paramètres */
AlkRequest::readToken();
$tabParam = array();
$tabParam["ids"] 						= AlkRequest::getToken("ids", AlkRequest::_REQUEST("ids", ""));
$tabParam["idUnique"]				= AlkRequest::getToken("idUnique", AlkRequest::_REQUEST("idUnique", ""));
$tabParam["dtmp"]						= AlkRequest::getToken("dtmp", AlkRequest::_REQUEST("dtmp", ""));
$tabParam["strFilePathSrc"] = AlkRequest::getToken("strFilePathSrc", AlkRequest::_REQUEST("strFilePathSrc", ""));
$tabParam["strDirPathDest"] = AlkRequest::getToken("strDirPathDest", AlkRequest::_REQUEST("strDirPathDest", ""));
//print_r($tabParam);die();

/* Vérification des paramètres (tous obligatoires) */
foreach ( $tabParam as $param ) {
	if ( $param == "" ) {
		writeError("Paramètres non valides.");
		exit();
	}
}

/* Fichier de session php */
$strFileSession = "sess_".$tabParam["ids"];
if ( !(file_exists($tabParam["dtmp"]."/".$strFileSession) && is_file($tabParam["dtmp"]."/".$strFileSession)) ) {
	writeError("Sécurité non assurée.");
	exit();
}

$file_error = $tabParam["dtmp"]."/".$tabParam["idUnique"]."_unzip_error";
@unlink($file_error);
$file_progress = $tabParam["dtmp"]."/".$tabParam["idUnique"]."_unzip_progress";
@unlink($file_progress);

/* Vérifie les emplacements */
if ( !(file_exists($tabParam["strFilePathSrc"]) && is_file($tabParam["strFilePathSrc"])) ) {
	writeError("Le fichier ZIP n'existe pas.");
}
/*
if ( file_exists($tabParam["strDirPathDest"]) ) {
	writeError("Destination invalide.");
}
*/

/* Extraction du ZIP */
$nbFilesExtracted = 0;
$zipFile = new ZipArchive();
if ( $zipFile->open($tabParam["strFilePathSrc"]) === TRUE ) {
	writeProgress($nbFilesExtracted, $zipFile->numFiles);
	for ( $i=0; $i < $zipFile->numFiles; $i++ ) {
		$entry = $zipFile->getNameIndex($i);
		if ( $zipFile->extractTo($tabParam["strDirPathDest"], array($zipFile->getNameIndex($i))) === FALSE ) {
			exec("rm -r ".$zipFile->extractTo($tabParam["strDirPathDest"]));
			writeError("Erreur d'extraction des fichiers.");
		} else {
			$nbFilesExtracted++;
			writeProgress($nbFilesExtracted, $zipFile->numFiles);
		}
	}
	$zipFile->close();
}

echo $nbFilesExtracted;

/**
 * Ecrit l'avancement dans le fichier d'avancement
 */
function writeProgress($nbFilesExtracted=0, $nbFileTotal=0)
{
	global $tabParam;
	global $file_progress;
	$fileProgress = fopen($file_progress, "w");
	if ( $fileProgress !== FALSE ) {
		fwrite($fileProgress, $nbFilesExtracted."|".$nbFileTotal);
		fclose($fileProgress);
	} else {
  	writeError("Impossible d'initialiser l'extraction.");
  }
}

/**
 * Ecrit dans le fichier d'erreur et quitte le script
 */
function writeError($strMsg="")
{
	global $tabParam;
	global $file_error;
	$fileError = fopen($file_error, "w");
	if ( $fileError !== FALSE ) {
		fwrite($fileError, $strMsg);
		fclose($fileError);
	}
	echo -1;
	exit();
}
?>