<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Module fournissant l'interface d'authentification Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once("../../lib/lib_session.php");

/* Suppression de la redirection car ne redirige pas au bon endroit => index.php au lieu de index_chgpwd.php + token
 * @TODO vérifier si nécessaire de forcer le domaine back-office
if( defined("ALK_B_SAMEDOMAIN") && ALK_B_SAMEDOMAIN==false && ALK_ROOT_URL != ALK_ROOT_URL_BACKOFFICE ) {
  header("location:".ALK_ROOT_URL_BACKOFFICE.ALK_ROOT_DIR.ALK_ROOT_MODULE."ident/".ALK_INDEX_AUTH);
}
*/

AlkFactory::initLocale(false);

AlkRequest::readToken();

 $oTemplate =& AlkFactory::getTemplate();
 // chargement d'un template spécifique
 $strPathTemplate = ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."index_chgpwd.tpl";
 if ( !(file_exists($strPathTemplate) && is_file($strPathTemplate))){
   // chargement du modèle
   $strPathTemplate = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."alkanet/templates/index_chgpwd.tpl";
 }

//traitements
$strLogin = AlkRequest::getToken("l", "");
$strPwd   = AlkRequest::getToken("p", "");
$iRes     = AlkRequest::getToken("r", "0");
$strTokenValid = AlkRequest::getEncodeParam("l=".$strLogin."&p=".$strPwd."&r=1");

// vérification du token
define("ALK_B_ATYPE_ANNU", true);
  
$oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
$dsAgent = $oQueryAnnu->getDs_ficheAgentByLoginPwd($strLogin, $strPwd);
$agent_id = "-1";
if( $drAgent = $dsAgent->getRowIter() ) {
  $agent_id = $drAgent->getValueName("AGENT_ID");
} 

if( $agent_id == "-1" ) {
  // attaque probable, on quitte brusquement
  header($_SERVER["SERVER_PROTOCOL"]." 404 Not Found");
  echo "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">
    <html><head>
    <title>404 Not Found</title>
    </head><body>
    <h1>Not Found</h1>
    <p>The requested URL was not found on this server.</p>
    </body></html>";
  exit(); 
}

if( $iRes == "1" ) {
  // cas modif du mot de passe
  /** mot de passe crypté */
  $strPwd = AlkRequest::_POST("strPwd", "");
  if( $strPwd != "" ) { 
    $oQueryActionAnnu = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
    $oQueryActionAnnu->updateUserPwd($agent_id, $strPwd);
  } else {
    // attaque probable, on quitte brusquement
    header($_SERVER["SERVER_PROTOCOL"]." 404 Not Found");
    echo "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">
      <html><head>
      <title>404 Not Found</title>
      </head><body>
      <h1>Not Found</h1>
      <p>The requested URL was not found on this server.</p>
      </body></html>";
    exit(); 
  }
} else {
  /** chargement des constantes */
  define("ALK_B_ATYPE_ESPACE", true);
  
  $tabCont = array();
  $tabAppli = array();
  $tabAtype = array();

  // chargement des constantes génériques
  $tabCont[] = -1;
  $tabAppli[] = -1;
  $tabAtype[] = -1;
  $tabAtype[] = 1;
  $tabAtype[] = 0;

  //AlkFactory::loadConstants(-1, -1);
  AlkFactory::loadConstants($tabCont, $tabAppli, $tabAtype);
  
  $strTokenValid = AlkRequest::getEncodeParam("l=".$strLogin."&p=".$strPwd."&r=1");
}

$oTemplate->assign("iRes", $iRes);
$oTemplate->assign("titlePwd", _f("Veuillez saisir%nlvotre nouveau mot de passe.", "<br/>"));

// champs
$oLogin = AlkHtmlFactory::getNewHtmlText(null, 0, "strLogin", $strLogin, _t("Identifiant"), 1, 15, 80);
$oLogin->setProperty("bDisabled", true);
$oLogin->setProperty("cssFormCtrl", "homeCtrl");
$oTemplate->assign_by_ref("oLogin", $oLogin);

$oPwd = AlkHtmlFactory::getNewHtmlText(null, 0, "strPwd2", "", _t("Mot de passe"), 1, 15, 80);
$oPwd->setProperty("cssFormCtrl", "homeCtrl");
$oPwd->setBPassword(true);
$oTemplate->assign_by_ref("oPwd", $oPwd);

$oPwd2 = AlkHtmlFactory::getNewHtmlText(null, 0, "strPwd3", "", _t("Vérification"), 1, 15, 80);
$oPwd2->setProperty("cssFormCtrl", "homeCtrl");
$oPwd2->setBPassword(true);
$oTemplate->assign_by_ref("oPwd2", $oPwd2);

$oTemplate->assign("ALK_ANNU_LG_MIN_PWD", ALK_ANNU_LG_MIN_PWD);
$oTemplate->assign("strTokenValid", $strTokenValid);
$oTemplate->assign("strUrlAccueil", AlkRequest::getEncodeParam("/accueil"));
$oTemplate->assign("strMessage", _t("Votre mot de passe a été modifié avec succès.")."<br/><br/>"._t("Connexion en cours")."....");
$oTemplate->assign("strLogin", $strLogin);
$oTemplate->assign("strPwd", $strPwd);

// charge de css
$strPathCss = ALK_ROOT_STYLE."home.css";
if ( (file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."home.css") && is_file(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE."home.css"))){
  // chargement du modèle
  $strPathCss = "../../".ALK_ROOT_STYLE."home.css";
}
 
$oTemplate->assign("style_css", $strPathCss);

$strHtml = $oTemplate->fetch($strPathTemplate);
echo $strHtml;
?>